/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.asm;

import de.loskutov.bco.asm.CommentedASMifierClassVisitor;
import de.loskutov.bco.asm.CommentedClassVisitor;
import de.loskutov.bco.asm.DecompiledClass;
import de.loskutov.bco.asm.DecompiledClassInfo;
import de.loskutov.bco.asm.DecompiledMethod;
import de.loskutov.bco.asm.DecompilerOptions;
import de.loskutov.bco.asm.ICommentedClassVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecompilerHelper {
    public static DecompiledClass getDecompiledClass(InputStream is, DecompilerOptions options) throws IOException, UnsupportedClassVersionError {
        ClassReader cr = new ClassReader(is);
        ClassNode cn = new ClassNode(262144);
        int crFlags = 0;
        if (options.modes.get(7)) {
            crFlags |= 8;
        }
        cr.accept((ClassVisitor)cn, crFlags);
        ICommentedClassVisitor printer = options.modes.get(2) ? new CommentedASMifierClassVisitor(cn, options) : new CommentedClassVisitor(cn, options);
        TraceClassVisitor dcv = new TraceClassVisitor(null, (Printer)printer, null);
        cn.accept((ClassVisitor)dcv);
        return DecompilerHelper.getResult(printer, options, cn);
    }

    private static DecompiledClass getResult(ICommentedClassVisitor printer, DecompilerOptions options, ClassNode classNode) {
        ArrayList<Object> classText = new ArrayList<Object>();
        DecompilerHelper.formatText(printer.getText(), new StringBuffer(), classText, options.cl);
        while (classText.size() > 0 && classText.get(0).equals("\n")) {
            classText.remove(0);
        }
        DecompiledClassInfo classInfo = printer.getClassInfo();
        return new DecompiledClass(classText, classInfo, classNode);
    }

    private static void formatText(List input, StringBuffer line, List<Object> result, ClassLoader cl) {
        for (int i = 0; i < input.size(); ++i) {
            int p;
            Object o = input.get(i);
            if (o instanceof List) {
                DecompilerHelper.formatText((List)o, line, result, cl);
                continue;
            }
            if (o instanceof DecompiledMethod) {
                result.add(o);
                continue;
            }
            String s = o.toString();
            do {
                if ((p = s.indexOf(10)) == -1) {
                    line.append(s);
                    continue;
                }
                result.add(line.toString() + s.substring(0, p + 1));
                s = s.substring(p + 1);
                line.setLength(0);
            } while (p != -1);
        }
    }
}

