/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.editors;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.editors.BytecodeClassFileEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditorActionContributor;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BytecodeActionBarContributor
extends ClassFileEditorActionContributor {
    BytecodeClassFileEditor editor;
    protected ShowBytecodeAction refreshAction;
    protected ToggleRawBytecodeAction toggleRawBytecodeAction;
    private final AttachSourceAction attachAction;

    public BytecodeActionBarContributor() {
        String symbolicName = BytecodeOutlinePlugin.getDefault().getBundle().getSymbolicName();
        ImageDescriptor actionIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)symbolicName, (String)"icons/bytecodeview.gif");
        this.refreshAction = new ShowBytecodeAction(actionIcon);
        actionIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)symbolicName, (String)"icons/raw_mode.gif");
        this.toggleRawBytecodeAction = new ToggleRawBytecodeAction(actionIcon);
        actionIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)symbolicName, (String)"icons/source.gif");
        this.attachAction = new AttachSourceAction(actionIcon);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IAction)this.toggleRawBytecodeAction);
        toolBarManager.add((IAction)this.attachAction);
    }

    public void contributeToMenu(IMenuManager menu) {
        super.contributeToMenu(menu);
        IMenuManager edit = menu.findMenuUsingPath("edit");
        if (edit != null) {
            edit.add((IAction)this.refreshAction);
            edit.add((IAction)this.toggleRawBytecodeAction);
            edit.add((IAction)this.attachAction);
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof BytecodeClassFileEditor) {
            this.editor = (BytecodeClassFileEditor)targetEditor;
            this.refreshAction.setEnabled(this.editor.hasMappedSource());
            this.refreshAction.setChecked(this.editor.isDecompiled());
            this.toggleRawBytecodeAction.setEnabled(this.editor.isDecompiled());
            this.toggleRawBytecodeAction.setChecked(this.editor.getDecompilerFlag(3));
            this.attachAction.setEnabled(this.editor.isSourceAttachmentPossible());
        } else {
            this.refreshAction.setEnabled(false);
            this.toggleRawBytecodeAction.setEnabled(false);
            this.attachAction.setEnabled(false);
            this.editor = null;
        }
        super.setActiveEditor(targetEditor);
    }

    private class ToggleRawBytecodeAction
    extends Action {
        protected ToggleRawBytecodeAction(ImageDescriptor actionIcon) {
            super("Show Internal Types", 2);
            this.setImageDescriptor(actionIcon);
            this.setToolTipText("Show Internal Types");
        }

        public void run() {
            if (BytecodeActionBarContributor.this.editor != null) {
                ITextSelection textSelection;
                BytecodeActionBarContributor.this.editor.setDecompilerFlag(3, this.isChecked());
                ISelection selection = BytecodeActionBarContributor.this.editor.getSelectionProvider().getSelection();
                int sourceLine = 0;
                if (selection instanceof ITextSelection) {
                    sourceLine = BytecodeActionBarContributor.this.editor.getSourceLine((ITextSelection)selection);
                }
                BytecodeActionBarContributor.this.editor.doSetInput(true, false);
                if (selection instanceof ITextSelection && (textSelection = BytecodeActionBarContributor.this.editor.convertLine(sourceLine)) != null) {
                    BytecodeActionBarContributor.this.editor.getSelectionProvider().setSelection((ISelection)textSelection);
                }
            }
        }
    }

    private class AttachSourceAction
    extends Action {
        protected AttachSourceAction(ImageDescriptor actionIcon) {
            super("Attach Source...", 0);
            this.setImageDescriptor(actionIcon);
            this.setToolTipText("Attach Source...");
        }

        public void run() {
            if (BytecodeActionBarContributor.this.editor == null) {
                return;
            }
            IPackageFragmentRoot root = BytecodeActionBarContributor.this.editor.getPackageFragmentRoot(BytecodeActionBarContributor.this.editor.getClassFile());
            try {
                Shell shell;
                IClasspathEntry cpe;
                IClasspathEntry entry = root.getRawClasspathEntry();
                IPath containerPath = null;
                IJavaProject javaProject = root.getJavaProject();
                if (entry.getEntryKind() == 5) {
                    containerPath = entry.getPath();
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
                    if (!this.isSourceAttachmentPossible(containerPath, javaProject)) {
                        BytecodeActionBarContributor.this.editor.setSourceAttachmentPossible(false);
                        BytecodeActionBarContributor.this.attachAction.setEnabled(false);
                        BytecodeOutlinePlugin.error("Unable to configure source attachment:\nclasspath entry '" + containerPath + "'\nis either read-only " + "or source attachment is not supported...", null);
                        return;
                    }
                    entry = JavaModelUtil.findEntryInContainer((IClasspathContainer)container, (IPath)root.getPath());
                }
                if ((cpe = BuildPathDialogAccess.configureSourceAttachment((Shell)(shell = Display.getDefault().getActiveShell()), (IClasspathEntry)entry)) == null) {
                    return;
                }
                String[] changedAttributes = new String[]{"sourcepath"};
                BuildPathSupport.modifyClasspathEntry((Shell)shell, (IClasspathEntry)cpe, (String[])changedAttributes, (IJavaProject)javaProject, (IPath)containerPath, (cpe.getReferencingEntry() != null ? 1 : 0) != 0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                BytecodeOutlinePlugin.error("Unable to configure source attachment", e);
            }
        }

        private boolean isSourceAttachmentPossible(IPath containerPath, IJavaProject javaProject) {
            ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
            IStatus status = initializer.getSourceAttachmentStatus(containerPath, javaProject);
            return status.getCode() != 1 && status.getCode() != 2;
        }
    }

    private class ShowBytecodeAction
    extends Action {
        protected ShowBytecodeAction(ImageDescriptor actionIcon) {
            super("Show Bytecode@Ctrl+Shift+B", 2);
            this.setImageDescriptor(actionIcon);
            this.setToolTipText("Show Bytecode");
            this.setAccelerator(393282);
        }

        public void run() {
            if (BytecodeActionBarContributor.this.editor != null) {
                ISelection selection = BytecodeActionBarContributor.this.editor.getSelectionProvider().getSelection();
                boolean showBytecode = this.isChecked();
                if (BytecodeActionBarContributor.this.editor.isDecompiled() != showBytecode) {
                    BytecodeActionBarContributor.this.editor.doSetInput(true, !showBytecode);
                    if (selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        textSelection = BytecodeActionBarContributor.this.editor.convertSelection(textSelection, showBytecode);
                        BytecodeActionBarContributor.this.editor.getSelectionProvider().setSelection((ISelection)textSelection);
                    }
                }
                BytecodeActionBarContributor.this.toggleRawBytecodeAction.setEnabled(BytecodeActionBarContributor.this.editor.isDecompiled());
            }
        }
    }
}

