/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.views;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.editors.BytecodeClassFileEditor;
import de.loskutov.bco.ui.actions.DefaultToggleAction;
import de.loskutov.bco.views.BytecodeOutlineView;
import de.loskutov.bco.views.HelpUtils;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class BytecodeReferenceView
extends ViewPart
implements IPartListener2,
ISelectionListener {
    private Browser browser;
    private DefaultToggleAction linkWithViewAction;
    private boolean linkWithView;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 2048);
        final IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        this.linkWithView = BytecodeOutlinePlugin.getDefault().getPreferenceStore().getBoolean("linkRefViewToEditor");
        this.linkWithViewAction = new DefaultToggleAction("linkRefViewToEditor"){

            public void run(boolean newState) {
                BytecodeReferenceView.this.linkWithView = newState;
                if (BytecodeReferenceView.this.linkWithView) {
                    ISelectionService selectionService = workbenchWindow.getSelectionService();
                    try {
                        IViewPart part = workbenchWindow.getActivePage().showView("de.loskutov.bco.views.BytecodeOutlineView");
                        ISelection selection = selectionService.getSelection("de.loskutov.bco.views.BytecodeOutlineView");
                        BytecodeReferenceView.this.selectionChanged((IWorkbenchPart)part, selection);
                    }
                    catch (PartInitException e) {
                        BytecodeOutlinePlugin.log(e, 4);
                    }
                }
            }
        };
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tmanager = bars.getToolBarManager();
        tmanager.add((IAction)this.linkWithViewAction);
        this.shouDefaultEmptyPage();
        workbenchWindow.getPartService().addPartListener((IPartListener2)this);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
        this.browser.dispose();
        this.browser = null;
        this.linkWithViewAction = null;
        super.dispose();
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.partVisible(partRef);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getSite().getId())) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getSite().getId())) {
            IViewReference viewReference;
            IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
            ISelectionService selectionService = workbenchWindow.getSelectionService();
            String partId = BytecodeOutlineView.class.getName();
            selectionService.addPostSelectionListener((ISelectionListener)this);
            ISelection selection = selectionService.getSelection(partId);
            if (selection != null && (viewReference = workbenchWindow.getActivePage().findViewReference(partId)) != null) {
                this.selectionChanged((IWorkbenchPart)viewReference.getView(false), selection);
            }
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection sselection;
        int size;
        boolean isViewSelection = part instanceof BytecodeOutlineView;
        if (!this.linkWithView || !isViewSelection && !(part instanceof BytecodeClassFileEditor)) {
            return;
        }
        int line = -1;
        if (selection instanceof ITextSelection) {
            line = ((ITextSelection)selection).getStartLine();
        } else if (selection instanceof IStructuredSelection && (size = (sselection = (IStructuredSelection)selection).size()) == 1 && sselection.getFirstElement() instanceof Integer) {
            line = (Integer)sselection.getFirstElement();
        }
        if (line < 0) {
            this.shouDefaultEmptyPage();
            return;
        }
        int opcode = isViewSelection ? ((BytecodeOutlineView)part).getBytecodeInstructionAtLine(line) : ((BytecodeClassFileEditor)part).getBytecodeInstructionAtLine(line);
        URL url = HelpUtils.getHelpResource(opcode);
        if (url != null) {
            this.browser.setUrl(url.toString());
        } else {
            this.shouDefaultEmptyPage();
        }
    }

    private void shouDefaultEmptyPage() {
        this.browser.setUrl(HelpUtils.getHelpIndex().toString());
    }
}

