/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.views;

import de.loskutov.bco.views.BytecodeOutlineView;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class EditorListener
implements ISelectionListener,
IFileBufferListener,
IPartListener2 {
    protected volatile BytecodeOutlineView view;

    EditorListener(BytecodeOutlineView view) {
        this.view = view;
    }

    public void dispose() {
        this.view = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)selection;
                if (ssel.isEmpty()) {
                    return;
                }
                if (ssel.getFirstElement() instanceof IJavaElement) {
                    Display display = Display.getDefault();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (EditorListener.this.view != null) {
                                EditorListener.this.view.checkOpenEditors(true);
                            }
                        }
                    });
                }
            }
            return;
        }
        this.view.handleSelectionChanged(part, selection);
    }

    public void dirtyStateChanged(IFileBuffer buffer, final boolean isDirty) {
        if (!this.view.isLinkedWithEditor()) {
            return;
        }
        if (EditorListener.isSupportedBuffer(buffer)) {
            this.view.handleBufferIsDirty(isDirty);
            if (!isDirty) {
                final Runnable runnable2 = new Runnable(){

                    public void run() {
                        EditorListener.this.view.handleBufferIsDirty(isDirty);
                    }
                };
                Runnable runnable1 = new Runnable(){

                    public void run() {
                        Display display = Display.getCurrent();
                        display.timerExec(1000, runnable2);
                    }
                };
                Display display = Display.getDefault();
                display.asyncExec(runnable1);
            }
        }
    }

    private static boolean isSupportedBuffer(IFileBuffer buffer) {
        String fileExtension = buffer.getLocation().getFileExtension();
        return "java".equals(fileExtension);
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.view.handlePartHidden(partRef.getPart(false));
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        this.view.handlePartHidden(partRef.getPart(false));
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.view.handlePartVisible(partRef.getPart(false));
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.view.handlePartVisible(partRef.getPart(false));
    }

    public void bufferDisposed(IFileBuffer buffer) {
    }

    public void bufferCreated(IFileBuffer buffer) {
    }

    public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
    }

    public void bufferContentReplaced(IFileBuffer buffer) {
    }

    public void stateChanging(IFileBuffer buffer) {
    }

    public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
    }

    public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
    }

    public void underlyingFileDeleted(IFileBuffer buffer) {
    }

    public void stateChangeFailed(IFileBuffer buffer) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }
}

