/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ResourceAction;

public class ToggleBreadcrumbAction
extends ResourceAction
implements IPropertyChangeListener,
IPerspectiveListener {
    private IPreferenceStore fStore;
    private IWorkbenchPage fPage;

    public ToggleBreadcrumbAction(IWorkbenchPage page) {
        this(page, false);
    }

    public ToggleBreadcrumbAction(IWorkbenchPage page, boolean inContextMenu) {
        super(JavaEditorMessages.getBundleForConstructedKeys(), inContextMenu ? "ToggleBreadcrumbAction.Hide." : "ToggleBreadcrumbAction.", inContextMenu ? 1 : 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.toggle_breadcrumb_action_context");
        this.fPage = page;
        if (!inContextMenu) {
            JavaPluginImages.setToolImageDescriptors((IAction)this, "toggle_breadcrumb.gif");
            this.fPage.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        }
        this.update();
    }

    public void run() {
        this.fStore.setValue(this.getPreferenceKey(), this.isChecked());
    }

    public void update() {
        String key;
        if (this.fStore == null) {
            this.fStore = JavaPlugin.getDefault().getPreferenceStore();
            this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.setChecked((key = this.getPreferenceKey()) != null && this.fStore.getBoolean(key));
        this.setEnabled(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.getPreferenceKey())) {
            this.setChecked(Boolean.valueOf(event.getNewValue().toString()));
        }
    }

    public void dispose() {
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        if (this.fPage != null) {
            this.fPage.getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
            this.fPage = null;
        }
    }

    private String getPreferenceKey() {
        IPerspectiveDescriptor perspective = this.fPage.getPerspective();
        String perspectiveID = perspective != null ? perspective.getId() : "<unknown>";
        return "breadcrumb." + perspectiveID;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        boolean isChecked = this.fStore.getBoolean(this.getPreferenceKey());
        if (isChecked != this.isChecked()) {
            Boolean value = isChecked;
            this.fStore.firePropertyChangeEvent(this.getPreferenceKey(), (Object)value, (Object)value);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

