/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.AdaptableMergeResult;
import com.collabnet.subversion.merge.MergeCommand;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeSummaryResult;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.views.MergeResultsView;
import com.collabnet.subversion.merge.wizards.DialogWizard;
import com.collabnet.subversion.merge.wizards.MergeWizardDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.CommitAction;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeOperation
extends SVNOperation {
    private IResource[] mergedResources;
    private SVNUrl[] svnUrls1;
    private SVNUrl[] svnUrls2;
    private SVNRevision svnRevision1;
    private SVNRevision svnRevision2;
    private SVNRevisionRange[] revisions;
    private MergeOutput mergeOutput;
    private boolean reintegrate = false;
    private boolean force = false;
    private boolean ignoreAncestry = false;
    private int depth = 5;
    private boolean recordOnly = false;
    private boolean unblock = false;
    private int textConflictHandling;
    private int binaryConflictHandling;
    private int propertyConflictHandling;
    private MergeCommand command;
    private MergeOutput abortedMergeOutput;
    private MergeOutput incompleteOutput;
    private boolean unresolvedConflicts;
    private boolean abnormalEnd = false;
    private boolean resumed = false;

    public MergeOperation(IWorkbenchPart part, IResource[] resources, SVNUrl[] svnUrls1, SVNRevision svnRevision1, SVNUrl[] svnUrls2, SVNRevision svnRevision2, SVNRevisionRange[] revisions, MergeOutput mergeOutput) {
        super(part);
        this.mergedResources = resources;
        this.svnUrls1 = svnUrls1;
        this.svnRevision1 = svnRevision1;
        this.svnUrls2 = svnUrls2;
        this.svnRevision2 = svnRevision2;
        this.revisions = revisions;
        this.mergeOutput = mergeOutput;
        if (mergeOutput != null) {
            this.resumed = true;
        }
    }

    protected String getTaskName() {
        return Messages.MergeOperation_title;
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return String.valueOf(Messages.MergeOperation_merging) + provider.getProject().getName();
    }

    public void runWithNoMonitor() throws InvocationTargetException, InterruptedException {
        this.run();
    }

    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(this.getTaskName(), this.mergedResources.length);
        ArrayList<MergeOutput> mergeOutputs = new ArrayList<MergeOutput>();
        int i = 0;
        while (i < this.mergedResources.length) {
            MergeResultsView view;
            MergeOutput mergeOutput;
            try {
                monitor.subTask(this.mergedResources[i].getName());
                this.incompleteOutput = null;
                if (this.mergeOutput == null) {
                    this.incompleteOutput = MergeOutput.getIncompleteMerge(this.mergedResources[i], this.svnUrls1[i].toString(), this.svnUrls2[i].toString());
                }
                if (this.incompleteOutput == null) {
                    this.command = new MergeCommand(this.mergedResources[i], this.svnUrls1[i], this.svnRevision1, this.svnUrls2[i], this.svnRevision2, this.revisions, this.mergeOutput);
                } else {
                    if (this.incompleteOutput.hasUnresolvedConflicts()) {
                        this.unresolvedConflicts = true;
                        break;
                    }
                    this.command = new MergeCommand(this.mergedResources[i], this.svnUrls1[i], this.svnRevision1, this.svnUrls2[i], this.svnRevision2, this.revisions, this.incompleteOutput);
                }
                this.command.setPart(this.getPart());
                this.command.setReintegrate(this.reintegrate);
                this.command.setForce(this.force);
                this.command.setIgnoreAncestry(this.ignoreAncestry);
                this.command.setDepth(this.depth);
                this.command.setTextConflictHandling(this.textConflictHandling);
                this.command.setBinaryConflictHandling(this.binaryConflictHandling);
                this.command.setPropertyConflictHandling(this.propertyConflictHandling);
                this.command.setRecordOnly(this.recordOnly);
                this.command.run(Policy.subMonitorFor((IProgressMonitor)monitor, (int)1000));
                monitor.worked(1);
                if (this.recordOnly) {
                    mergeOutput = this.command.getMergeOutput();
                    MergeSummaryResult[] summaryResults = new MergeSummaryResult[]{new MergeSummaryResult(1, "Updated", "1")};
                    mergeOutput.setMergeSummaryResults(summaryResults);
                    MergeResult[] mergeResults = new MergeResult[]{new AdaptableMergeResult(" ", "U", " ", this.mergedResources[i].getLocation().toString(), false)};
                    mergeOutput.setMergeResults(mergeResults);
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.mergedResources[i]);
                    if (svnResource != null) {
                        svnResource.refreshStatus();
                    }
                }
            }
            catch (SVNException e) {
                if (e.operationInterrupted()) {
                    this.showCancelledMessage();
                } else {
                    this.collectStatus(e.getStatus());
                }
                this.abnormalEnd = true;
            }
            mergeOutput = this.command.getMergeOutput();
            mergeOutputs.add(mergeOutput);
            if (this.command.isMergeAborted()) {
                mergeOutput.setIncomplete(true);
                mergeOutput.setNormalEnd(true);
                mergeOutput.store();
                this.abortedMergeOutput = mergeOutput;
                view = MergeResultsView.getView();
                if (view == null) break;
                view.refreshAsync(mergeOutput);
                break;
            }
            mergeOutput.setIncomplete(false);
            if (!this.recordOnly && !this.abnormalEnd) {
                mergeOutput.setNormalEnd(true);
                mergeOutput.store();
                view = MergeResultsView.getView();
                if (view != null) {
                    view.refreshAsync(mergeOutput);
                }
            }
            ++i;
        }
        if (this.recordOnly) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DialogWizard dialogWizard = new DialogWizard(11);
                    dialogWizard.setUnblock(MergeOperation.this.unblock);
                    MergeWizardDialog dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard, true);
                    if (dialog.open() == 1) {
                        return;
                    }
                    CommitAction commitAction = new CommitAction();
                    commitAction.setSelectedResources(MergeOperation.this.mergedResources);
                    commitAction.run(null);
                }
            });
        } else {
            final MergeOutput[] mergeOutputArray = new MergeOutput[mergeOutputs.size()];
            mergeOutputs.toArray(mergeOutputArray);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MergeWizardDialog dialog;
                    DialogWizard dialogWizard;
                    if (MergeOperation.this.unresolvedConflicts) {
                        dialogWizard = new DialogWizard(8);
                        dialogWizard.setMergeOutput(MergeOperation.this.incompleteOutput);
                        dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard);
                        dialog.open();
                    } else if (MergeOperation.this.command.isMergeAborted()) {
                        dialogWizard = new DialogWizard(6);
                        dialogWizard.setMergeOutput(MergeOperation.this.abortedMergeOutput);
                        dialogWizard.setErrorMessage(MergeOperation.this.command.getErrorMessage());
                        dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard);
                        dialog.open();
                    }
                    if (mergeOutputArray.length > 0 && !MergeOperation.this.abnormalEnd) {
                        dialogWizard = new DialogWizard(0);
                        dialogWizard.setMergeOutputs(mergeOutputArray);
                        dialogWizard.setResumed(MergeOperation.this.resumed);
                        dialog = new MergeWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard);
                        dialog.open();
                    }
                }
            });
        }
        monitor.done();
    }

    public void setReintegrate(boolean reintegrate) {
        this.reintegrate = reintegrate;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setTextConflictHandling(int textConflictHandling) {
        this.textConflictHandling = textConflictHandling;
    }

    public void setBinaryConflictHandling(int binaryConflictHandling) {
        this.binaryConflictHandling = binaryConflictHandling;
    }

    public void setPropertyConflictHandling(int propertyConflictHandling) {
        this.propertyConflictHandling = propertyConflictHandling;
    }

    public void setRecordOnly(boolean recordOnly) {
        this.recordOnly = recordOnly;
    }

    public void setUnblock(boolean unblock) {
        this.unblock = unblock;
    }
}

