/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.actions;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.CopyOperation;
import com.collabnet.subversion.merge.ISkippedMergeResult;
import com.collabnet.subversion.merge.MergeOptions;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.SkippedMergeResult;
import com.collabnet.subversion.merge.SkippedMergeResultsFolder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CopyFromMergeSourceAction
extends WorkspaceAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        for (Object object : this.selection) {
            String resourceSubString;
            SVNUrl svnUrl;
            MergeOptions mergeOptions;
            if (!(object instanceof ISkippedMergeResult)) continue;
            SVNRevision svnRevision = null;
            IResource resource = null;
            SVNUrl srcUrl = null;
            MergeResult mergeResult = null;
            if (object instanceof SkippedMergeResult) {
                SkippedMergeResult skippedMergeResult;
                mergeResult = skippedMergeResult = (SkippedMergeResult)object;
                mergeOptions = skippedMergeResult.getMergeOutput().getMergeOptions();
                svnRevision = mergeOptions.getToRevision();
                svnUrl = mergeOptions.getFromUrl();
                resource = skippedMergeResult.getResource();
                if (!resource.exists()) {
                    SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    resourceSubString = resource.getFullPath().toOSString().substring(skippedMergeResult.getMergeOutput().getTarget().length() + 1);
                    if (!resourceSubString.startsWith("/")) {
                        resourceSubString = "/" + resourceSubString;
                    }
                    try {
                        srcUrl = new SVNUrl(String.valueOf(svnUrl.toString()) + resourceSubString.replaceAll("\\\\", "/"));
                    }
                    catch (MalformedURLException e) {
                        Activator.handleError(Messages.CopyFromMergeSourceAction_error, e);
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.CopyFromMergeSourceAction_title, (String)e.getLocalizedMessage());
                        return;
                    }
                }
            }
            if (object instanceof SkippedMergeResultsFolder) {
                SkippedMergeResultsFolder skippedMergeResultsFolder = (SkippedMergeResultsFolder)object;
                mergeResult = skippedMergeResultsFolder.getMergeResult();
                mergeOptions = skippedMergeResultsFolder.getMergeOutput().getMergeOptions();
                svnRevision = mergeOptions.getToRevision();
                svnUrl = mergeOptions.getFromUrl();
                resource = skippedMergeResultsFolder.getFolder();
                if (!resource.exists()) {
                    SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    resourceSubString = resource.getFullPath().toOSString().substring(skippedMergeResultsFolder.getMergeOutput().getTarget().length() + 1);
                    if (!resourceSubString.startsWith("/")) {
                        resourceSubString = "/" + resourceSubString;
                    }
                    try {
                        srcUrl = new SVNUrl(String.valueOf(svnUrl.toString()) + resourceSubString.replaceAll("\\\\", "/"));
                    }
                    catch (MalformedURLException e) {
                        Activator.handleError(Messages.CopyFromMergeSourceAction_error2, e);
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.CopyFromMergeSourceAction_title, (String)e.getLocalizedMessage());
                        return;
                    }
                }
            }
            if (resource.exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.CopyFromMergeSourceAction_title, (String)(String.valueOf(resource.getName()) + Messages.CopyFromMergeSourceAction_alreadyExists));
                return;
            }
            if (svnRevision == null) {
                svnRevision = SVNRevision.HEAD;
            }
            IResource[] resources = new IResource[]{resource};
            File destPath = new File(resource.getLocation().toOSString());
            CopyOperation copyOperation = new CopyOperation(this.getTargetPart(), resources, srcUrl, destPath, svnRevision, mergeResult);
            copyOperation.run();
        }
    }

    protected boolean isEnabled() throws TeamException {
        return true;
    }
}

