/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.Filer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.JavaSourceFilePrintWriter;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.core.JavaModelException;

public abstract class FilerImpl
implements Filer {
    protected abstract AbstractCompilationEnv getEnv();

    public PrintWriter createSourceFile(String typeName) throws IOException {
        JavaSourceFilePrintWriter pw;
        if (typeName == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        if ("".equals(typeName)) {
            throw new IllegalArgumentException("Type name cannot be empty");
        }
        this.getEnv().checkValid();
        try {
            pw = new JavaSourceFilePrintWriter(typeName, new StringWriter(), this.getEnv());
        }
        catch (CoreException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return pw;
    }

    protected IPath getOutputFileForLocation(Filer.Location loc, String pkg, File relPath) throws IOException {
        GeneratedSourceFolderManager gsfm = this.getEnv().getAptProject().getGeneratedSourceFolderManager();
        IPath path = null;
        if (loc == Filer.Location.CLASS_TREE) {
            try {
                path = gsfm.getBinaryOutputLocation();
            }
            catch (JavaModelException e) {
                AptPlugin.log(e, "Failure getting the output file");
                throw new IOException();
            }
        } else if (loc == Filer.Location.SOURCE_TREE) {
            path = gsfm.getFolder().getProjectRelativePath();
        }
        if (pkg != null) {
            path = path.append(pkg.replace('.', File.separatorChar));
        }
        path = path.append(relPath.getPath());
        IPath absolutePath = this.getEnv().getProject().getLocation().append(path);
        File parentFile = absolutePath.toFile().getParentFile();
        FileSystemUtil.mkdirs(parentFile);
        return path;
    }
}

