/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.tigris.subversion.svnclientadapter.Annotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JhlAnnotations
extends Annotations
implements BlameCallback {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    private void singleLine(Date changed, long revision, String author, Date merged_date, long merged_revision, String merged_author, String mergedPath, String line) {
        if (merged_revision == -1L || revision <= merged_revision) {
            this.addAnnotation(new Annotations.Annotation(revision, author, changed, line));
        } else {
            this.addAnnotation(new Annotations.Annotation(merged_revision, merged_author, merged_date, line));
        }
    }

    @Override
    public void singleLine(long lineNum, long revision, Map<String, byte[]> revProps, long mergedRevision, Map<String, byte[]> mergedRevProps, String mergedPath, String line, boolean localChange) throws ClientException {
        String author = null;
        String mergedAuthor = null;
        try {
            author = new String(revProps.get("svn:author"), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            author = new String(revProps.get("svn:author"));
        }
        if (mergedRevProps != null) {
            try {
                mergedAuthor = new String(mergedRevProps.get("svn:author"), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                mergedAuthor = new String(mergedRevProps.get("svn:author"));
            }
        }
        try {
            this.singleLine(df.parse(new String(revProps.get("svn:date"))), revision, author, mergedRevProps == null ? null : df.parse(new String(mergedRevProps.get("svn:date"))), mergedRevision, mergedAuthor, mergedPath, line);
        }
        catch (ParseException e) {
            throw ClientException.fromException(e);
        }
    }
}

