/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.tigris.subversion.subclipse.ui.actions.UpdateAction;
import org.tigris.subversion.subclipse.ui.operations.UpdateOperation;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardUpdatePage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateDialogAction
extends UpdateAction {
    private long revision;
    private int depth = -2;
    private boolean setDepth = false;

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            IResource[] resources = this.getSelectedResources();
            String pageName = resources.length > 1 ? "UpdateDialog.multiple" : "UpdateDialog";
            SvnWizardUpdatePage updatePage = new SvnWizardUpdatePage(pageName, resources);
            updatePage.setDefaultRevision(this.revision);
            updatePage.setDepth(this.depth);
            updatePage.setSetDepth(this.setDepth);
            SvnWizard wizard = new SvnWizard(updatePage);
            SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
            wizard.setParentDialog((Dialog)dialog);
            if (dialog.open() == 0) {
                SVNRevision svnRevision = updatePage.getRevision();
                UpdateOperation updateOperation = new UpdateOperation(this.getTargetPart(), resources, svnRevision);
                updateOperation.setDepth(updatePage.getDepth());
                updateOperation.setSetDepth(updatePage.isSetDepth());
                updateOperation.setForce(updatePage.isForce());
                updateOperation.setIgnoreExternals(updatePage.isIgnoreExternals());
                updateOperation.setCanRunAsJob(this.canRunAsJob);
                updateOperation.run();
            }
        }
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }
}

