/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizard;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagWizardCopyPage
extends SVNWizardPage {
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    protected Button serverButton;
    protected Button revisionButton;
    private Text revisionText;
    private Button logButton;
    protected Button workingCopyButton;
    private long revisionNumber = 0L;

    public BranchTagWizardCopyPage() {
        super("copyPage", Policy.bind("BranchTagWizardCopyPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/svn_wizban.png"), Policy.bind("BranchTagWizardCopyPage.message"));
    }

    public void createControl(Composite parent) {
        this.resource = ((BranchTagWizard)this.getWizard()).getResource();
        this.remoteResource = ((BranchTagWizard)this.getWizard()).getRemoteResource();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerLayout.marginHeight = 0;
        outerLayout.marginWidth = 0;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Group serverComposite = new Group(outerContainer, 0);
        serverComposite.setText(Policy.bind("BranchTagDialog.createCopy"));
        GridLayout serverLayout = new GridLayout();
        serverLayout.numColumns = 3;
        serverComposite.setLayout((Layout)serverLayout);
        GridData data = new GridData(4, 4, true, false);
        serverComposite.setLayoutData((Object)data);
        this.serverButton = new Button((Composite)serverComposite, 16);
        this.serverButton.setText(Policy.bind("BranchTagDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.serverButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)serverComposite, 16);
        this.revisionButton.setText(Policy.bind("BranchTagDialog.revision"));
        this.revisionText = new Text((Composite)serverComposite, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        if (this.revisionNumber == 0L) {
            this.revisionText.setEnabled(false);
        } else {
            this.revisionText.setText("" + this.revisionNumber);
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BranchTagWizardCopyPage.this.setPageComplete(BranchTagWizardCopyPage.this.canFinish());
            }
        });
        this.logButton = new Button((Composite)serverComposite, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        if (this.revisionNumber == 0L) {
            this.logButton.setEnabled(false);
        }
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchTagWizardCopyPage.this.showLog();
            }
        });
        this.workingCopyButton = new Button((Composite)serverComposite, 16);
        this.workingCopyButton.setText(Policy.bind("BranchTagDialog.working"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.workingCopyButton.setLayoutData((Object)data);
        if (this.resource == null) {
            this.workingCopyButton.setVisible(false);
        }
        if (this.revisionNumber == 0L) {
            this.serverButton.setSelection(true);
        } else {
            this.revisionButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchTagWizardCopyPage.this.revisionText.setEnabled(BranchTagWizardCopyPage.this.revisionButton.getSelection());
                BranchTagWizardCopyPage.this.logButton.setEnabled(BranchTagWizardCopyPage.this.revisionButton.getSelection());
                if (BranchTagWizardCopyPage.this.revisionButton.getSelection()) {
                    BranchTagWizardCopyPage.this.revisionText.setFocus();
                }
                BranchTagWizardCopyPage.this.setPageComplete(BranchTagWizardCopyPage.this.canFinish());
            }
        };
        this.serverButton.addSelectionListener((SelectionListener)selectionListener);
        this.revisionButton.addSelectionListener((SelectionListener)selectionListener);
        this.workingCopyButton.addSelectionListener((SelectionListener)selectionListener);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener(focusListener);
        this.setControl((Control)outerContainer);
    }

    private void showLog() {
        ISVNRemoteResource remoteResource = null;
        if (((BranchTagWizard)this.getWizard()).multipleSelections()) {
            ISVNRepositoryLocation repository = null;
            repository = this.resource == null ? this.remoteResource.getRepository() : SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository();
            try {
                remoteResource = repository.getRemoteFile(new SVNUrl(((BranchTagWizard)this.getWizard()).getCommonRoot()));
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
        }
        if (this.resource == null) {
            remoteResource = this.remoteResource;
        } else {
            try {
                remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository().getRemoteFile(((BranchTagWizard)this.getWizard()).getUrl());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + ((BranchTagWizard)this.getWizard()).getUrlText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setPageComplete(this.canFinish());
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public String getRevision() {
        return this.revisionText.getText().trim();
    }

    private boolean canFinish() {
        return !this.revisionButton.getSelection() || this.revisionText.getText().trim().length() != 0;
    }
}

