/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.editor.RemoteFileEditorInput;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class OpenRemoteFileAction
extends SVNAction {
    private boolean usePegRevision;

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IWorkbench workbench = SVNUIPlugin.getPlugin().getWorkbench();
                IEditorRegistry registry = workbench.getEditorRegistry();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                ISVNRemoteFile[] files = OpenRemoteFileAction.this.getSelectedRemoteFiles();
                int i = 0;
                while (i < files.length) {
                    ISVNRemoteFile file = files[i];
                    String filename = file.getName();
                    IEditorDescriptor descriptor = registry.getDefaultEditor(filename);
                    if (descriptor == null) {
                        descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
                    }
                    String id = descriptor == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
                    try {
                        try {
                            if (OpenRemoteFileAction.this.usePegRevision && files[i] instanceof RemoteResource) {
                                ((RemoteResource)files[i]).setPegRevision(files[i].getRevision());
                            } else {
                                ((RemoteResource)files[i]).setPegRevision(SVNRevision.HEAD);
                            }
                            RemoteFileEditorInput input = new RemoteFileEditorInput(files[i], monitor);
                            if (descriptor != null && descriptor.isOpenExternal()) {
                                input.writeToTempFile();
                            }
                            page.openEditor((IEditorInput)input, id);
                        }
                        catch (PartInitException e) {
                            if (id.equals("org.eclipse.ui.DefaultTextEditor")) {
                                throw e;
                            }
                            RemoteFileEditorInput input = new RemoteFileEditorInput(files[i], monitor);
                            page.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor");
                        }
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)OpenRemoteFileAction.this.getShell(), (String)Policy.bind("OpenRemoteFileAction.0"), (String)e.getMessage());
                    }
                    ++i;
                }
            }
        }, false, 2);
    }

    protected boolean isEnabled() {
        ISVNRemoteFile[] resources = this.getSelectedRemoteFiles();
        return resources.length != 0;
    }

    public void setUsePegRevision(boolean usePegRevision) {
        this.usePegRevision = usePegRevision;
    }
}

