/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.conflicts.SVNConflictResolver;
import org.tigris.subversion.subclipse.ui.operations.UpdateOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateAction
extends WorkbenchWindowAction {
    private IResource[] selectedResources;
    private int depth = 0;
    private boolean setDepth = false;
    protected boolean canRunAsJob = true;

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
            IResource[] resources = this.getSelectedResources();
            SVNConflictResolver conflictResolver = new SVNConflictResolver(resources[0], store.getInt("pref_update_to_head_conflict_handling_text_files"), store.getInt("pref_update_to_head_conflict_handling_binary_files"), store.getInt("pref_update_to_head_conflict_handling_properties"));
            UpdateOperation updateOperation = new UpdateOperation(this.getTargetPart(), resources, SVNRevision.HEAD);
            updateOperation.setDepth(this.depth);
            updateOperation.setSetDepth(this.setDepth);
            updateOperation.setForce(store.getBoolean("pref_update_to_head_allow_unversioned_obstructions"));
            updateOperation.setIgnoreExternals(store.getBoolean("pref_update_to_head_ignore_externals"));
            updateOperation.setCanRunAsJob(this.canRunAsJob);
            updateOperation.setConflictResolver(conflictResolver);
            updateOperation.run();
        }
    }

    protected IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return super.getSelectedResources();
        }
        return this.selectedResources;
    }

    protected String getErrorTitle() {
        return Policy.bind("UpdateAction.updateerror");
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected String getImageId() {
        return "Menu Update";
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }
}

