/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.comments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.DialogArea;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;

public class CommitCommentArea
extends DialogArea {
    private boolean showLabel = true;
    public static final String SPELLING_ERROR = "spelling.error";
    private static final String EMPTY_MESSAGE = Policy.bind("CommitCommentArea_0");
    private static final String COMBO_MESSAGE = Policy.bind("CommitCommentArea_1");
    public static final String OK_REQUESTED = "OkRequested";
    public static final String COMMENT_MODIFIED = "CommentModified";
    private TextBox fTextBox;
    private ComboBox fComboBox;
    private String fProposedComment;
    private Composite fComposite;
    private String enterCommentMessage;
    private CommentProperties commentProperties;
    private ModifyListener modifyListener;

    public CommitCommentArea(Dialog parentDialog, IDialogSettings settings) {
        super(parentDialog, settings);
    }

    public CommitCommentArea(Dialog parentDialog, IDialogSettings settings, CommentProperties commentProperties) {
        this(parentDialog, settings);
        this.commentProperties = commentProperties;
    }

    public CommitCommentArea(Dialog parentDialog, IDialogSettings settings, String enterCommentMessage) {
        this(parentDialog, settings);
        this.enterCommentMessage = enterCommentMessage;
    }

    public CommitCommentArea(Dialog parentDialog, IDialogSettings settings, String enterCommentMessage, CommentProperties commentProperties) {
        this(parentDialog, settings, enterCommentMessage);
        this.commentProperties = commentProperties;
    }

    public Control createArea(Composite parent) {
        this.fComposite = this.createGrabbingComposite(parent, 1);
        this.initializeDialogUnits((Control)this.fComposite);
        if (this.showLabel) {
            Label label = new Label(this.fComposite, 0);
            label.setLayoutData((Object)new GridData());
            if (this.enterCommentMessage == null) {
                label.setText(Policy.bind("ReleaseCommentDialog.enterComment"));
            } else {
                label.setText(this.enterCommentMessage);
            }
        }
        this.fTextBox = new TextBox(this.fComposite, EMPTY_MESSAGE, this.getInitialComment());
        String[] comments = SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().getPreviousComments();
        String[] commentTemplates = SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().getCommentTemplates();
        this.fComboBox = new ComboBox(this.fComposite, COMBO_MESSAGE, comments, commentTemplates);
        Link templatesPrefsLink = new Link(this.fComposite, 0);
        templatesPrefsLink.setText("<a href=\"configureTemplates\">Configure Comment Templates...</a>");
        templatesPrefsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CommitCommentArea.this.openCommentTemplatesPreferencePage();
            }

            public void widgetSelected(SelectionEvent e) {
                CommitCommentArea.this.openCommentTemplatesPreferencePage();
            }
        });
        this.fComboBox.addObserver(this.fTextBox);
        return this.fComposite;
    }

    void openCommentTemplatesPreferencePage() {
        PreferencesUtil.createPreferenceDialogOn(null, (String)"org.tigris.subversion.subclipse.ui.CommentTemplatesPreferences", (String[])new String[]{"org.tigris.subversion.subclipse.ui.CommentTemplatesPreferences"}, null).open();
        this.fComboBox.setCommentTemplates(SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().getCommentTemplates());
    }

    public String getComment() {
        return this.getComment(false);
    }

    public String getComment(boolean save) {
        String comment = this.fTextBox.getText();
        if (comment == null) {
            return "";
        }
        if (save) {
            this.addComment(comment);
        }
        return comment;
    }

    public void addComment(String comment) {
        if (comment != null && comment.trim().length() > 0) {
            SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().addComment(comment);
        }
    }

    public String getCommentWithPrompt(Shell shell) {
        String comment = this.getComment(false);
        if (comment.length() == 0) {
            String toggleMessage;
            String message;
            String title;
            MessageDialogWithToggle dialog;
            IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
            String value = store.getString("pref_allow_empty_commit_comment");
            if ("never".equals(value)) {
                return null;
            }
            if ("prompt".equals(value) && (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)(title = Policy.bind("CommitCommentArea_2")), (String)(message = Policy.bind("CommitCommentArea_3")), (String)(toggleMessage = Policy.bind("CommitCommentArea_4")), (boolean)false, (IPreferenceStore)store, (String)"pref_allow_empty_commit_comment")).getReturnCode() != 2) {
                this.fTextBox.setFocus();
                return null;
            }
        }
        return this.getComment(true);
    }

    public void setFocus() {
        if (this.fTextBox != null) {
            this.fTextBox.setFocus();
        }
    }

    public void setProposedComment(String proposedComment) {
        this.fProposedComment = proposedComment == null || proposedComment.length() == 0 ? null : proposedComment;
    }

    public boolean hasCommitTemplate() {
        try {
            String commitTemplate = this.getCommitTemplate();
            return commitTemplate != null && commitTemplate.length() > 0;
        }
        catch (SVNException e) {
            SVNUIPlugin.log((TeamException)((Object)e));
            return false;
        }
    }

    public void setEnabled(boolean enabled) {
        this.fTextBox.setEnabled(enabled);
        this.fComboBox.setEnabled(enabled);
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    public int getCommentLength() {
        if (this.fTextBox == null) {
            return 0;
        }
        return this.fTextBox.getCommentLength();
    }

    protected void firePropertyChangeChange(String property, Object oldValue, Object newValue) {
        super.firePropertyChangeChange(property, oldValue, newValue);
    }

    private String getInitialComment() {
        if (this.fProposedComment != null) {
            return this.fProposedComment;
        }
        try {
            return this.getCommitTemplate();
        }
        catch (SVNException e) {
            SVNUIPlugin.log((TeamException)((Object)e));
            return "";
        }
    }

    private String getCommitTemplate() throws SVNException {
        if (this.commentProperties != null && this.commentProperties.getLogTemplate() != null) {
            return this.commentProperties.getLogTemplate();
        }
        return "";
    }

    public void setModifyListener(ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    private class TextBox
    implements ModifyListener,
    TraverseListener,
    FocusListener,
    Observer {
        private final StyledText fTextField;
        private final String fMessage;
        private String fText;
        private LocalResourceManager fResources;

        public TextBox(Composite composite, String message, String initialText) {
            Font commentFont;
            this.fMessage = message;
            this.fText = initialText;
            this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
            AnnotationModel annotationModel = new AnnotationModel();
            DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
            AnnotationRulerColumn annotationRuler = new AnnotationRulerColumn((IAnnotationModel)annotationModel, 16, (IAnnotationAccess)annotationAccess);
            CompositeRuler compositeRuler = new CompositeRuler();
            compositeRuler.setModel((IAnnotationModel)annotationModel);
            compositeRuler.addDecorator(0, (IVerticalRulerColumn)annotationRuler);
            Composite cc = new Composite(composite, 2048);
            cc.setLayout((Layout)new FillLayout());
            cc.setLayoutData((Object)new GridData(1808));
            SourceViewer sourceViewer = new SourceViewer(cc, (IVerticalRuler)compositeRuler, null, true, 770);
            if (CommitCommentArea.this.modifyListener != null) {
                sourceViewer.getTextWidget().addModifyListener(CommitCommentArea.this.modifyListener);
            }
            if ((commentFont = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("svn_comment_font")) != null) {
                sourceViewer.getTextWidget().setFont(commentFont);
            }
            int widthMarker = 0;
            if (CommitCommentArea.this.commentProperties != null) {
                widthMarker = CommitCommentArea.this.commentProperties.getLogWidthMarker();
            }
            if (widthMarker > 0) {
                MarginPainter marginPainter = new MarginPainter((ITextViewer)sourceViewer);
                marginPainter.setMarginRulerColumn(widthMarker);
                marginPainter.setMarginRulerColor(Display.getCurrent().getSystemColor(15));
                sourceViewer.addPainter((IPainter)marginPainter);
            }
            sourceViewer.showAnnotations(false);
            sourceViewer.showAnnotationsOverview(false);
            if (this.isSpellingAnnotationEnabled()) {
                AnnotationPainter ap = new AnnotationPainter((ISourceViewer)sourceViewer, (IAnnotationAccess)annotationAccess);
                ap.addAnnotationType((Object)CommitCommentArea.SPELLING_ERROR);
                ap.setAnnotationTypeColor((Object)CommitCommentArea.SPELLING_ERROR, this.getSpellingErrorColor(composite));
                sourceViewer.addPainter((IPainter)ap);
            }
            Document document = new Document(initialText);
            sourceViewer.configure((SourceViewerConfiguration)new SourceViewerConfig(annotationModel, document));
            sourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
            this.fTextField = sourceViewer.getTextWidget();
            this.fTextField.addTraverseListener((TraverseListener)this);
            this.fTextField.addModifyListener((ModifyListener)this);
            this.fTextField.addFocusListener((FocusListener)this);
            this.fTextField.setWordWrap(this.mustWrapWord());
        }

        private boolean mustWrapWord() {
            return CommitCommentArea.this.commentProperties == null || CommitCommentArea.this.commentProperties.getLogWidthMarker() <= 0;
        }

        private boolean isSpellingAnnotationEnabled() {
            return true;
        }

        private Color getSpellingErrorColor(Composite composite) {
            AnnotationPreference pref = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference("org.eclipse.ui.workbench.texteditor.spelling");
            String preferenceKey = pref.getColorPreferenceKey();
            try {
                return this.fResources.createColor(PreferenceConverter.getColor((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)preferenceKey));
            }
            catch (DeviceResourceException e) {
                SVNUIPlugin.log(4, Policy.bind("internal"), e);
                return JFaceColors.getErrorText((Display)composite.getDisplay());
            }
        }

        public void modifyText(ModifyEvent e) {
            String old = this.fText;
            this.fText = this.fTextField.getText();
            CommitCommentArea.this.firePropertyChangeChange(CommitCommentArea.COMMENT_MODIFIED, old, this.fText);
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4 && (e.stateMask & 0x20000) != 0) {
                e.doit = false;
                return;
            }
            if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
                e.doit = false;
                CommitCommentArea.this.firePropertyChangeChange(CommitCommentArea.OK_REQUESTED, null, null);
            }
        }

        public void focusGained(FocusEvent e) {
            if (this.fText.length() > 0) {
                return;
            }
            this.fTextField.removeModifyListener((ModifyListener)this);
            try {
                this.fTextField.setText(this.fText);
            }
            finally {
                this.fTextField.addModifyListener((ModifyListener)this);
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.fText.length() > 0) {
                return;
            }
            this.fTextField.removeModifyListener((ModifyListener)this);
            try {
                this.fTextField.setText(this.fMessage);
                this.fTextField.selectAll();
            }
            finally {
                this.fTextField.addModifyListener((ModifyListener)this);
            }
        }

        public void setEnabled(boolean enabled) {
            this.fTextField.setEnabled(enabled);
        }

        public void update(Observable o, Object arg) {
            if (arg instanceof String) {
                this.setText((String)arg);
                if (CommitCommentArea.this.modifyListener != null) {
                    CommitCommentArea.this.modifyListener.modifyText(null);
                }
            }
        }

        public String getText() {
            return this.fText;
        }

        public int getCommentLength() {
            if (this.fTextField == null) {
                return 0;
            }
            if (this.fTextField.getText().equals(Policy.bind("CommitCommentArea_0"))) {
                return 0;
            }
            return this.fTextField.getText().trim().length();
        }

        private void setText(String text) {
            if (text.length() == 0) {
                this.fTextField.setText(this.fMessage);
                this.fTextField.selectAll();
            } else {
                this.fTextField.setText(text);
            }
        }

        public void setFocus() {
            this.fTextField.setFocus();
        }
    }

    public class SourceViewerConfig
    extends SourceViewerConfiguration {
        private CommentSpellingReconcileStrategy strategy;

        public SourceViewerConfig(AnnotationModel annotationModel, Document document) {
            this.strategy = new CommentSpellingReconcileStrategy(annotationModel);
            this.strategy.setDocument((IDocument)document);
        }

        public IReconciler getReconciler(ISourceViewer sourceViewer) {
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)this.strategy, false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(200);
            return reconciler;
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
            return new DefaultTextHover(sourceViewer);
        }
    }

    public class CommentSpellingReconcileStrategy
    implements IReconcilingStrategy {
        private IDocument fDocument;
        private SpellingContext fSpellingContext;
        private IAnnotationModel fAnnotationModel;

        public CommentSpellingReconcileStrategy(AnnotationModel annotationModel) {
            this.fAnnotationModel = annotationModel;
            this.fSpellingContext = new SpellingContext();
            this.fSpellingContext.setContentType(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"));
        }

        public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
            this.reconcile(subRegion);
        }

        public void reconcile(IRegion region) {
            SpellingProblemCollector collector = new SpellingProblemCollector(this.fAnnotationModel);
            EditorsUI.getSpellingService().check(this.fDocument, this.fSpellingContext, (ISpellingProblemCollector)collector, null);
        }

        public void setDocument(IDocument document) {
            this.fDocument = document;
        }

        private class SpellingProblemCollector
        implements ISpellingProblemCollector {
            private IAnnotationModel fAnnotationModel;
            private Map fAddAnnotations;

            public SpellingProblemCollector(IAnnotationModel annotationModel) {
                this.fAnnotationModel = annotationModel;
            }

            public void accept(SpellingProblem problem) {
                this.fAddAnnotations.put(new Annotation(CommitCommentArea.SPELLING_ERROR, false, problem.getMessage()), new Position(problem.getOffset(), problem.getLength()));
            }

            public void beginCollecting() {
                this.fAddAnnotations = new HashMap();
            }

            public void endCollecting() {
                ArrayList<Annotation> removeAnnotations = new ArrayList<Annotation>();
                Iterator<Object> iter = this.fAnnotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    if (!CommitCommentArea.SPELLING_ERROR.equals(annotation.getType())) continue;
                    removeAnnotations.add(annotation);
                }
                iter = removeAnnotations.iterator();
                while (iter.hasNext()) {
                    this.fAnnotationModel.removeAnnotation((Annotation)iter.next());
                }
                for (Annotation annotation : this.fAddAnnotations.keySet()) {
                    this.fAnnotationModel.addAnnotation(annotation, (Position)this.fAddAnnotations.get(annotation));
                }
                this.fAddAnnotations = null;
            }
        }
    }

    private static class ComboBox
    extends Observable
    implements SelectionListener,
    FocusListener {
        private final String fMessage;
        private final String[] fComments;
        private String[] fCommentTemplates;
        private final Combo fCombo;

        public ComboBox(Composite composite, String message, String[] options, String[] commentTemplates) {
            this.fMessage = message;
            this.fComments = options;
            this.fCommentTemplates = commentTemplates;
            this.fCombo = new Combo(composite, 8);
            this.fCombo.setLayoutData((Object)SWTUtils.createHFillGridData());
            this.fCombo.setVisibleItemCount(20);
            this.populateList();
            this.fCombo.addFocusListener((FocusListener)this);
            this.fCombo.addSelectionListener((SelectionListener)this);
        }

        private void populateList() {
            this.fCombo.removeAll();
            this.fCombo.add(this.fMessage);
            int i = 0;
            while (i < this.fCommentTemplates.length) {
                this.fCombo.add(String.valueOf(Policy.bind("CommitCommentArea_6")) + ": " + Util.flattenText((String)this.fCommentTemplates[i]));
                ++i;
            }
            i = 0;
            while (i < this.fComments.length) {
                this.fCombo.add(Util.flattenText((String)this.fComments[i]));
                ++i;
            }
            this.fCombo.setText(this.fMessage);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.fCombo.getSelectionIndex();
            if (index > 0) {
                this.setChanged();
                String message = --index < this.fCommentTemplates.length ? this.fCommentTemplates[index] : this.fComments[index - this.fCommentTemplates.length];
                this.notifyObservers(message);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.fCombo.removeSelectionListener((SelectionListener)this);
            try {
                this.fCombo.setText(this.fMessage);
            }
            finally {
                this.fCombo.addSelectionListener((SelectionListener)this);
            }
        }

        public void setEnabled(boolean enabled) {
            this.fCombo.setEnabled(enabled);
        }

        void setCommentTemplates(String[] templates) {
            this.fCommentTemplates = templates;
            this.populateList();
        }
    }
}

