/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.tigris.subversion.subclipse.ui.conflicts.ExternalFileStorage;

public class ExternalFileEditorInput
implements IPathEditorInput,
IStorageEditorInput,
ILocationProvider {
    private IFileStore fFileStore;
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();
    private IStorage fStorage;
    private IPath fPath;

    public ExternalFileEditorInput(IFileStore fileStore) {
        this.fFileStore = fileStore;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
    }

    public boolean exists() {
        return this.fFileStore.fetchInfo().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFileStore.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFileStore.toString();
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return this.fWorkbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof ExternalFileEditorInput) {
            return ((ExternalFileEditorInput)element).getPath();
        }
        return null;
    }

    public IPath getPath() {
        if (this.fPath == null) {
            this.fPath = new Path(this.fFileStore.toURI().getPath());
        }
        return this.fPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExternalFileEditorInput) {
            ExternalFileEditorInput input = (ExternalFileEditorInput)o;
            return this.fFileStore.equals(input.fFileStore);
        }
        if (o instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)o;
            return this.getPath().equals((Object)input.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }

    public IStorage getStorage() throws CoreException {
        if (this.fStorage == null) {
            this.fStorage = new ExternalFileStorage(this.fFileStore);
        }
        return this.fStorage;
    }

    private class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((ExternalFileEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

