/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.util.DaySelectionCanvas;

public class DateSelectionDialog
extends Dialog {
    private Date date;
    private Composite dateComp;
    private DaySelectionCanvas daysComp;
    private Spinner yearSpinner;
    private Combo monthCombo;
    private boolean refreshing;

    public DateSelectionDialog(Shell parent, String dateString) {
        super(parent);
        this.setShellStyle(64);
        this.date = this.parseDate(dateString);
    }

    public Date getDate() {
        return this.date;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Policy.bind("DateSelectionDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.dateComp = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.dateComp.setLayout((Layout)gridLayout);
        this.dateComp.setLayoutData((Object)new GridData(768));
        this.monthCombo = new Combo(this.dateComp, 12);
        this.monthCombo.add(Policy.bind("DateSelectionDialog.january"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.february"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.march"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.april"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.may"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.june"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.july"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.august"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.september"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.october"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.november"));
        this.monthCombo.add(Policy.bind("DateSelectionDialog.december"));
        this.monthCombo.setLayoutData((Object)new GridData(32));
        Calendar calendar = DateFormat.getDateTimeInstance().getCalendar();
        calendar.setTime(this.date);
        this.yearSpinner = new Spinner(this.dateComp, 2048);
        this.yearSpinner.setValues(calendar.get(1), calendar.getActualMinimum(1), calendar.getActualMaximum(1), 0, 1, 1);
        this.yearSpinner.setLayoutData((Object)new GridData(640));
        this.daysComp = new DaySelectionCanvas(composite, 2048);
        this.daysComp.setLayoutData(new GridData(1808));
        String[] header = new String[]{Policy.bind("DateSelectionDialog.monday"), Policy.bind("DateSelectionDialog.tuesday"), Policy.bind("DateSelectionDialog.wednesday"), Policy.bind("DateSelectionDialog.thursday"), Policy.bind("DateSelectionDialog.friday"), Policy.bind("DateSelectionDialog.saturday"), Policy.bind("DateSelectionDialog.sunday")};
        this.daysComp.setHeader(header);
        this.monthCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DateSelectionDialog.this.refreshing) {
                    DateSelectionDialog.this.refreshDays(DateSelectionDialog.this.monthCombo.getSelectionIndex(), DateSelectionDialog.this.yearSpinner.getSelection());
                }
            }
        });
        this.yearSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!DateSelectionDialog.this.refreshing) {
                    DateSelectionDialog.this.refreshDays(DateSelectionDialog.this.monthCombo.getSelectionIndex(), DateSelectionDialog.this.yearSpinner.getSelection());
                }
            }
        });
        this.yearSpinner.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DateSelectionDialog.this.refreshDays(DateSelectionDialog.this.monthCombo.getSelectionIndex(), DateSelectionDialog.this.yearSpinner.getSelection());
            }
        });
        this.yearSpinner.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DateSelectionDialog.this.refreshDays(DateSelectionDialog.this.monthCombo.getSelectionIndex(), DateSelectionDialog.this.yearSpinner.getSelection());
            }
        });
        this.daysComp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int day = DateSelectionDialog.this.daysComp.getSelectedDay();
                if (day > 0) {
                    Calendar calendar = DateFormat.getDateTimeInstance().getCalendar();
                    calendar.setTime(DateSelectionDialog.this.date);
                    calendar.set(5, day);
                    calendar.set(2, DateSelectionDialog.this.monthCombo.getSelectionIndex());
                    calendar.set(1, DateSelectionDialog.this.yearSpinner.getSelection());
                    DateSelectionDialog.this.date = calendar.getTime();
                    DateSelectionDialog.this.close();
                }
            }
        });
        this.refreshDate();
        return composite;
    }

    private Date parseDate(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(DateFormat.getDateInstance(3).parse(date));
        }
        catch (ParseException parseException) {}
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private void refreshDays(int month, int year) {
        Calendar calendar = DateFormat.getDateTimeInstance().getCalendar();
        calendar.setTime(this.date);
        calendar.set(5, 1);
        calendar.set(2, month);
        calendar.set(1, year);
        int day = this.daysComp.getSelectedDay();
        if (day > 0) {
            if (day > calendar.getActualMaximum(5)) {
                day = calendar.getActualMaximum(5);
            }
            calendar.set(5, day);
        }
        this.date = calendar.getTime();
        this.refreshDate();
    }

    private void refreshDate() {
        this.refreshing = true;
        Calendar calendar = DateFormat.getDateTimeInstance().getCalendar();
        calendar.setTime(this.date);
        int day = calendar.get(5);
        this.yearSpinner.setSelection(calendar.get(1));
        this.monthCombo.select(calendar.get(2));
        int maxDays = calendar.getActualMaximum(5);
        calendar.add(2, -1);
        int prevMaxDays = calendar.getActualMaximum(5);
        calendar.add(2, 1);
        calendar.set(5, 1);
        int weekDay = calendar.get(7);
        int convertedWeekDay = (weekDay + 5) % 7;
        boolean addFirstWeek = false;
        int remainingDays = 42 - maxDays - convertedWeekDay;
        if (remainingDays - convertedWeekDay > 7) {
            addFirstWeek = true;
        }
        int[] days = new int[42];
        int i = 0;
        int numPrefix = convertedWeekDay;
        if (addFirstWeek) {
            numPrefix += 7;
        }
        while (i < numPrefix) {
            days[i] = prevMaxDays - numPrefix + i + 1;
            ++i;
        }
        int numMonth = numPrefix + maxDays;
        while (i < numMonth) {
            days[i] = i - numPrefix + 1;
            ++i;
        }
        while (i < days.length) {
            days[i] = i - numMonth + 1;
            ++i;
        }
        this.daysComp.setDays(days);
        this.daysComp.setSelectedDay(day);
        this.refreshing = false;
    }
}

