/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.history.ChangePathsFlatViewer;
import org.tigris.subversion.subclipse.ui.history.ChangePathsTableProvider;
import org.tigris.subversion.subclipse.ui.history.ChangePathsTreeViewer;
import org.tigris.subversion.subclipse.ui.history.SVNHistoryPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShowRevisionsDialog
extends TrayDialog {
    private ILogEntry logEntry;
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    private boolean includeTags;
    private SashForm sashForm;
    private StructuredViewer changePathsViewer;
    private TreeViewer treeHistoryViewer;
    private TextViewer textViewer;
    private IAction showDifferencesAsUnifiedDiffAction;
    private IDialogSettings settings;
    private TreeColumn revisionColumn;
    private TreeColumn tagsColumn;
    private TreeColumn dateColumn;
    private TreeColumn authorColumn;
    private TreeColumn commentColumn;
    private SVNHistoryPage historyPage;
    private String title;
    private boolean selectFirst;
    private static final int WIDTH_HINT = 500;
    private static final int LOG_HEIGHT_HINT = 200;
    private static final int COMMENT_HEIGHT_HINT = 100;
    private static final int COL_REVISION = 0;
    private static final int COL_TAGS = 1;
    private static final int COL_DATE = 2;
    private static final int COL_AUTHOR = 3;
    private static final int COL_COMMENT = 4;

    public ShowRevisionsDialog(Shell parentShell, ILogEntry logEntry, IResource resource, boolean includeTags, SVNHistoryPage historyPage) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.logEntry = logEntry;
        this.resource = resource;
        this.includeTags = includeTags;
        this.historyPage = historyPage;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
    }

    public ShowRevisionsDialog(Shell parentShell, ILogEntry logEntry, ISVNRemoteResource remoteResource, boolean includeTags, SVNHistoryPage historyPage) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.logEntry = logEntry;
        this.remoteResource = remoteResource;
        this.includeTags = includeTags;
        this.historyPage = historyPage;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.title == null) {
            this.getShell().setText(Policy.bind("HistoryView.showMergedRevisions"));
        } else {
            this.getShell().setText(this.title);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.sashForm = new SashForm(composite, 512);
        this.sashForm.setLayout((Layout)new GridLayout());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        Composite historyGroup = new Composite((Composite)this.sashForm, 0);
        historyGroup.setLayout((Layout)new GridLayout());
        historyGroup.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(historyGroup, 67584);
        this.treeHistoryViewer = new TreeViewer(tree);
        data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 200;
        this.treeHistoryViewer.getTree().setLayoutData((Object)data);
        this.treeHistoryViewer.getTree().setHeaderVisible(true);
        this.revisionColumn = new TreeColumn(this.treeHistoryViewer.getTree(), 0);
        this.revisionColumn.setResizable(true);
        this.revisionColumn.setText(Policy.bind("HistoryView.revision"));
        int revisionWidth = 75;
        int tagsWidth = 225;
        int dateWidth = 100;
        int authorWidth = 100;
        int commentWidth = 300;
        try {
            revisionWidth = this.settings.getInt("ShowRevisionsDialog.width_revision");
            dateWidth = this.settings.getInt("ShowRevisionsDialog.width_date");
            authorWidth = this.settings.getInt("ShowRevisionsDialog.width_author");
            commentWidth = this.settings.getInt("ShowRevisionsDialog.width_comment");
            tagsWidth = this.settings.getInt("ShowRevisionsDialog.width_tag");
        }
        catch (Exception exception) {}
        this.revisionColumn.setWidth(revisionWidth);
        if (this.includeTags) {
            this.tagsColumn = new TreeColumn(this.treeHistoryViewer.getTree(), 0);
            this.tagsColumn.setResizable(true);
            this.tagsColumn.setText(Policy.bind("HistoryView.tags"));
            this.tagsColumn.setWidth(tagsWidth);
        }
        this.dateColumn = new TreeColumn(this.treeHistoryViewer.getTree(), 0);
        this.dateColumn.setResizable(true);
        this.dateColumn.setText(Policy.bind("HistoryView.date"));
        this.dateColumn.setWidth(dateWidth);
        this.authorColumn = new TreeColumn(this.treeHistoryViewer.getTree(), 0);
        this.authorColumn.setResizable(true);
        this.authorColumn.setText(Policy.bind("HistoryView.author"));
        this.authorColumn.setWidth(authorWidth);
        this.commentColumn = new TreeColumn(this.treeHistoryViewer.getTree(), 0);
        this.commentColumn.setResizable(true);
        this.commentColumn.setText(Policy.bind("HistoryView.comment"));
        this.commentColumn.setWidth(commentWidth);
        this.treeHistoryViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ILogEntry entry = (ILogEntry)element;
                int index = columnIndex;
                if (index > 0 && !ShowRevisionsDialog.this.includeTags) {
                    ++index;
                }
                switch (index) {
                    case 0: {
                        String revision = entry.getRevision().toString();
                        return revision;
                    }
                    case 1: {
                        return AliasManager.getAliasesAsString((Alias[])entry.getTags());
                    }
                    case 2: {
                        Date date = entry.getDate();
                        if (date == null) {
                            return Policy.bind("notAvailable");
                        }
                        return DateFormat.getInstance().format(date);
                    }
                    case 3: {
                        if (entry.getAuthor() == null) {
                            return Policy.bind("noauthor");
                        }
                        return entry.getAuthor();
                    }
                    case 4: {
                        String comment = entry.getComment();
                        if (comment == null) {
                            return "";
                        }
                        int rIndex = comment.indexOf("\r");
                        int nIndex = comment.indexOf("\n");
                        if (rIndex == -1 && nIndex == -1) {
                            return comment;
                        }
                        if (rIndex == 0 || nIndex == 0) {
                            return Policy.bind("HistoryView.[...]_4");
                        }
                        if (rIndex != -1) {
                            return Policy.bind("SVNCompareRevisionsInput.truncate", comment.substring(0, rIndex));
                        }
                        return Policy.bind("SVNCompareRevisionsInput.truncate", comment.substring(0, nIndex));
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.treeHistoryViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof ILogEntry) {
                    return ((ILogEntry)element).getChildMessages();
                }
                Object[] logEntries = new ILogEntry[]{ShowRevisionsDialog.this.logEntry};
                return logEntries;
            }

            public Object[] getElements(Object element) {
                return this.getChildren(element);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ILogEntry) {
                    return ((ILogEntry)element).getNumberOfChildren() > 0L;
                }
                return false;
            }
        });
        this.treeHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    ShowRevisionsDialog.this.textViewer.setDocument((IDocument)new Document(""));
                    ShowRevisionsDialog.this.changePathsViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    ShowRevisionsDialog.this.textViewer.setDocument((IDocument)new Document(""));
                    ShowRevisionsDialog.this.changePathsViewer.setInput(null);
                    return;
                }
                LogEntry entry = (LogEntry)ss.getFirstElement();
                ShowRevisionsDialog.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                ShowRevisionsDialog.this.changePathsViewer.setInput((Object)entry);
            }
        });
        if (this.resource == null) {
            this.treeHistoryViewer.setInput((Object)this.remoteResource);
        } else {
            this.treeHistoryViewer.setInput((Object)this.resource);
        }
        this.treeHistoryViewer.resetFilters();
        this.treeHistoryViewer.expandToLevel(2);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeHistoryViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                ShowRevisionsDialog.this.fillTreeMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeHistoryViewer.getTree().setMenu(menu);
        Composite commentGroup = new Composite((Composite)this.sashForm, 0);
        commentGroup.setLayout((Layout)new GridLayout());
        commentGroup.setLayoutData((Object)new GridData(1808));
        this.textViewer = new TextViewer(commentGroup, 2826);
        data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 500;
        this.textViewer.getControl().setLayoutData((Object)data);
        Composite pathGroup = new Composite((Composite)this.sashForm, 0);
        pathGroup.setLayout((Layout)new GridLayout());
        pathGroup.setLayoutData((Object)new GridData(1808));
        IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
        int mode = store.getInt("pref_affected_paths_layout");
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof ILogEntry)) {
                    return null;
                }
                ILogEntry logEntry = (ILogEntry)inputElement;
                return logEntry.getLogEntryChangePaths();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        switch (mode) {
            case 2: {
                this.changePathsViewer = new ChangePathsTreeViewer(pathGroup, this.historyPage);
                break;
            }
            case 3: {
                this.changePathsViewer = new ChangePathsFlatViewer(pathGroup, this.historyPage);
                break;
            }
            default: {
                this.changePathsViewer = new ChangePathsTableProvider(pathGroup, (IContentProvider)contentProvider);
            }
        }
        try {
            int[] weights = new int[]{this.settings.getInt("ShowRevisionsDialog.weights.0"), this.settings.getInt("ShowRevisionsDialog.weights.1"), this.settings.getInt("ShowRevisionsDialog.weights.2")};
            this.sashForm.setWeights(weights);
        }
        catch (Exception exception) {}
        if (this.selectFirst && this.treeHistoryViewer.getTree().getItemCount() > 0) {
            TreeItem item = this.treeHistoryViewer.getTree().getItem(0);
            this.treeHistoryViewer.getTree().setSelection(item);
            this.treeHistoryViewer.setSelection(this.treeHistoryViewer.getSelection());
            this.changePathsViewer.refresh();
            if (this.changePathsViewer instanceof ChangePathsTreeViewer) {
                ((ChangePathsTreeViewer)this.changePathsViewer).expandAll();
            }
        }
        return composite;
    }

    private void fillTreeMenu(IMenuManager manager) {
        ISelection sel = this.treeHistoryViewer.getSelection();
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && ((IStructuredSelection)sel).size() == 1) {
            manager.add(this.getShowDifferencesAsUnifiedDiffAction());
        }
    }

    private IAction getShowDifferencesAsUnifiedDiffAction() {
        if (this.showDifferencesAsUnifiedDiffAction == null) {
            this.showDifferencesAsUnifiedDiffAction = new Action(Policy.bind("HistoryView.showDifferences"), SVNUIPlugin.getPlugin().getImageDescriptor("Menu Diff")){

                public void run() {
                    ISelection selection = ShowRevisionsDialog.this.treeHistoryViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ILogEntry currentSelection = (ILogEntry)ss.getFirstElement();
                    FileDialog dialog = new FileDialog(ShowRevisionsDialog.this.getShell(), 8192);
                    dialog.setText("Select Unified Diff Output File");
                    dialog.setFileName("revision" + currentSelection.getRevision().getNumber() + ".diff");
                    String outFile = dialog.open();
                    if (outFile != null) {
                        final SVNUrl url = currentSelection.getResource().getUrl();
                        SVNRevision.Number oldUrlRevision = new SVNRevision.Number(currentSelection.getRevision().getNumber() - 1L);
                        SVNRevision.Number newUrlRevision = currentSelection.getRevision();
                        File file = new File(outFile);
                        if (file.exists() && !MessageDialog.openQuestion((Shell)ShowRevisionsDialog.this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)Policy.bind("HistoryView.overwriteOutfile", file.getName()))) {
                            return;
                        }
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable((SVNRevision)oldUrlRevision, (SVNRevision)newUrlRevision, file){
                            private final /* synthetic */ SVNRevision val$oldUrlRevision;
                            private final /* synthetic */ SVNRevision val$newUrlRevision;
                            private final /* synthetic */ File val$file;
                            {
                                this.val$oldUrlRevision = sVNRevision;
                                this.val$newUrlRevision = sVNRevision2;
                                this.val$file = file;
                            }

                            public void run() {
                                ISVNClientAdapter client = null;
                                try {
                                    try {
                                        client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                                        client.diff(url, this.val$oldUrlRevision, this.val$newUrlRevision, this.val$file, true);
                                    }
                                    catch (Exception e) {
                                        MessageDialog.openError((Shell)ShowRevisionsDialog.this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)e.getMessage());
                                    }
                                }
                                finally {
                                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.showDifferencesAsUnifiedDiffAction;
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        super.okPressed();
    }

    public void setSelectFirst(boolean selectFirst) {
        this.selectFirst = selectFirst;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("ShowRevisionsDialog.location.x");
            int y = this.settings.getInt("ShowRevisionsDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("ShowRevisionsDialog.size.x");
            int y = this.settings.getInt("ShowRevisionsDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return new Point(400, 400);
        }
    }

    private void saveLocation() {
        this.settings.put("ShowRevisionsDialog.width_revision", this.revisionColumn.getWidth());
        this.settings.put("ShowRevisionsDialog.width_date", this.dateColumn.getWidth());
        this.settings.put("ShowRevisionsDialog.width_author", this.authorColumn.getWidth());
        this.settings.put("ShowRevisionsDialog.width_comment", this.commentColumn.getWidth());
        if (this.tagsColumn != null) {
            this.settings.put("ShowRevisionsDialog.width_tags", this.tagsColumn.getWidth());
        }
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("ShowRevisionsDialog.location.x", x);
        this.settings.put("ShowRevisionsDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("ShowRevisionsDialog.size.x", x);
        this.settings.put("ShowRevisionsDialog.size.y", y);
        int[] weights = this.sashForm.getWeights();
        int i = 0;
        while (i < weights.length) {
            this.settings.put("ShowRevisionsDialog.weights." + i, weights[i]);
            ++i;
        }
    }
}

