/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.editor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteFileEditorInput
implements IWorkbenchAdapter,
IStorageEditorInput,
IPathEditorInput {
    private ISVNRemoteFile file;
    protected IStorage storage;
    private File tempFile;

    public RemoteFileEditorInput(ISVNRemoteFile file, IProgressMonitor monitor) {
        this.file = file;
        try {
            this.initializeStorage(file, monitor);
        }
        catch (TeamException e) {
            SVNUIPlugin.log(e);
        }
    }

    protected void initializeStorage(ISVNRemoteFile file, IProgressMonitor monitor) throws TeamException {
        this.storage = file.getStorage(monitor);
    }

    public boolean exists() {
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteFileEditorInput)) {
            return false;
        }
        RemoteFileEditorInput input = (RemoteFileEditorInput)o;
        return this.file.equals((Object)input.file);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public String getContentType() {
        String name = this.file.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public ImageDescriptor getImageDescriptor() {
        IWorkbenchAdapter fileAdapter = (IWorkbenchAdapter)this.file.getAdapter(IWorkbenchAdapter.class);
        return fileAdapter == null ? null : fileAdapter.getImageDescriptor((Object)this.file);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        IWorkbenchAdapter fileAdapter = (IWorkbenchAdapter)this.file.getAdapter(IWorkbenchAdapter.class);
        return fileAdapter == null ? null : fileAdapter.getImageDescriptor((Object)this.file);
    }

    public String getLabel(Object o) {
        return this.file.getName();
    }

    public String getName() {
        String name = this.file.getName();
        SVNRevision.Number revision = this.file.getLastChangedRevision();
        return Policy.bind("nameAndRevision", name, revision != null ? revision.toString() : "");
    }

    public Object getParent(Object o) {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        if (this.storage == null) {
            this.initializeStorage(this.file, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.storage;
    }

    public String getToolTipText() {
        SVNUrl url = this.file.getUrl();
        return url.toString();
    }

    public ISVNRemoteFile getSVNRemoteFile() {
        return this.file;
    }

    public IPath getPath() {
        try {
            return new Path(this.writeToTempFile().getAbsolutePath());
        }
        catch (Exception e) {
            SVNUIPlugin.log(0, e.getMessage(), e);
            return null;
        }
    }

    public File writeToTempFile() throws IOException, CoreException {
        if (this.tempFile == null) {
            InputStream in = null;
            FilterOutputStream fOut = null;
            this.tempFile = null;
            in = this.getStorage().getContents();
            try {
                this.tempFile = File.createTempFile("svn", "." + this.getContentType());
            }
            catch (Exception e) {
                throw new IOException(String.valueOf(Policy.bind("RemoteFileEditorInput.3")) + e.toString());
            }
            try {
                try {
                    this.tempFile.deleteOnExit();
                    fOut = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                    byte[] buffer = new byte[32768];
                    int bytesRead = 0;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        ((BufferedOutputStream)fOut).write(buffer, 0, bytesRead);
                    }
                }
                catch (Exception e) {
                    throw new IOException(String.valueOf(Policy.bind("RemoteFileEditorInput.4")) + e.toString());
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (fOut != null) {
                    fOut.close();
                }
            }
        }
        return this.tempFile;
    }
}

