/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNExternal;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.BranchTagCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.commands.SwitchToUrlCommand;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagOperation
extends RepositoryProviderOperation {
    private SVNUrl[] sourceUrls;
    private SVNUrl destinationUrl;
    private SVNRevision revision;
    private boolean createOnServer;
    private boolean makeParents;
    private String message;
    private Alias newAlias;
    private boolean switchAfterTagBranch;
    private boolean branchCreated = false;
    private boolean multipleTransactions = true;
    private SVNExternal[] svnExternals;

    public BranchTagOperation(IWorkbenchPart part, IResource[] resources, SVNUrl[] sourceUrls, SVNUrl destinationUrl, boolean createOnServer, SVNRevision revision, String message) {
        super(part, resources);
        this.sourceUrls = sourceUrls;
        this.destinationUrl = destinationUrl;
        this.createOnServer = createOnServer;
        this.revision = revision;
        this.message = message;
    }

    protected String getTaskName() {
        return Policy.bind("BranchTagOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("BranchTagOperation.0", provider.getProject().getName());
    }

    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        block25: {
            if (this.branchCreated) {
                return;
            }
            this.branchCreated = true;
            monitor.beginTask(null, 100);
            try {
                try {
                    BranchTagCommand command = new BranchTagCommand(provider.getSVNWorkspaceRoot(), this.getResources(), this.sourceUrls, this.destinationUrl, this.message, this.createOnServer, this.revision);
                    command.setMakeParents(this.makeParents);
                    command.setMultipleTransactions(this.multipleTransactions);
                    command.run(Policy.subMonitorFor(monitor, 1000));
                    if (this.svnExternals != null) {
                        ISVNClientAdapter svnClient = null;
                        try {
                            try {
                                svnClient = provider.getSVNWorkspaceRoot().getRepository().getSVNClient();
                                int i = 0;
                                while (i < this.sourceUrls.length) {
                                    ISVNProperty[] copyToProperties;
                                    SVNUrl copyToUrl = command.getDestinationUrl(this.sourceUrls[i].toString());
                                    GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(provider.getSVNWorkspaceRoot().getRepository(), copyToUrl, SVNRevision.HEAD);
                                    try {
                                        getRemoteResourceCommand.run(null);
                                    }
                                    catch (SVNException e) {
                                        if (e.getStatus().getCode() == -6) {
                                            copyToUrl = this.destinationUrl;
                                        }
                                        throw e;
                                    }
                                    ISVNProperty[] iSVNPropertyArray = copyToProperties = svnClient.getProperties(copyToUrl);
                                    int n = 0;
                                    int n2 = iSVNPropertyArray.length;
                                    while (n < n2) {
                                        ISVNProperty copyToProperty = iSVNPropertyArray[n];
                                        if (copyToProperty.getName().equals("svn:externals")) {
                                            ISVNInfo info = svnClient.getInfo(copyToUrl);
                                            svnClient.propertySet(copyToProperty.getUrl(), info.getRevision(), "svn:externals", this.getUpdatedSvnExternalsProperty(copyToProperty), Policy.bind("BranchTagOperation.3"));
                                        }
                                        ++n;
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                throw SVNException.wrapException((Exception)e);
                            }
                        }
                        finally {
                            provider.getSVNWorkspaceRoot().getRepository().returnSVNClient(svnClient);
                        }
                    }
                    SVNUIPlugin.getPlugin().getRepositoryManager().resourceCreated(null, null);
                    if (this.newAlias != null) {
                        this.updateBranchTagProperty(resources[0]);
                    }
                    if (!this.switchAfterTagBranch) break block25;
                    int i = 0;
                    while (i < this.sourceUrls.length) {
                        SVNUrl switchDestinationUrl = command.getDestinationUrl(this.sourceUrls[i].toString());
                        GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(provider.getSVNWorkspaceRoot().getRepository(), switchDestinationUrl, SVNRevision.HEAD);
                        try {
                            getRemoteResourceCommand.run(null);
                        }
                        catch (SVNException e) {
                            if (e.getStatus().getCode() == -6) {
                                switchDestinationUrl = this.destinationUrl;
                            }
                            throw e;
                        }
                        resources = this.getResources();
                        SwitchToUrlCommand switchToUrlCommand = new SwitchToUrlCommand(provider.getSVNWorkspaceRoot(), resources[i], switchDestinationUrl, SVNRevision.HEAD);
                        switchToUrlCommand.run(Policy.subMonitorFor(monitor, 100));
                        ++i;
                    }
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                        break block25;
                    }
                    this.collectStatus(e.getStatus());
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected ISchedulingRule getSchedulingRule(SVNTeamProvider provider) {
        IResource[] resources = this.getResources();
        if (resources == null) {
            return super.getSchedulingRule(provider);
        }
        IResourceRuleFactory ruleFactory = provider.getRuleFactory();
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            rules.add(ruleFactory.modifyRule((IResource)resources[i].getProject()));
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
    }

    private String getUpdatedSvnExternalsProperty(ISVNProperty svnExternalsProperty) {
        String[] propertyLines;
        StringBuffer updatedProperty = new StringBuffer();
        String[] stringArray = propertyLines = svnExternalsProperty.getValue().split("\\n");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String propertyLine = stringArray[n];
            SVNExternal svnExternal = new SVNExternal(null, propertyLine);
            String newPropertyLine = null;
            SVNExternal[] sVNExternalArray = this.svnExternals;
            int n3 = 0;
            int n4 = sVNExternalArray.length;
            while (n3 < n4) {
                SVNExternal checkExternal = sVNExternalArray[n3];
                if (checkExternal.getUrl().equals(svnExternal.getUrl()) && checkExternal.getFolder().equals(svnExternal.getFolder()) && checkExternal.getPropertyLine().equals(svnExternal.getPropertyLine())) {
                    newPropertyLine = checkExternal.toString();
                    break;
                }
                ++n3;
            }
            if (newPropertyLine == null) {
                newPropertyLine = propertyLine;
            }
            if (updatedProperty.length() > 0) {
                updatedProperty.append("\n");
            }
            updatedProperty.append(newPropertyLine);
            ++n;
        }
        return updatedProperty.toString();
    }

    private void updateBranchTagProperty(IResource resource) {
        AliasManager aliasManager = new AliasManager(resource, false);
        Alias[] branchAliases = aliasManager.getBranches();
        Alias[] tagAliases = aliasManager.getTags();
        StringBuffer propertyValue = new StringBuffer();
        int i = 0;
        while (i < branchAliases.length) {
            if (branchAliases[i].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias branch = branchAliases[i];
                propertyValue.append(String.valueOf(branch.getRevision()) + "," + branch.getName());
                if (branch.getRelativePath() != null) {
                    propertyValue.append("," + branch.getRelativePath());
                }
                if (branch.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i;
        }
        i = 0;
        while (i < tagAliases.length) {
            if (tagAliases[i].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias tag = tagAliases[i];
                propertyValue.append(String.valueOf(tag.getRevision()) + "," + tag.getName());
                if (tag.getRelativePath() != null) {
                    propertyValue.append("," + tag.getRelativePath());
                }
                if (tag.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i;
        }
        if (propertyValue.length() > 0) {
            propertyValue.append("\n");
        }
        propertyValue.append(String.valueOf(this.newAlias.getRevision()) + "," + this.newAlias.getName() + "," + this.newAlias.getRelativePath());
        if (this.newAlias.isBranch()) {
            propertyValue.append(",branch");
        } else {
            propertyValue.append(",tag");
        }
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        try {
            svnResource.setSvnProperty("subclipse:tags", propertyValue.toString(), false);
        }
        catch (SVNException sVNException) {}
    }

    public void setNewAlias(Alias newAlias) {
        this.newAlias = newAlias;
    }

    public void switchAfterTagBranchOperation(boolean switchAfterTagBranchOperation) {
        this.switchAfterTagBranch = switchAfterTagBranchOperation;
    }

    public void setMakeParents(boolean makeParents) {
        this.makeParents = makeParents;
    }

    public void setMultipleTransactions(boolean multipleTransactions) {
        this.multipleTransactions = multipleTransactions;
    }

    public void setSvnExternals(SVNExternal[] svnExternals) {
        this.svnExternals = svnExternals;
    }
}

