/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.clientadapter.Activator;
import org.tigris.subversion.clientadapter.ISVNClientWrapper;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.internal.SWTUtils;

public class SVNPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showCompareRevisionInDialog;
    private Button fetchChangePathOnDemand;
    private Button showTagsInRemoteHistory;
    private Button showOutOfDateFolders;
    private Button useJavaHLCommitHack;
    private Button shareNestedProjects;
    private Button warnOnCommitToTagPath;
    private Button ignoreHiddenChanges;
    private Button ignoreManagedDerivedResources;
    private Button removeOnReplace;
    private Text logEntriesToFetchText;
    private Button defaultConfigLocationRadio;
    private Button useDirectoryLocationRadio;
    private Text directoryLocationText;
    private Button browseConfigDirButton;
    private Button quickDiffAnnotateYes;
    private Button quickDiffAnnotateNo;
    private Button quickDiffAnnotatePrompt;
    private Button resourcesWithErrorsYes;
    private Button resourcesWithErrorsNo;
    private Button resourcesWithErrorsPrompt;
    private Button resourcesWithWarningsYes;
    private Button resourcesWithWarningsNo;
    private Button resourcesWithWarningsPrompt;
    protected final ArrayList fFields = new ArrayList();
    private String[] CLIENT_VALUES;
    private String[] CLIENT_LABELS;

    public SVNPreferencesPage() {
        this.setDescription(Policy.bind("SVNPreferencePage.description"));
        ISVNClientWrapper[] clients = null;
        clients = Activator.getDefault().getAllClientWrappers();
        if (clients != null) {
            this.CLIENT_LABELS = new String[clients.length];
            this.CLIENT_VALUES = new String[clients.length];
            int i = 0;
            while (i < clients.length) {
                this.CLIENT_LABELS[i] = clients[i].getDisplayName();
                this.CLIENT_VALUES[i] = clients[i].getAdapterID();
                ++i;
            }
        } else {
            this.CLIENT_LABELS = new String[0];
            this.CLIENT_VALUES = new String[0];
        }
    }

    private Label createLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createRadio(Composite group, String label, int horizontalSpan) {
        Button button = new Button(group, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Control createContents(Composite parent) {
        boolean isHiddenSupported;
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.showCompareRevisionInDialog = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.showCompareMergeInSync"));
        this.removeOnReplace = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.removeOnReplace"));
        this.fetchChangePathOnDemand = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.fetchChangePathOnDemand"));
        this.showTagsInRemoteHistory = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.showTags"));
        this.showOutOfDateFolders = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.showOutOfDateFolders"));
        this.useJavaHLCommitHack = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.useJavaHLCommitHack"));
        this.shareNestedProjects = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.shareNestedProjects"));
        this.warnOnCommitToTagPath = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.warnOnCommitToTagPath"));
        this.ignoreHiddenChanges = this.createCheckBox(composite, Policy.bind("SVNPreferencesPage.0"));
        try {
            isHiddenSupported = Util.isHiddenSupported();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            isHiddenSupported = false;
        }
        this.ignoreHiddenChanges.setVisible(isHiddenSupported);
        this.ignoreManagedDerivedResources = this.createCheckBox(composite, Policy.bind("SVNPreferencesPage.1"));
        this.createLabel(composite, "", 2);
        this.createLabel(composite, Policy.bind("SVNPreferencePage.logEntriesToFetch"), 1);
        this.logEntriesToFetchText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.widthHint = 40;
        this.logEntriesToFetchText.setLayoutData((Object)gridData);
        this.createLabel(composite, "", 2);
        Group group = new Group(composite, 0);
        group.setText(Policy.bind("SVNPreferencePage.useQuickdiffAnnotateGroup"));
        group.setLayout((Layout)new GridLayout(3, true));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.quickDiffAnnotateYes = this.createRadio((Composite)group, Policy.bind("yes"), 1);
        this.quickDiffAnnotateNo = this.createRadio((Composite)group, Policy.bind("no"), 1);
        this.quickDiffAnnotatePrompt = this.createRadio((Composite)group, Policy.bind("prompt"), 1);
        Group groupErrors = new Group(composite, 0);
        groupErrors.setText(Policy.bind("SVNPreferencePage.commitWithErrors"));
        groupErrors.setLayout((Layout)new GridLayout(3, true));
        groupErrors.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.resourcesWithErrorsYes = this.createRadio((Composite)groupErrors, Policy.bind("yes"), 1);
        this.resourcesWithErrorsNo = this.createRadio((Composite)groupErrors, Policy.bind("no"), 1);
        this.resourcesWithErrorsPrompt = this.createRadio((Composite)groupErrors, Policy.bind("prompt"), 1);
        Group groupWarnings = new Group(composite, 0);
        groupWarnings.setText(Policy.bind("SVNPreferencePage.commitWithWarnings"));
        groupWarnings.setLayout((Layout)new GridLayout(3, true));
        groupWarnings.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.resourcesWithWarningsYes = this.createRadio((Composite)groupWarnings, Policy.bind("yes"), 1);
        this.resourcesWithWarningsNo = this.createRadio((Composite)groupWarnings, Policy.bind("no"), 1);
        this.resourcesWithWarningsPrompt = this.createRadio((Composite)groupWarnings, Policy.bind("prompt"), 1);
        this.createLabel(composite, "", 2);
        group = new Group(composite, 0);
        group.setText(Policy.bind("SVNPreferencePage.svnClientInterface"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        new StringComboBox((Composite)group, "pref_svninterface", Policy.bind("SVNPreferencePage.client"), "", this.CLIENT_LABELS, this.CLIENT_VALUES);
        this.createLabel(composite, "", 2);
        group = new Group(composite, 0);
        group.setText(Policy.bind("SVNPreferencePage.configurationLocation"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        this.defaultConfigLocationRadio = this.createRadio((Composite)group, Policy.bind("SVNPreferencePage.useDefaultConfigLocation"), 3);
        this.useDirectoryLocationRadio = this.createRadio((Composite)group, Policy.bind("SVNPreferencePage.useDirectoryConfig"), 1);
        this.directoryLocationText = new Text((Composite)group, 2052);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        this.directoryLocationText.setLayoutData((Object)gridData);
        this.directoryLocationText.setEditable(false);
        this.browseConfigDirButton = new Button((Composite)group, 0);
        this.browseConfigDirButton.setText(Policy.bind("SVNPreferencePage.browseDirectory"));
        Listener configUpdateEnablements = new Listener(){

            public void handleEvent(Event event) {
                SVNPreferencesPage.this.browseConfigDirButton.setEnabled(SVNPreferencesPage.this.useDirectoryLocationRadio.getSelection());
                SVNPreferencesPage.this.verifyValidation();
            }
        };
        this.defaultConfigLocationRadio.addListener(13, configUpdateEnablements);
        this.useDirectoryLocationRadio.addListener(13, configUpdateEnablements);
        this.browseConfigDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(SVNPreferencesPage.this.getShell(), 4096);
                String res = directoryDialog.open();
                if (res != null) {
                    SVNPreferencesPage.this.directoryLocationText.setText(res);
                }
                SVNPreferencesPage.this.verifyValidation();
            }
        });
        this.initializeValues();
        this.verifyValidation();
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.logEntriesToFetchText.addFocusListener((FocusListener)focusListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.tigris.subversion.subclipse.ui.svn_preference_page_context");
        return composite;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        Iterator iter = this.fFields.iterator();
        while (iter.hasNext()) {
            ((Field)iter.next()).initializeValue(store);
        }
        this.showCompareRevisionInDialog.setSelection(store.getBoolean("pref_show_compare_revision_in_dialog"));
        this.fetchChangePathOnDemand.setSelection(store.getBoolean("pref_fetch_change_path_on_Demand"));
        this.showTagsInRemoteHistory.setSelection(store.getBoolean("pref_show_tags_in_remote"));
        this.showOutOfDateFolders.setSelection(SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_out_of_date_folders"));
        this.useJavaHLCommitHack.setSelection(store.getBoolean("pref_use_javahl_commit_hack"));
        this.shareNestedProjects.setSelection(SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("share_nested_projects"));
        this.warnOnCommitToTagPath.setSelection(!SVNUIPlugin.getPlugin().getPluginPreferences().getBoolean("pref_commit_to_tags_path_without_warning"));
        this.ignoreHiddenChanges.setSelection(SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_hidden_changes"));
        this.ignoreManagedDerivedResources.setSelection(SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_managed_derived_resources"));
        this.removeOnReplace.setSelection(store.getBoolean("pref_remove_unadded_resources_on_replace"));
        this.logEntriesToFetchText.setText(Integer.toString(store.getInt("pref_log_entries_to_fetch")));
        this.quickDiffAnnotateYes.setSelection("always".equals(store.getString("pref_use_quickdiffannotate")));
        this.quickDiffAnnotateNo.setSelection("never".equals(store.getString("pref_use_quickdiffannotate")));
        this.quickDiffAnnotatePrompt.setSelection("prompt".equals(store.getString("pref_use_quickdiffannotate")));
        this.resourcesWithErrorsYes.setSelection("always".equals(store.getString("pref_commit_with_errors")));
        this.resourcesWithErrorsNo.setSelection("never".equals(store.getString("pref_commit_with_errors")));
        this.resourcesWithErrorsPrompt.setSelection("prompt".equals(store.getString("pref_commit_with_errors")));
        this.resourcesWithWarningsYes.setSelection("always".equals(store.getString("pref_commit_with_warning")));
        this.resourcesWithWarningsNo.setSelection("never".equals(store.getString("pref_commit_with_warning")));
        this.resourcesWithWarningsPrompt.setSelection("prompt".equals(store.getString("pref_commit_with_warning")));
        String configLocation = store.getString("pref_svnconfigdir");
        this.directoryLocationText.setText(configLocation);
        if (configLocation.equals("")) {
            this.defaultConfigLocationRadio.setSelection(true);
            this.useDirectoryLocationRadio.setSelection(false);
            this.browseConfigDirButton.setEnabled(false);
        } else {
            this.defaultConfigLocationRadio.setSelection(false);
            this.useDirectoryLocationRadio.setSelection(true);
            this.browseConfigDirButton.setEnabled(true);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        Iterator iter = this.fFields.iterator();
        while (iter.hasNext()) {
            ((Field)iter.next()).performOk(store);
        }
        store.setValue("pref_show_compare_revision_in_dialog", this.showCompareRevisionInDialog.getSelection());
        store.setValue("pref_fetch_change_path_on_Demand", this.fetchChangePathOnDemand.getSelection());
        store.setValue("pref_show_tags_in_remote", this.showTagsInRemoteHistory.getSelection());
        if (SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_out_of_date_folders") != this.showOutOfDateFolders.getSelection()) {
            SVNProviderPlugin.getPlugin().getPluginPreferences().setValue("show_out_of_date_folders", this.showOutOfDateFolders.getSelection());
            SVNUIPlugin.getPlugin().getShowOutOfDateFoldersAction().setChecked(this.showOutOfDateFolders.getSelection());
        }
        SVNProviderPlugin.getPlugin().getPluginPreferences().setValue("share_nested_projects", this.shareNestedProjects.getSelection());
        SVNUIPlugin.getPlugin().getPluginPreferences().setValue("pref_commit_to_tags_path_without_warning", !this.warnOnCommitToTagPath.getSelection());
        SVNProviderPlugin.getPlugin().getPluginPreferences().setValue("ignore_hidden_changes", this.ignoreHiddenChanges.getSelection());
        SVNProviderPlugin.getPlugin().getPluginPreferences().setValue("ignore_managed_derived_resources", this.ignoreManagedDerivedResources.getSelection());
        store.setValue("pref_use_javahl_commit_hack", this.useJavaHLCommitHack.getSelection());
        store.setValue("pref_remove_unadded_resources_on_replace", this.removeOnReplace.getSelection());
        if (this.quickDiffAnnotateYes.getSelection()) {
            store.setValue("pref_use_quickdiffannotate", "always");
        } else if (this.quickDiffAnnotateNo.getSelection()) {
            store.setValue("pref_use_quickdiffannotate", "never");
        } else if (this.quickDiffAnnotatePrompt.getSelection()) {
            store.setValue("pref_use_quickdiffannotate", "prompt");
        }
        if (this.resourcesWithErrorsYes.getSelection()) {
            store.setValue("pref_commit_with_errors", "always");
        } else if (this.resourcesWithErrorsNo.getSelection()) {
            store.setValue("pref_commit_with_errors", "never");
        } else if (this.resourcesWithErrorsPrompt.getSelection()) {
            store.setValue("pref_commit_with_errors", "prompt");
        }
        if (this.resourcesWithWarningsYes.getSelection()) {
            store.setValue("pref_commit_with_warning", "always");
        } else if (this.resourcesWithWarningsNo.getSelection()) {
            store.setValue("pref_commit_with_warning", "never");
        } else if (this.resourcesWithWarningsPrompt.getSelection()) {
            store.setValue("pref_commit_with_warning", "prompt");
        }
        int entriesToFetch = store.getInt("pref_log_entries_to_fetch");
        try {
            entriesToFetch = Integer.parseInt(this.logEntriesToFetchText.getText().trim());
        }
        catch (Exception exception) {}
        store.setValue("pref_log_entries_to_fetch", entriesToFetch);
        if (this.defaultConfigLocationRadio.getSelection()) {
            store.setValue("pref_svnconfigdir", "");
        } else {
            store.setValue("pref_svnconfigdir", this.directoryLocationText.getText());
        }
        SVNUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeValues();
        this.verifyValidation();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SVNUIPlugin.getPlugin().getPreferenceStore();
    }

    private void verifyValidation() {
        this.setErrorMessage(null);
        if (this.useDirectoryLocationRadio.getSelection()) {
            File configDir = new File(this.directoryLocationText.getText());
            if (!configDir.exists()) {
                this.setErrorMessage(Policy.bind("SVNPreferencePage.svnConfigDirDoesNotExist"));
            } else {
                File serversFile = new File(configDir, "servers");
                File configFile = new File(configDir, "config");
                if (!serversFile.exists() && !configFile.exists()) {
                    this.setErrorMessage(Policy.bind("SVNPreferencePage.isNotSvnConfigDir"));
                }
            }
        }
        this.setValid(this.getErrorMessage() == null);
    }

    private abstract class Field {
        protected final String fKey;

        public Field(String key) {
            SVNPreferencesPage.this.fFields.add(this);
            this.fKey = key;
        }

        public abstract void initializeValue(IPreferenceStore var1);

        public abstract void performOk(IPreferenceStore var1);

        public void performDefaults(IPreferenceStore store) {
            store.setToDefault(this.fKey);
            this.initializeValue(store);
        }
    }

    private abstract class ComboBox
    extends Field {
        protected final Combo fCombo;
        private final String[] fLabels;
        private final List fValues;

        public ComboBox(Composite composite, String key, String text, String helpID, String[] labels, Object[] values) {
            super(key);
            this.fLabels = labels;
            this.fValues = Arrays.asList(values);
            Label label = SWTUtils.createLabel(composite, text);
            this.fCombo = new Combo(composite, 8);
            this.fCombo.setLayoutData((Object)SWTUtils.createHFillGridData());
            this.fCombo.setItems(labels);
            if (((GridLayout)composite.getLayout()).numColumns > 1) {
                label.setLayoutData((Object)SWTUtils.createGridData(-1, -1, false, false));
            }
            if (helpID != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fCombo, helpID);
            }
        }

        public Combo getCombo() {
            return this.fCombo;
        }

        public void initializeValue(IPreferenceStore store) {
            Object value = this.getValue(store, this.fKey);
            int index = this.fValues.indexOf(value);
            if (index >= 0 && index < this.fLabels.length) {
                this.fCombo.select(index);
            } else {
                this.fCombo.select(0);
            }
        }

        public void performOk(IPreferenceStore store) {
            this.saveValue(store, this.fKey, this.fValues.get(this.fCombo.getSelectionIndex()));
        }

        protected abstract void saveValue(IPreferenceStore var1, String var2, Object var3);

        protected abstract Object getValue(IPreferenceStore var1, String var2);
    }

    private class StringComboBox
    extends ComboBox {
        public StringComboBox(Composite composite, String key, String label, String helpID, String[] labels, String[] values) {
            super(composite, key, label, helpID, labels, values);
        }

        protected Object getValue(IPreferenceStore store, String key) {
            return store.getString(key);
        }

        protected void saveValue(IPreferenceStore store, String key, Object object) {
            store.setValue(key, (String)object);
        }
    }
}

