/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.generatediff;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.util.ResourceSelectionTree;
import org.tigris.subversion.subclipse.ui.util.WorkspaceDialog;

class PatchFileSelectionPage
extends WizardPage {
    private Text filenameCombo;
    private Button browseButton;
    private Button saveInFilesystem;
    private Button saveInWorkspace;
    private Button saveToClipboard;
    private ResourceSelectionTree resourceSelectionTree;
    private IResource[] resources;
    protected Text wsPathText;
    private Button wsBrowseButton;
    private boolean wsBrowsed = false;
    private HashMap statusMap;
    public final int CLIPBOARD = 1;
    public final int FILESYSTEM = 2;
    public final int WORKSPACE = 3;

    public PatchFileSelectionPage(String pageName, String title, ImageDescriptor image, IStructuredSelection selection, HashMap statusMap) {
        super(pageName, title, image);
        this.statusMap = statusMap;
        Object[] selectedResources = selection.toArray();
        this.resources = new IResource[selectedResources.length];
        int i = 0;
        while (i < selectedResources.length) {
            this.resources[i] = (IResource)selectedResources[i];
            ++i;
        }
        this.setPageComplete(false);
    }

    protected boolean validatePage() {
        boolean valid = false;
        switch (this.getSaveType()) {
            case 3: {
                valid = this.validateWorkspaceLocation();
                break;
            }
            case 2: {
                File file = new File(this.getFilesystemFile());
                valid = this.isValidFile(file);
                break;
            }
            case 1: {
                valid = true;
            }
        }
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Policy.bind("GenerateSVNDiff.EnterFilename"));
        }
        this.setPageComplete(valid && this.getSelectedResources().length > 0);
        return valid;
    }

    private boolean isValidFile(File file) {
        if (!file.isAbsolute()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!parent.exists()) {
            return false;
        }
        if (!parent.isDirectory()) {
            return false;
        }
        if (!file.exists()) {
            block9: {
                try {
                    if (file.createNewFile()) break block9;
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            file.delete();
        }
        return true;
    }

    public String getFilesystemFile() {
        if (this.saveInFilesystem.getSelection()) {
            return this.filenameCombo.getText();
        }
        return null;
    }

    public IFile getWorkspaceFile() {
        if (this.saveInWorkspace.getSelection() && this.wsPathText.getText().length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.wsPathText.getText()));
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.patch_selection_page_context");
        this.saveToClipboard = new Button(composite, 16);
        this.saveToClipboard.setText(Policy.bind("GenerateSVNDiff.SaveToClipboard"));
        this.saveToClipboard.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PatchFileSelectionPage.this.validatePage();
                PatchFileSelectionPage.this.updateEnablements();
            }
        });
        this.saveInFilesystem = new Button(composite, 16);
        this.saveInFilesystem.setText(Policy.bind("GenerateSVNDiff.SaveInFileSystem"));
        this.saveInFilesystem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PatchFileSelectionPage.this.validatePage();
                PatchFileSelectionPage.this.updateEnablements();
            }
        });
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        nameGroup.setLayoutData((Object)data);
        this.filenameCombo = new Text(nameGroup, 2048);
        GridData gd = new GridData(768);
        this.filenameCombo.setLayoutData((Object)gd);
        this.filenameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatchFileSelectionPage.this.setPageComplete(PatchFileSelectionPage.this.validatePage());
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.filenameCombo.addFocusListener((FocusListener)focusListener);
        this.browseButton = new Button(nameGroup, 0);
        this.browseButton.setText(Policy.bind("GenerateSVNDiff.Browse"));
        data = new GridData(128);
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(PatchFileSelectionPage.this.getShell(), 40960);
                d.setText(Policy.bind("GenerateSVNDiff.SavePatchAs"));
                d.setFileName(Policy.bind("GenerateSVNDiff.patchTxt"));
                String file = d.open();
                if (file != null) {
                    Path path = new Path(file);
                    PatchFileSelectionPage.this.setFilesystemFilename(path.toOSString());
                }
            }
        });
        this.saveInWorkspace = new Button(composite, 16);
        this.saveInWorkspace.setText(Policy.bind("GenerateSVNDiff.SaveInWorkspace"));
        this.saveInWorkspace.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PatchFileSelectionPage.this.validatePage();
                PatchFileSelectionPage.this.updateEnablements();
            }
        });
        Composite pathGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        pathGroup.setLayout((Layout)layout);
        data = new GridData(4, 4, true, false);
        pathGroup.setLayoutData((Object)data);
        this.wsPathText = new Text(pathGroup, 2048);
        gd = new GridData(768);
        gd.verticalAlignment = 2;
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = 200;
        this.wsPathText.setLayoutData((Object)gd);
        this.wsPathText.setEditable(false);
        this.wsBrowseButton = new Button(pathGroup, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, this.wsBrowseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.wsBrowseButton.setLayoutData((Object)gd);
        this.wsBrowseButton.setText(Policy.bind("GenerateSVNDiff.Browse"));
        this.wsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDialog dialog = new WorkspaceDialog(PatchFileSelectionPage.this.getShell(), Policy.bind("GenerateSVNDiff.workspaceDialogTitle"), Policy.bind("GenerateSVNDiff.workspaceDialogMessage"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"), PatchFileSelectionPage.this.wsPathText);
                PatchFileSelectionPage.this.wsBrowsed = true;
                dialog.open();
                PatchFileSelectionPage.this.validatePage();
            }
        });
        this.resourceSelectionTree = new ResourceSelectionTree(composite, 0, Policy.bind("GenerateSVNDiff.Changes"), this.resources, this.statusMap, null, true, null, null);
        ((CheckboxTreeViewer)this.resourceSelectionTree.getTreeViewer()).setAllChecked(true);
        this.resourceSelectionTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PatchFileSelectionPage.this.validatePage();
            }
        });
        this.saveToClipboard.setSelection(true);
        this.validatePage();
        this.updateEnablements();
    }

    protected void setFilesystemFilename(String filename) {
        this.filenameCombo.setText(filename);
    }

    public IResource[] getSelectedResources() {
        return this.resourceSelectionTree.getSelectedResources();
    }

    protected void updateEnablements() {
        int type = this.getSaveType();
        this.browseButton.setEnabled(type == 2);
        this.filenameCombo.setEnabled(type == 2);
        this.wsPathText.setEnabled(type == 3);
        this.wsBrowseButton.setEnabled(type == 3);
        if (type == 3) {
            this.wsBrowsed = false;
        }
    }

    public int getSaveType() {
        if (this.saveInFilesystem.getSelection()) {
            return 2;
        }
        if (this.saveToClipboard.getSelection()) {
            return 1;
        }
        return 3;
    }

    private boolean validateWorkspaceLocation() {
        int type = this.getSaveType();
        if (this.wsPathText.getText().equals("")) {
            if (type == 3 && this.wsBrowsed) {
                this.setErrorMessage(Policy.bind("GenerateSVNDiff.validFileName"));
            }
            return false;
        }
        Path pathToWorkspaceFile = new Path(this.wsPathText.getText());
        IPath containerPath = pathToWorkspaceFile.removeLastSegments(1);
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
        if (container == null) {
            if (type == 3) {
                this.setErrorMessage(Policy.bind("GenerateSVNDiff.validFileName"));
            }
            return false;
        }
        return true;
    }
}

