/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.IPropertyProvider;
import org.tigris.subversion.subclipse.ui.compare.PropertyCompareInput;
import org.tigris.subversion.subclipse.ui.compare.PropertyCompareLocalResourceNode;
import org.tigris.subversion.subclipse.ui.compare.PropertyCompareRemoteResourceNode;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.dialogs.SvnDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ComparePropertiesDialog
extends SvnDialog {
    private IPropertyProvider left;
    private IPropertyProvider right;
    private ISVNRepositoryLocation repository;
    private Button fromWorkingCopyButton;
    private Text fromWorkingCopyText;
    private Button fromWorkingCopyBrowseButton;
    private Button fromRepositoryButton;
    private Text fromRepositoryText;
    private Button fromRepositoryBrowseButton;
    private Button fromHeadButton;
    private Label fromRevisionLabel;
    private Text fromRevisionText;
    private Button fromRevisionBrowseButton;
    private Button toWorkingCopyButton;
    private Text toWorkingCopyText;
    private Button toWorkingCopyBrowseButton;
    private Button toRepositoryButton;
    private Text toRepositoryText;
    private Button toRepositoryBrowseButton;
    private Button toHeadButton;
    private Label toRevisionLabel;
    private Text toRevisionText;
    private Button toRevisionBrowseButton;
    private Button recursiveButton;
    private PropertyCompareInput input;
    private Button okButton;
    private IResource fromLocalResource;
    private IResource toLocalResource;

    public ComparePropertiesDialog(Shell shell, IPropertyProvider left, IPropertyProvider right) {
        super(shell, "ComparePropertiesDialog2");
        this.left = left;
        this.right = right;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("ComparePropertiesDialog.1"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group fromGroup = new Group(composite, 0);
        fromGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareFrom"));
        GridLayout fromLayout = new GridLayout();
        fromLayout.numColumns = 3;
        fromGroup.setLayout((Layout)fromLayout);
        GridData data = new GridData(4, 4, true, false);
        fromGroup.setLayoutData((Object)data);
        this.fromWorkingCopyButton = new Button((Composite)fromGroup, 16);
        this.fromWorkingCopyButton.setText(Policy.bind("ComparePropertiesDialog.2"));
        this.fromWorkingCopyText = new Text((Composite)fromGroup, 2056);
        data = new GridData(768);
        data.widthHint = 600;
        this.fromWorkingCopyText.setLayoutData((Object)data);
        this.fromWorkingCopyBrowseButton = new Button((Composite)fromGroup, 8);
        this.fromWorkingCopyBrowseButton.setText(Policy.bind("ComparePropertiesDialog.3"));
        this.fromRepositoryButton = new Button((Composite)fromGroup, 16);
        this.fromRepositoryButton.setText(Policy.bind("ComparePropertiesDialog.4"));
        this.fromRepositoryText = new Text((Composite)fromGroup, 2048);
        data = new GridData(768);
        data.widthHint = 600;
        this.fromRepositoryText.setLayoutData((Object)data);
        this.fromRepositoryBrowseButton = new Button((Composite)fromGroup, 8);
        this.fromRepositoryBrowseButton.setText(Policy.bind("ComparePropertiesDialog.3"));
        this.fromHeadButton = new Button((Composite)fromGroup, 32);
        data = new GridData();
        data.horizontalSpan = 3;
        this.fromHeadButton.setLayoutData((Object)data);
        this.fromHeadButton.setText(Policy.bind("ComparePropertiesDialog.6"));
        this.fromHeadButton.setSelection(true);
        Composite fromRevisionGroup = new Composite((Composite)fromGroup, 0);
        GridLayout fromRevisionLayout = new GridLayout();
        fromRevisionLayout.numColumns = 3;
        fromRevisionLayout.marginHeight = 0;
        fromRevisionLayout.marginWidth = 0;
        fromRevisionGroup.setLayout((Layout)fromRevisionLayout);
        data = new GridData();
        data.horizontalSpan = 3;
        fromRevisionGroup.setLayoutData((Object)data);
        this.fromRevisionLabel = new Label(fromRevisionGroup, 0);
        this.fromRevisionLabel.setText(Policy.bind("ComparePropertiesDialog.7"));
        this.fromRevisionLabel.setEnabled(false);
        this.fromRevisionText = new Text(fromRevisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.fromRevisionText.setLayoutData((Object)data);
        this.fromRevisionText.setEnabled(false);
        this.fromRevisionBrowseButton = new Button(fromRevisionGroup, 8);
        this.fromRevisionBrowseButton.setText(Policy.bind("ComparePropertiesDialog.3"));
        this.fromRevisionBrowseButton.setEnabled(false);
        Group toGroup = new Group(composite, 0);
        toGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareTo"));
        GridLayout toLayout = new GridLayout();
        toLayout.numColumns = 3;
        toGroup.setLayout((Layout)toLayout);
        data = new GridData(4, 4, true, false);
        toGroup.setLayoutData((Object)data);
        this.toWorkingCopyButton = new Button((Composite)toGroup, 16);
        this.toWorkingCopyButton.setText(Policy.bind("ComparePropertiesDialog.2"));
        this.toWorkingCopyText = new Text((Composite)toGroup, 2056);
        data = new GridData(768);
        data.widthHint = 600;
        this.toWorkingCopyText.setLayoutData((Object)data);
        this.toWorkingCopyBrowseButton = new Button((Composite)toGroup, 8);
        this.toWorkingCopyBrowseButton.setText(Policy.bind("ComparePropertiesDialog.3"));
        this.toRepositoryButton = new Button((Composite)toGroup, 16);
        this.toRepositoryButton.setText(Policy.bind("ComparePropertiesDialog.4"));
        this.toRepositoryText = new Text((Composite)toGroup, 2048);
        data = new GridData(768);
        data.widthHint = 600;
        this.toRepositoryText.setLayoutData((Object)data);
        this.toRepositoryBrowseButton = new Button((Composite)toGroup, 8);
        this.toRepositoryBrowseButton.setText(Policy.bind("ComparePropertiesDialog.3"));
        this.toHeadButton = new Button((Composite)toGroup, 32);
        data = new GridData();
        data.horizontalSpan = 3;
        this.toHeadButton.setLayoutData((Object)data);
        this.toHeadButton.setText(Policy.bind("ComparePropertiesDialog.6"));
        this.toHeadButton.setSelection(true);
        Composite toRevisionGroup = new Composite((Composite)toGroup, 0);
        GridLayout toRevisionLayout = new GridLayout();
        toRevisionLayout.numColumns = 3;
        toRevisionLayout.marginHeight = 0;
        toRevisionLayout.marginWidth = 0;
        toRevisionGroup.setLayout((Layout)toRevisionLayout);
        data = new GridData();
        data.horizontalSpan = 3;
        toRevisionGroup.setLayoutData((Object)data);
        this.toRevisionLabel = new Label(toRevisionGroup, 0);
        this.toRevisionLabel.setText(Policy.bind("ComparePropertiesDialog.7"));
        this.toRevisionLabel.setEnabled(false);
        this.toRevisionText = new Text(toRevisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.toRevisionText.setLayoutData((Object)data);
        this.toRevisionText.setEnabled(false);
        this.toRevisionBrowseButton = new Button(toRevisionGroup, 8);
        this.toRevisionBrowseButton.setText(Policy.bind("ComparePropertiesDialog.3"));
        this.toRevisionBrowseButton.setEnabled(false);
        this.recursiveButton = new Button(composite, 32);
        this.recursiveButton.setText(Policy.bind("ComparePropertiesDialog.16"));
        if (this.left != null) {
            if (this.left instanceof PropertyCompareLocalResourceNode) {
                this.fromWorkingCopyText.setText(((PropertyCompareLocalResourceNode)this.left).getResource().getFullPath().toString());
                this.fromWorkingCopyButton.setSelection(true);
                this.fromRepositoryText.setEnabled(false);
                this.fromRepositoryBrowseButton.setEnabled(false);
                this.fromHeadButton.setEnabled(false);
                this.fromLocalResource = ((PropertyCompareLocalResourceNode)this.left).getResource();
            } else if (this.left instanceof PropertyCompareRemoteResourceNode) {
                this.fromRepositoryText.setText(((PropertyCompareRemoteResourceNode)this.left).getRemoteResource().getUrl().toString());
                this.fromRepositoryButton.setSelection(true);
                this.fromWorkingCopyText.setEnabled(false);
                this.fromWorkingCopyBrowseButton.setEnabled(false);
                this.fromHeadButton.setEnabled(true);
            }
        }
        if (this.right == null) {
            this.right = this.left;
        }
        if (this.right != null) {
            if (this.right instanceof PropertyCompareLocalResourceNode) {
                this.toWorkingCopyText.setText(((PropertyCompareLocalResourceNode)this.right).getResource().getFullPath().toString());
                this.toWorkingCopyButton.setSelection(true);
                this.toRepositoryText.setEnabled(false);
                this.toRepositoryBrowseButton.setEnabled(false);
                this.toHeadButton.setEnabled(false);
                this.repository = SVNWorkspaceRoot.getSVNResourceFor((IResource)((PropertyCompareLocalResourceNode)this.right).getResource()).getRepository();
                this.toLocalResource = ((PropertyCompareLocalResourceNode)this.right).getResource();
            } else if (this.right instanceof PropertyCompareRemoteResourceNode) {
                this.toRepositoryText.setText(((PropertyCompareRemoteResourceNode)this.right).getRemoteResource().getUrl().toString());
                this.toRepositoryButton.setSelection(true);
                this.toWorkingCopyText.setEnabled(false);
                this.toWorkingCopyBrowseButton.setEnabled(false);
                this.toHeadButton.setEnabled(true);
                this.repository = ((PropertyCompareRemoteResourceNode)this.right).getRemoteResource().getRepository();
            }
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComparePropertiesDialog.this.okButton.setEnabled(ComparePropertiesDialog.this.canFinish());
            }
        };
        this.fromWorkingCopyText.addModifyListener(modifyListener);
        this.fromRepositoryText.addModifyListener(modifyListener);
        this.fromRevisionText.addModifyListener(modifyListener);
        this.toWorkingCopyText.addModifyListener(modifyListener);
        this.toRepositoryText.addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ComparePropertiesDialog.this.fromWorkingCopyBrowseButton || e.getSource() == ComparePropertiesDialog.this.toWorkingCopyBrowseButton) {
                    Object result;
                    ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(ComparePropertiesDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                    dialog.setTitle(Policy.bind("ComparePropertiesDialog.1"));
                    dialog.setMessage(Policy.bind("ComparePropertiesDialog.18"));
                    dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                    if (dialog.open() != 1 && (result = dialog.getFirstResult()) instanceof IResource) {
                        if (e.getSource() == ComparePropertiesDialog.this.fromWorkingCopyBrowseButton) {
                            ComparePropertiesDialog.this.fromWorkingCopyText.setText(((IResource)result).getFullPath().toString());
                            ComparePropertiesDialog.this.fromLocalResource = (IResource)result;
                        } else {
                            ComparePropertiesDialog.this.toWorkingCopyText.setText(((IResource)result).getFullPath().toString());
                            ComparePropertiesDialog.this.toLocalResource = (IResource)result;
                        }
                    }
                } else if (e.getSource() == ComparePropertiesDialog.this.fromRepositoryBrowseButton || e.getSource() == ComparePropertiesDialog.this.toRepositoryBrowseButton) {
                    String url;
                    ChooseUrlDialog dialog = new ChooseUrlDialog(ComparePropertiesDialog.this.getShell(), null);
                    dialog.setRepositoryLocation(ComparePropertiesDialog.this.repository);
                    if (dialog.open() != 1 && (url = dialog.getUrl()) != null) {
                        if (e.getSource() == ComparePropertiesDialog.this.fromRepositoryBrowseButton) {
                            ComparePropertiesDialog.this.fromRepositoryText.setText(url);
                        } else {
                            ComparePropertiesDialog.this.toRepositoryText.setText(url);
                        }
                    }
                } else if (e.getSource() == ComparePropertiesDialog.this.fromRevisionBrowseButton || e.getSource() == ComparePropertiesDialog.this.toRevisionBrowseButton) {
                    try {
                        ILogEntry[] selectedEntries;
                        SVNUrl url = null;
                        url = e.getSource() == ComparePropertiesDialog.this.fromRevisionBrowseButton ? new SVNUrl(ComparePropertiesDialog.this.fromRepositoryText.getText().trim()) : new SVNUrl(ComparePropertiesDialog.this.toRepositoryText.getText().trim());
                        ISVNRemoteFile remoteResource = ComparePropertiesDialog.this.repository.getRemoteFile(url);
                        HistoryDialog dialog = new HistoryDialog(ComparePropertiesDialog.this.getShell(), (ISVNRemoteResource)remoteResource);
                        if (dialog.open() != 1 && (selectedEntries = dialog.getSelectedLogEntries()).length > 0) {
                            if (e.getSource() == ComparePropertiesDialog.this.fromRevisionBrowseButton) {
                                ComparePropertiesDialog.this.fromRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
                            } else {
                                ComparePropertiesDialog.this.toRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
                            }
                        }
                    }
                    catch (Exception exc) {
                        MessageDialog.openError((Shell)ComparePropertiesDialog.this.getShell(), (String)Policy.bind("ComparePropertiesDialog.1"), (String)exc.getMessage());
                    }
                }
                ComparePropertiesDialog.this.setEnablement();
                ComparePropertiesDialog.this.okButton.setEnabled(ComparePropertiesDialog.this.canFinish());
            }
        };
        this.fromWorkingCopyButton.addSelectionListener((SelectionListener)selectionListener);
        this.fromWorkingCopyBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        this.fromRepositoryButton.addSelectionListener((SelectionListener)selectionListener);
        this.fromRepositoryBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        this.fromHeadButton.addSelectionListener((SelectionListener)selectionListener);
        this.fromRevisionBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        this.toWorkingCopyButton.addSelectionListener((SelectionListener)selectionListener);
        this.toWorkingCopyBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        this.toRepositoryButton.addSelectionListener((SelectionListener)selectionListener);
        this.toRepositoryBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        this.toHeadButton.addSelectionListener((SelectionListener)selectionListener);
        this.toRevisionBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        return composite;
    }

    protected void okPressed() {
        try {
            RemoteFolder remoteFolder;
            Object revision;
            if (this.fromWorkingCopyButton.getSelection()) {
                this.left = new PropertyCompareLocalResourceNode(this.fromLocalResource, this.recursiveButton.getSelection(), null);
            } else {
                revision = null;
                revision = this.fromHeadButton.getSelection() ? SVNRevision.HEAD : new SVNRevision.Number(Long.parseLong(this.fromRevisionText.getText()));
                remoteFolder = new RemoteFolder(this.repository, new SVNUrl(this.fromRepositoryText.getText().trim()), revision);
                this.left = new PropertyCompareRemoteResourceNode((ISVNRemoteResource)remoteFolder, (SVNRevision)revision, this.recursiveButton.getSelection(), null);
            }
            if (this.toWorkingCopyButton.getSelection()) {
                this.right = new PropertyCompareLocalResourceNode(this.toLocalResource, this.recursiveButton.getSelection(), null);
            } else {
                revision = null;
                revision = this.toHeadButton.getSelection() ? SVNRevision.HEAD : new SVNRevision.Number(Long.parseLong(this.toRevisionText.getText()));
                remoteFolder = new RemoteFolder(this.repository, new SVNUrl(this.toRepositoryText.getText().trim()), revision);
                this.right = new PropertyCompareRemoteResourceNode((ISVNRemoteResource)remoteFolder, (SVNRevision)revision, this.recursiveButton.getSelection(), null);
            }
            this.input = new PropertyCompareInput(this.left, this.right, this.recursiveButton.getSelection());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ComparePropertiesDialog.1"), (String)e.getMessage());
            return;
        }
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(this.left != null);
        }
        return button;
    }

    public PropertyCompareInput getInput() {
        return this.input;
    }

    private boolean canFinish() {
        if (this.fromWorkingCopyButton.getSelection() && this.fromWorkingCopyText.getText().trim().length() == 0) {
            return false;
        }
        if (this.fromRepositoryButton.getSelection()) {
            if (this.fromRepositoryText.getText().trim().length() == 0) {
                return false;
            }
            if (!this.fromHeadButton.getSelection() && this.fromRevisionText.getText().trim().length() == 0) {
                return false;
            }
        }
        if (this.toWorkingCopyButton.getSelection() && this.toWorkingCopyText.getText().trim().length() == 0) {
            return false;
        }
        if (this.toRepositoryButton.getSelection()) {
            if (this.toRepositoryText.getText().trim().length() == 0) {
                return false;
            }
            if (!this.toHeadButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
                return false;
            }
        }
        return true;
    }

    private void setEnablement() {
        this.fromWorkingCopyText.setEnabled(this.fromWorkingCopyButton.getSelection());
        this.fromWorkingCopyBrowseButton.setEnabled(this.fromWorkingCopyButton.getSelection());
        this.fromRepositoryText.setEnabled(this.fromRepositoryButton.getSelection());
        this.fromRepositoryBrowseButton.setEnabled(this.fromRepositoryButton.getSelection());
        this.fromHeadButton.setEnabled(this.fromRepositoryButton.getSelection());
        this.fromRevisionLabel.setEnabled(this.fromRepositoryButton.getSelection() && !this.fromHeadButton.getSelection());
        this.fromRevisionText.setEnabled(this.fromRepositoryButton.getSelection() && !this.fromHeadButton.getSelection());
        this.fromRevisionBrowseButton.setEnabled(this.fromRepositoryButton.getSelection() && !this.fromHeadButton.getSelection() && this.fromRepositoryText.getText().trim().length() > 0);
        this.toWorkingCopyText.setEnabled(this.toWorkingCopyButton.getSelection());
        this.toWorkingCopyBrowseButton.setEnabled(this.toWorkingCopyButton.getSelection());
        this.toRepositoryText.setEnabled(this.toRepositoryButton.getSelection());
        this.toRepositoryBrowseButton.setEnabled(this.toRepositoryButton.getSelection());
        this.toHeadButton.setEnabled(this.toRepositoryButton.getSelection());
        this.toRevisionLabel.setEnabled(this.toRepositoryButton.getSelection() && !this.toHeadButton.getSelection());
        this.toRevisionText.setEnabled(this.toRepositoryButton.getSelection() && !this.toHeadButton.getSelection());
        this.toRevisionBrowseButton.setEnabled(this.toRepositoryButton.getSelection() && !this.toHeadButton.getSelection() && this.toRepositoryText.getText().trim().length() > 0);
    }
}

