/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.repo.RepositoryComparator;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.util.AdaptableList;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;

public class RepositorySelectionPage
extends SVNWizardPage {
    private TableViewer table;
    private Button useExistingRepo;
    private Button useNewRepo;
    private ISVNRepositoryLocation result;
    private ISVNRepositoryLocation[] locations;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private static final String LAST_LOCATION = "RepositorySelectionPage.lastRepository";

    public RepositorySelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected TableViewer createTable(Composite parent, int span) {
        Table table = new Table(parent, 68356);
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        return new TableViewer(table);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.sharing_select_repository_page_context");
        this.createWrappingLabel(composite, Policy.bind("RepositorySelectionPage.description"), 0, 1);
        this.useNewRepo = this.createRadioButton(composite, Policy.bind("RepositorySelectionPage.useNew"), 1);
        this.useExistingRepo = this.createRadioButton(composite, Policy.bind("RepositorySelectionPage.useExisting"), 1);
        this.table = this.createTable(composite, 1);
        this.table.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositorySelectionPage.this.result = (ISVNRepositoryLocation)((IStructuredSelection)RepositorySelectionPage.this.table.getSelection()).getFirstElement();
                RepositorySelectionPage.this.settings.put(RepositorySelectionPage.LAST_LOCATION, RepositorySelectionPage.this.result.getLocation());
                RepositorySelectionPage.this.setPageComplete(true);
            }
        });
        this.useExistingRepo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (RepositorySelectionPage.this.useNewRepo.getSelection()) {
                    RepositorySelectionPage.this.table.getTable().setEnabled(false);
                    RepositorySelectionPage.this.result = null;
                } else {
                    RepositorySelectionPage.this.table.getTable().setEnabled(true);
                    RepositorySelectionPage.this.result = (ISVNRepositoryLocation)((IStructuredSelection)RepositorySelectionPage.this.table.getSelection()).getFirstElement();
                }
                RepositorySelectionPage.this.setPageComplete(true);
            }
        });
        this.setControl((Control)composite);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                RepositorySelectionPage.this.locations = SVNUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations(monitor);
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, runnable);
        }
        catch (Exception e) {
            SVNUIPlugin.openError(this.getShell(), null, null, e, 2);
        }
        Arrays.sort(this.locations, new RepositoryComparator());
        AdaptableList input = new AdaptableList((IAdaptable[])this.locations);
        this.table.setInput((Object)input);
        if (this.locations.length == 0) {
            this.useNewRepo.setSelection(true);
        } else {
            this.useExistingRepo.setSelection(true);
            int selectionIndex = 0;
            String lastLocation = this.settings.get(LAST_LOCATION);
            if (lastLocation != null) {
                int i = 0;
                while (i < this.locations.length) {
                    ISVNRepositoryLocation location = this.locations[i];
                    if (lastLocation.equals(location.getLocation())) {
                        selectionIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            this.table.setSelection((ISelection)new StructuredSelection((Object)this.locations[selectionIndex]));
            this.result = this.locations[selectionIndex];
            this.setPageComplete(true);
        }
    }

    public ISVNRepositoryLocation getLocation() {
        return this.result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.useExistingRepo.setFocus();
        }
    }
}

