/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.jdt;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.preference.IPreferenceStore;
import zigen.plugin.db.ext.jdt.Activator;
import zigen.plugin.db.ext.jdt.CodeCreatorUtil;
import zigen.plugin.db.ext.jdt.ICodeGenerator;

public abstract class CodeGenerator
implements ICodeGenerator {
    protected final String line_sep = System.getProperty("line.separator");
    protected final String user_name = System.getProperty("user.name");
    private SimpleDateFormat format1 = new SimpleDateFormat("yyyy/MM/dd");
    private StringBuffer out = new StringBuffer();
    boolean generateInfoOn = true;
    boolean classCommentOon = true;

    public CodeGenerator() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.generateInfoOn = store.getBoolean("GeneratePreferencePage.GenerateInfoOn");
        this.classCommentOon = store.getBoolean("GeneratePreferencePage.ClassCommentOn");
    }

    protected void setGenerateInfo() {
        if (this.generateInfoOn) {
            this.println("/* Code Generator Information.");
            this.println(" * generator Version 1.0.0 release 2007/10/10");
            this.println(" * generated Date " + new Date());
            this.println(" */");
        }
    }

    protected void setClassComment() {
        if (this.classCommentOon) {
            this.println("/**");
            this.println(" * " + this.getClassName() + ".");
            this.println(" * @author " + this.user_name);
            this.println(" * @version 1.0 ");
            this.println(" * history ");
            this.println(" * Symbol\tDate\t\tPerson\t\tNote");
            this.println(" * [1]\t\t" + this.format1.format(new Date()) + "\t" + this.user_name + "\t\t" + "Generated.");
            this.println(" */");
        }
    }

    protected String getterString(String propertyName) {
        return CodeCreatorUtil.getterString(propertyName);
    }

    protected String setterString(String propertyName) {
        return CodeCreatorUtil.setterString(propertyName);
    }

    protected String propertyString(String accessModifiers, String type, String property) {
        return CodeCreatorUtil.propertyString(accessModifiers, type, property);
    }

    protected String toStringString(String className, String[] properties) {
        return CodeCreatorUtil.toStringString(className, properties);
    }

    public abstract void execute();

    public abstract String getClassName();

    protected void println() {
        this.println("");
    }

    protected void println(String str) {
        this.out.append(String.valueOf(str) + this.line_sep);
    }

    protected void print(String str) {
        this.out.append(str);
    }

    public void setPackageString(String pkgName) {
        if (pkgName != null && !pkgName.equals("")) {
            this.out.insert(0, "package " + pkgName + ";" + this.line_sep + this.line_sep);
        }
    }

    public String genaratedString() {
        return this.out.toString();
    }
}

