/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequence;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNMergeResult;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnMerger;
import org.tmatesoft.svn.core.wc2.SvnMergeResult;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSvnMerger
implements ISvnMerger {
    private final SVNWCContext context;
    private SVNSkel workItems;

    public DefaultSvnMerger(SVNWCContext context) {
        this.context = context;
    }

    public SVNSkel getWorkItems() {
        return this.workItems;
    }

    public SVNMergeResult mergeText(SVNMergeFileSet files, boolean dryRun, SVNDiffOptions options) throws SVNException {
        return null;
    }

    public SVNMergeResult mergeProperties(String localPath, SVNProperties workingProperties, SVNProperties baseProperties, SVNProperties serverBaseProps, SVNProperties propDiff, SVNAdminArea adminArea, SVNLog log, boolean baseMerge, boolean dryRun) throws SVNException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMergeResult mergeText(ISvnMerger baseMerger, File resultFile, File targetAbspath, File detranslatedTargetAbspath, File leftAbspath, File rightAbspath, String targetLabel, String leftLabel, String rightLabel, SVNDiffOptions options) throws SVNException {
        SVNWCContext.ConflictMarkersInfo markersInfo = this.context.initConflictMarkers(targetLabel, leftLabel, rightLabel);
        String targetMarker = markersInfo.targetMarker;
        String leftMarker = markersInfo.leftMarker;
        String rightMarker = markersInfo.rightMarker;
        FSMergerBySequence merger = new FSMergerBySequence(targetMarker.getBytes(), SVNWCContext.CONFLICT_SEPARATOR, rightMarker.getBytes(), leftMarker.getBytes());
        int mergeResult = 0;
        RandomAccessFile localIS = null;
        RandomAccessFile latestIS = null;
        RandomAccessFile baseIS = null;
        OutputStream result = null;
        try {
            result = SVNFileUtil.openFileForWriting(resultFile);
            localIS = new RandomAccessFile(detranslatedTargetAbspath, "r");
            latestIS = new RandomAccessFile(rightAbspath, "r");
            baseIS = new RandomAccessFile(leftAbspath, "r");
            QSequenceLineRAFileData baseData = new QSequenceLineRAFileData(baseIS);
            QSequenceLineRAFileData localData = new QSequenceLineRAFileData(localIS);
            QSequenceLineRAFileData latestData = new QSequenceLineRAFileData(latestIS);
            mergeResult = merger.merge(baseData, localData, latestData, options, result, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST);
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(result);
                SVNFileUtil.closeFile(localIS);
                SVNFileUtil.closeFile(baseIS);
                SVNFileUtil.closeFile(latestIS);
                throw throwable;
            }
            SVNFileUtil.closeFile(result);
            SVNFileUtil.closeFile(localIS);
            SVNFileUtil.closeFile(baseIS);
            SVNFileUtil.closeFile(latestIS);
        }
        SVNFileUtil.closeFile(result);
        SVNFileUtil.closeFile(localIS);
        SVNFileUtil.closeFile(baseIS);
        SVNFileUtil.closeFile(latestIS);
        if (mergeResult == 2) {
            return SvnMergeResult.create(SVNStatusType.CONFLICTED);
        }
        return SvnMergeResult.create(SVNStatusType.MERGED);
    }

    public SvnMergeResult mergeProperties(ISvnMerger baseMerger, File localAbsPath, SVNNodeKind kind, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, SVNProperties serverBaseProperties, SVNProperties pristineProperties, SVNProperties actualProperties, SVNProperties propChanges, boolean baseMerge, boolean dryRun) throws SVNException {
        this.workItems = null;
        SVNSkel conflictSkel = null;
        boolean isDir = kind == SVNNodeKind.DIR;
        ISVNConflictHandler conflictResolver = this.context.getOptions().getConflictResolver();
        SVNStatusType mergeOutcome = SVNStatusType.UNCHANGED;
        if (propChanges != null) {
            Iterator<String> i = propChanges.nameSet().iterator();
            while (i.hasNext()) {
                boolean conflictRemains;
                SVNWCContext.MergePropStatusInfo mergePropStatus;
                this.context.checkCancelled();
                String propname = i.next();
                SVNPropertyValue toVal = propChanges.getSVNPropertyValue(propname);
                SVNPropertyValue fromVal = serverBaseProperties.getSVNPropertyValue(propname);
                SVNPropertyValue baseVal = pristineProperties.getSVNPropertyValue(propname);
                if (baseMerge) {
                    if (toVal != null) {
                        pristineProperties.put(propname, toVal);
                    } else {
                        pristineProperties.remove(propname);
                    }
                }
                SVNPropertyValue mineVal = actualProperties.getSVNPropertyValue(propname);
                mergeOutcome = this.context.setPropMergeState(mergeOutcome, SVNStatusType.CHANGED);
                if (fromVal == null) {
                    mergePropStatus = this.context.applySinglePropAdd(mergeOutcome, localAbsPath, leftVersion, rightVersion, isDir, actualProperties, propname, baseVal, toVal, conflictResolver, dryRun);
                    mergeOutcome = mergePropStatus.state;
                    conflictRemains = mergePropStatus.conflictRemains;
                } else if (toVal == null) {
                    mergePropStatus = this.context.applySinglePropDelete(mergeOutcome, localAbsPath, leftVersion, rightVersion, isDir, actualProperties, propname, baseVal, fromVal, conflictResolver, dryRun);
                    mergeOutcome = mergePropStatus.state;
                    conflictRemains = mergePropStatus.conflictRemains;
                } else {
                    mergePropStatus = this.context.applySinglePropChange(mergeOutcome, localAbsPath, leftVersion, rightVersion, isDir, actualProperties, propname, baseVal, fromVal, toVal, conflictResolver, dryRun);
                    mergeOutcome = mergePropStatus.state;
                    conflictRemains = mergePropStatus.conflictRemains;
                }
                if (!conflictRemains) continue;
                mergeOutcome = this.context.setPropMergeState(mergeOutcome, SVNStatusType.CONFLICTED);
                if (dryRun) continue;
                if (conflictSkel == null) {
                    conflictSkel = SVNSkel.createEmptyList();
                }
                this.context.conflictSkelAddPropConflict(conflictSkel, propname, baseVal, mineVal, toVal, fromVal);
            }
        }
        if (dryRun) {
            return SvnMergeResult.create(mergeOutcome);
        }
        SvnMergeResult result = SvnMergeResult.create(mergeOutcome);
        result.getBaseProperties().putAll(pristineProperties);
        result.getActualProperties().putAll(actualProperties);
        SVNSkel workItems = null;
        if (conflictSkel != null) {
            File rejectPath = this.context.getPrejfileAbspath(localAbsPath);
            if (rejectPath == null) {
                String rejectFilename;
                File rejectDirpath;
                if (isDir) {
                    rejectDirpath = localAbsPath;
                    rejectFilename = "dir_conflicts";
                } else {
                    rejectDirpath = SVNFileUtil.getFileDir(localAbsPath);
                    rejectFilename = SVNFileUtil.getFileName(localAbsPath);
                }
                rejectPath = SVNFileUtil.createUniqueFile(rejectDirpath, rejectFilename, ".prej", false);
                SVNSkel workItem = this.context.wqBuildSetPropertyConflictMarkerTemp(localAbsPath, rejectPath);
                workItems = this.context.wqMerge(workItems, workItem);
            }
            SVNSkel workItem = this.context.wqBuildPrejInstall(localAbsPath, conflictSkel);
            workItems = this.context.wqMerge(workItems, workItem);
        }
        this.workItems = workItems;
        return result;
    }
}

