/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc17.ISVNDirFetcher;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateEditor17
implements ISVNUpdateEditor {
    private SVNWCContext myWCContext;
    private String myTargetBasename;
    private File myAnchorAbspath;
    private File myTargetAbspath;
    private String[] myExtensionPatterns;
    private long myTargetRevision;
    private SVNDepth myRequestedDepth;
    private boolean myIsDepthSticky;
    private boolean myIsUseCommitTimes;
    private boolean rootOpened;
    private boolean myIsTargetDeleted;
    private boolean myIsUnversionedObstructionsAllowed;
    private File mySwitchRelpath;
    private SVNURL myReposRootURL;
    private String myReposUuid;
    private Set<File> mySkippedTrees = new HashSet<File>();
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNExternalsStore myExternalsStore;
    private DirectoryBaton myCurrentDirectory;
    private FileBaton myCurrentFile;
    private boolean myAddsAsModification = true;
    private Map<File, Map<String, SVNDirEntry>> myDirEntries;
    private boolean myIsCleanCheckout;
    private File myWCRootAbsPath;

    public static ISVNUpdateEditor createUpdateEditor(SVNWCContext context, long targetRevision, File anchorAbspath, String targetName, boolean useCommitTimes, SVNURL switchURL, SVNDepth depth, boolean depthIsSticky, boolean allowUnversionedObstructions, boolean addsAsModifications, boolean serverPerformsFiltering, boolean cleanCheckout, ISVNDirFetcher dirFetcher, SVNExternalsStore externalsStore, String[] preservedExtensions) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        ISVNWCDb.WCDbRepositoryInfo repositoryInfo = context.getDb().scanBaseRepository(anchorAbspath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
        assert (repositoryInfo != null && repositoryInfo.rootUrl != null && repositoryInfo.uuid != null);
        if (switchURL != null && !SVNURLUtil.isAncestor(repositoryInfo.rootUrl, switchURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}'' is not the same repository as ''{1}''", switchURL, repositoryInfo.rootUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNUpdateEditor17 editor = new SVNUpdateEditor17();
        editor.myIsUseCommitTimes = useCommitTimes;
        editor.myTargetRevision = targetRevision;
        editor.myReposRootURL = repositoryInfo.rootUrl;
        editor.myReposUuid = repositoryInfo.uuid;
        editor.myWCContext = context;
        editor.myTargetBasename = targetName;
        editor.myAnchorAbspath = anchorAbspath;
        editor.myWCRootAbsPath = context.getDb().getWCRoot(anchorAbspath);
        if (switchURL != null) {
            editor.mySwitchRelpath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(repositoryInfo.rootUrl.getPath(), switchURL.getPath()));
        }
        editor.myTargetAbspath = "".equals(targetName) || targetName == null ? anchorAbspath : SVNFileUtil.createFilePath(anchorAbspath, targetName);
        editor.myRequestedDepth = depth;
        editor.myIsDepthSticky = depthIsSticky;
        editor.myIsUnversionedObstructionsAllowed = allowUnversionedObstructions;
        editor.myAddsAsModification = addsAsModifications;
        editor.myIsCleanCheckout = cleanCheckout;
        editor.myExtensionPatterns = preservedExtensions;
        editor.myExternalsStore = externalsStore;
        if (dirFetcher != null) {
            editor.initExcludedDirectoryEntries(dirFetcher);
        }
        ISVNUpdateEditor result = editor;
        if (!serverPerformsFiltering && !depthIsSticky) {
            result = new SVNAmbientDepthFilterEditor17(result, context, anchorAbspath, targetName, true);
        }
        return (ISVNUpdateEditor)SVNCancellableEditor.newInstance(result, context.getEventHandler(), null);
    }

    public static ISVNUpdateEditor createUpdateEditor(SVNWCContext wcContext, File anchorAbspath, String target, SVNURL reposRoot, SVNURL switchURL, SVNExternalsStore externalsStore, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExts, ISVNDirFetcher dirFetcher) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        ISVNWCDb.WCDbInfo info = wcContext.getDb().readInfo(anchorAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.reposId, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid);
        if (info.status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo addition = wcContext.getDb().scanAddition(anchorAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid);
            info.reposRootUrl = addition.reposRootUrl;
            info.reposUuid = addition.reposUuid;
        }
        assert (info.reposRootUrl != null && info.reposUuid != null);
        if (switchURL != null && !SVNPathUtil.isAncestor(info.reposRootUrl.toDecodedString(), switchURL.toDecodedString())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", switchURL.toDecodedString(), info.reposRootUrl.toDecodedString());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return new SVNUpdateEditor17(wcContext, anchorAbspath, target, info.reposRootUrl, info.reposUuid, switchURL, externalsStore, allowUnversionedObstructions, depthIsSticky, depth, preservedExts, dirFetcher);
    }

    private SVNUpdateEditor17() {
        this.myDirEntries = new HashMap<File, Map<String, SVNDirEntry>>();
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.mySkippedTrees = new HashSet<File>();
    }

    public SVNUpdateEditor17(SVNWCContext wcContext, File anchorAbspath, String targetBasename, SVNURL reposRootUrl, String reposUuid, SVNURL switchURL, SVNExternalsStore externalsStore, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExts, ISVNDirFetcher dirFetcher) throws SVNException {
        this.myWCContext = wcContext;
        this.myAnchorAbspath = anchorAbspath;
        this.myTargetBasename = targetBasename;
        this.myIsUnversionedObstructionsAllowed = allowUnversionedObstructions;
        this.myTargetRevision = -1L;
        this.myRequestedDepth = depth;
        this.myIsDepthSticky = depthIsSticky;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myExtensionPatterns = preservedExts;
        this.myTargetAbspath = anchorAbspath;
        this.myReposRootURL = reposRootUrl;
        this.myReposUuid = reposUuid;
        this.myExternalsStore = externalsStore;
        this.myIsUseCommitTimes = this.myWCContext.getOptions().isUseCommitTimes();
        if (this.myTargetBasename != null) {
            this.myTargetAbspath = SVNFileUtil.createFilePath(this.myTargetAbspath, this.myTargetBasename);
        }
        if ("".equals(this.myTargetBasename)) {
            this.myTargetBasename = null;
        }
        this.mySwitchRelpath = switchURL != null ? SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(reposRootUrl.getPath(), switchURL.getPath())) : null;
        if (dirFetcher != null) {
            this.initExcludedDirectoryEntries(dirFetcher);
        }
    }

    private void initExcludedDirectoryEntries(ISVNDirFetcher dirFetcher) throws SVNException {
        if (!this.myIsDepthSticky && SVNDepth.EMPTY.compareTo(this.myRequestedDepth) <= 0 && this.myRequestedDepth.compareTo(SVNDepth.INFINITY) < 0 && this.myRequestedDepth != SVNDepth.UNKNOWN) {
            ISVNWCDb.WCDbBaseInfo info;
            block7: {
                this.myDirEntries = new HashMap<File, Map<String, SVNDirEntry>>();
                info = null;
                try {
                    info = this.myWCContext.getDb().getBaseInfo(this.myTargetAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
                }
                catch (SVNException e) {
                    info = null;
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block7;
                    throw e;
                }
            }
            if (info != null && info.kind == ISVNWCDb.SVNWCDbKind.Dir && info.status == ISVNWCDb.SVNWCDbStatus.Normal) {
                File dirReposRelPath;
                Map<String, SVNDirEntry> dirEntries;
                if (info.depth.compareTo(this.myRequestedDepth) > 0 && (dirEntries = dirFetcher.fetchEntries(this.myReposRootURL, dirReposRelPath = this.mySwitchRelpath != null ? this.mySwitchRelpath : info.reposRelPath)) != null && !dirEntries.isEmpty()) {
                    this.myDirEntries.put(dirReposRelPath, dirEntries);
                }
                if (this.myRequestedDepth == SVNDepth.IMMEDIATES) {
                    Set<String> children = this.myWCContext.getDb().getBaseChildren(this.myTargetAbspath);
                    for (String child : children) {
                        File dirReposRelPath2;
                        Map<String, SVNDirEntry> dirEntries2;
                        File childAbsPath = SVNFileUtil.createFilePath(this.myTargetAbspath, child);
                        info = this.myWCContext.getDb().getBaseInfo(childAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
                        if (info.kind != ISVNWCDb.SVNWCDbKind.Dir || info.status != ISVNWCDb.SVNWCDbStatus.Normal || info.depth.compareTo(SVNDepth.EMPTY) <= 0 || (dirEntries2 = dirFetcher.fetchEntries(this.myReposRootURL, dirReposRelPath2 = this.mySwitchRelpath != null ? SVNFileUtil.createFilePath(this.mySwitchRelpath, child) : info.reposRelPath)) == null || dirEntries2.isEmpty()) continue;
                        this.myDirEntries.put(dirReposRelPath2, dirEntries2);
                    }
                }
            }
        }
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    private void rememberSkippedTree(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        File relativePath = SVNWCUtils.skipAncestor(this.getWCRootAbsPath(), localAbspath);
        this.mySkippedTrees.add(relativePath);
    }

    private File getWCRootAbsPath() throws SVNException {
        if (this.myWCRootAbsPath == null) {
            this.myWCRootAbsPath = this.myWCContext.getDb().getWCRoot(this.myAnchorAbspath);
        }
        return this.myWCRootAbsPath;
    }

    public void openRoot(long revision) throws SVNException {
        boolean alreadyConflicted;
        this.rootOpened = true;
        this.myCurrentDirectory = this.makeDirectoryBaton(null, null, false);
        try {
            alreadyConflicted = this.alreadyInATreeConflict(this.myCurrentDirectory.localAbsolutePath);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            alreadyConflicted = false;
        }
        if (alreadyConflicted) {
            this.myCurrentDirectory.skipThis = true;
            this.myCurrentDirectory.alreadyNotified = true;
            this.doNotification(this.myTargetAbspath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, null, null);
            return;
        }
        if ("".equals(this.myTargetBasename) || this.myTargetBasename == null) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(this.myCurrentDirectory.localAbsolutePath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
            this.myCurrentDirectory.ambientDepth = baseInfo.depth;
            this.myCurrentDirectory.wasIncomplete = baseInfo.status == ISVNWCDb.SVNWCDbStatus.Incomplete;
            this.myCurrentDirectory.changedAuthor = baseInfo.changedAuthor;
            this.myCurrentDirectory.changedDate = baseInfo.changedDate;
            this.myCurrentDirectory.changedRevsion = baseInfo.changedRev;
            this.myCurrentDirectory.oldRelativePath = baseInfo.reposRelPath;
            this.myWCContext.getDb().opStartDirectoryUpdateTemp(this.myCurrentDirectory.localAbsolutePath, this.myCurrentDirectory.newRelativePath, this.myTargetRevision);
        }
    }

    private void doNotification(File localAbspath, SVNNodeKind kind, SVNEventAction action, SVNURL url, SVNURL previousURL) throws SVNException {
        if (this.myWCContext.getEventHandler() != null) {
            SVNEvent event = new SVNEvent(localAbspath, kind, null, -1L, null, null, null, null, action, null, null, null, null, null, null);
            event.setURL(url);
            event.setPreviousURL(previousURL);
            this.myWCContext.getEventHandler().handleEvent(event, 0.0);
        }
    }

    private boolean alreadyInATreeConflict(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        File ancestorAbspath = localAbspath;
        boolean conflicted = false;
        while (ancestorAbspath != null) {
            SVNTreeConflictDescription conflict;
            ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(ancestorAbspath, ISVNWCDb.WCDbInfo.InfoField.conflicted);
            if (readInfo.conflicted && (conflict = this.myWCContext.getDb().opReadTreeConflict(ancestorAbspath)) != null) {
                return true;
            }
            if (this.myWCContext.getDb().isWCRoot(ancestorAbspath)) break;
            ancestorAbspath = SVNFileUtil.getParentFile(ancestorAbspath);
        }
        return conflicted;
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNSkel workItem;
        ISVNWCDb.SVNWCDbKind baseKind;
        ISVNWCDb.SVNWCDbStatus baseStatus;
        SVNURL previousURL;
        if (this.myCurrentDirectory.skipThis) {
            return;
        }
        this.myCurrentDirectory.markEdited();
        String base = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(path));
        File localAbsPath = SVNFileUtil.createFilePath(this.myCurrentDirectory.localAbsolutePath, base);
        boolean isRoot = this.myWCContext.getDb().isWCRoot(localAbsPath);
        if (isRoot) {
            this.rememberSkippedTree(localAbsPath);
            this.doNotification(localAbsPath, SVNNodeKind.UNKNOWN, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
            return;
        }
        boolean deletingTarget = localAbsPath.equals(this.myTargetAbspath);
        ISVNWCDb.WCDbInfo info = this.myWCContext.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.haveBase, ISVNWCDb.WCDbInfo.InfoField.haveWork);
        SVNURL sVNURL = previousURL = info.reposRelPath != null ? SVNWCUtils.join(this.myReposRootURL, info.reposRelPath) : null;
        if (!info.haveWork) {
            baseStatus = info.status;
            baseKind = info.kind;
        } else {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
            baseStatus = baseInfo.status;
            baseKind = baseInfo.kind;
            info.reposRelPath = baseInfo.reposRelPath;
        }
        if (info.conflicted) {
            info.conflicted = this.isNodeAlreadyConflicted(localAbsPath);
        }
        if (info.conflicted) {
            this.rememberSkippedTree(localAbsPath);
            this.doNotification(localAbsPath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, null, null);
            return;
        }
        if (baseStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || baseStatus == ISVNWCDb.SVNWCDbStatus.Excluded || baseStatus == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
            this.myWCContext.getDb().removeBase(localAbsPath);
            if (deletingTarget) {
                this.myIsTargetDeleted = true;
            }
            return;
        }
        SVNTreeConflictDescription treeConflict = null;
        if (!this.myCurrentDirectory.shadowed) {
            treeConflict = this.checkTreeConflict(localAbsPath, info.status, info.kind, true, SVNConflictAction.DELETE, SVNNodeKind.NONE, info.reposRelPath);
        }
        if (treeConflict != null) {
            if (this.myCurrentDirectory.deletionConflicts == null) {
                this.myCurrentDirectory.deletionConflicts = new HashMap();
            }
            this.myCurrentDirectory.deletionConflicts.put(base, treeConflict);
            this.myWCContext.getDb().opSetTreeConflict(localAbsPath, treeConflict);
            this.doNotification(localAbsPath, SVNNodeKind.UNKNOWN, SVNEventAction.TREE_CONFLICT, null, null);
            if (treeConflict.getConflictReason() == SVNConflictReason.EDITED) {
                this.myWCContext.getDb().opMakeCopyTemp(localAbsPath, false);
            } else if (treeConflict.getConflictReason() != SVNConflictReason.DELETED && treeConflict.getConflictReason() != SVNConflictReason.REPLACED) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL), SVNLogType.WC);
            }
        }
        if (!deletingTarget) {
            workItem = this.myWCContext.wqBuildBaseRemove(localAbsPath, -1L, ISVNWCDb.SVNWCDbKind.Unknown);
        } else {
            workItem = this.myWCContext.wqBuildBaseRemove(localAbsPath, this.myTargetRevision, baseKind);
            this.myIsTargetDeleted = true;
        }
        this.myWCContext.getDb().addWorkQueue(localAbsPath, workItem);
        this.myWCContext.wqRun(localAbsPath);
        if (treeConflict == null) {
            SVNEventAction action = SVNEventAction.UPDATE_DELETE;
            if (this.myCurrentDirectory.shadowed) {
                action = SVNEventAction.UPDATE_SHADOWED_DELETE;
            }
            this.doNotification(localAbsPath, info.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, action, null, previousURL);
        }
    }

    private boolean isNodeAlreadyConflicted(File localAbspath) throws SVNException {
        List<SVNConflictDescription> conflicts = this.myWCContext.getDb().readConflicts(localAbspath);
        for (SVNConflictDescription cd : conflicts) {
            if (cd.isTreeConflict()) {
                return true;
            }
            if (!cd.isPropertyConflict() && !cd.isTextConflict()) continue;
            SVNWCContext.ConflictInfo info = this.myWCContext.getConflicted(localAbspath, true, true, true);
            return info.textConflicted || info.propConflicted || info.treeConflicted;
        }
        return false;
    }

    private SVNTreeConflictDescription checkTreeConflict(File localAbspath, ISVNWCDb.SVNWCDbStatus workingStatus, ISVNWCDb.SVNWCDbKind workingKind, boolean existsInRepos, SVNConflictAction action, SVNNodeKind theirNodeKind, File theirRelpath) throws SVNException {
        SVNConflictReason reason = null;
        boolean locally_replaced = false;
        switch (workingStatus) {
            case Added: 
            case MovedHere: 
            case Copied: {
                ISVNWCDb.SVNWCDbStatus base_status;
                if (existsInRepos && (base_status = this.myWCContext.getDb().getBaseInfo((File)localAbspath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.status}).status) != ISVNWCDb.SVNWCDbStatus.NotPresent) {
                    locally_replaced = true;
                }
                if (!locally_replaced) {
                    assert (action == SVNConflictAction.ADD);
                    reason = SVNConflictReason.ADDED;
                    break;
                }
                reason = SVNConflictReason.REPLACED;
                break;
            }
            case Deleted: {
                reason = SVNConflictReason.DELETED;
                break;
            }
            case Incomplete: 
            case Normal: {
                if (action == SVNConflictAction.EDIT) {
                    return null;
                }
                TreeLocalModsInfo info = this.hasLocalMods(localAbspath);
                if (!info.modificationsFound) break;
                if (!info.nonDeleteModificationsFound) {
                    reason = SVNConflictReason.DELETED;
                    break;
                }
                reason = SVNConflictReason.EDITED;
                break;
            }
            case ServerExcluded: 
            case Excluded: 
            case NotPresent: {
                return null;
            }
            case BaseDeleted: {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (reason == null) {
            return null;
        }
        if (reason == SVNConflictReason.EDITED || reason == SVNConflictReason.DELETED || reason == SVNConflictReason.REPLACED ? !$assertionsDisabled && action != SVNConflictAction.EDIT && action != SVNConflictAction.DELETE && action != SVNConflictAction.REPLACE : reason == SVNConflictReason.ADDED && !$assertionsDisabled && action != SVNConflictAction.ADD) {
            throw new AssertionError();
        }
        return this.createTreeConflict(localAbspath, reason, action, theirNodeKind, theirRelpath);
    }

    private TreeLocalModsInfo hasLocalMods(File localAbspath) throws SVNException {
        final TreeLocalModsInfo modsInfo = new TreeLocalModsInfo();
        SVNStatusEditor17 statusEditor = new SVNStatusEditor17(this.myAnchorAbspath, this.myWCContext, this.myWCContext.getOptions(), false, false, SVNDepth.INFINITY, new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus status) throws SVNException {
                SVNStatusType nodeStatus = status.getNodeStatus();
                if (nodeStatus == SVNStatusType.STATUS_NORMAL || nodeStatus == SVNStatusType.STATUS_INCOMPLETE || nodeStatus == SVNStatusType.STATUS_IGNORED || nodeStatus == SVNStatusType.STATUS_NONE || nodeStatus == SVNStatusType.STATUS_UNVERSIONED || nodeStatus == SVNStatusType.STATUS_EXTERNAL) {
                    return;
                }
                if (nodeStatus == SVNStatusType.STATUS_DELETED) {
                    modsInfo.modificationsFound = true;
                    return;
                }
                if ((nodeStatus == SVNStatusType.STATUS_MISSING || nodeStatus == SVNStatusType.STATUS_OBSTRUCTED) && status.getPropertiesStatus() != SVNStatusType.STATUS_MODIFIED) {
                    return;
                }
                modsInfo.modificationsFound = true;
                modsInfo.nonDeleteModificationsFound = true;
                throw new SVNCancelException();
            }
        });
        try {
            statusEditor.walkStatus(localAbspath, SVNDepth.INFINITY, false, false, false, null);
        }
        catch (SVNCancelException cancel) {
            // empty catch block
        }
        return modsInfo;
    }

    public void absentDir(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.DIR);
    }

    public void absentFile(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.FILE);
    }

    private void absentEntry(String path, SVNNodeKind nodeKind) throws SVNException {
        if (this.myCurrentDirectory.skipThis) {
            return;
        }
        String name = SVNPathUtil.tail(path);
        ISVNWCDb.SVNWCDbKind absentKind = nodeKind == SVNNodeKind.DIR ? ISVNWCDb.SVNWCDbKind.Dir : ISVNWCDb.SVNWCDbKind.File;
        this.myCurrentDirectory.markEdited();
        File localAbsPath = SVNFileUtil.createFilePath(this.myCurrentDirectory.localAbsolutePath, name);
        ISVNWCDb.WCDbInfo info = null;
        ISVNWCDb.SVNWCDbStatus status = null;
        ISVNWCDb.SVNWCDbKind kind = null;
        try {
            info = this.myWCContext.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind);
            status = info.status;
            kind = info.kind;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            status = ISVNWCDb.SVNWCDbStatus.NotPresent;
            kind = ISVNWCDb.SVNWCDbKind.Unknown;
        }
        if ((status != ISVNWCDb.SVNWCDbStatus.Normal || kind != ISVNWCDb.SVNWCDbKind.Dir) && status != ISVNWCDb.SVNWCDbStatus.NotPresent && status != ISVNWCDb.SVNWCDbStatus.ServerExcluded && status != ISVNWCDb.SVNWCDbStatus.Excluded) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File reposRelPath = SVNFileUtil.createFilePath(this.myCurrentDirectory.newRelativePath, name);
        this.myWCContext.getDb().addBaseExcludedNode(localAbsPath, reposRelPath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, absentKind, ISVNWCDb.SVNWCDbStatus.ServerExcluded, null, null);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        boolean versionedLocallyAndPresent;
        boolean conflicted;
        ISVNWCDb.SVNWCDbKind wc_kind;
        ISVNWCDb.SVNWCDbStatus status;
        assert (copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision) || copyFromPath == null && !SVNRevision.isValidRevisionNumber(copyFromRevision));
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentDirectory = this.makeDirectoryBaton(path, this.myCurrentDirectory, true);
        DirectoryBaton db = this.myCurrentDirectory;
        if (db.skipThis) {
            return;
        }
        db.markEdited();
        if (this.myTargetAbspath.equals(db.localAbsolutePath)) {
            db.ambientDepth = this.myRequestedDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : this.myRequestedDepth;
        } else if (this.myRequestedDepth == SVNDepth.IMMEDIATES || this.myRequestedDepth == SVNDepth.UNKNOWN && pb.ambientDepth == SVNDepth.IMMEDIATES) {
            db.ambientDepth = SVNDepth.EMPTY;
        } else {
            db.ambientDepth = SVNDepth.INFINITY;
        }
        if (SVNFileUtil.getAdminDirectoryName().equals(db.name)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': object of the same name as the administrative directory", (Object)db.localAbsolutePath);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(db.localAbsolutePath));
        boolean error = false;
        try {
            ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(db.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.reposRelPath);
            status = readInfo.status;
            wc_kind = readInfo.kind;
            conflicted = readInfo.conflicted;
            versionedLocallyAndPresent = SVNUpdateEditor17.isNodePresent(status);
            db.oldRelativePath = readInfo.reposRelPath;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            error = true;
            wc_kind = ISVNWCDb.SVNWCDbKind.Unknown;
            status = ISVNWCDb.SVNWCDbStatus.Normal;
            conflicted = false;
            versionedLocallyAndPresent = false;
        }
        if (!error) {
            if (wc_kind == ISVNWCDb.SVNWCDbKind.Dir && status == ISVNWCDb.SVNWCDbStatus.Normal) {
                this.myWCContext.getDb().addBaseNotPresentNode(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, ISVNWCDb.SVNWCDbKind.File, null, null);
                this.rememberSkippedTree(db.localAbsolutePath);
                db.skipThis = true;
                db.alreadyNotified = true;
                this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, db.getURL(), db.getPreviousURL());
                return;
            }
            if (status == ISVNWCDb.SVNWCDbStatus.Normal && (wc_kind == ISVNWCDb.SVNWCDbKind.File || wc_kind == ISVNWCDb.SVNWCDbKind.Symlink)) {
                this.rememberSkippedTree(db.localAbsolutePath);
                db.skipThis = true;
                db.alreadyNotified = true;
                this.doNotification(db.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, db.getURL(), db.getPreviousURL());
                return;
            }
            versionedLocallyAndPresent = wc_kind == ISVNWCDb.SVNWCDbKind.Unknown ? false : SVNUpdateEditor17.isNodePresent(status);
        }
        SVNConflictDescription treeConflict = null;
        if (conflicted) {
            if (pb.deletionConflicts != null) {
                treeConflict = (SVNTreeConflictDescription)pb.deletionConflicts.get(db.name);
            }
            if (treeConflict != null) {
                treeConflict.setConflictAction(SVNConflictAction.REPLACE);
                this.myWCContext.getDb().opSetTreeConflict(db.localAbsolutePath, (SVNTreeConflictDescription)treeConflict);
                treeConflict = null;
                db.shadowed = true;
                conflicted = false;
            } else {
                conflicted = this.isNodeAlreadyConflicted(db.localAbsolutePath);
            }
        }
        if (conflicted) {
            this.rememberSkippedTree(db.localAbsolutePath);
            db.skipThis = true;
            db.alreadyNotified = true;
            this.myWCContext.getDb().addBaseNotPresentNode(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, ISVNWCDb.SVNWCDbKind.Dir, null, null);
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.SKIP_CONFLICTED, db.getURL(), db.getPreviousURL());
            return;
        }
        if (!db.shadowed) {
            if (versionedLocallyAndPresent) {
                boolean localIsNonDir;
                ISVNWCDb.SVNWCDbStatus addStatus = ISVNWCDb.SVNWCDbStatus.Normal;
                if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                    addStatus = this.myWCContext.getDb().scanAddition((File)((DirectoryBaton)db).localAbsolutePath, (ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[])new ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[]{ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status}).status;
                }
                boolean bl = localIsNonDir = wc_kind != ISVNWCDb.SVNWCDbKind.Dir && status != ISVNWCDb.SVNWCDbStatus.Deleted;
                if (!this.myAddsAsModification || localIsNonDir || addStatus != ISVNWCDb.SVNWCDbStatus.Added) {
                    treeConflict = this.checkTreeConflict(db.localAbsolutePath, status, wc_kind, false, SVNConflictAction.ADD, SVNNodeKind.DIR, db.newRelativePath);
                }
                if (treeConflict == null) {
                    db.addExisted = true;
                } else {
                    db.shadowed = true;
                }
            } else if (kind != SVNNodeKind.NONE) {
                db.obstructionFound = true;
                if (kind != SVNNodeKind.DIR || !this.myIsUnversionedObstructionsAllowed) {
                    db.shadowed = true;
                    treeConflict = this.createTreeConflict(db.localAbsolutePath, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, SVNNodeKind.DIR, db.newRelativePath);
                }
            }
        }
        this.myWCContext.getDb().opSetNewDirToIncompleteTemp(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, db.ambientDepth);
        if (!db.shadowed) {
            SVNFileUtil.ensureDirectoryExists(db.localAbsolutePath);
        }
        if (!db.shadowed && status == ISVNWCDb.SVNWCDbStatus.Added) {
            this.myWCContext.getDb().opRemoveWorkingTemp(db.localAbsolutePath);
        }
        if (db.shadowed && db.obstructionFound) {
            this.myWCContext.getDb().opDelete(db.localAbsolutePath, null);
        }
        if (treeConflict != null) {
            this.myWCContext.getDb().opSetTreeConflict(db.localAbsolutePath, (SVNTreeConflictDescription)treeConflict);
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.TREE_CONFLICT, db.getURL(), db.getPreviousURL());
        }
        if (this.myWCContext.getEventHandler() != null && !db.alreadyNotified && !db.addExisted) {
            SVNEventAction action = db.shadowed ? SVNEventAction.UPDATE_SHADOWED_ADD : (db.obstructionFound ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_ADD);
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, action, db.getURL(), db.getPreviousURL());
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        ISVNWCDb.SVNWCDbStatus baseStatus;
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentDirectory = this.makeDirectoryBaton(path, pb, false);
        DirectoryBaton db = this.myCurrentDirectory;
        if (db.skipThis) {
            return;
        }
        boolean isWCRoot = this.myWCContext.getDb().isWCRoot(db.localAbsolutePath);
        if (isWCRoot) {
            this.rememberSkippedTree(db.localAbsolutePath);
            db.skipThis = true;
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
            return;
        }
        this.myWCContext.writeCheck(db.localAbsolutePath);
        ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(db.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedAuthor, ISVNWCDb.WCDbInfo.InfoField.depth, ISVNWCDb.WCDbInfo.InfoField.haveWork, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.haveWork);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        ISVNWCDb.SVNWCDbKind wcKind = readInfo.kind;
        db.oldRevision = readInfo.revision;
        db.ambientDepth = readInfo.depth;
        db.changedRevsion = readInfo.changedRev;
        db.changedAuthor = readInfo.changedAuthor;
        db.changedDate = readInfo.changedDate;
        db.oldRelativePath = readInfo.reposRelPath;
        boolean have_work = readInfo.haveWork;
        boolean conflicted = readInfo.conflicted;
        SVNTreeConflictDescription treeConflict = null;
        if (!have_work) {
            baseStatus = status;
        } else {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(db.localAbsolutePath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
            baseStatus = baseInfo.status;
            db.oldRevision = baseInfo.revision;
            db.ambientDepth = baseInfo.depth;
            db.changedAuthor = baseInfo.changedAuthor;
            db.changedDate = baseInfo.changedDate;
            db.changedRevsion = baseInfo.changedRev;
        }
        db.wasIncomplete = baseStatus == ISVNWCDb.SVNWCDbStatus.Incomplete;
        if (conflicted) {
            conflicted = this.isNodeAlreadyConflicted(db.localAbsolutePath);
        }
        if (conflicted) {
            this.rememberSkippedTree(db.localAbsolutePath);
            db.skipThis = true;
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, null, null);
            return;
        }
        if (!db.shadowed) {
            treeConflict = this.checkTreeConflict(db.localAbsolutePath, status, wcKind, true, SVNConflictAction.EDIT, SVNNodeKind.DIR, db.newRelativePath);
        }
        if (treeConflict != null) {
            db.editConflict = treeConflict;
            db.shadowed = true;
        }
        this.myWCContext.getDb().opStartDirectoryUpdateTemp(db.localAbsolutePath, db.newRelativePath, this.myTargetRevision);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentDirectory.skipThis) {
            return;
        }
        if (SVNProperty.isRegularProperty(name)) {
            if (this.myCurrentDirectory.regularPropChanges == null) {
                this.myCurrentDirectory.regularPropChanges = new SVNProperties();
            }
            this.myCurrentDirectory.regularPropChanges.put(name, value);
        } else if (SVNProperty.isEntryProperty(name)) {
            if (this.myCurrentDirectory.entryPropChanges == null) {
                this.myCurrentDirectory.entryPropChanges = new SVNProperties();
            }
            this.myCurrentDirectory.entryPropChanges.put(name, value);
        } else if (SVNProperty.isWorkingCopyProperty(name)) {
            if (this.myCurrentDirectory.davPropChanges == null) {
                this.myCurrentDirectory.davPropChanges = new SVNProperties();
            }
            this.myCurrentDirectory.davPropChanges.put(name, value);
        }
        if (!this.myCurrentDirectory.edited && SVNProperty.isRegularProperty(name)) {
            this.myCurrentDirectory.markEdited();
        }
    }

    public void closeDir() throws SVNException {
        Map<String, SVNDirEntry> newChildren;
        SVNPropertyValue newWCDavURL;
        DirectoryBaton db = this.myCurrentDirectory;
        if (db.skipThis) {
            this.maybeBumpDirInfo(db.bumpInfo);
            this.myCurrentDirectory = this.myCurrentDirectory.parentBaton;
            return;
        }
        SVNSkel allWorkItems = null;
        SVNProperties entryProps = db.entryPropChanges;
        SVNProperties davProps = db.davPropChanges;
        SVNPropertyValue sVNPropertyValue = newWCDavURL = davProps != null ? davProps.getSVNPropertyValue("svn:wc:ra_dav:version-url") : null;
        if (newWCDavURL == null) {
            davProps = null;
        }
        SVNProperties regularProps = db.regularPropChanges;
        SVNProperties actualProps = null;
        SVNProperties baseProps = null;
        actualProps = (!db.addingDir || db.addExisted) && !db.shadowed ? this.myWCContext.getActualProps(db.localAbsolutePath) : new SVNProperties();
        baseProps = db.addExisted ? this.myWCContext.getPristineProps(db.localAbsolutePath) : (!db.addingDir ? this.myWCContext.getDb().getBaseProps(db.localAbsolutePath) : new SVNProperties());
        SVNStatusType[] propStatus = new SVNStatusType[]{SVNStatusType.UNKNOWN};
        SVNProperties newBaseProps = null;
        SVNProperties newActualProps = null;
        long newChangedRev = -1L;
        SVNDate newChangedDate = null;
        String newChangedAuthor = null;
        if (db.wasIncomplete) {
            SVNProperties propertiesToDelete = new SVNProperties(baseProps);
            if (regularProps == null) {
                regularProps = new SVNProperties();
            }
            for (String name : regularProps.nameSet()) {
                propertiesToDelete.remove(name);
            }
            for (String name : propertiesToDelete.nameSet()) {
                regularProps.put(name, SVNPropertyValue.create(null));
            }
        }
        if (regularProps != null && regularProps.size() > 0) {
            if (this.myExternalsStore != null && regularProps.containsName("svn:externals")) {
                String newValue = regularProps.getStringValue("svn:externals");
                String oldValue = baseProps.getStringValue("svn:externals");
                if (!(oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null)) {
                    this.myExternalsStore.addExternal(db.localAbsolutePath, oldValue, newValue);
                    this.myExternalsStore.addDepth(db.localAbsolutePath, db.ambientDepth);
                }
            }
            if (db.shadowed) {
                actualProps = db.addingDir ? new SVNProperties() : baseProps;
            }
            SVNWCContext.MergePropertiesInfo mergeProperiesInfo = this.myWCContext.mergeProperties2(null, db.localAbsolutePath, ISVNWCDb.SVNWCDbKind.Dir, null, null, null, baseProps, actualProps, regularProps, true, false);
            newActualProps = mergeProperiesInfo.newActualProperties;
            newBaseProps = mergeProperiesInfo.newBaseProperties;
            propStatus[0] = mergeProperiesInfo.mergeOutcome;
            allWorkItems = this.myWCContext.wqMerge(allWorkItems, mergeProperiesInfo.workItems);
        }
        AccumulatedChangeInfo change = this.accumulateLastChange(db.localAbsolutePath, entryProps);
        newChangedRev = change.changedRev;
        newChangedDate = change.changedDate;
        newChangedAuthor = change.changedAuthor;
        Map<String, SVNDirEntry> map = newChildren = this.myDirEntries != null ? this.myDirEntries.get(db.newRelativePath) : null;
        if (newChildren != null) {
            for (String childName : newChildren.keySet()) {
                File childAbsPath;
                SVNDirEntry childEntry;
                block26: {
                    childEntry = newChildren.get(childName);
                    childAbsPath = SVNFileUtil.createFilePath(db.localAbsolutePath, childName);
                    if (db.ambientDepth.compareTo(SVNDepth.IMMEDIATES) < 0 && childEntry.getKind() == SVNNodeKind.DIR) continue;
                    try {
                        this.myWCContext.getDb().getBaseInfo(childAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status);
                        if (!this.myWCContext.getDb().isWCRoot(childAbsPath)) {
                            continue;
                        }
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block26;
                        throw e;
                    }
                }
                File childRelPath = SVNFileUtil.createFilePath(db.newRelativePath, childName);
                ISVNWCDb.SVNWCDbKind childKind = childEntry.getKind() == SVNNodeKind.DIR ? ISVNWCDb.SVNWCDbKind.Dir : ISVNWCDb.SVNWCDbKind.File;
                this.myWCContext.getDb().addBaseNotPresentNode(childAbsPath, childRelPath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, childKind, null, null);
            }
        }
        if (db.notPresentFiles != null && db.notPresentFiles.size() > 0) {
            for (String fileName : db.notPresentFiles) {
                File childAbsPath = SVNFileUtil.createFilePath(db.localAbsolutePath, fileName);
                File childRelPath = SVNFileUtil.createFilePath(db.newRelativePath, fileName);
                this.myWCContext.getDb().addBaseNotPresentNode(childAbsPath, childRelPath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, ISVNWCDb.SVNWCDbKind.File, null, null);
            }
        }
        if (db.parentBaton != null || "".equals(this.myTargetBasename) || this.myTargetBasename == null) {
            SVNProperties props;
            if (newChangedRev >= 0L) {
                db.changedRevsion = newChangedRev;
            }
            if (newChangedDate != null && newChangedDate.getTime() != 0L) {
                db.changedDate = newChangedDate;
            }
            if (newChangedAuthor != null) {
                db.changedAuthor = newChangedAuthor;
            }
            if (db.ambientDepth == SVNDepth.UNKNOWN) {
                db.ambientDepth = SVNDepth.INFINITY;
            }
            if (this.myIsDepthSticky && db.ambientDepth != this.myRequestedDepth && (this.myRequestedDepth == SVNDepth.INFINITY || db.localAbsolutePath.equals(this.myTargetAbspath) && this.myRequestedDepth.compareTo(db.ambientDepth) > 0)) {
                db.ambientDepth = this.myRequestedDepth;
            }
            if ((props = newBaseProps) == null) {
                props = baseProps;
            }
            if (davProps != null) {
                davProps.removeNullValues();
            }
            this.myWCContext.getDb().addBaseDirectory(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, props, db.changedRevsion, db.changedDate, db.changedAuthor, null, db.ambientDepth, davProps != null && !davProps.isEmpty() ? davProps : null, null, !db.shadowed && newBaseProps != null, newActualProps, allWorkItems);
        }
        this.myWCContext.wqRun(db.localAbsolutePath);
        if (!db.alreadyNotified && this.myWCContext.getEventHandler() != null && db.edited) {
            SVNEventAction action = null;
            action = db.shadowed ? SVNEventAction.UPDATE_SHADOWED_UPDATE : (db.obstructionFound || db.addExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_UPDATE);
            SVNEvent event = new SVNEvent(db.localAbsolutePath, SVNNodeKind.DIR, null, this.myTargetRevision, null, propStatus[0], null, null, action, null, null, null, null, null, null);
            event.setPreviousRevision(db.oldRevision);
            event.setURL(db.getURL());
            event.setPreviousURL(db.getPreviousURL());
            this.myWCContext.getEventHandler().handleEvent(event, 0.0);
        }
        this.maybeBumpDirInfo(db.bumpInfo);
        this.myCurrentDirectory = this.myCurrentDirectory.parentBaton;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        FileBaton fb;
        assert (copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision) || copyFromPath == null && !SVNRevision.isValidRevisionNumber(copyFromRevision));
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentFile = fb = this.makeFileBaton(pb, path, true);
        if (fb.skipThis) {
            return;
        }
        fb.markEdited();
        if (SVNFileUtil.getAdminDirectoryName().equals(fb.name)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'' : object of the same name as the administrative directory", (Object)fb.localAbsolutePath);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        SVNNodeKind kind = SVNNodeKind.NONE;
        ISVNWCDb.SVNWCDbKind wcKind = ISVNWCDb.SVNWCDbKind.Unknown;
        ISVNWCDb.SVNWCDbStatus status = ISVNWCDb.SVNWCDbStatus.Normal;
        boolean conflicted = false;
        boolean versionedLocallyAndPresent = false;
        boolean error = false;
        SVNConflictDescription treeConflict = null;
        if (!this.myIsCleanCheckout) {
            kind = SVNFileType.getNodeKind(SVNFileType.getType(fb.localAbsolutePath));
            try {
                ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(fb.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.reposRelPath);
                status = readInfo.status;
                wcKind = readInfo.kind;
                conflicted = readInfo.conflicted;
                fb.oldRelativePath = readInfo.reposRelPath;
                versionedLocallyAndPresent = SVNUpdateEditor17.isNodePresent(status);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                    throw e;
                }
                error = true;
                wcKind = ISVNWCDb.SVNWCDbKind.Unknown;
                conflicted = false;
                versionedLocallyAndPresent = false;
            }
        }
        if (!error) {
            if (wcKind == ISVNWCDb.SVNWCDbKind.Dir && status == ISVNWCDb.SVNWCDbStatus.Normal) {
                if (pb.notPresentFiles == null) {
                    pb.notPresentFiles = new HashSet();
                }
                pb.notPresentFiles.add(fb.name);
                this.rememberSkippedTree(fb.localAbsolutePath);
                fb.skipThis = true;
                fb.alreadyNotified = true;
                this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, fb.getURL(), fb.getPreviousURL());
                return;
            }
            if (status == ISVNWCDb.SVNWCDbStatus.Normal && (wcKind == ISVNWCDb.SVNWCDbKind.File || wcKind == ISVNWCDb.SVNWCDbKind.Symlink)) {
                this.rememberSkippedTree(fb.localAbsolutePath);
                fb.skipThis = true;
                fb.alreadyNotified = true;
                this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, fb.getURL(), fb.getPreviousURL());
                return;
            }
            versionedLocallyAndPresent = wcKind == ISVNWCDb.SVNWCDbKind.Unknown ? false : SVNUpdateEditor17.isNodePresent(status);
        }
        if (conflicted) {
            if (pb.deletionConflicts != null) {
                treeConflict = (SVNTreeConflictDescription)pb.deletionConflicts.get(fb.name);
            }
            if (treeConflict != null) {
                treeConflict.setConflictAction(SVNConflictAction.REPLACE);
                this.myWCContext.getDb().opSetTreeConflict(fb.localAbsolutePath, (SVNTreeConflictDescription)treeConflict);
                treeConflict = null;
                fb.shadowed = true;
                conflicted = false;
            } else {
                conflicted = this.isNodeAlreadyConflicted(fb.localAbsolutePath);
            }
        }
        if (conflicted) {
            this.rememberSkippedTree(fb.localAbsolutePath);
            fb.skipThis = true;
            fb.alreadyNotified = true;
            if (pb.notPresentFiles == null) {
                pb.notPresentFiles = new HashSet();
            }
            pb.notPresentFiles.add(fb.name);
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, fb.getURL(), fb.getPreviousURL());
            return;
        }
        if (!fb.shadowed) {
            if (versionedLocallyAndPresent) {
                boolean localIsFile = false;
                if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                    status = this.myWCContext.getDb().scanAddition((File)((FileBaton)fb).localAbsolutePath, (ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[])new ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[]{ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status}).status;
                }
                boolean bl = localIsFile = wcKind == ISVNWCDb.SVNWCDbKind.File || wcKind == ISVNWCDb.SVNWCDbKind.Symlink;
                if (!this.myAddsAsModification || !localIsFile || status != ISVNWCDb.SVNWCDbStatus.Added) {
                    treeConflict = this.checkTreeConflict(fb.localAbsolutePath, status, wcKind, false, SVNConflictAction.ADD, SVNNodeKind.FILE, fb.newRelativePath);
                }
                if (treeConflict == null) {
                    fb.addExisted = true;
                } else {
                    fb.shadowed = true;
                }
            } else if (kind != SVNNodeKind.NONE) {
                fb.obstructionFound = true;
                if (kind != SVNNodeKind.FILE || !this.myIsUnversionedObstructionsAllowed) {
                    fb.shadowed = true;
                    treeConflict = this.createTreeConflict(fb.localAbsolutePath, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, SVNNodeKind.FILE, fb.newRelativePath);
                    assert (treeConflict != null);
                }
            }
        }
        if (pb.parentBaton != null || this.myTargetBasename == null || "".equals(this.myTargetBasename) || !fb.localAbsolutePath.equals(this.myTargetAbspath)) {
            if (pb.notPresentFiles == null) {
                pb.notPresentFiles = new HashSet();
            }
            pb.notPresentFiles.add(fb.name);
        }
        if (treeConflict != null) {
            this.myWCContext.getDb().opSetTreeConflict(fb.localAbsolutePath, (SVNTreeConflictDescription)treeConflict);
            fb.alreadyNotified = true;
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.TREE_CONFLICT, fb.getURL(), fb.getPreviousURL());
        }
    }

    public void openFile(String path, long revision) throws SVNException {
        FileBaton fb;
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentFile = fb = this.makeFileBaton(pb, path, false);
        if (fb.skipThis) {
            return;
        }
        boolean isRoot = this.myWCContext.getDb().isWCRoot(fb.localAbsolutePath);
        if (isRoot) {
            this.rememberSkippedTree(fb.localAbsolutePath);
            fb.skipThis = true;
            fb.alreadyNotified = true;
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
            return;
        }
        boolean conflicted = false;
        ISVNWCDb.SVNWCDbKind kind = ISVNWCDb.SVNWCDbKind.Unknown;
        SVNTreeConflictDescription treeConflict = null;
        ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(fb.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.checksum, ISVNWCDb.WCDbInfo.InfoField.haveWork, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.reposRelPath);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        fb.changedAuthor = readInfo.changedAuthor;
        fb.changedDate = readInfo.changedDate;
        fb.changedRevison = readInfo.changedRev;
        fb.oldRevision = readInfo.revision;
        fb.originalChecksum = readInfo.checksum;
        fb.oldRelativePath = readInfo.reposRelPath;
        conflicted = readInfo.conflicted;
        if (readInfo.haveWork) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(fb.localAbsolutePath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
            fb.changedAuthor = baseInfo.changedAuthor;
            fb.changedDate = baseInfo.changedDate;
            fb.changedRevison = baseInfo.changedRev;
            fb.oldRevision = baseInfo.revision;
            fb.originalChecksum = baseInfo.checksum;
        }
        if (conflicted) {
            conflicted = this.isNodeAlreadyConflicted(fb.localAbsolutePath);
        }
        if (conflicted) {
            this.rememberSkippedTree(fb.localAbsolutePath);
            fb.skipThis = true;
            fb.alreadyNotified = true;
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, fb.getURL(), fb.getPreviousURL());
            return;
        }
        fb.shadowed = pb.shadowed;
        if (!fb.shadowed) {
            treeConflict = this.checkTreeConflict(fb.localAbsolutePath, status, kind, true, SVNConflictAction.EDIT, SVNNodeKind.FILE, fb.newRelativePath);
        }
        if (treeConflict != null) {
            fb.editConflict = treeConflict;
            fb.shadowed = true;
        }
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        FileBaton fb = this.myCurrentFile;
        if (fb.skipThis) {
            return;
        }
        if (SVNProperty.isRegularProperty(propertyName)) {
            if (this.myCurrentFile.regularPropChanges == null) {
                this.myCurrentFile.regularPropChanges = new SVNProperties();
            }
            this.myCurrentFile.regularPropChanges.put(propertyName, propertyValue);
        } else if (SVNProperty.isEntryProperty(propertyName)) {
            if (this.myCurrentFile.entryPropChanges == null) {
                this.myCurrentFile.entryPropChanges = new SVNProperties();
            }
            this.myCurrentFile.entryPropChanges.put(propertyName, propertyValue);
        } else if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            if (this.myCurrentFile.davPropChanges == null) {
                this.myCurrentFile.davPropChanges = new SVNProperties();
            }
            this.myCurrentFile.davPropChanges.put(propertyName, propertyValue);
        }
        if (!fb.edited && SVNProperty.isRegularProperty(propertyName)) {
            fb.markEdited();
        }
    }

    public void closeFile(String path, String expectedMd5Digest) throws SVNException {
        SVNWCContext.MergePropertiesInfo info;
        SVNPropertyValue newWCDavURL;
        FileBaton fb = this.myCurrentFile;
        if (fb.skipThis) {
            this.maybeBumpDirInfo(fb.bumpInfo);
            return;
        }
        SvnChecksum expectedMd5Checksum = null;
        if (expectedMd5Digest != null) {
            expectedMd5Checksum = new SvnChecksum(SvnChecksum.Kind.md5, expectedMd5Digest);
        }
        if (expectedMd5Checksum != null && fb.newTextBaseMD5Digest != null && !expectedMd5Checksum.getDigest().equals(fb.newTextBaseMD5Digest)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", fb.localAbsolutePath, expectedMd5Checksum, fb.newTextBaseMD5Digest);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNProperties entryProps = fb.entryPropChanges;
        SVNProperties davProps = fb.davPropChanges;
        SVNPropertyValue sVNPropertyValue = newWCDavURL = davProps != null ? davProps.getSVNPropertyValue("svn:wc:ra_dav:version-url") : null;
        if (newWCDavURL == null) {
            davProps = null;
        }
        SVNProperties regularProps = fb.regularPropChanges;
        AccumulatedChangeInfo lastChange = this.accumulateLastChange(fb.localAbsolutePath, entryProps);
        long newChangedRev = lastChange.changedRev;
        SVNDate newChangedDate = lastChange.changedDate;
        String newChangedAuthor = lastChange.changedAuthor;
        if (newChangedRev >= 0L) {
            fb.changedRevison = newChangedRev;
        }
        if (newChangedDate != null) {
            fb.changedDate = newChangedDate;
        }
        if (newChangedAuthor != null) {
            fb.changedAuthor = newChangedAuthor;
        }
        SVNStatusType lockState = SVNStatusType.LOCK_UNCHANGED;
        for (String name : entryProps.nameSet()) {
            if (!"svn:entry:lock-token".equals(name)) continue;
            assert (entryProps.getStringValue(name) == null);
            this.myWCContext.getDb().removeLock(fb.localAbsolutePath);
            lockState = SVNStatusType.LOCK_UNLOCKED;
            break;
        }
        SVNProperties localActualProps = null;
        SVNProperties currentBaseProps = null;
        SVNProperties currentActualProps = null;
        if (!(fb.addingFile && !fb.addExisted || fb.shadowed)) {
            localActualProps = this.myWCContext.getActualProps(fb.localAbsolutePath);
        }
        if (localActualProps == null) {
            localActualProps = new SVNProperties();
        }
        if (fb.addExisted) {
            currentBaseProps = this.myWCContext.getPristineProps(fb.localAbsolutePath);
            currentActualProps = localActualProps;
        } else if (!fb.addingFile) {
            currentBaseProps = this.myWCContext.getDb().getBaseProps(fb.localAbsolutePath);
            currentActualProps = localActualProps;
        }
        if (currentBaseProps == null) {
            currentBaseProps = new SVNProperties();
        }
        if (currentActualProps == null) {
            currentActualProps = new SVNProperties();
        }
        if (!(fb.shadowed || fb.addingFile && !fb.addExisted)) {
            boolean localIsLink = false;
            boolean incomingIsLink = false;
            incomingIsLink = localIsLink = localActualProps.getStringValue("svn:special") != null;
            if (regularProps != null) {
                String name;
                Iterator<String> names = regularProps.nameSet().iterator();
                while (names.hasNext() && !(incomingIsLink = "svn:special".equals(name = names.next()))) {
                }
            }
            if (localIsLink != incomingIsLink) {
                SVNTreeConflictDescription treeConflict = null;
                fb.shadowed = true;
                fb.obstructionFound = true;
                fb.addExisted = false;
                treeConflict = this.checkTreeConflict(fb.localAbsolutePath, ISVNWCDb.SVNWCDbStatus.Added, ISVNWCDb.SVNWCDbKind.File, true, SVNConflictAction.ADD, SVNNodeKind.FILE, fb.newRelativePath);
                this.myWCContext.getDb().opSetTreeConflict(fb.localAbsolutePath, treeConflict);
                fb.alreadyNotified = true;
                this.doNotification(fb.localAbsolutePath, SVNNodeKind.UNKNOWN, SVNEventAction.TREE_CONFLICT, fb.getURL(), fb.getPreviousURL());
            }
        }
        SVNStatusType[] propState = new SVNStatusType[]{SVNStatusType.UNKNOWN};
        SVNStatusType contentState = null;
        SVNProperties newBaseProps = new SVNProperties();
        SVNProperties newActualProps = new SVNProperties();
        SVNSkel allWorkItems = null;
        boolean keepRecordedInfo = false;
        if (!fb.shadowed) {
            boolean installPristine = false;
            info = new SVNWCContext.MergePropertiesInfo();
            info.newActualProperties = newActualProps;
            info.newBaseProperties = newBaseProps;
            info = this.myWCContext.mergeProperties2(info, fb.localAbsolutePath, ISVNWCDb.SVNWCDbKind.File, null, null, null, currentBaseProps, currentActualProps, regularProps, true, false);
            newActualProps = info.newActualProperties;
            newBaseProps = info.newBaseProperties;
            propState[0] = info.mergeOutcome;
            allWorkItems = this.myWCContext.wqMerge(allWorkItems, info.workItems);
            File installFrom = null;
            if (!fb.obstructionFound) {
                MergeFileInfo fileInfo = null;
                try {
                    fileInfo = this.mergeFile(fb, currentActualProps, fb.changedDate);
                    contentState = fileInfo.contentState;
                    installFrom = fileInfo.installFrom;
                    installPristine = fileInfo.installPristine;
                }
                catch (SVNException e) {
                    if (SVNWCContext.isErrorAccess(e)) {
                        this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_ACCESS_DENINED, fb.getURL(), fb.getPreviousURL());
                        this.rememberSkippedTree(fb.localAbsolutePath);
                        fb.skipThis = true;
                        this.maybeBumpDirInfo(fb.bumpInfo);
                        return;
                    }
                    throw e;
                }
                if (fileInfo != null) {
                    allWorkItems = this.myWCContext.wqMerge(allWorkItems, fileInfo.workItems);
                }
            } else {
                installPristine = false;
                contentState = fb.newTextBaseSHA1Checksum != null ? SVNStatusType.CHANGED : SVNStatusType.UNCHANGED;
            }
            if (installPristine) {
                boolean recordFileInfo = installFrom == null;
                SVNSkel wi = this.myWCContext.wqBuildFileInstall(fb.localAbsolutePath, installFrom, this.myIsUseCommitTimes, recordFileInfo);
                allWorkItems = this.myWCContext.wqMerge(allWorkItems, wi);
            } else if (lockState == SVNStatusType.LOCK_UNLOCKED && !fb.obstructionFound) {
                SVNSkel wi = this.myWCContext.wqBuildSyncFileFlags(fb.localAbsolutePath);
                allWorkItems = this.myWCContext.wqMerge(allWorkItems, wi);
            }
            if (!installPristine && contentState == SVNStatusType.UNCHANGED) {
                keepRecordedInfo = true;
            }
            if (installFrom != null && !fb.localAbsolutePath.equals(installFrom)) {
                SVNSkel wi = this.myWCContext.wqBuildFileRemove(installFrom);
                allWorkItems = this.myWCContext.wqMerge(allWorkItems, wi);
            }
        } else {
            SVNProperties fakeActualProperties = fb.addingFile ? new SVNProperties() : currentBaseProps;
            info = new SVNWCContext.MergePropertiesInfo();
            info.newActualProperties = newActualProps;
            info.newBaseProperties = newBaseProps;
            info = this.myWCContext.mergeProperties2(info, fb.localAbsolutePath, ISVNWCDb.SVNWCDbKind.File, null, null, null, currentBaseProps, fakeActualProperties, regularProps, true, false);
            newActualProps = info.newActualProperties;
            newBaseProps = info.newBaseProperties;
            propState[0] = info.mergeOutcome;
            allWorkItems = this.myWCContext.wqMerge(allWorkItems, info.workItems);
            contentState = fb.newTextBaseSHA1Checksum != null ? SVNStatusType.CHANGED : SVNStatusType.UNCHANGED;
        }
        SvnChecksum newChecksum = fb.newTextBaseSHA1Checksum;
        if (newChecksum == null) {
            newChecksum = fb.originalChecksum;
        }
        if (davProps != null) {
            davProps.removeNullValues();
        }
        this.myWCContext.getDb().addBaseFile(fb.localAbsolutePath, fb.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, newBaseProps, fb.changedRevison, fb.changedDate, fb.changedAuthor, newChecksum, davProps != null && !davProps.isEmpty() ? davProps : null, null, !fb.shadowed && newBaseProps != null, newActualProps, keepRecordedInfo, fb.shadowed && fb.obstructionFound, allWorkItems);
        if (fb.addExisted && fb.addingFile) {
            this.myWCContext.getDb().opRemoveWorkingTemp(fb.localAbsolutePath);
        }
        if (fb.directoryBaton.notPresentFiles != null) {
            fb.directoryBaton.notPresentFiles.remove(fb.name);
        }
        if (this.myWCContext.getEventHandler() != null && !fb.alreadyNotified && (fb.edited || lockState == SVNStatusType.LOCK_UNLOCKED)) {
            SVNEventAction action = SVNEventAction.UPDATE_UPDATE;
            if (fb.edited) {
                if (fb.shadowed) {
                    action = fb.addingFile ? SVNEventAction.UPDATE_SHADOWED_ADD : SVNEventAction.UPDATE_SHADOWED_UPDATE;
                } else if (fb.obstructionFound || fb.addExisted) {
                    if (contentState != SVNStatusType.CONFLICTED) {
                        action = SVNEventAction.UPDATE_EXISTS;
                    }
                } else if (fb.addingFile) {
                    action = SVNEventAction.UPDATE_ADD;
                }
            }
            String mimeType = this.myWCContext.getProperty(fb.localAbsolutePath, "svn:mime-type");
            SVNEvent event = SVNEventFactory.createSVNEvent(fb.localAbsolutePath, SVNNodeKind.FILE, mimeType, this.myTargetRevision, contentState, propState[0], lockState, action, null, null, null);
            SVNURL url = fb.getURL();
            event.setPreviousRevision(fb.oldRevision);
            event.setURL(url);
            this.myWCContext.getEventHandler().handleEvent(event, 0.0);
        }
        this.maybeBumpDirInfo(fb.bumpInfo);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.rootOpened && ("".equals(this.myTargetBasename) || this.myTargetBasename == null)) {
            this.myWCContext.getDb().opSetBaseIncompleteTemp(this.myAnchorAbspath, false);
        }
        if (!this.myIsTargetDeleted) {
            this.myWCContext.getDb().opBumpRevisionPostUpdate(this.myTargetAbspath, this.myRequestedDepth, this.mySwitchRelpath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, this.mySkippedTrees);
            if (this.myTargetBasename == null || "".equals(this.myTargetBasename)) {
                ISVNWCDb.SVNWCDbStatus status = null;
                boolean error = false;
                try {
                    status = this.myWCContext.getDb().getBaseInfo((File)this.myTargetAbspath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.status}).status;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                        throw e;
                    }
                    error = true;
                }
                if (!error && status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    this.myWCContext.getDb().removeBase(this.myTargetAbspath);
                }
            }
        }
        this.myWCContext.wqRun(this.myAnchorAbspath);
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void applyTextDelta(String path, String expectedChecksum) throws SVNException {
        InputStream source;
        FileBaton fb = this.myCurrentFile;
        if (fb.skipThis) {
            return;
        }
        fb.markEdited();
        SvnChecksum expectedBaseChecksum = expectedChecksum != null ? new SvnChecksum(SvnChecksum.Kind.md5, expectedChecksum) : null;
        SvnChecksum recordedBaseChecksum = fb.originalChecksum;
        if (recordedBaseChecksum != null && expectedBaseChecksum != null && recordedBaseChecksum.getKind() != SvnChecksum.Kind.md5) {
            recordedBaseChecksum = this.myWCContext.getDb().getPristineMD5(this.myAnchorAbspath, recordedBaseChecksum);
        }
        if (recordedBaseChecksum != null && expectedBaseChecksum != null && !expectedBaseChecksum.equals(recordedBaseChecksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}'':\n    expected:  ''{1}''\n   recorded:  ''{2}''\n", fb.localAbsolutePath, expectedBaseChecksum, recordedBaseChecksum);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        if (!fb.addingFile) {
            source = this.myWCContext.getDb().readPristine(fb.localAbsolutePath, fb.originalChecksum);
            if (source == null) {
                source = SVNFileUtil.DUMMY_IN;
            }
        } else {
            source = SVNFileUtil.DUMMY_IN;
        }
        if (recordedBaseChecksum == null) {
            recordedBaseChecksum = expectedBaseChecksum;
        }
        if (recordedBaseChecksum != null) {
            fb.expectedSourceChecksum = new SvnChecksum(recordedBaseChecksum.getKind(), recordedBaseChecksum.getDigest());
            if (source != SVNFileUtil.DUMMY_IN) {
                source = new SVNChecksumInputStream(source, "MD5");
                fb.sourceChecksumStream = (SVNChecksumInputStream)source;
            }
        }
        SVNWCContext.WritableBaseInfo openWritableBase = this.myWCContext.openWritableBase(fb.localAbsolutePath, false, true);
        OutputStream target = openWritableBase.stream;
        fb.newTextBaseTmpAbsPath = openWritableBase.tempBaseAbspath;
        this.myDeltaProcessor.applyTextDelta(source, target, true);
        fb.newTextBaseSHA1ChecksumStream = openWritableBase.sha1ChecksumStream;
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.myCurrentFile.skipThis) {
            return SVNFileUtil.DUMMY_OUT;
        }
        try {
            this.myDeltaProcessor.textDeltaChunk(diffWindow);
        }
        catch (SVNException svne) {
            this.myDeltaProcessor.textDeltaEnd();
            SVNFileUtil.deleteFile(this.myCurrentFile.newTextBaseTmpAbsPath);
            this.myCurrentFile.newTextBaseTmpAbsPath = null;
            throw svne;
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (this.myCurrentFile.skipThis) {
            return;
        }
        this.myCurrentFile.newTextBaseMD5Digest = this.myDeltaProcessor.textDeltaEnd();
        if (this.myCurrentFile.newTextBaseSHA1ChecksumStream != null) {
            this.myCurrentFile.newTextBaseSHA1Checksum = new SvnChecksum(SvnChecksum.Kind.sha1, this.myCurrentFile.newTextBaseSHA1ChecksumStream.getDigest());
        }
        if (this.myCurrentFile.expectedSourceChecksum != null && this.myCurrentFile.expectedSourceChecksum.getKind() == SvnChecksum.Kind.md5) {
            String actualSourceChecksum;
            String string = actualSourceChecksum = this.myCurrentFile.sourceChecksumStream != null ? this.myCurrentFile.sourceChecksumStream.getDigest() : null;
            if (!this.myCurrentFile.expectedSourceChecksum.getDigest().equals(actualSourceChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch while updating ''{0}''; expected: ''{1}'', actual: ''{2}''", this.myCurrentFile.localAbsolutePath, this.myCurrentFile.expectedSourceChecksum.getDigest(), actualSourceChecksum);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (this.myCurrentFile.newTextBaseTmpAbsPath != null && this.myCurrentFile.newTextBaseSHA1Checksum != null && this.myCurrentFile.newTextBaseMD5Digest != null) {
            this.myWCContext.getDb().installPristine(this.myCurrentFile.newTextBaseTmpAbsPath, this.myCurrentFile.newTextBaseSHA1Checksum, new SvnChecksum(SvnChecksum.Kind.md5, this.myCurrentFile.newTextBaseMD5Digest));
        }
    }

    private DirectoryBaton makeDirectoryBaton(String path, DirectoryBaton parent, boolean adding) throws SVNException {
        DirectoryBaton d = new DirectoryBaton();
        if (path != null) {
            d.name = SVNPathUtil.tail(path);
            d.localAbsolutePath = SVNFileUtil.createFilePath(parent.localAbsolutePath, d.name);
        } else {
            d.name = null;
            d.localAbsolutePath = this.myAnchorAbspath;
        }
        if (this.mySwitchRelpath != null) {
            if (parent == null) {
                if ("".equals(this.myTargetBasename) || this.myTargetBasename == null) {
                    d.newRelativePath = this.mySwitchRelpath;
                } else {
                    d.newRelativePath = this.myWCContext.getDb().scanBaseRepository((File)((DirectoryBaton)d).localAbsolutePath, (ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[])new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath}).relPath;
                }
            } else if (parent.parentBaton == null && this.myTargetBasename.equals(d.name)) {
                d.newRelativePath = this.mySwitchRelpath;
            } else {
                d.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, d.name);
            }
        } else if (adding) {
            d.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, d.name);
        } else {
            d.newRelativePath = this.myWCContext.getDb().scanBaseRepository((File)((DirectoryBaton)d).localAbsolutePath, (ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[])new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath}).relPath;
        }
        BumpDirectoryInfo bdi = new BumpDirectoryInfo();
        bdi.parent = parent != null ? parent.bumpInfo : null;
        bdi.refCount = 1;
        if (parent != null) {
            bdi.parent.refCount++;
        }
        d.parentBaton = parent;
        d.bumpInfo = bdi;
        d.oldRevision = -1L;
        d.addingDir = adding;
        d.changedRevsion = -1L;
        d.notPresentFiles = new HashSet();
        if (parent != null) {
            d.skipThis = parent.skipThis;
            d.shadowed = parent.shadowed;
        }
        d.ambientDepth = SVNDepth.UNKNOWN;
        return d;
    }

    private FileBaton makeFileBaton(DirectoryBaton parent, String path, boolean adding) throws SVNException {
        FileBaton f = new FileBaton();
        f.name = SVNPathUtil.tail(path);
        f.oldRevision = -1L;
        f.localAbsolutePath = SVNFileUtil.createFilePath(parent.localAbsolutePath, f.name);
        if (this.mySwitchRelpath != null) {
            if (parent.parentBaton == null && this.myTargetBasename != null && f.name.equals(this.myTargetBasename)) {
                f.newRelativePath = this.mySwitchRelpath;
            } else {
                f.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, f.name);
            }
        } else if (adding) {
            f.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, f.name);
        } else {
            f.newRelativePath = this.myWCContext.getDb().scanBaseRepository((File)((FileBaton)f).localAbsolutePath, (ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[])new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath}).relPath;
        }
        f.bumpInfo = parent.bumpInfo;
        f.addingFile = adding;
        f.skipThis = parent.skipThis;
        f.shadowed = parent.shadowed;
        f.directoryBaton = parent;
        f.changedRevison = -1L;
        f.bumpInfo.refCount++;
        return f;
    }

    private static boolean isNodePresent(ISVNWCDb.SVNWCDbStatus status) {
        return status != ISVNWCDb.SVNWCDbStatus.ServerExcluded && status != ISVNWCDb.SVNWCDbStatus.Excluded && status != ISVNWCDb.SVNWCDbStatus.NotPresent;
    }

    private SVNTreeConflictDescription createTreeConflict(File localAbspath, SVNConflictReason reason, SVNConflictAction action, SVNNodeKind theirNodeKind, File theirRelpath) throws SVNException {
        SVNNodeKind conflictNodeKind;
        File rightReposRelpath;
        SVNURL reposRootUrl;
        File leftReposRelpath;
        long leftRevision;
        assert (reason != null);
        SVNNodeKind leftKind = null;
        File addedReposRelpath = null;
        if (reason == SVNConflictReason.ADDED) {
            leftKind = SVNNodeKind.NONE;
            leftRevision = -1L;
            leftReposRelpath = null;
            ISVNWCDb.WCDbAdditionInfo scanAddition = this.myWCContext.getDb().scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl);
            ISVNWCDb.SVNWCDbStatus addedStatus = scanAddition.status;
            addedReposRelpath = scanAddition.reposRelPath;
            reposRootUrl = scanAddition.reposRootUrl;
            assert (addedStatus == ISVNWCDb.SVNWCDbStatus.Added || addedStatus == ISVNWCDb.SVNWCDbStatus.Copied || addedStatus == ISVNWCDb.SVNWCDbStatus.MovedHere);
        } else if (reason == SVNConflictReason.UNVERSIONED) {
            leftKind = SVNNodeKind.NONE;
            leftRevision = -1L;
            leftReposRelpath = null;
            reposRootUrl = this.myReposRootURL;
        } else {
            assert (reason == SVNConflictReason.EDITED || reason == SVNConflictReason.DELETED || reason == SVNConflictReason.REPLACED || reason == SVNConflictReason.OBSTRUCTED);
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl);
            ISVNWCDb.SVNWCDbKind baseKind = baseInfo.kind;
            leftRevision = baseInfo.revision;
            leftReposRelpath = baseInfo.reposRelPath;
            reposRootUrl = baseInfo.reposRootUrl;
            if (baseKind == ISVNWCDb.SVNWCDbKind.File || baseKind == ISVNWCDb.SVNWCDbKind.Symlink) {
                leftKind = SVNNodeKind.FILE;
            } else if (baseKind == ISVNWCDb.SVNWCDbKind.Dir) {
                leftKind = SVNNodeKind.DIR;
            } else {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL), SVNLogType.WC);
            }
        }
        assert (reposRootUrl.equals(this.myReposRootURL));
        if (this.mySwitchRelpath != null) {
            if (theirRelpath != null) {
                rightReposRelpath = theirRelpath;
            } else {
                rightReposRelpath = this.mySwitchRelpath;
                rightReposRelpath = SVNFileUtil.createFilePath(rightReposRelpath.getPath() + "_THIS_IS_INCOMPLETE");
            }
        } else {
            File file = rightReposRelpath = reason == SVNConflictReason.ADDED ? addedReposRelpath : leftReposRelpath;
            if (rightReposRelpath == null) {
                rightReposRelpath = theirRelpath;
            }
        }
        assert (rightReposRelpath != null);
        SVNNodeKind sVNNodeKind = conflictNodeKind = action == SVNConflictAction.DELETE ? leftKind : theirNodeKind;
        assert (conflictNodeKind == SVNNodeKind.FILE || conflictNodeKind == SVNNodeKind.DIR);
        SVNConflictVersion srcLeftVersion = leftReposRelpath == null ? null : new SVNConflictVersion(reposRootUrl, leftReposRelpath.getPath(), leftRevision, leftKind);
        SVNConflictVersion srcRightVersion = new SVNConflictVersion(reposRootUrl, rightReposRelpath.getPath(), this.myTargetRevision, theirNodeKind);
        return new SVNTreeConflictDescription(localAbspath, conflictNodeKind, action, reason, this.mySwitchRelpath != null ? SVNOperation.SWITCH : SVNOperation.UPDATE, srcLeftVersion, srcRightVersion);
    }

    private void maybeBumpDirInfo(BumpDirectoryInfo bdi) throws SVNException {
        while (bdi != null) {
            if (--bdi.refCount > 0) {
                return;
            }
            bdi = bdi.parent;
        }
    }

    private AccumulatedChangeInfo accumulateLastChange(File localAbspath, SVNProperties entryProps) throws SVNException {
        AccumulatedChangeInfo info = new AccumulatedChangeInfo();
        info.changedRev = -1L;
        info.changedDate = null;
        info.changedAuthor = null;
        if (entryProps != null) {
            for (String propertyName : entryProps.nameSet()) {
                String propertyValue = entryProps.getStringValue(propertyName);
                if (propertyValue == null) continue;
                if ("svn:entry:last-author".equals(propertyName)) {
                    info.changedAuthor = propertyValue;
                    continue;
                }
                if ("svn:entry:committed-rev".equals(propertyName)) {
                    info.changedRev = Long.valueOf(propertyValue);
                    continue;
                }
                if (!"svn:entry:committed-date".equals(propertyName)) continue;
                info.changedDate = SVNDate.parseDate(propertyValue);
            }
        }
        return info;
    }

    public static SVNWCContext.MergeInfo performFileMerge(SVNWCContext context, File localAbsPath, File wriAbsPath, SvnChecksum newChecksum, SvnChecksum originalChecksum, SVNProperties actualProperties, String[] extPatterns, long oldRevision, long targetRevision, SVNProperties propChanges) throws SVNException {
        File mergeLeft = null;
        boolean deleteLeft = false;
        File newTextBaseTmpAbsPath = context.getDb().getPristinePath(wriAbsPath, newChecksum);
        if (extPatterns == null || extPatterns.length > 0) {
            // empty if block
        }
        if (oldRevision < 0L) {
            oldRevision = 0L;
        }
        String oldRevStr = String.format(".r%s%s%s", oldRevision, "", "");
        String newRevStr = String.format(".r%s%s%s", targetRevision, "", "");
        String mineStr = String.format(".mine%s%s", "", "");
        if (originalChecksum == null) {
            File tmpDir = context.getDb().getWCRootTempDir(wriAbsPath);
            mergeLeft = SVNFileUtil.createUniqueFile(tmpDir, "file", "tmp", false);
            deleteLeft = true;
        } else {
            mergeLeft = context.getDb().getPristinePath(wriAbsPath, originalChecksum);
        }
        SVNWCContext.MergeInfo mergeInfo = context.merge(mergeLeft, null, newTextBaseTmpAbsPath, null, localAbsPath, wriAbsPath, oldRevStr, newRevStr, mineStr, actualProperties, false, null, propChanges);
        if (deleteLeft) {
            SVNSkel workItem = context.wqBuildFileRemove(mergeLeft);
            context.wqMerge(mergeInfo.workItems, workItem);
        }
        return mergeInfo;
    }

    private MergeFileInfo mergeFile(FileBaton fb, SVNProperties actualProps, SVNDate lastChangedDate) throws SVNException {
        DirectoryBaton pb = fb.directoryBaton;
        boolean magicPropsChanged = false;
        MergeFileInfo mergeFileInfo = new MergeFileInfo();
        mergeFileInfo.installPristine = false;
        mergeFileInfo.contentState = SVNStatusType.UNCHANGED;
        boolean isLocallyModified = fb.addingFile && !fb.addExisted ? false : this.myWCContext.isTextModified(fb.localAbsolutePath, false);
        SVNProperties propChanges = new SVNProperties();
        if (fb.regularPropChanges != null) {
            propChanges.putAll(fb.regularPropChanges);
        }
        if (fb.entryPropChanges != null) {
            propChanges.putAll(fb.entryPropChanges);
        }
        if (fb.davPropChanges != null) {
            propChanges.putAll(fb.davPropChanges);
        }
        if (!isLocallyModified && fb.newTextBaseSHA1Checksum != null) {
            mergeFileInfo.installPristine = true;
        } else if (fb.newTextBaseSHA1Checksum != null) {
            SVNWCContext.MergeInfo mergeInfo = SVNUpdateEditor17.performFileMerge(this.myWCContext, fb.localAbsolutePath, pb.localAbsolutePath, fb.newTextBaseSHA1Checksum, fb.addExisted ? null : fb.originalChecksum, actualProps, this.myExtensionPatterns, fb.oldRevision, this.myTargetRevision, propChanges);
            mergeFileInfo.workItems = this.myWCContext.wqMerge(mergeFileInfo.workItems, mergeInfo.workItems);
            mergeFileInfo.contentState = mergeInfo.mergeOutcome;
        } else {
            magicPropsChanged = this.myWCContext.hasMagicProperty(propChanges);
            SVNWCContext.TranslateInfo translateInfo = this.myWCContext.getTranslateInfo(fb.localAbsolutePath, actualProps, true, false, true, false);
            if (magicPropsChanged || translateInfo.keywords != null && !translateInfo.keywords.isEmpty()) {
                if (isLocallyModified) {
                    File tmpText = null;
                    tmpText = this.myWCContext.getTranslatedFile(fb.localAbsolutePath, fb.localAbsolutePath, true, true, false, false);
                    mergeFileInfo.installPristine = true;
                    mergeFileInfo.installFrom = tmpText;
                } else {
                    mergeFileInfo.installPristine = true;
                }
            }
        }
        if (!mergeFileInfo.installPristine && !isLocallyModified) {
            SVNDate date = SVNDate.NULL;
            if (lastChangedDate != null) {
                date = lastChangedDate;
            }
            SVNSkel workItem = this.myWCContext.wqBuildRecordFileinfo(fb.localAbsolutePath, date);
            mergeFileInfo.workItems = this.myWCContext.wqMerge(mergeFileInfo.workItems, workItem);
        }
        if (mergeFileInfo.contentState != SVNStatusType.CONFLICTED) {
            mergeFileInfo.contentState = fb.newTextBaseSHA1Checksum != null ? (isLocallyModified ? SVNStatusType.MERGED : SVNStatusType.CHANGED) : SVNStatusType.UNCHANGED;
        }
        return mergeFileInfo;
    }

    private static class MergeFileInfo {
        public SVNSkel workItems;
        public boolean installPristine;
        public File installFrom;
        public SVNStatusType contentState;

        private MergeFileInfo() {
        }
    }

    private static class AccumulatedChangeInfo {
        public long changedRev;
        public SVNDate changedDate;
        public String changedAuthor;

        private AccumulatedChangeInfo() {
        }
    }

    private class FileBaton {
        private String name;
        private File localAbsolutePath;
        private File newRelativePath;
        private File oldRelativePath;
        private long oldRevision;
        private DirectoryBaton directoryBaton;
        private boolean skipThis;
        private boolean alreadyNotified;
        private boolean addingFile;
        private boolean obstructionFound;
        private boolean addExisted;
        private boolean shadowed;
        private long changedRevison;
        private SVNDate changedDate;
        private String changedAuthor;
        private SvnChecksum originalChecksum;
        private SVNProperties entryPropChanges;
        private SVNProperties regularPropChanges;
        private SVNProperties davPropChanges;
        private BumpDirectoryInfo bumpInfo;
        private boolean edited;
        private SVNTreeConflictDescription editConflict;
        File newTextBaseTmpAbsPath;
        SVNChecksumInputStream sourceChecksumStream;
        SVNChecksumOutputStream newTextBaseSHA1ChecksumStream;
        SvnChecksum expectedSourceChecksum;
        String newTextBaseMD5Digest;
        public SvnChecksum newTextBaseSHA1Checksum;

        private FileBaton() {
        }

        public void markEdited() throws SVNException {
            if (this.edited) {
                return;
            }
            if (this.directoryBaton != null) {
                this.directoryBaton.markEdited();
            }
            this.edited = true;
            if (this.editConflict != null) {
                SVNUpdateEditor17.this.myWCContext.getDb().opSetTreeConflict(this.localAbsolutePath, this.editConflict);
                SVNUpdateEditor17.this.doNotification(this.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.TREE_CONFLICT, this.getURL(), this.getPreviousURL());
                this.alreadyNotified = true;
            }
        }

        public SVNURL getURL() throws SVNException {
            if (this.newRelativePath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.newRelativePath);
            }
            return null;
        }

        public SVNURL getPreviousURL() throws SVNException {
            if (this.oldRelativePath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.oldRelativePath);
            }
            return null;
        }
    }

    private class DirectoryBaton {
        private String name;
        private File localAbsolutePath;
        private File newRelativePath;
        private File oldRelativePath;
        private long oldRevision;
        DirectoryBaton parentBaton;
        private boolean skipThis;
        private boolean alreadyNotified;
        private boolean addingDir;
        private boolean shadowed;
        private long changedRevsion;
        private SVNDate changedDate;
        private String changedAuthor;
        private Map<String, SVNTreeConflictDescription> deletionConflicts;
        private Set<String> notPresentFiles;
        private boolean obstructionFound;
        private boolean addExisted;
        private SVNProperties entryPropChanges;
        private SVNProperties regularPropChanges;
        private SVNProperties davPropChanges;
        private boolean edited;
        private SVNTreeConflictDescription editConflict;
        private BumpDirectoryInfo bumpInfo;
        private SVNDepth ambientDepth;
        private boolean wasIncomplete;

        private DirectoryBaton() {
        }

        public void markEdited() throws SVNException {
            if (this.edited) {
                return;
            }
            if (this.parentBaton != null) {
                this.parentBaton.markEdited();
            }
            this.edited = true;
            if (this.editConflict != null) {
                SVNUpdateEditor17.this.myWCContext.getDb().opSetTreeConflict(this.localAbsolutePath, this.editConflict);
                SVNUpdateEditor17.this.doNotification(this.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.TREE_CONFLICT, this.getURL(), this.getPreviousURL());
                this.alreadyNotified = true;
            }
        }

        public SVNURL getURL() throws SVNException {
            if (this.newRelativePath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.newRelativePath);
            }
            return null;
        }

        public SVNURL getPreviousURL() throws SVNException {
            if (this.oldRelativePath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.oldRelativePath);
            }
            return null;
        }
    }

    private static class BumpDirectoryInfo {
        private int refCount;
        private BumpDirectoryInfo parent;

        private BumpDirectoryInfo() {
        }
    }

    private static class TreeLocalModsInfo {
        public boolean modificationsFound;
        public boolean nonDeleteModificationsFound;

        private TreeLocalModsInfo() {
        }
    }
}

