/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTransaction;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbChangelist;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbCopy;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevert;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCreateSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbInsertDeleteList;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNPropertyConflictDescription;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTextConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNWCDb
implements ISVNWCDb {
    public static final int FORMAT_FROM_SDB = -1;
    public static final long UNKNOWN_WC_ID = -1L;
    static final long INVALID_REPOS_ID = -1L;
    private ISVNOptions config;
    private boolean autoUpgrade;
    private boolean enforceEmptyWQ;
    private Map<String, SVNWCDbDir> dirData;

    public static boolean isAbsolute(File localAbsPath) {
        return localAbsPath != null && localAbsPath.isAbsolute();
    }

    public static <E extends Enum<E>> EnumSet<E> getInfoFields(Class<E> clazz, E ... fields) {
        EnumSet<E> set = EnumSet.noneOf(clazz);
        for (E f : fields) {
            set.add(f);
        }
        return set;
    }

    @Override
    public void open(ISVNWCDb.SVNWCDbOpenMode mode, ISVNOptions config, boolean autoUpgrade, boolean enforceEmptyWQ) {
        this.config = config;
        this.autoUpgrade = autoUpgrade;
        this.enforceEmptyWQ = enforceEmptyWQ;
        this.dirData = new HashMap<String, SVNWCDbDir>();
    }

    @Override
    public void close() {
        HashSet<SVNWCDbRoot> roots = new HashSet<SVNWCDbRoot>();
        if (this.dirData != null) {
            for (Map.Entry<String, SVNWCDbDir> entry : this.dirData.entrySet()) {
                SVNWCDbDir pdh = entry.getValue();
                if (pdh.getWCRoot() == null || pdh.getWCRoot().getSDb() == null) continue;
                roots.add(pdh.getWCRoot());
            }
            this.dirData.clear();
        }
        this.closeManyWCRoots(roots);
    }

    public void ensureNoUnfinishedTransactions() throws SVNException {
        HashSet<SVNWCDbRoot> roots = new HashSet<SVNWCDbRoot>();
        if (this.dirData != null) {
            for (Map.Entry entry : this.dirData.entrySet()) {
                SVNWCDbDir pdh = (SVNWCDbDir)entry.getValue();
                if (pdh.getWCRoot() == null || pdh.getWCRoot().getSDb() == null) continue;
                roots.add(pdh.getWCRoot());
            }
        }
        for (SVNWCDbRoot sVNWCDbRoot : roots) {
            sVNWCDbRoot.ensureNoUnfinishedTransactions();
        }
    }

    private void closeManyWCRoots(Set<SVNWCDbRoot> roots) {
        for (SVNWCDbRoot wcRoot : roots) {
            try {
                wcRoot.close();
            }
            catch (SVNException e) {}
        }
    }

    @Override
    public ISVNOptions getConfig() {
        return this.config;
    }

    @Override
    public void init(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long initialRev, SVNDepth depth) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        assert (reposRelPath != null);
        assert (depth == SVNDepth.EMPTY || depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY);
        CreateDbInfo createDb = this.createDb(localAbsPath, reposRootUrl, reposUuid, "wc.db");
        SVNWCDbDir pdh = new SVNWCDbDir(localAbsPath);
        pdh.setWCRoot(new SVNWCDbRoot(this, localAbsPath, createDb.sDb, createDb.wcId, -1, false, false));
        this.dirData.put(localAbsPath.getAbsolutePath(), pdh);
        InsertBase ibb = new InsertBase();
        ibb.status = initialRev > 0L ? ISVNWCDb.SVNWCDbStatus.Incomplete : ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.Dir;
        ibb.reposId = createDb.reposId;
        ibb.reposRelpath = reposRelPath;
        ibb.revision = initialRev;
        ibb.children = null;
        ibb.depth = depth;
        ibb.wcId = createDb.wcId;
        ibb.localRelpath = SVNFileUtil.createFilePath("");
        createDb.sDb.runTransaction(ibb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateDbInfo createDb(File dirAbsPath, SVNURL reposRootUrl, String reposUuid, String sdbFileName) throws SVNException {
        CreateDbInfo info = new CreateDbInfo();
        info.sDb = SVNWCDb.openDb(dirAbsPath, sdbFileName, SVNSqlJetDb.Mode.RWCreate);
        info.sDb.execStatement(SVNWCDbStatements.CREATE_SCHEMA);
        info.reposId = this.createReposId(info.sDb, reposRootUrl, reposUuid);
        SVNSqlJetStatement statement = info.sDb.getStatement(SVNWCDbStatements.INSERT_WCROOT);
        try {
            info.wcId = statement.done();
            CreateDbInfo createDbInfo = info;
            return createDbInfo;
        }
        finally {
            statement.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createReposId(SVNSqlJetDb sDb, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        SVNSqlJetStatement getStmt = sDb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY);
        try {
            getStmt.bindf("s", reposRootUrl);
            boolean haveRow = getStmt.next();
            if (haveRow) {
                long l = SvnWcDbStatementUtil.getColumnInt64(getStmt, SVNWCDbSchema.WCROOT__Fields.id);
                return l;
            }
        }
        finally {
            getStmt.reset();
        }
        SVNSqlJetStatement insertStmt = sDb.getStatement(SVNWCDbStatements.INSERT_REPOSITORY);
        try {
            insertStmt.bindf("ss", reposRootUrl, reposUuid);
            long l = insertStmt.done();
            return l;
        }
        finally {
            insertStmt.reset();
        }
    }

    private void addWorkItems(SVNSqlJetDb sDb, SVNSkel skel) throws SVNException {
        if (skel == null) {
            return;
        }
        if (skel.isAtom()) {
            this.addSingleWorkItem(sDb, skel);
        } else {
            for (int i = 0; i < skel.getListSize(); ++i) {
                this.addSingleWorkItem(sDb, skel.getChild(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSingleWorkItem(SVNSqlJetDb sDb, SVNSkel workItem) throws SVNException {
        byte[] serialized = workItem.unparse();
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.INSERT_WORK_ITEM);
        try {
            stmt.bindBlob(1, serialized);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<File, File> getExternalsDefinedBelow(File localAbsPath) throws SVNException {
        TreeMap<File, File> externals = new TreeMap<File, File>(Collections.reverseOrder());
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_EXTERNALS_DEFINED);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            while (stmt.next()) {
                localRelpath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.EXTERNALS__Fields.local_relpath));
                File defLocalRelpath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.EXTERNALS__Fields.def_local_relpath));
                externals.put(SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), localRelpath), SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), defLocalRelpath));
            }
        }
        finally {
            stmt.reset();
        }
        return externals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherExternalDefinitions(File localAbsPath, SVNExternalsStore externals) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_EXTERNAL_PROPERTIES);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            while (stmt.next()) {
                String externalProperty;
                SVNProperties properties = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties);
                if (properties == null || (externalProperty = properties.getStringValue("svn:externals")) == null) continue;
                File nodeRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath));
                File nodeAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), nodeRelPath);
                externals.addExternal(nodeAbsPath, null, externalProperty);
                String depthWord = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth);
                externals.addDepth(nodeAbsPath, SvnWcDbStatementUtil.parseDepth(depthWord));
            }
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void addBaseExcludedNode(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, ISVNWCDb.SVNWCDbKind kind, ISVNWCDb.SVNWCDbStatus status, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        assert (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded);
        this.addExcludedOrNotPresentNode(localAbsPath, reposRelPath, reposRootUrl, reposUuid, revision, kind, status, conflict, workItems);
    }

    @Override
    public void addBaseDirectory(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, List<File> children, SVNDepth depth, SVNProperties davCache, SVNSkel conflict, boolean updateActualProps, SVNProperties actualProps, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        assert (reposRelPath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (props != null);
        assert (SVNRevision.isValidRevisionNumber(changedRev));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.reposRootURL = reposRootUrl;
        ibb.reposUUID = reposUuid;
        ibb.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.Dir;
        ibb.reposRelpath = reposRelPath;
        ibb.revision = revision;
        ibb.props = props;
        ibb.changedRev = changedRev;
        ibb.changedDate = changedDate;
        ibb.changedAuthor = changedAuthor;
        ibb.children = children;
        ibb.depth = depth;
        ibb.davCache = davCache;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        if (updateActualProps) {
            ibb.updateActualProps = true;
            ibb.actualProps = actualProps;
        }
        ibb.localRelpath = localRelpath;
        ibb.wcId = pdh.getWCRoot().getWcId();
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIncompleteChildren(SVNSqlJetDb db, long wcId, File localRelpath, long revision, List<File> children, long opDepth) throws SVNException {
        for (File name : children) {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
            try {
                stmt.bindf("isisnnrsns", wcId, SVNFileUtil.createFilePath(localRelpath, name), opDepth, localRelpath, revision, "incomplete", "unknown");
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractParentDelete(SVNSqlJetDb db, long wcId, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.DELETE_LOWEST_WORKING_NODE);
        try {
            stmt.bindf("is", wcId, localRelPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendParentDelete(SVNSqlJetDb db, long wcId, File localRelpath) throws SVNException {
        boolean haveRow;
        assert (localRelpath != null);
        long parentOpDepth = 0L;
        File parentRelpath = SVNFileUtil.getFileDir(localRelpath);
        assert (parentRelpath != null);
        SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
        try {
            stmt.bindf("is", wcId, parentRelpath);
            haveRow = stmt.next();
            if (haveRow) {
                parentOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            }
        }
        finally {
            stmt.reset();
        }
        if (haveRow) {
            long opDepth = 0L;
            try {
                stmt.bindf("is", wcId, localRelpath);
                haveRow = stmt.next();
                if (haveRow) {
                    opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                }
            }
            finally {
                stmt.reset();
            }
            if (!haveRow || parentOpDepth < opDepth) {
                stmt = db.getStatement(SVNWCDbStatements.INSTALL_WORKING_NODE_FOR_DELETE);
                try {
                    stmt.bindf("isit", wcId, localRelpath, parentOpDepth, SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.BaseDeleted));
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    @Override
    public void addBaseFile(File localAbspath, File reposRelpath, SVNURL reposRootUrl, String reposUuid, long revision, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, SvnChecksum checksum, SVNProperties davCache, SVNSkel conflict, boolean updateActualProps, SVNProperties actualProps, boolean keepRecordedInfo, boolean insertBaseDeleted, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (reposRelpath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (props != null);
        assert (SVNRevision.isValidRevisionNumber(changedRev));
        assert (checksum != null);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.reposRootURL = reposRootUrl;
        ibb.reposUUID = reposUuid;
        ibb.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.File;
        ibb.reposRelpath = reposRelpath;
        ibb.revision = revision;
        ibb.props = props;
        ibb.changedRev = changedRev;
        ibb.changedDate = changedDate;
        ibb.changedAuthor = changedAuthor;
        ibb.checksum = checksum;
        ibb.davCache = davCache;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        if (updateActualProps) {
            ibb.updateActualProps = true;
            ibb.actualProps = actualProps;
        }
        ibb.keepRecordedInfo = keepRecordedInfo;
        ibb.insertBaseDeleted = insertBaseDeleted;
        ibb.localRelpath = localRelpath;
        ibb.wcId = pdh.getWCRoot().getWcId();
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void addBaseSymlink(File localAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File target, SVNProperties davCache, SVNSkel conflict, boolean updateActualProps, SVNProperties acutalProps, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        assert (reposRelPath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (props != null);
        assert (SVNRevision.isValidRevisionNumber(changedRev));
        assert (target != null);
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.reposUUID = reposUuid;
        ibb.reposRootURL = reposRootUrl;
        ibb.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibb.kind = ISVNWCDb.SVNWCDbKind.Symlink;
        ibb.reposRelpath = reposRelPath;
        ibb.revision = revision;
        ibb.props = props;
        ibb.changedRev = changedRev;
        ibb.changedDate = changedDate;
        ibb.changedAuthor = changedAuthor;
        ibb.target = target;
        ibb.davCache = davCache;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        if (updateActualProps) {
            ibb.updateActualProps = true;
            ibb.actualProps = acutalProps;
        }
        ibb.wcId = pdh.getWCRoot().getWcId();
        ibb.localRelpath = localRelpath;
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void addLock(File localAbsPath, ISVNWCDb.SVNWCDbLock lock) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        assert (lock != null);
        DirParsedInfo dir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = dir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        InsertLock ilb = new InsertLock();
        ilb.localAbsPath = localAbsPath;
        ilb.lock = lock;
        pdh.getWCRoot().getSDb().runTransaction(ilb);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void addWorkQueue(File wcRootAbsPath, SVNSkel workItem) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        if (workItem == null) {
            return;
        }
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        this.addWorkItems(pdh.getWCRoot().getSDb(), workItem);
    }

    @Override
    public boolean checkPristine(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.checkPristine(pdh.getWCRoot(), checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedWorkQueue(File wcRootAbsPath, long id) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        assert (id != 0L);
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_WORK_ITEM);
        try {
            stmt.bindLong(1, id);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNWCDb.WCDbWorkQueueInfo fetchWorkQueue(File wcRootAbsPath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        ISVNWCDb.WCDbWorkQueueInfo info = new ISVNWCDb.WCDbWorkQueueInfo();
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_WORK_ITEM);
        try {
            boolean haveRow = stmt.next();
            if (!haveRow) {
                info.id = 0L;
                info.workItem = null;
                ISVNWCDb.WCDbWorkQueueInfo wCDbWorkQueueInfo = info;
                return wCDbWorkQueueInfo;
            }
            info.id = stmt.getColumnLong(SVNWCDbSchema.WORK_QUEUE__Fields.id);
            info.workItem = SVNSkel.parse(stmt.getColumnBlob(SVNWCDbSchema.WORK_QUEUE__Fields.work));
            ISVNWCDb.WCDbWorkQueueInfo wCDbWorkQueueInfo = info;
            return wCDbWorkQueueInfo;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public File fromRelPath(File wcRootAbsPath, File localRelPath) throws SVNException {
        return SVNFileUtil.createFilePath(wcRootAbsPath, localRelPath);
    }

    @Override
    public Set<String> getBaseChildren(File localAbsPath) throws SVNException {
        return this.gatherChildren(localAbsPath, true, false);
    }

    public Set<String> getWorkingChildren(File localAbsPath) throws SVNException {
        return this.gatherChildren(localAbsPath, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties getBaseDavCache(File localAbsPath) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(localAbsPath, SVNWCDbStatements.SELECT_BASE_DAV_CACHE);
        try {
            boolean haveRow = stmt.next();
            if (!haveRow) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNProperties sVNProperties = stmt.getColumnProperties(SVNWCDbSchema.NODES__Fields.dav_cache);
            return sVNProperties;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDavCacheRecursive(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDb.verifyDirUsable(parsed.wcDbDir);
        SVNWCDbRoot root = parsed.wcDbDir.getWCRoot();
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.CLEAR_BASE_NODE_RECURSIVE_DAV_CACHE);
        try {
            stmt.bindf("is", root.getWcId(), SVNFileUtil.getFilePath(parsed.localRelPath));
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public ISVNWCDb.WCDbBaseInfo getBaseInfo(File localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo dir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = dir.wcDbDir;
        File localRelPath = dir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return this.getBaseInfo(dir.wcDbDir.getWCRoot(), localRelPath, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNWCDb.WCDbBaseInfo getBaseInfo(SVNWCDbRoot root, File localRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField ... fields) throws SVNException {
        ISVNWCDb.WCDbBaseInfo info;
        block32: {
            EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbBaseInfo.BaseInfoField.class, (Enum[])fields);
            info = new ISVNWCDb.WCDbBaseInfo();
            SVNSqlJetStatement stmt = root.getSDb().getStatement(f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock) ? SVNWCDbStatements.SELECT_BASE_NODE_WITH_LOCK : SVNWCDbStatements.SELECT_BASE_NODE);
            try {
                stmt.bindf("is", root.getWcId(), SVNFileUtil.getFilePath(localRelPath));
                boolean have_row = stmt.next();
                if (have_row) {
                    ISVNWCDb.SVNWCDbKind node_kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind)) {
                        info.kind = node_kind;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.status)) {
                        info.status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision)) {
                        info.revision = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath)) {
                        info.reposRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock)) {
                        SVNSqlJetStatement lockStmt = stmt.getJoinedStatement(SVNWCDbSchema.LOCK);
                        if (SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token)) {
                            info.lock = null;
                        } else {
                            info.lock = new ISVNWCDb.SVNWCDbLock();
                            info.lock.token = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token);
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner)) {
                                info.lock.owner = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment)) {
                                info.lock.comment = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date)) {
                                info.lock.date = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date));
                            }
                        }
                    }
                    info.reposId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id);
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid)) {
                        if (SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id)) {
                            if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl)) {
                                info.reposRootUrl = null;
                            }
                            if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid)) {
                                info.reposUuid = null;
                            }
                        } else {
                            ReposInfo reposInfo = this.fetchReposInfo(root.getSDb(), SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                            info.reposRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
                            info.reposUuid = reposInfo.reposUuid;
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev)) {
                        info.changedRev = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.changed_revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate)) {
                        info.changedDate = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_date));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor)) {
                        info.changedAuthor = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.lastModTime)) {
                        info.lastModTime = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.last_mod_time));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth)) {
                        String depth_str;
                        info.depth = node_kind != ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.UNKNOWN : ((depth_str = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth)) == null ? SVNDepth.UNKNOWN : SvnWcDbStatementUtil.parseDepth(depth_str));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.File) {
                            info.checksum = null;
                        } else {
                            try {
                                info.checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)root.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.translatedSize)) {
                        info.translatedSize = SvnWcDbStatementUtil.getTranslatedSize(stmt, SVNWCDbSchema.NODES__Fields.translated_size);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.target)) {
                        info.target = node_kind != ISVNWCDb.SVNWCDbKind.Symlink ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.symlink_target));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot)) {
                        info.updateRoot = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.file_external);
                    }
                    break block32;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            finally {
                stmt.reset();
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties getBaseProps(File localAbsPath) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(localAbsPath, SVNWCDbStatements.SELECT_BASE_PROPS);
        try {
            SVNProperties props;
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}''  was not found.", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((props = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties)) == null) {
                SVNProperties sVNProperties = new SVNProperties();
                return sVNProperties;
            }
            SVNProperties sVNProperties = props;
            return sVNProperties;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public int getFormatTemp(File localDirAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localDirAbsPath));
        SVNWCDbDir pdh = this.getOrCreateDir(localDirAbsPath, false);
        if (pdh == null || pdh.getWCRoot() == null) {
            try {
                DirParsedInfo parsed = this.parseDir(localDirAbsPath, SVNSqlJetDb.Mode.ReadOnly);
                pdh = parsed.wcDbDir;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_WORKING_COPY) {
                    throw e;
                }
                if (pdh != null) {
                    pdh.setWCRoot(null);
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Path ''{0}'' is not a working copy", (Object)localDirAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            assert (pdh.getWCRoot() != null);
        }
        assert (pdh.getWCRoot().getFormat() >= 1);
        return pdh.getWCRoot().getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SvnChecksum getPristineMD5(File wcRootAbsPath, SvnChecksum sha1Checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (sha1Checksum != null);
        assert (sha1Checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_MD5_CHECKSUM);
        try {
            stmt.bindChecksum(1, sha1Checksum);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with checksum ''{0}'' not found", (Object)sha1Checksum.toString());
                SVNErrorManager.error(err, SVNLogType.WC);
                SvnChecksum svnChecksum = null;
                return svnChecksum;
            }
            SvnChecksum md5Checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.PRISTINE__Fields.md5_checksum);
            assert (md5Checksum.getKind() == SvnChecksum.Kind.md5);
            SvnChecksum svnChecksum = md5Checksum;
            return svnChecksum;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public File getPristinePath(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.getPristinePath(pdh.getWCRoot(), checksum);
    }

    @Override
    public SvnChecksum getPristineSHA1(File wcRootAbsPath, SvnChecksum md5Checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (md5Checksum.getKind() == SvnChecksum.Kind.md5);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.getPristineSHA1(pdh.getWCRoot(), md5Checksum);
    }

    @Override
    public File getPristineTempDir(File wcRootAbsPath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(wcRootAbsPath));
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.getPristineTempDir(pdh.getWCRoot(), wcRootAbsPath);
    }

    @Override
    public void globalRecordFileinfo(File localAbspath, long translatedSize, SVNDate lastModTime) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        RecordFileinfo rb = new RecordFileinfo();
        rb.wcRoot = pdh.getWCRoot();
        rb.localRelpath = parsed.localRelPath;
        rb.translatedSize = translatedSize;
        rb.lastModTime = lastModTime;
        pdh.getWCRoot().getSDb().runTransaction(rb);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void installPristine(File tempfileAbspath, SvnChecksum sha1Checksum, SvnChecksum md5Checksum) throws SVNException {
        assert (SVNFileUtil.isAbsolute(tempfileAbspath));
        File wriAbspath = SVNFileUtil.getParentFile(tempfileAbspath);
        DirParsedInfo parsed = this.parseDir(wriAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbPristines.installPristine(pdh.getWCRoot(), tempfileAbspath, sha1Checksum, md5Checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeHidden(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsedInfo = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsedInfo.wcDbDir;
        File localRelPath = parsedInfo.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), SVNFileUtil.getFilePath(localRelPath));
            boolean have_row = stmt.next();
            if (have_row) {
                ISVNWCDb.SVNWCDbStatus work_status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                boolean bl = work_status == ISVNWCDb.SVNWCDbStatus.Excluded;
                return bl;
            }
        }
        finally {
            stmt.reset();
        }
        ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status);
        ISVNWCDb.SVNWCDbStatus base_status = baseInfo.status;
        return base_status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || base_status == ISVNWCDb.SVNWCDbStatus.NotPresent || base_status == ISVNWCDb.SVNWCDbStatus.Excluded;
    }

    public DirParsedInfo parseDir(File localAbsPath, SVNSqlJetDb.Mode sMode) throws SVNException {
        return this.parseDir(localAbsPath, sMode, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirParsedInfo parseDir(File localAbspath, SVNSqlJetDb.Mode sMode, boolean isDetectWCGeneration, boolean isAdditionMode) throws SVNException {
        SVNErrorMessage err;
        File localDirAbspath;
        String buildRelPath;
        SVNNodeKind kind;
        DirParsedInfo info = new DirParsedInfo();
        File originalAbspath = localAbspath;
        SVNWCDbDir foundRoot = null;
        boolean movedUpwards = false;
        boolean alwaysCheck = false;
        sMode = SVNSqlJetDb.Mode.ReadWrite;
        SVNSqlJetDb sDb = null;
        int wc_format = 0;
        boolean isOldFormat = false;
        SVNWCDbDir probeRoot = this.dirData.get(localAbspath.getAbsolutePath());
        SVNFileType fileType = null;
        if (probeRoot != null) {
            fileType = SVNFileType.getType(localAbspath);
            if (!isAdditionMode || fileType != SVNFileType.SYMLINK) {
                info.wcDbDir = probeRoot;
                info.localRelPath = probeRoot.computeRelPath();
                return info;
            }
        }
        if (fileType == null) {
            fileType = SVNFileType.getType(localAbspath);
        }
        boolean isSymlink = fileType == SVNFileType.SYMLINK;
        SVNNodeKind sVNNodeKind = kind = fileType == SVNFileType.DIRECTORY || isSymlink && localAbspath.isDirectory() ? SVNNodeKind.DIR : SVNFileType.getNodeKind(fileType);
        if (kind != SVNNodeKind.DIR || isSymlink) {
            buildRelPath = SVNFileUtil.getFileName(localAbspath);
            localDirAbspath = SVNFileUtil.getParentFile(localAbspath);
            if (localDirAbspath == null) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy", (Object)originalAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((probeRoot = this.dirData.get(localDirAbspath.getAbsolutePath())) != null) {
                if (!isSymlink || isAdditionMode) {
                    info.wcDbDir = probeRoot;
                    info.localRelPath = SVNFileUtil.createFilePath(info.wcDbDir.computeRelPath(), buildRelPath);
                    return info;
                }
                foundRoot = probeRoot;
            }
            if (kind == SVNNodeKind.NONE) {
                alwaysCheck = true;
            }
            localAbspath = localDirAbspath;
        } else {
            buildRelPath = "";
            localDirAbspath = localAbspath;
        }
        while (true) {
            SVNNodeKind resolvedKind;
            if (foundRoot == null) {
                while (true) {
                    try {
                        sDb = SVNWCDb.openDb(localAbspath, "wc.db", sMode);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() != SVNErrorCode.SQLITE_ERROR && !e.isEnoent()) {
                            throw e;
                        }
                        if ((!movedUpwards || alwaysCheck || isDetectWCGeneration) && (wc_format = this.getOldVersion(localAbspath)) != 0) break;
                        if (SVNFileUtil.getParentFile(localAbspath) == null) {
                            SVNNodeKind resolvedKind2;
                            if (isSymlink && !isAdditionMode && (resolvedKind2 = SVNFileType.getNodeKind(SVNFileType.getType(SVNFileUtil.resolveSymlink(localAbspath = originalAbspath)))) == SVNNodeKind.DIR) {
                                foundRoot = this.dirData.get(localAbspath.getAbsolutePath());
                                if (foundRoot != null) break;
                                kind = SVNNodeKind.DIR;
                                isSymlink = false;
                                movedUpwards = false;
                                localDirAbspath = localAbspath;
                                buildRelPath = "";
                                continue;
                            }
                            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy", (Object)originalAbspath);
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                        localAbspath = SVNFileUtil.getParentFile(localAbspath);
                        movedUpwards = true;
                        foundRoot = this.dirData.get(localAbspath.getAbsolutePath());
                        if (foundRoot != null) break;
                        continue;
                    }
                    break;
                }
            }
            if (foundRoot != null) {
                info.wcDbDir = foundRoot;
            } else if (wc_format == 0) {
                long wcId;
                block38: {
                    wcId = -1L;
                    try {
                        wcId = this.fetchWCId(sDb);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_CORRUPT) break block38;
                        SVNErrorMessage err2 = e.getErrorMessage().wrap("Missing a row in WCROOT for ''{0}''.", originalAbspath);
                        SVNErrorManager.error(err2, SVNLogType.WC);
                    }
                }
                info.wcDbDir = new SVNWCDbDir(localAbspath);
                info.wcDbDir.setWCRoot(new SVNWCDbRoot(this, localAbspath, sDb, wcId, -1, this.autoUpgrade, this.enforceEmptyWQ));
            } else {
                info.wcDbDir = new SVNWCDbDir(localAbspath);
                info.wcDbDir.setWCRoot(new SVNWCDbRoot(this, localAbspath, null, -1L, wc_format, this.autoUpgrade, this.enforceEmptyWQ));
                isOldFormat = true;
            }
            String dirRelPath = SVNPathUtil.getRelativePath(info.wcDbDir.getWCRoot().getAbsPath().getAbsolutePath(), localDirAbspath.getAbsolutePath());
            info.localRelPath = SVNFileUtil.createFilePath(dirRelPath, buildRelPath);
            if (!isSymlink || isAdditionMode) break;
            boolean retryIfDir = false;
            if (isOldFormat) {
                SVNAdminArea area = null;
                try {
                    area = SVNWCAccess.newInstance(null).open(localDirAbspath, false, false, 0);
                    retryIfDir = area.getEntry(SVNFileUtil.getFileName(originalAbspath), false) == null;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_UPGRADE_REQUIRED && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_WORKING_COPY) {
                        throw e;
                    }
                    retryIfDir = true;
                }
                finally {
                    if (area != null) {
                        area.close();
                    }
                }
            } else {
                try {
                    ISVNWCDb.WCDbInfo wcDbInfo = this.readInfo(info.wcDbDir.getWCRoot(), info.localRelPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.conflicted);
                    ISVNWCDb.SVNWCDbStatus status = wcDbInfo.status;
                    boolean conflicted = wcDbInfo.conflicted;
                    retryIfDir = (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded) && !conflicted;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_UPGRADE_REQUIRED && e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_WORKING_COPY) {
                        throw e;
                    }
                    retryIfDir = true;
                }
            }
            if (!retryIfDir || (resolvedKind = SVNFileType.getNodeKind(SVNFileType.getType(SVNFileUtil.resolveSymlink(localAbspath)))) != SVNNodeKind.DIR) break;
            localAbspath = originalAbspath;
            kind = SVNNodeKind.DIR;
            isSymlink = false;
            movedUpwards = false;
            localDirAbspath = localAbspath;
            buildRelPath = "";
            foundRoot = null;
            wc_format = 0;
        }
        if (!isAdditionMode || !isSymlink) {
            File parentDir;
            SVNWCDbDir wcDbDir = new SVNWCDbDir(localDirAbspath);
            wcDbDir.setWCRoot(info.wcDbDir.getWCRoot());
            this.dirData.put(wcDbDir.getLocalAbsPath().getAbsolutePath(), wcDbDir);
            if (!movedUpwards) {
                return info;
            }
            File scanAbspath = localDirAbspath;
            do {
                SVNWCDbDir parentRoot;
                if ((parentRoot = this.dirData.get((parentDir = SVNFileUtil.getParentFile(scanAbspath)).getAbsolutePath())) != null) continue;
                SVNWCDbDir parentWcDbDir = new SVNWCDbDir(parentDir);
                parentWcDbDir.setWCRoot(info.wcDbDir.getWCRoot());
                this.dirData.put(parentWcDbDir.getLocalAbsPath().getAbsolutePath(), parentWcDbDir);
            } while (!localAbspath.equals(scanAbspath = parentDir));
        }
        return info;
    }

    private int getOldVersion(File localAbsPath) {
        if (localAbsPath == null) {
            return 0;
        }
        try {
            int formatVersion = 0;
            File adminDir = new File(localAbsPath, SVNFileUtil.getAdminDirectoryName());
            File entriesFile = new File(adminDir, "entries");
            if (entriesFile.exists()) {
                formatVersion = this.readFormatVersion(entriesFile);
            } else {
                File formatFile = new File(adminDir, "format");
                if (formatFile.exists()) {
                    formatVersion = this.readFormatVersion(formatFile);
                }
            }
            return formatVersion;
        }
        catch (SVNException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int readFormatVersion(File path) throws SVNException {
        SVNErrorMessage err;
        int formatVersion = -1;
        BufferedReader reader = null;
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(path, Level.FINEST, SVNLogType.WC), "UTF-8"));
            line = reader.readLine();
        }
        catch (IOException e) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", path, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
            SVNFileUtil.closeFile(reader);
        }
        catch (SVNException svne) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err.setChildErrorMessage(svne.getErrorMessage());
            SVNErrorManager.error(err, svne, Level.FINEST, SVNLogType.WC);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(reader);
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(reader);
        }
        SVNFileUtil.closeFile(reader);
        if (line == null || line.length() == 0) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)path);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err1.setChildErrorMessage(err2);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        try {
            formatVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException e) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)path);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err1.setChildErrorMessage(err);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        return formatVersion;
    }

    @Override
    public boolean isWCLocked(File localAbspath) throws SVNException {
        return this.isWCLocked(localAbspath, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWCLocked(File localAbspath, long recurseDepth) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(localAbspath, SVNWCDbStatements.SELECT_WC_LOCK);
        try {
            boolean have_row = stmt.next();
            if (have_row) {
                long locked_levels = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.WC_LOCK__Fields.locked_levels);
                boolean bl = locked_levels == -1L || locked_levels >= recurseDepth;
                return bl;
            }
        }
        finally {
            stmt.reset();
        }
        File parentFile = SVNFileUtil.getParentFile(localAbspath);
        if (parentFile == null) {
            return false;
        }
        try {
            return this.isWCLocked(parentFile, recurseDepth + 1L);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWCLocked(SVNWCDbRoot root, File localRelpath, long recurseDepth) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_ANCESTORS_WC_LOCKS);
        int pathDepth = SVNWCUtils.relpathDepth(localRelpath);
        stmt.bindf("is", root.getWcId(), localRelpath);
        try {
            while (stmt.next()) {
                File lockedPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.WC_LOCK__Fields.local_dir_relpath);
                if (!SVNWCUtils.isAncestor(lockedPath, localRelpath)) continue;
                long locked_levels = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.WC_LOCK__Fields.locked_levels);
                int lockedPathDepth = SVNWCUtils.relpathDepth(lockedPath);
                boolean bl = locked_levels == -1L || locked_levels + (long)lockedPathDepth >= (long)pathDepth;
                return bl;
            }
        }
        finally {
            stmt.reset();
        }
        return false;
    }

    @Override
    public void opAddDirectory(File localAbsPath, SVNSkel workItems) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertWorking ibw = new InsertWorking();
        ibw.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibw.kind = ISVNWCDb.SVNWCDbKind.Dir;
        ibw.opDepth = SVNWCUtils.relpathDepth(localRelpath);
        ibw.workItems = workItems;
        ibw.localRelpath = localRelpath;
        ibw.wcId = pdh.getWCRoot().getWcId();
        pdh.getWCRoot().getSDb().runTransaction(ibw);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void opAddFile(File localAbsPath, SVNSkel workItems) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite, false, true);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        InsertWorking ibw = new InsertWorking();
        ibw.status = ISVNWCDb.SVNWCDbStatus.Normal;
        ibw.kind = ISVNWCDb.SVNWCDbKind.File;
        ibw.opDepth = SVNWCUtils.relpathDepth(localRelpath);
        ibw.workItems = workItems;
        ibw.localRelpath = localRelpath;
        ibw.wcId = pdh.getWCRoot().getWcId();
        pdh.getWCRoot().getSDb().runTransaction(ibw);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void opCopy(File srcAbsPath, File dstAbsPath, SVNSkel workItems) throws SVNException {
        DirParsedInfo parseSrcDir = this.parseDir(srcAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir srcPdh = parseSrcDir.wcDbDir;
        File localSrcRelpath = parseSrcDir.localRelPath;
        SVNWCDb.verifyDirUsable(srcPdh);
        DirParsedInfo parseDstDir = this.parseDir(dstAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir dstPdh = parseDstDir.wcDbDir;
        File localDstRelpath = parseDstDir.localRelPath;
        SVNWCDb.verifyDirUsable(dstPdh);
        SvnWcDbCopy.copy(srcPdh, localSrcRelpath, dstPdh, localDstRelpath, workItems);
    }

    @Override
    public void opCopyShadowedLayer(File srcAbsPath, File dstAbsPath) throws SVNException {
        DirParsedInfo parseSrcDir = this.parseDir(srcAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir srcPdh = parseSrcDir.wcDbDir;
        File localSrcRelpath = parseSrcDir.localRelPath;
        SVNWCDb.verifyDirUsable(srcPdh);
        DirParsedInfo parseDstDir = this.parseDir(dstAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir dstPdh = parseDstDir.wcDbDir;
        File localDstRelpath = parseDstDir.localRelPath;
        SVNWCDb.verifyDirUsable(dstPdh);
        SvnWcDbCopy.copyShadowedLayer(srcPdh, localSrcRelpath, dstPdh, localDstRelpath);
    }

    @Override
    public void opCopyDir(File localAbsPath, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File originalReposRelPath, SVNURL originalRootUrl, String originalUuid, long originalRevision, List<File> children, SVNDepth depth, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbCopy.copyDir(pdh, localRelpath, props, changedRev, changedDate, changedAuthor, originalReposRelPath, originalRootUrl, originalUuid, originalRevision, children, depth, conflict, workItems);
    }

    @Override
    public void opCopyFile(File localAbsPath, SVNProperties props, long changedRev, SVNDate changedDate, String changedAuthor, File originalReposRelPath, SVNURL originalRootUrl, String originalUuid, long originalRevision, SvnChecksum checksum, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbCopy.copyFile(pdh, localRelpath, props, changedRev, changedDate, changedAuthor, originalReposRelPath, originalRootUrl, originalUuid, originalRevision, checksum, conflict, workItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opDelete(File localAbsPath, ISVNEventHandler notifyHandler) throws SVNException {
        block14: {
            DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
            SVNWCDbDir pdh = parsed.wcDbDir;
            File localRelpath = parsed.localRelPath;
            SVNWCDb.verifyDirUsable(pdh);
            Delete deleteTxn = new Delete();
            deleteTxn.root = pdh.getWCRoot();
            deleteTxn.localRelPath = localRelpath;
            deleteTxn.deleteDepth = SVNWCUtils.relpathDepth(localRelpath);
            deleteTxn.eventHandler = notifyHandler;
            pdh.flushEntries(localAbsPath);
            pdh.getWCRoot().getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                try {
                    deleteTxn.transaction(pdh.getWCRoot().getSDb());
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
                if (notifyHandler == null || !pdh.getWCRoot().getSDb().getTemporaryDb().hasTable(SVNWCDbSchema.DELETE_LIST.toString())) break block14;
                SVNSqlJetSelectStatement selectDeleteList = new SVNSqlJetSelectStatement(pdh.getWCRoot().getSDb().getTemporaryDb(), SVNWCDbSchema.DELETE_LIST);
                try {
                    while (((SVNSqlJetStatement)selectDeleteList).next()) {
                        File path = SvnWcDbStatementUtil.getColumnPath(selectDeleteList, SVNWCDbSchema.DELETE_LIST__Fields.local_relpath);
                        path = pdh.getWCRoot().getAbsPath(path);
                        notifyHandler.handleEvent(SVNEventFactory.createSVNEvent(path, SVNNodeKind.NONE, null, -1L, SVNEventAction.DELETE, SVNEventAction.DELETE, null, null, 1L, 1L), -1.0);
                    }
                }
                finally {
                    ((SVNSqlJetStatement)selectDeleteList).reset();
                }
                SVNWCDbCreateSchema dropList = new SVNWCDbCreateSchema(pdh.getWCRoot().getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DROP_DELETE_LIST, -1);
                try {
                    dropList.done();
                }
                finally {
                    dropList.reset();
                }
            }
            catch (SVNException e) {
                pdh.getWCRoot().getSDb().rollback();
                throw e;
            }
            finally {
                pdh.getWCRoot().getSDb().commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opMarkResolved(File localAbspath, boolean resolvedText, boolean resolvedProps, boolean resolvedTree) throws SVNException {
        SVNSqlJetStatement stmt;
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (!resolvedTree);
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        if (resolvedText) {
            stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.CLEAR_TEXT_CONFLICT);
            try {
                stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        if (resolvedProps) {
            stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.CLEAR_PROPS_CONFLICT);
            try {
                stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        pdh.flushEntries(localAbspath);
    }

    @Override
    public Map<String, SVNTreeConflictDescription> opReadAllTreeConflicts(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return this.readAllTreeConflicts(pdh, localRelpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SVNTreeConflictDescription> readAllTreeConflicts(SVNWCDbDir pdh, File localRelpath) throws SVNException {
        HashMap<String, SVNTreeConflictDescription> treeConflicts = new HashMap<String, SVNTreeConflictDescription>();
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_TREE_CONFLICT);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            while (haveRow) {
                File childRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath));
                String childBaseName = SVNFileUtil.getFileName(childRelpath);
                byte[] conflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                SVNSkel skel = SVNSkel.parse(conflictData);
                SVNTreeConflictDescription treeConflict = SVNTreeConflictUtil.readSingleTreeConflict(skel, pdh.getWCRoot().getAbsPath());
                treeConflicts.put(childBaseName, treeConflict);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return treeConflicts;
    }

    @Override
    public SVNTreeConflictDescription opReadTreeConflict(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return this.readTreeConflict(pdh, localRelpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNTreeConflictDescription readTreeConflict(SVNWCDbDir pdh, File localRelpath) throws SVNException {
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_TREE_CONFLICT);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                SVNTreeConflictDescription sVNTreeConflictDescription = null;
                return sVNTreeConflictDescription;
            }
            byte[] conflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
            SVNSkel skel = SVNSkel.parse(conflictData);
            SVNTreeConflictDescription sVNTreeConflictDescription = SVNTreeConflictUtil.readSingleTreeConflict(skel, pdh.getWCRoot().getAbsPath());
            return sVNTreeConflictDescription;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRevert(File localAbspath, SVNDepth depth) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetDb sdb = pdh.getWCRoot().getSDb();
        sdb.beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            SVNWCDbCreateSchema stmt = new SVNWCDbCreateSchema(sdb.getTemporaryDb(), SVNWCDbCreateSchema.REVERT_LIST, -1);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (depth == SVNDepth.INFINITY) {
                SvnWcDbRevert.revertRecursive(pdh.getWCRoot(), parsed.localRelPath);
            } else if (depth == SVNDepth.EMPTY) {
                SvnWcDbRevert.revert(pdh.getWCRoot(), parsed.localRelPath);
            }
        }
        catch (SVNException e) {
            sdb.rollback();
            throw e;
        }
        finally {
            sdb.commit();
        }
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void opSetChangelist(File localAbspath, String changelistName, String[] changeLists, SVNDepth depth, ISVNEventHandler eventHandler) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.flushEntries(localAbspath);
        SvnWcDbChangelist.setChangelist(pdh.getWCRoot(), parsed.localRelPath, changelistName, changeLists, depth, eventHandler);
    }

    @Override
    public void opSetProps(File localAbsPath, SVNProperties props, SVNSkel conflict, boolean clearRecordedInfo, SVNSkel workItems) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SetProperties spb = new SetProperties();
        spb.props = props;
        spb.pdh = pdh;
        spb.conflict = conflict;
        spb.workItems = workItems;
        spb.localRelpath = parsed.localRelPath;
        spb.clearRecordedInfo = clearRecordedInfo;
        pdh.getWCRoot().getSDb().runTransaction(spb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActualProperties(SVNSqlJetDb db, long wcId, File localRelpath, SVNProperties props) throws SVNException {
        long affectedRows;
        SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_PROPS);
        try {
            stmt.bindf("is", wcId, localRelpath);
            stmt.bindProperties(3, props);
            affectedRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        if (affectedRows == 1L || props == null) {
            return;
        }
        stmt = db.getStatement(SVNWCDbStatements.INSERT_ACTUAL_PROPS);
        try {
            stmt.bindf("is", wcId, localRelpath);
            if (localRelpath != null && !"".equals(SVNFileUtil.getFilePath(localRelpath))) {
                stmt.bindString(3, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelpath)));
            } else {
                stmt.bindNull(3);
            }
            stmt.bindProperties(4, props);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void opSetTreeConflict(File localAbspath, SVNTreeConflictDescription treeConflict) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        SetTreeConflict stb = new SetTreeConflict();
        stb.treeConflict = treeConflict;
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        stb.localRelpath = parseDir.localRelPath;
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        stb.wcId = pdh.getWCRoot().getWcId();
        stb.parentRelpath = SVNFileUtil.getFileDir(stb.localRelpath);
        pdh.getWCRoot().getSDb().runTransaction(stb);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public Set<String> readChildren(File localAbsPath) throws SVNException {
        return this.gatherChildren(localAbsPath, false, false);
    }

    @Override
    public Set<String> getChildrenOfWorkingNode(File localAbsPath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        long wcId = wcInfo.wcDbDir.getWCRoot().getWcId();
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        TreeSet<String> names = new TreeSet<String>();
        SVNSqlJetStatement work_stmt = sDb.getStatement(SVNWCDbStatements.SELECT_WORKING_CHILDREN);
        work_stmt.bindf("is", wcId, SVNFileUtil.getFilePath(localRelPath));
        this.addChildren(names, work_stmt);
        return names;
    }

    @Override
    public void readChildren(File localAbsPath, Map<String, ISVNWCDb.SVNWCDbInfo> children, Set<String> conflicts) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        this.readChildren(pdh.getWCRoot(), localRelPath, children, conflicts);
    }

    public void readChildren(SVNWCDbRoot root, File localRelPath, Map<String, ISVNWCDb.SVNWCDbInfo> children, Set<String> conflicts) throws SVNException {
        GatherChildren gather = new GatherChildren();
        gather.dirRelPath = localRelPath;
        gather.wcRoot = root;
        gather.nodes = children;
        gather.conflicts = conflicts;
        root.getSDb().runTransaction(gather, SqlJetTransactionMode.READ_ONLY);
    }

    private Set<String> gatherChildren(File localAbsPath, boolean baseOnly, boolean workOnly) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        long wcId = wcInfo.wcDbDir.getWCRoot().getWcId();
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        TreeSet<String> names = new TreeSet<String>();
        if (!workOnly) {
            SVNSqlJetStatement base_stmt = sDb.getStatement(SVNWCDbStatements.SELECT_BASE_NODE_CHILDREN);
            base_stmt.bindf("is", wcId, localRelPath);
            this.addChildren(names, base_stmt);
        }
        if (!baseOnly) {
            SVNSqlJetStatement work_stmt = sDb.getStatement(SVNWCDbStatements.SELECT_WORKING_NODE_CHILDREN);
            work_stmt.bindf("is", wcId, localRelPath);
            this.addChildren(names, work_stmt);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ISVNWCDb.WCDbBaseInfo> getBaseChildrenMap(SVNWCDbRoot wcRoot, File localRelPath, boolean fetchLocks) throws SVNException {
        long wcId = wcRoot.getWcId();
        SVNSqlJetDb sDb = wcRoot.getSDb();
        TreeMap<String, ISVNWCDb.WCDbBaseInfo> children = new TreeMap<String, ISVNWCDb.WCDbBaseInfo>();
        SVNSqlJetSelectStatement baseStmt = (SVNSqlJetSelectStatement)sDb.getStatement(SVNWCDbStatements.SELECT_BASE_NODE_CHILDREN);
        baseStmt.bindf("is", wcId, localRelPath);
        Map<String, Object> row = null;
        try {
            while (baseStmt.next()) {
                ISVNWCDb.WCDbBaseInfo child = new ISVNWCDb.WCDbBaseInfo();
                child.updateRoot = (row = baseStmt.getRowValues2(row)).get(SVNWCDbSchema.NODES__Fields.file_external.toString()) != null;
                child.status = SvnWcDbStatementUtil.parsePresence((String)row.get(SVNWCDbSchema.NODES__Fields.presence.toString()));
                child.revision = (Long)row.get(SVNWCDbSchema.NODES__Fields.revision.toString());
                String path = (String)row.get(SVNWCDbSchema.NODES__Fields.repos_path.toString());
                child.reposRelPath = path != null ? new File(path) : null;
                child.depth = SvnWcDbStatementUtil.parseDepth((String)row.get(SVNWCDbSchema.NODES__Fields.depth.toString()));
                child.kind = SvnWcDbStatementUtil.parseKind((String)row.get(SVNWCDbSchema.NODES__Fields.kind.toString()));
                if (fetchLocks) {
                    SVNSqlJetStatement lockStmt = fetchLocks ? sDb.getStatement(SVNWCDbStatements.SELECT_LOCK) : null;
                    try {
                        child.lock = null;
                        lockStmt.bindf("is", row.get(SVNWCDbSchema.NODES__Fields.repos_id.toString()), row.get(SVNWCDbSchema.NODES__Fields.repos_path.toString()));
                        if (lockStmt.next()) {
                            child.lock = SvnWcDbStatementUtil.getLockFromColumns(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token, SVNWCDbSchema.LOCK__Fields.lock_owner, SVNWCDbSchema.LOCK__Fields.lock_comment, SVNWCDbSchema.LOCK__Fields.lock_date);
                        }
                    }
                    finally {
                        lockStmt.reset();
                    }
                }
                String child_relpath = (String)row.get(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
                children.put(SVNPathUtil.tail(child_relpath), child);
            }
        }
        finally {
            baseStmt.reset();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildren(Set<String> children, SVNSqlJetStatement stmt) throws SVNException {
        try {
            while (stmt.next()) {
                String child_relpath = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                String name = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(child_relpath));
                children.add(name);
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> readConflictVictims(File localAbsPath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        long wcId = wcInfo.wcDbDir.getWCRoot().getWcId();
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        ArrayList<String> victims = new ArrayList<String>();
        HashSet<String> found = new HashSet<String>();
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CONFLICT_VICTIMS);
        try {
            stmt.bindf("is", wcId, SVNFileUtil.getFilePath(localRelPath));
            while (stmt.next()) {
                String child_relpath = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath);
                String child_name = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(child_relpath));
                found.add(child_name);
            }
        }
        finally {
            stmt.reset();
        }
        victims.addAll(found);
        return victims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SVNConflictDescription> readConflicts(File localAbsPath) throws SVNException {
        ArrayList<SVNConflictDescription> conflicts = new ArrayList<SVNConflictDescription>();
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelPath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_CONFLICT_DETAILS);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelPath);
            boolean have_row = stmt.next();
            if (have_row) {
                byte[] conflict_data;
                String prop_reject = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject);
                if (prop_reject != null) {
                    File reposFile = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), prop_reject);
                    SVNMergeFileSet mergeFiles = new SVNMergeFileSet(null, null, null, localAbsPath, null, reposFile, null, null, null);
                    SVNPropertyConflictDescription desc = new SVNPropertyConflictDescription(mergeFiles, SVNNodeKind.UNKNOWN, "", null, null);
                    conflicts.add(desc);
                }
                String conflict_old = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old);
                String conflict_new = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new);
                String conflict_working = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working);
                if (conflict_old != null || conflict_new != null || conflict_working != null) {
                    File baseFile = conflict_old != null ? SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), conflict_old) : null;
                    File theirFile = conflict_new != null ? SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), conflict_new) : null;
                    File myFile = conflict_working != null ? SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), conflict_working) : null;
                    File mergedFile = new File(SVNFileUtil.getFileName(localAbsPath));
                    SVNMergeFileSet mergeFiles = new SVNMergeFileSet(null, null, baseFile, myFile, null, theirFile, mergedFile, null, null);
                    SVNTextConflictDescription desc = new SVNTextConflictDescription(mergeFiles, SVNNodeKind.UNKNOWN, null, null);
                    conflicts.add(desc);
                }
                if ((conflict_data = SvnWcDbStatementUtil.getColumnBlob(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data)) != null) {
                    SVNSkel skel = SVNSkel.parse(conflict_data);
                    SVNTreeConflictDescription desc = SVNTreeConflictUtil.readSingleTreeConflict(skel, SVNFileUtil.getParentFile(localAbsPath));
                    conflicts.add(desc);
                }
            }
        }
        finally {
            stmt.reset();
        }
        return conflicts;
    }

    @Override
    public ISVNWCDb.WCDbInfo readInfo(File localAbsPath, ISVNWCDb.WCDbInfo.InfoField ... fields) throws SVNException {
        ReposInfo reposInfo;
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        ISVNWCDb.WCDbInfo info = this.readInfo(wcInfo.wcDbDir.getWCRoot(), localRelPath, fields);
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbInfo.InfoField.class, (Enum[])fields);
        if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposUuid)) {
            reposInfo = this.fetchReposInfo(sDb, info.reposId);
            if (reposInfo.reposRootUrl != null) {
                info.reposRootUrl = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposRootUrl) ? SVNURL.parseURIEncoded(reposInfo.reposRootUrl) : null;
            }
            String string = info.reposUuid = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposUuid) ? reposInfo.reposUuid : null;
        }
        if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalUuid)) {
            reposInfo = this.fetchReposInfo(sDb, info.originalReposId);
            if (reposInfo.reposRootUrl != null) {
                info.originalRootUrl = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRootUrl) ? SVNURL.parseURIEncoded(reposInfo.reposRootUrl) : null;
            }
            info.originalUuid = f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalUuid) ? reposInfo.reposUuid : null;
        }
        return info;
    }

    @Override
    public Structure<StructureFields.NodeInfo> readInfo(File localAbsPath, StructureFields.NodeInfo ... fields) throws SVNException {
        return this.readInfo(localAbsPath, false, fields);
    }

    @Override
    public Structure<StructureFields.NodeInfo> readInfo(File localAbsPath, boolean isAdditionMode, StructureFields.NodeInfo ... fields) throws SVNException {
        Structure<StructureFields.RepositoryInfo> reposInfo;
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath, isAdditionMode);
        File localRelPath = wcInfo.localRelPath;
        SVNSqlJetDb sDb = wcInfo.wcDbDir.getWCRoot().getSDb();
        Structure<StructureFields.NodeInfo> info = SvnWcDbShared.readInfo(wcInfo.wcDbDir.getWCRoot(), localRelPath, fields);
        if (info.hasField(StructureFields.NodeInfo.reposRootUrl) || info.hasField(StructureFields.NodeInfo.reposUuid)) {
            reposInfo = this.fetchRepositoryInfo(sDb, info.lng(StructureFields.NodeInfo.reposId));
            reposInfo.from(new StructureFields.RepositoryInfo[]{StructureFields.RepositoryInfo.reposRootUrl, StructureFields.RepositoryInfo.reposUuid}).into(info, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid});
            reposInfo.release();
        }
        if (info.hasField(StructureFields.NodeInfo.originalRootUrl) || info.hasField(StructureFields.NodeInfo.originalUuid)) {
            reposInfo = this.fetchRepositoryInfo(sDb, info.lng(StructureFields.NodeInfo.originalReposId));
            reposInfo.from(new StructureFields.RepositoryInfo[]{StructureFields.RepositoryInfo.reposRootUrl, StructureFields.RepositoryInfo.reposUuid}).into(info, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.originalRootUrl, StructureFields.NodeInfo.originalUuid});
            reposInfo.release();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readOpDepth(SVNWCDbRoot root, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = null;
        try {
            stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            stmt.bindf("is", root.getWcId(), localRelPath);
            if (stmt.next()) {
                long l = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                return l;
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.reset();
                }
            }
            catch (SVNException e) {}
        }
        return 0L;
    }

    @Override
    public ISVNWCDb.WCDbInfo readInfoBelowWorking(File localAbsPath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbsPath);
        File localRelPath = wcInfo.localRelPath;
        return this.readInfoBelowWorking(wcInfo.wcDbDir.getWCRoot(), localRelPath, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNWCDb.WCDbInfo readInfoBelowWorking(SVNWCDbRoot wcRoot, File localRelPath, int belowOpDepth) throws SVNException {
        ISVNWCDb.WCDbInfo info = new ISVNWCDb.WCDbInfo();
        SVNSqlJetStatement stmt = null;
        try {
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            stmt.bindf("is", wcRoot.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (belowOpDepth >= 0) {
                while (haveRow && SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth) > (long)belowOpDepth) {
                    haveRow = stmt.next();
                }
            }
            if (haveRow) {
                haveRow = stmt.next();
                if (haveRow) {
                    info.status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                }
                while (haveRow) {
                    if (SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth) > 0L) {
                        info.haveWork = true;
                    } else {
                        info.haveBase = true;
                    }
                    haveRow = stmt.next();
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.reset();
                }
            }
            catch (SVNException e) {}
        }
        if (info.haveWork) {
            info.status = SVNWCDb.getWorkingStatus(info.status);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNWCDb.WCDbInfo readInfo(SVNWCDbRoot wcRoot, File localRelPath, ISVNWCDb.WCDbInfo.InfoField ... fields) throws SVNException {
        ISVNWCDb.WCDbInfo info;
        block62: {
            info = new ISVNWCDb.WCDbInfo();
            EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbInfo.InfoField.class, (Enum[])fields);
            SVNSqlJetStatement stmtInfo = null;
            SVNSqlJetStatement stmtActual = null;
            try {
                stmtInfo = wcRoot.getSDb().getStatement(f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.lock) ? SVNWCDbStatements.SELECT_NODE_INFO_WITH_LOCK : SVNWCDbStatements.SELECT_NODE_INFO);
                stmtInfo.bindf("is", wcRoot.getWcId(), localRelPath);
                boolean haveInfo = stmtInfo.next();
                boolean haveActual = false;
                if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changelist) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.propsMod)) {
                    stmtActual = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
                    stmtActual.bindf("is", wcRoot.getWcId(), localRelPath);
                    haveActual = stmtActual.next();
                }
                if (haveInfo) {
                    SVNSqlJetStatement stmtBaseLock;
                    long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                    ISVNWCDb.SVNWCDbKind nodeKind = SvnWcDbStatementUtil.getColumnKind(stmtInfo, SVNWCDbSchema.NODES__Fields.kind);
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.status)) {
                        info.status = SvnWcDbStatementUtil.getColumnPresence(stmtInfo);
                        if (opDepth != 0L) {
                            info.status = SVNWCDb.getWorkingStatus(info.status);
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.kind)) {
                        info.kind = nodeKind;
                    }
                    long l = info.reposId = opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id);
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.revision)) {
                        long l2 = info.revision = opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.reposRelPath)) {
                        File file = info.reposRelPath = opDepth != 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedDate)) {
                        info.changedDate = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_date));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedRev)) {
                        info.changedRev = SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedAuthor)) {
                        info.changedAuthor = SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_author);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.lastModTime)) {
                        info.lastModTime = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.last_mod_time);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.depth)) {
                        info.depth = nodeKind != ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.UNKNOWN : SvnWcDbStatementUtil.getColumnDepth(stmtInfo, SVNWCDbSchema.NODES__Fields.depth);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.checksum)) {
                        if (nodeKind != ISVNWCDb.SVNWCDbKind.File) {
                            info.checksum = null;
                        } else {
                            try {
                                info.checksum = SvnWcDbStatementUtil.getColumnChecksum(stmtInfo, SVNWCDbSchema.NODES__Fields.checksum);
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)wcRoot.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.translatedSize)) {
                        info.translatedSize = SvnWcDbStatementUtil.getTranslatedSize(stmtInfo, SVNWCDbSchema.NODES__Fields.translated_size);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.target)) {
                        info.target = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.symlink_target));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changelist) && haveActual) {
                        info.changelist = SvnWcDbStatementUtil.getColumnText(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                    }
                    long l3 = info.originalReposId = opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id);
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRevision)) {
                        long l4 = info.originalRevision = opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalReposRelpath)) {
                        File file = info.originalReposRelpath = opDepth == 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.propsMod) && haveActual) {
                        boolean bl = info.propsMod = !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.hadProps)) {
                        byte[] props = SvnWcDbStatementUtil.getColumnBlob(stmtInfo, SVNWCDbSchema.NODES__Fields.properties);
                        boolean bl = info.hadProps = props != null && props.length > 2;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted) && haveActual) {
                        boolean bl = info.conflicted = !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.lock) && opDepth == 0L && !SvnWcDbStatementUtil.isColumnNull(stmtBaseLock = stmtInfo.getJoinedStatement(SVNWCDbSchema.LOCK.toString()), SVNWCDbSchema.LOCK__Fields.lock_token)) {
                        info.lock = new ISVNWCDb.SVNWCDbLock();
                        info.lock.token = SvnWcDbStatementUtil.getColumnText(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_token);
                        if (!SvnWcDbStatementUtil.isColumnNull(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_owner)) {
                            info.lock.owner = SvnWcDbStatementUtil.getColumnText(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_owner);
                        }
                        if (!SvnWcDbStatementUtil.isColumnNull(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_comment)) {
                            info.lock.comment = SvnWcDbStatementUtil.getColumnText(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_comment);
                        }
                        if (!SvnWcDbStatementUtil.isColumnNull(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_date)) {
                            info.lock.date = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_date));
                        }
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveWork)) {
                        boolean bl = info.haveWork = opDepth != 0L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.opRoot)) {
                        boolean bl = info.opRoot = opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveBase) || f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveWork)) {
                        while (opDepth != 0L && (haveInfo = stmtInfo.next())) {
                            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                            if (!f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveMoreWork)) continue;
                            if (opDepth > 0L) {
                                info.haveMoreWork = true;
                            }
                            if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveBase)) continue;
                        }
                        if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.haveBase)) {
                            info.haveBase = opDepth == 0L;
                        }
                    }
                    break block62;
                }
                if (haveActual) {
                    if (SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Corrupt data for ''{0}''", (Object)wcRoot.getAbsPath(localRelPath));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    assert (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted));
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.status)) {
                        info.status = ISVNWCDb.SVNWCDbStatus.Normal;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.kind)) {
                        info.kind = ISVNWCDb.SVNWCDbKind.Unknown;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.revision)) {
                        info.revision = -1L;
                    }
                    info.reposId = -1L;
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changedRev)) {
                        info.changedRev = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.depth)) {
                        info.depth = SVNDepth.UNKNOWN;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalReposId)) {
                        info.originalReposId = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRevision)) {
                        info.originalRevision = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.changelist)) {
                        info.changelist = stmtActual.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.originalRevision)) {
                        info.originalRevision = -1L;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbInfo.InfoField.conflicted)) {
                        info.conflicted = true;
                    }
                } else {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcRoot.getAbsPath(localRelPath));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            finally {
                try {
                    if (stmtInfo != null) {
                        stmtInfo.reset();
                    }
                }
                catch (SVNException e) {}
                try {
                    if (stmtActual != null) {
                        stmtActual.reset();
                    }
                }
                catch (SVNException e) {}
            }
        }
        return info;
    }

    public static ISVNWCDb.SVNWCDbStatus getWorkingStatus(ISVNWCDb.SVNWCDbStatus status) {
        if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            return status;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
            return ISVNWCDb.SVNWCDbStatus.Deleted;
        }
        return ISVNWCDb.SVNWCDbStatus.Added;
    }

    @Override
    public ISVNWCDb.SVNWCDbKind readKind(File localAbsPath, boolean allowMissing) throws SVNException {
        try {
            ISVNWCDb.WCDbInfo info = this.readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.kind);
            return info.kind;
        }
        catch (SVNException e) {
            if (allowMissing && e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return ISVNWCDb.SVNWCDbKind.Unknown;
            }
            throw e;
        }
    }

    @Override
    public InputStream readPristine(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parsed = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbPristines.readPristine(pdh.getWCRoot(), wcRootAbsPath, checksum);
    }

    @Override
    public SVNProperties readPristineProperties(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelPath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return SvnWcDbProperties.readPristineProperties(pdh.getWCRoot(), localRelPath);
    }

    public void readPropertiesRecursively(File localAbsPath, SVNDepth depth, boolean baseProperties, boolean pristineProperties, Collection<String> changelists, ISvnObjectReceiver<SVNProperties> receiver) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelPath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbProperties.readPropertiesRecursively(pdh.getWCRoot(), localRelPath, depth, baseProperties, pristineProperties, changelists, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNProperties readProperties(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelPath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        try {
            SvnWcDbShared.begingReadTransaction(pdh.getWCRoot());
            SVNProperties sVNProperties = SvnWcDbProperties.readProperties(pdh.getWCRoot(), localRelPath);
            return sVNProperties;
        }
        finally {
            SvnWcDbShared.commitTransaction(pdh.getWCRoot());
        }
    }

    private SVNSqlJetStatement getStatementForPath(File localAbsPath, SVNWCDbStatements statementIndex) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(parsed.wcDbDir);
        SVNWCDbRoot wcRoot = parsed.wcDbDir.getWCRoot();
        SVNSqlJetStatement statement = wcRoot.getSDb().getStatement(statementIndex);
        statement.bindf("is", wcRoot.getWcId(), SVNFileUtil.getFilePath(parsed.localRelPath));
        return statement;
    }

    @Override
    public void removeBase(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        BaseRemove brb = new BaseRemove();
        brb.localRelpath = localRelpath;
        brb.wcId = pdh.getWCRoot().getWcId();
        pdh.getWCRoot().getSDb().runTransaction(brb);
        pdh.flushEntries(localAbsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLock(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
        long reposId = SVNWCDb.scanUpwardsForRepos(reposInfo, pdh.getWCRoot(), localRelpath);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_LOCK);
        try {
            stmt.bindf("is", reposId, reposInfo.relPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public void removePristine(File wcRootAbsPath, SvnChecksum checksum) throws SVNException {
        assert (SVNWCDb.isAbsolute(wcRootAbsPath));
        assert (checksum != null);
        if (checksum.getKind() != SvnChecksum.Kind.sha1) {
            checksum = this.getPristineSHA1(wcRootAbsPath, checksum);
        }
        assert (checksum.getKind() == SvnChecksum.Kind.sha1);
        DirParsedInfo parseDir = this.parseDir(wcRootAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbPristines.removePristine(pdh.getWCRoot(), checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNWCDb.WCDbAdditionInfo scanAddition(File localAbsPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.class, (Enum[])fields);
        File buildRelpath = SVNFileUtil.createFilePath("");
        ISVNWCDb.WCDbAdditionInfo additionInfo = new ISVNWCDb.WCDbAdditionInfo();
        additionInfo.originalRevision = -1L;
        long originalReposId = -1L;
        File currentRelpath = localRelpath;
        File reposPrefixPath = SVNFileUtil.createFilePath("");
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
        try {
            ISVNWCDb.SVNWCDbStatus presence;
            SVNErrorMessage err;
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                stmt.reset();
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((presence = SvnWcDbStatementUtil.getColumnPresence(stmt)) != ISVNWCDb.SVNWCDbStatus.Normal) {
                stmt.reset();
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be added.", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision)) {
                additionInfo.originalRevision = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status)) {
                additionInfo.status = ISVNWCDb.SVNWCDbStatus.Added;
            }
            long opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            int i = SVNWCUtils.relpathDepth(localRelpath);
            while ((long)i > opDepth) {
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                --i;
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.opRootAbsPath)) {
                additionInfo.opRootAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), currentRelpath);
            }
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalUuid) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision) && additionInfo.originalRevision == -1L || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status)) {
                if (!localRelpath.equals(currentRelpath)) {
                    stmt.reset();
                    stmt.bindf("is", pdh.getWCRoot().getWcId(), currentRelpath);
                    haveRow = stmt.next();
                    if (!haveRow) {
                        stmt.reset();
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), currentRelpath));
                        SVNErrorManager.error(err2, SVNLogType.WC);
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRevision) && additionInfo.originalRevision == -1L) {
                        additionInfo.originalRevision = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
                    }
                }
                if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposRelPath)) {
                    additionInfo.originalReposRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path);
                }
                if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id) && (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalUuid))) {
                    if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalUuid)) {
                        originalReposId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id);
                        ReposInfo reposInfo = this.fetchReposInfo(pdh.getWCRoot().getSDb(), originalReposId);
                        additionInfo.originalRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
                        additionInfo.originalUuid = reposInfo.reposUuid;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status)) {
                        additionInfo.status = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here) ? ISVNWCDb.SVNWCDbStatus.MovedHere : ISVNWCDb.SVNWCDbStatus.Copied;
                    }
                }
            }
            block4: while (true) {
                stmt.reset();
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                stmt.bindf("is", pdh.getWCRoot().getWcId(), currentRelpath);
                haveRow = stmt.next();
                if (!haveRow) {
                    break;
                }
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                i = SVNWCUtils.relpathDepth(currentRelpath);
                while (true) {
                    if ((long)i <= opDepth) continue block4;
                    reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                    currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                    --i;
                }
                break;
            }
        }
        finally {
            stmt.reset();
        }
        buildRelpath = reposPrefixPath;
        if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid)) {
            ISVNWCDb.WCDbRepositoryInfo rInfo = new ISVNWCDb.WCDbRepositoryInfo();
            long reposId = SVNWCDb.scanUpwardsForRepos(rInfo, pdh.getWCRoot(), currentRelpath);
            if (f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath)) {
                additionInfo.reposRelPath = SVNFileUtil.createFilePath(rInfo.relPath, buildRelpath);
            }
            if (reposId != -1L && f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid)) {
                ReposInfo reposInfo = this.fetchReposInfo(pdh.getWCRoot().getSDb(), reposId);
                if (reposInfo.reposRootUrl != null) {
                    additionInfo.reposRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
                }
                additionInfo.reposUuid = reposInfo.reposUuid;
            }
        }
        if (originalReposId != -1L && f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalRootUrl) || f.contains((Object)ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalUuid)) {
            ReposInfo reposInfo = this.fetchReposInfo(pdh.getWCRoot().getSDb(), originalReposId);
            if (reposInfo.reposRootUrl != null) {
                additionInfo.originalRootUrl = SVNURL.parseURIEncoded(reposInfo.reposRootUrl);
            }
            additionInfo.originalUuid = reposInfo.reposUuid;
        }
        return additionInfo;
    }

    @Override
    public ISVNWCDb.WCDbRepositoryInfo scanBaseRepository(File localAbsPath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.class, (Enum[])fields);
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
        ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
        reposInfo.relPath = baseInfo.reposRelPath;
        if (f.contains((Object)ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl) || f.contains((Object)ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid)) {
            SVNWCDb.fetchReposInfo(reposInfo, pdh.getWCRoot().getSDb(), baseInfo.reposId);
        }
        return reposInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long scanUpwardsForRepos(ISVNWCDb.WCDbRepositoryInfo reposInfo, SVNWCDbRoot wcroot, File localRelPath) throws SVNException {
        assert (wcroot.getSDb() != null && wcroot.getWcId() != -1L);
        assert (reposInfo != null);
        SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.SELECT_BASE_NODE);
        try {
            stmt.bindf("is", wcroot.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
                long l = 0L;
                return l;
            }
            assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_id));
            assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_path));
            reposInfo.relPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path));
            long l = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id);
            return l;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchReposInfo(ISVNWCDb.WCDbRepositoryInfo reposInfo, SVNSqlJetDb sdb, long reposId) throws SVNException {
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY_BY_ID);
        try {
            stmt.bindf("i", reposId);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "No REPOSITORY table entry for id ''{0}''", (Object)reposId);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            reposInfo.rootUrl = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REPOSITORY__Fields.root) ? SVNURL.parseURIEncoded(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.root)) : null;
            reposInfo.uuid = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.uuid);
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNWCDb.WCDbDeletionInfo scanDeletion(File localAbsPath, ISVNWCDb.WCDbDeletionInfo.DeletionInfoField ... fields) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File current_relpath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        EnumSet f = SVNWCDb.getInfoFields(ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.class, (Enum[])fields);
        ISVNWCDb.WCDbDeletionInfo deletionInfo = new ISVNWCDb.WCDbDeletionInfo();
        File current_abspath = localAbsPath;
        File child_abspath = null;
        boolean child_has_base = false;
        boolean found_moved_to = false;
        long opDepth = 0L;
        long localOpDepth = 0L;
        ISVNWCDb.SVNWCDbStatus child_presence = ISVNWCDb.SVNWCDbStatus.BaseDeleted;
        while (true) {
            SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_DELETION_INFO);
            try {
                stmt.bindf("is", pdh.getWCRoot().getWcId(), SVNFileUtil.getFilePath(current_relpath));
                boolean have_row = stmt.next();
                if (!have_row) {
                    if (current_abspath == localAbsPath) {
                        stmt.reset();
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbsPath);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    stmt.reset();
                    if (f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath) && child_presence == ISVNWCDb.SVNWCDbStatus.NotPresent && deletionInfo.workDelAbsPath == null) {
                        deletionInfo.workDelAbsPath = child_abspath;
                    }
                    if (!f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath) || !child_has_base || deletionInfo.baseDelAbsPath != null) break;
                    deletionInfo.baseDelAbsPath = child_abspath;
                    break;
                }
                ISVNWCDb.SVNWCDbStatus work_presence = SvnWcDbStatementUtil.getColumnPresence(stmt);
                if (current_abspath.equals(localAbsPath) && work_presence != ISVNWCDb.SVNWCDbStatus.NotPresent && work_presence != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be deleted.", (Object)localAbsPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                assert (work_presence == ISVNWCDb.SVNWCDbStatus.Normal || work_presence == ISVNWCDb.SVNWCDbStatus.Incomplete || work_presence == ISVNWCDb.SVNWCDbStatus.NotPresent || work_presence == ISVNWCDb.SVNWCDbStatus.BaseDeleted);
                SVNSqlJetStatement baseStmt = stmt.getJoinedStatement("nodes_base");
                try {
                    boolean have_base;
                    boolean bl = have_base = baseStmt != null && baseStmt.next() && !SvnWcDbStatementUtil.isColumnNull(baseStmt, SVNWCDbSchema.NODES__Fields.presence);
                    if (have_base) {
                        ISVNWCDb.SVNWCDbStatus base_presence = SvnWcDbStatementUtil.getColumnPresence(baseStmt);
                        assert (base_presence == ISVNWCDb.SVNWCDbStatus.Normal || base_presence == ISVNWCDb.SVNWCDbStatus.NotPresent || base_presence == ISVNWCDb.SVNWCDbStatus.Incomplete);
                        if (base_presence == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                            base_presence = ISVNWCDb.SVNWCDbStatus.Normal;
                        }
                        if (f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseReplaced) && base_presence == ISVNWCDb.SVNWCDbStatus.Normal && work_presence != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                            deletionInfo.baseReplaced = true;
                        }
                    }
                    if (!found_moved_to && (f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.movedToAbsPath) || f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath)) && !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.moved_to)) {
                        assert (have_base);
                        found_moved_to = true;
                        if (f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.baseDelAbsPath)) {
                            deletionInfo.baseDelAbsPath = current_abspath;
                        }
                        if (f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.movedToAbsPath)) {
                            deletionInfo.movedToAbsPath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.moved_to));
                        }
                    }
                    opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    if (current_abspath.equals(localAbsPath)) {
                        localOpDepth = opDepth;
                    }
                    if (f.contains((Object)ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.workDelAbsPath) && deletionInfo.workDelAbsPath == null && (opDepth < localOpDepth && opDepth > 0L || child_presence == ISVNWCDb.SVNWCDbStatus.NotPresent)) {
                        deletionInfo.workDelAbsPath = child_abspath;
                    }
                    child_abspath = current_abspath;
                    child_presence = work_presence;
                    child_has_base = have_base;
                    if (current_abspath.equals(pdh.getLocalAbsPath())) {
                        pdh = this.navigateToParent(pdh, SVNSqlJetDb.Mode.ReadOnly);
                    }
                    current_abspath = pdh.getLocalAbsPath();
                    current_relpath = pdh.computeRelPath();
                    continue;
                }
                finally {
                    baseStmt.reset();
                    continue;
                }
            }
            finally {
                stmt.reset();
                continue;
            }
            break;
        }
        return deletionInfo;
    }

    public SVNWCDbDir navigateToParent(SVNWCDbDir childPdh, SVNSqlJetDb.Mode sMode) throws SVNException {
        SVNWCDbDir parentPdh = childPdh.getParent();
        if (parentPdh != null && parentPdh.getWCRoot() != null) {
            return parentPdh;
        }
        File parentAbsPath = SVNFileUtil.getParentFile(childPdh.getLocalAbsPath());
        assert (parentAbsPath != null);
        parentPdh = this.parseDir((File)parentAbsPath, (SVNSqlJetDb.Mode)sMode).wcDbDir;
        SVNWCDb.verifyDirUsable(parentPdh);
        childPdh.setParent(parentPdh);
        return parentPdh;
    }

    @Override
    public void setBaseDavCache(File localAbsPath, SVNProperties props) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbShared.begingWriteTransaction(pdh.getWCRoot());
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_BASE_NODE_DAV_CACHE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), parsed.localRelPath);
            stmt.bindProperties(3, props);
            stmt.exec();
        }
        catch (SVNException e) {
            SvnWcDbShared.rollbackTransaction(pdh.getWCRoot());
            throw e;
        }
        finally {
            stmt.reset();
            SvnWcDbShared.commitTransaction(pdh.getWCRoot());
        }
    }

    @Override
    public File toRelPath(File localAbsPath) throws SVNException {
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        return parsed.localRelPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFileExternalTemp(File path) throws SVNException {
        SVNSqlJetStatement stmt = this.getStatementForPath(path, SVNWCDbStatements.SELECT_FILE_EXTERNAL);
        try {
            boolean have_row = stmt.next();
            if (!have_row) {
                String string = null;
                return string;
            }
            String string = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.file_external);
            return string;
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void cleanupPristine(File localAbsPath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbsPath));
        DirParsedInfo parsed = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SvnWcDbPristines.cleanupPristine(pdh.getWCRoot(), localAbsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long fetchWCId(SVNSqlJetDb sDb) throws SVNException {
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_WCROOT_NULL);
        try {
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Missing a row in WCROOT.");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            long l = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.WCROOT__Fields.id);
            return l;
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReposInfo fetchReposInfo(SVNSqlJetDb sDb, long repos_id) throws SVNException {
        ReposInfo info = new ReposInfo();
        if (repos_id == -1L) {
            return info;
        }
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY_BY_ID);
        try {
            stmt.bindf("i", repos_id);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "No REPOSITORY table entry for id ''{0}''", (Object)repos_id);
                SVNErrorManager.error(err, SVNLogType.WC);
                ReposInfo reposInfo = info;
                return reposInfo;
            }
            info.reposRootUrl = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.root);
            info.reposUuid = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.uuid);
        }
        finally {
            stmt.reset();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Structure<StructureFields.RepositoryInfo> fetchRepositoryInfo(SVNSqlJetDb sDb, long repos_id) throws SVNException {
        Object info = Structure.obtain(StructureFields.RepositoryInfo.class);
        if (repos_id == -1L) {
            return info;
        }
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_REPOSITORY_BY_ID);
        try {
            stmt.bindf("i", repos_id);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "No REPOSITORY table entry for id ''{0}''", (Object)repos_id);
                SVNErrorManager.error(err, SVNLogType.WC);
                Object x = info;
                return x;
            }
            ((Structure)info).set((StructureFields.RepositoryInfo)StructureFields.RepositoryInfo.reposRootUrl, SVNURL.parseURIEncoded(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.root)));
            ((Structure)info).set((StructureFields.RepositoryInfo)StructureFields.RepositoryInfo.reposUuid, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REPOSITORY__Fields.uuid));
        }
        finally {
            stmt.reset();
        }
        return info;
    }

    private static SVNSqlJetDb openDb(File dirAbsPath, String sdbFileName, SVNSqlJetDb.Mode sMode) throws SVNException {
        if (dirAbsPath == null || sdbFileName == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return SVNSqlJetDb.open(SVNWCUtils.admChild(dirAbsPath, sdbFileName), sMode);
    }

    private static void verifyDirUsable(SVNWCDbDir pdh) throws SVNException {
        if (!SVNWCDbDir.isUsable(pdh)) {
            if (pdh != null && pdh.getWCRoot() != null && pdh.getWCRoot().getFormat() != 29) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            assert (false);
        }
    }

    @Override
    public SVNSqlJetDb borrowDbTemp(File localDirAbsPath, ISVNWCDb.SVNWCDbOpenMode mode) throws SVNException {
        assert (SVNWCDb.isAbsolute(localDirAbsPath));
        SVNSqlJetDb.Mode smode = mode == ISVNWCDb.SVNWCDbOpenMode.ReadOnly ? SVNSqlJetDb.Mode.ReadOnly : SVNSqlJetDb.Mode.ReadWrite;
        DirParsedInfo parsed = this.parseDir(localDirAbsPath, smode);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return pdh.getWCRoot().getSDb();
    }

    @Override
    public boolean isWCRoot(File localAbspath) throws SVNException {
        return this.isWCRoot(localAbspath, false);
    }

    @Override
    public boolean isWCRoot(File localAbspath, boolean isAdditionMode) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite, false, isAdditionMode);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        return localRelPath == null || localRelPath.getPath().equals("");
    }

    @Override
    public void opStartDirectoryUpdateTemp(File localAbspath, File newReposRelpath, long newRevision) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(newRevision));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        StartDirectoryUpdate du = new StartDirectoryUpdate();
        du.wcId = pdh.getWCRoot().getWcId();
        du.newRevision = newRevision;
        du.newReposRelpath = newReposRelpath;
        du.localRelpath = localRelPath;
        pdh.getWCRoot().getSDb().runTransaction(du);
        pdh.flushEntries(localAbspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opMakeCopyTemp(File localAbspath, boolean removeBase) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelPath = parsed.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        boolean haveRow = false;
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelPath);
            haveRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        if (haveRow) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Modification of ''{0}'' already exists", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.catchCopyOfAbsent(pdh, localRelPath);
        MakeCopy mcb = new MakeCopy();
        mcb.pdh = pdh;
        mcb.localRelpath = localRelPath;
        mcb.localAbspath = localAbspath;
        mcb.opDepth = SVNWCUtils.relpathDepth(localRelPath);
        pdh.getWCRoot().getSDb().runTransaction(mcb);
        pdh.flushEntries(localAbspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catchCopyOfAbsent(SVNWCDbDir pdh, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.HAS_SERVER_EXCLUDED_NODES);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelPath);
            if (stmt.next()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.AUTHZ_UNREADABLE, "Cannot copy ''{0}'', excluded by server", (Object)SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gatherRepoChildren(SVNWCDbDir pdh, File localRelpath, long opDepth) throws SVNException {
        ArrayList<String> children = new ArrayList<String>();
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_OP_DEPTH_CHILDREN);
        try {
            stmt.bindf("isi", pdh.getWCRoot().getWcId(), localRelpath, opDepth);
            boolean haveRow = stmt.next();
            while (haveRow) {
                String childRelpath = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath)));
                children.add(childRelpath);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fetchReposId(SVNSqlJetDb db, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        SVNSqlJetStatement getStmt = db.getStatement(SVNWCDbStatements.SELECT_REPOSITORY);
        try {
            getStmt.bindf("s", reposRootUrl);
            getStmt.nextRow();
            long l = getStmt.getColumnLong(SVNWCDbSchema.REPOSITORY__Fields.id);
            return l;
        }
        finally {
            getStmt.reset();
        }
    }

    @Override
    public void opSetNewDirToIncompleteTemp(File localAbspath, File reposRelpath, SVNURL reposRootURL, String reposUuid, long revision, SVNDepth depth) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (reposRelpath != null && reposRootURL != null && reposUuid != null);
        DirParsedInfo parsed = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parsed.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase insertBase = new InsertBase();
        insertBase.reposRootURL = reposRootURL;
        insertBase.reposUUID = reposUuid;
        insertBase.status = ISVNWCDb.SVNWCDbStatus.Incomplete;
        insertBase.kind = ISVNWCDb.SVNWCDbKind.Dir;
        insertBase.reposRelpath = reposRelpath;
        insertBase.revision = revision;
        insertBase.depth = depth;
        insertBase.localRelpath = parsed.localRelPath;
        insertBase.wcId = pdh.getWCRoot().getWcId();
        pdh.getWCRoot().getSDb().runTransaction(insertBase);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void opBumpRevisionPostUpdate(File localAbsPath, SVNDepth depth, File newReposRelPath, SVNURL newReposRootURL, String newReposUUID, long newRevision, Collection<File> excludedPaths) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        File localRelPath = parseDir.localRelPath;
        if (excludedPaths != null && excludedPaths.contains(localRelPath)) {
            return;
        }
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        BumpRevisionPostUpdate brb = new BumpRevisionPostUpdate();
        brb.depth = depth;
        brb.newReposRelPath = newReposRelPath;
        brb.newReposRootURL = newReposRootURL;
        brb.newReposUUID = newReposUUID;
        brb.newRevision = newRevision;
        brb.localRelPath = localRelPath;
        brb.wcRoot = pdh.getWCRoot().getAbsPath();
        brb.exludedRelPaths = excludedPaths;
        brb.dbWcRoot = pdh.getWCRoot();
        pdh.getWCRoot().getSDb().runTransaction(brb);
        pdh.flushEntries(localAbsPath);
    }

    @Override
    public File getWCRootTempDir(File localAbspath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRemoveWorkingTemp(File localAbspath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.flushEntries(localAbspath);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_WORKING_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opSetBaseIncompleteTemp(File localDirAbspath, boolean incomplete) throws SVNException {
        SVNWCDbDir pdh;
        long affectedNodeRows;
        ISVNWCDb.SVNWCDbStatus baseStatus = this.getBaseInfo((File)localDirAbspath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.status}).status;
        assert (baseStatus == ISVNWCDb.SVNWCDbStatus.Normal || baseStatus == ISVNWCDb.SVNWCDbStatus.Incomplete);
        SVNSqlJetStatement stmt = this.getStatementForPath(localDirAbspath, SVNWCDbStatements.UPDATE_NODE_BASE_PRESENCE);
        try {
            stmt.bindString(3, incomplete ? "incomplete" : "normal");
            affectedNodeRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        long affectedRows = affectedNodeRows;
        if (affectedRows > 0L && (pdh = this.getOrCreateDir(localDirAbspath, false)) != null) {
            pdh.flushEntries(localDirAbspath);
        }
    }

    private SVNWCDbDir getOrCreateDir(File localDirAbspath, boolean createAllowed) {
        SVNWCDbDir pdh = this.dirData.get(localDirAbspath.getAbsolutePath());
        if (pdh == null && createAllowed) {
            pdh = new SVNWCDbDir(localDirAbspath);
            this.dirData.put(localDirAbspath.getAbsolutePath(), pdh);
        }
        return pdh;
    }

    @Override
    public void opSetDirDepthTemp(File localAbspath, SVNDepth depth) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (depth.getId() >= SVNDepth.EMPTY.getId() && depth.getId() <= SVNDepth.INFINITY.getId());
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        this.updateDepthValues(localAbspath, pdh, localRelpath, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDepthValues(File localAbspath, SVNWCDbDir pdh, File localRelpath, SVNDepth depth) throws SVNException {
        long affectedRows;
        pdh.flushEntries(localAbspath);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_NODE_BASE_DEPTH);
        try {
            stmt.bindf("iss", pdh.getWCRoot().getWcId(), localRelpath, SVNDepth.asString(depth));
            affectedRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        if (affectedRows == 0L) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' os not a committed directory", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRemoveEntryTemp(File localAbspath) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.flushEntries(localAbspath);
        SVNSqlJetDb sdb = pdh.getWCRoot().getSDb();
        long wcId = pdh.getWCRoot().getWcId();
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.DELETE_NODES);
        try {
            stmt.bindf("is", wcId, localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_WITHOUT_CONFLICT);
        try {
            stmt.bindf("is", wcId, localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public void opSetRevAndReposRelpathTemp(File localAbspath, long revision, boolean setReposRelpath, File reposRelpath, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(revision) || setReposRelpath);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        SetRevRelpath baton = new SetRevRelpath();
        baton.pdh = pdh;
        baton.localRelpath = parseDir.localRelPath;
        baton.rev = revision;
        baton.setReposRelpath = setReposRelpath;
        baton.reposRelpath = reposRelpath;
        baton.reposRootUrl = reposRootUrl;
        baton.reposUuid = reposUuid;
        pdh.flushEntries(localAbspath);
        pdh.getWCRoot().getSDb().runTransaction(baton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opSetRevAndReposRelpath(SVNWCDbRoot wcRoot, File localRelpath, long revision, boolean setReposRelpath, final File reposRelpath, SVNURL reposRootUrl, String reposUuid) throws SVNException {
        SVNSqlJetStatement stmt;
        assert (SVNRevision.isValidRevisionNumber(revision) || setReposRelpath);
        if (SVNRevision.isValidRevisionNumber(revision)) {
            stmt = wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_BASE_REVISION);
            try {
                stmt.bindf("isi", wcRoot.getWcId(), localRelpath, revision);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        if (setReposRelpath) {
            final long reposId = this.createReposId(wcRoot.getSDb(), reposRootUrl, reposUuid);
            stmt = new SVNSqlJetUpdateStatement(wcRoot.getSDb(), SVNWCDbSchema.NODES){

                @Override
                public Map<String, Object> getUpdateValues() throws SVNException {
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), reposId);
                    values.put(SVNWCDbSchema.NODES__Fields.repos_path.toString(), SVNFileUtil.getFilePath(reposRelpath));
                    return values;
                }
            };
            try {
                stmt.bindf("isi", wcRoot.getWcId(), localRelpath, 0);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    @Override
    public void obtainWCLock(File localAbspath, int levelsToLock, boolean stealLock) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (levelsToLock >= -1);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        WCLockObtain baton = new WCLockObtain();
        baton.pdh = pdh;
        baton.localRelpath = localRelpath;
        if (!stealLock) {
            SVNWCDbRoot wcroot = pdh.getWCRoot();
            int depth = SVNWCUtils.relpathDepth(localRelpath);
            for (SVNWCDbRoot.WCLock lock : wcroot.getOwnedLocks()) {
                if (!SVNWCUtils.isAncestor(lock.localRelpath, localRelpath) || lock.levels != -1 && lock.levels + SVNWCUtils.relpathDepth(lock.localRelpath) < depth) continue;
                File lockAbspath = SVNFileUtil.createFilePath(pdh.getWCRoot().getAbsPath(), lock.localRelpath);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "''{0}'' is already locked via ''{1}''", localAbspath, lockAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            ISVNWCDb.WCDbWorkQueueInfo wq = this.fetchWorkQueue(pdh.getWCRoot().getAbsPath());
            if (wq.workItem != null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "There are unfinished work items in ''{0}''; run ''svn cleanup'' first.", (Object)pdh.getWCRoot().getAbsPath());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        baton.stealLock = stealLock;
        baton.levelsToLock = levelsToLock;
        pdh.getWCRoot().getSDb().runTransaction(baton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stealWCLock(SVNWCDbRoot wcroot, File localRelpath) throws SVNException {
        SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.DELETE_WC_LOCK);
        try {
            stmt.bindf("is", wcroot.getWcId(), localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseWCLock(File localAbspath) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        SVNWCDbRoot.WCLock foundLock = null;
        List<SVNWCDbRoot.WCLock> ownedLocks = pdh.getWCRoot().getOwnedLocks();
        for (SVNWCDbRoot.WCLock lock : ownedLocks) {
            if (!lock.localRelpath.equals(localRelpath)) continue;
            foundLock = lock;
            break;
        }
        if (foundLock == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy not locked at ''{0}''", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        ownedLocks.remove(foundLock);
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_WC_LOCK);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    @Override
    public File getWCRoot(File wcRootAbspath) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(wcRootAbspath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        if (pdh.getWCRoot() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "The node ''{0}'' is not in the working copy", (Object)wcRootAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return pdh.getWCRoot().getAbsPath();
    }

    @Override
    public void forgetDirectoryTemp(File localDirAbspath) throws SVNException {
        HashSet<SVNWCDbRoot> roots = new HashSet<SVNWCDbRoot>();
        Iterator<Map.Entry<String, SVNWCDbDir>> i = this.dirData.entrySet().iterator();
        while (i.hasNext()) {
            SVNWCDbDir pdh;
            block3: {
                Map.Entry<String, SVNWCDbDir> entry = i.next();
                pdh = entry.getValue();
                if (!SVNWCUtils.isAncestor(localDirAbspath, pdh.getLocalAbsPath())) continue;
                try {
                    this.releaseWCLock(pdh.getLocalAbsPath());
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) break block3;
                    throw e;
                }
            }
            i.remove();
            if (pdh.getWCRoot() == null || pdh.getWCRoot().getSDb() == null || !SVNWCUtils.isAncestor(localDirAbspath, pdh.getWCRoot().getAbsPath())) continue;
            roots.add(pdh.getWCRoot());
        }
        this.closeManyWCRoots(roots);
    }

    @Override
    public boolean isWCLockOwns(File localAbspath, boolean exact) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        if (pdh.getWCRoot() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "The node ''{0}'' was not found.", (Object)localAbspath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNWCDb.verifyDirUsable(pdh);
        boolean ownLock = false;
        List<SVNWCDbRoot.WCLock> ownedLocks = pdh.getWCRoot().getOwnedLocks();
        int lockLevel = SVNWCUtils.relpathDepth(localRelpath);
        if (exact) {
            for (SVNWCDbRoot.WCLock lock : ownedLocks) {
                if (!lock.localRelpath.equals(localRelpath)) continue;
                ownLock = true;
                return ownLock;
            }
        } else {
            for (SVNWCDbRoot.WCLock lock : ownedLocks) {
                if (!SVNWCUtils.isAncestor(lock.localRelpath, localRelpath) || lock.levels != -1 && SVNWCUtils.relpathDepth(lock.localRelpath) + lock.levels < lockLevel) continue;
                ownLock = true;
                return ownLock;
            }
        }
        return ownLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opSetTextConflictMarkerFilesTemp(File localAbspath, File oldBasename, File newBasename, File wrkBasename) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        boolean gotRow = false;
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            gotRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        try {
            if (gotRow) {
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_TEXT_CONFLICTS);
            } else {
                if (oldBasename == null && newBasename == null && wrkBasename == null) {
                    return;
                }
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_TEXT_CONFLICTS);
                stmt.bindString(6, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelpath)));
            }
            stmt.bindf("issss", pdh.getWCRoot().getWcId(), localRelpath, oldBasename, newBasename, wrkBasename);
            stmt.done();
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
        }
    }

    @Override
    public void addBaseNotPresentNode(File localAbspath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long revision, ISVNWCDb.SVNWCDbKind kind, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        this.addExcludedOrNotPresentNode(localAbspath, reposRelPath, reposRootUrl, reposUuid, revision, kind, ISVNWCDb.SVNWCDbStatus.NotPresent, conflict, workItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opSetPropertyConflictMarkerFileTemp(File localAbspath, String prejBasename) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        boolean gotRow = false;
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            gotRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        try {
            if (gotRow) {
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_PROPERTY_CONFLICTS);
            } else {
                if (prejBasename == null) {
                    return;
                }
                stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_PROPERTY_CONFLICTS);
                if (localRelpath != null && !"".equals(SVNFileUtil.getFilePath(localRelpath))) {
                    stmt.bindString(4, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelpath)));
                } else {
                    stmt.bindNull(4);
                }
            }
            stmt.bindf("iss", pdh.getWCRoot().getWcId(), localRelpath, prejBasename);
            stmt.done();
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
        }
    }

    private void addExcludedOrNotPresentNode(File localAbspath, File reposRelpath, SVNURL reposRootUrl, String reposUuid, long revision, ISVNWCDb.SVNWCDbKind kind, ISVNWCDb.SVNWCDbStatus status, SVNSkel conflict, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (reposRelpath != null);
        assert (reposUuid != null);
        assert (SVNRevision.isValidRevisionNumber(revision));
        assert (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.NotPresent);
        DirParsedInfo parseDir = this.parseDir(SVNFileUtil.getParentFile(localAbspath), SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = SVNFileUtil.createFilePath(parseDir.localRelPath, SVNFileUtil.getFileName(localAbspath));
        SVNWCDb.verifyDirUsable(pdh);
        InsertBase ibb = new InsertBase();
        ibb.status = status;
        ibb.kind = kind;
        ibb.reposRelpath = reposRelpath;
        ibb.revision = revision;
        ibb.children = null;
        ibb.depth = SVNDepth.UNKNOWN;
        ibb.checksum = null;
        ibb.target = null;
        ibb.conflict = conflict;
        ibb.workItems = workItems;
        ibb.reposRootURL = reposRootUrl;
        ibb.reposUUID = reposUuid;
        ibb.wcId = pdh.getWCRoot().getWcId();
        ibb.localRelpath = localRelpath;
        pdh.getWCRoot().getSDb().runTransaction(ibb);
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void globalCommit(File localAbspath, long newRevision, long changedRevision, SVNDate changedDate, String changedAuthor, SvnChecksum newChecksum, List<File> newChildren, SVNProperties newDavCache, boolean keepChangelist, boolean noUnlock, SVNSkel workItems) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        assert (SVNRevision.isValidRevisionNumber(newRevision));
        assert (newChecksum == null || newChildren == null);
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        Commit cb = new Commit();
        cb.pdh = pdh;
        cb.localRelpath = localRelpath;
        cb.newRevision = newRevision;
        cb.changedRev = changedRevision;
        cb.changedDate = changedDate;
        cb.changedAuthor = changedAuthor;
        cb.newChecksum = newChecksum;
        cb.newChildren = newChildren;
        cb.newDavCache = newDavCache;
        cb.keepChangelist = keepChangelist;
        cb.noUnlock = noUnlock;
        cb.workItems = workItems;
        pdh.getWCRoot().getSDb().runTransaction(cb);
        pdh.flushEntries(localAbspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReposInfo2 determineReposInfo(SVNWCDbDir pdh, File localRelpath) throws SVNException {
        ReposInfo2 info = new ReposInfo2();
        SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_BASE_NODE);
        try {
            stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
            boolean haveRow = stmt.next();
            if (haveRow) {
                assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_id));
                assert (!stmt.isColumnNull(SVNWCDbSchema.NODES__Fields.repos_path));
                info.reposId = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id);
                info.reposRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path));
                ReposInfo2 reposInfo2 = info;
                return reposInfo2;
            }
        }
        finally {
            stmt.reset();
        }
        File localParentRelpath = SVNFileUtil.getFileDir(localRelpath);
        String name = SVNFileUtil.getFileName(localRelpath);
        ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
        info.reposId = SVNWCDb.scanUpwardsForRepos(reposInfo, pdh.getWCRoot(), localParentRelpath);
        File reposParentRelpath = reposInfo.relPath;
        info.reposRelPath = SVNFileUtil.createFilePath(reposParentRelpath, name);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Structure<StructureFields.PristineInfo> readPristineInfo(File localAbspath) throws SVNException {
        DirParsedInfo wcInfo = this.obtainWcRoot(localAbspath);
        SVNWCDbDir dir = wcInfo.wcDbDir;
        SVNSqlJetStatement stmt = dir.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        File relativePath = wcInfo.localRelPath;
        Object result = Structure.obtain(StructureFields.PristineInfo.class);
        try {
            stmt.bindf("is", dir.getWCRoot().getWcId(), relativePath);
            if (!stmt.next()) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbspath), SVNLogType.WC);
            }
            long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            ISVNWCDb.SVNWCDbStatus status = SvnWcDbStatementUtil.getColumnPresence(stmt);
            if (opDepth > 0L && status == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                boolean hasNext = stmt.next();
                assert (hasNext);
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                status = SvnWcDbStatementUtil.getColumnPresence(stmt);
            }
            ISVNWCDb.SVNWCDbKind kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.kind, (Object)kind);
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.changed_date, SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_date)));
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.changed_author, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author));
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.changed_rev, SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_revision));
            if (opDepth > 0L) {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.status, (Object)SVNWCDb.getWorkingStatus(status));
            } else {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.status, (Object)status);
            }
            if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.depth, SVNDepth.UNKNOWN);
            } else {
                String depthStr = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth);
                if (depthStr == null) {
                    ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.depth, SVNDepth.UNKNOWN);
                } else {
                    ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.depth, SVNDepth.fromString(depthStr));
                }
            }
            if (kind == ISVNWCDb.SVNWCDbKind.File) {
                SvnChecksum checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.checksum, checksum);
            } else if (kind == ISVNWCDb.SVNWCDbKind.Symlink) {
                ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.target, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.symlink_target));
            }
            ((Structure)result).set((StructureFields.PristineInfo)StructureFields.PristineInfo.hadProps, SvnWcDbStatementUtil.hasColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties));
        }
        finally {
            stmt.reset();
        }
        return result;
    }

    public DirParsedInfo obtainWcRoot(File localAbspath) throws SVNException {
        return this.obtainWcRoot(localAbspath, false);
    }

    public DirParsedInfo obtainWcRoot(File localAbspath, boolean isAdditionMode) throws SVNException {
        assert (SVNWCDb.isAbsolute(localAbspath));
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadOnly, false, isAdditionMode);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        SVNWCDb.verifyDirUsable(pdh);
        return parseDir;
    }

    @Override
    public void registerExternal(File definingAbsPath, File localAbsPath, SVNNodeKind kind, SVNURL reposRootUrl, String reposUuid, File reposRelPath, long operationalRevision, long revision) throws SVNException {
        SvnWcDbExternals.addExternalDir(this, localAbsPath, definingAbsPath, reposRootUrl, reposUuid, definingAbsPath, reposRelPath, operationalRevision, revision, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opRemoveNode(File localAbspath, long notPresentRevision, ISVNWCDb.SVNWCDbKind notPresentKind) throws SVNException {
        DirParsedInfo parseDir = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadWrite);
        SVNWCDbDir pdh = parseDir.wcDbDir;
        File localRelpath = parseDir.localRelPath;
        SVNWCDb.verifyDirUsable(pdh);
        pdh.getWCRoot().getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            long reposId = -1L;
            File reposRelPath = null;
            if (notPresentRevision >= 0L) {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.getBaseInfo(pdh.getWCRoot(), localRelpath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
                reposId = baseInfo.reposId;
                reposRelPath = baseInfo.reposRelPath;
            }
            SVNSqlJetStatement stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_NODES_RECURSIVE);
            try {
                stmt.bindf("isi", pdh.getWCRoot().getWcId(), localRelpath, 0);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_RECURSIVE);
            try {
                stmt.bindf("is", pdh.getWCRoot().getWcId(), localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (notPresentRevision >= 0L) {
                InsertBase ib = new InsertBase();
                ib.reposId = reposId;
                ib.reposRelpath = reposRelPath;
                ib.status = ISVNWCDb.SVNWCDbStatus.NotPresent;
                ib.kind = notPresentKind;
                ib.revision = notPresentRevision;
                ib.localRelpath = localRelpath;
                ib.wcId = pdh.getWCRoot().getWcId();
                try {
                    ib.transaction(pdh.getWCRoot().getSDb());
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
            }
        }
        catch (SVNException e) {
            pdh.getWCRoot().getSDb().rollback();
            throw e;
        }
        finally {
            pdh.getWCRoot().getSDb().commit();
        }
        pdh.flushEntries(localAbspath);
    }

    @Override
    public void upgradeBegin(File localAbspath, ISVNWCDb.SVNWCDbUpgradeData upgradeData, SVNURL repositoryRootUrl, String repositoryUUID) throws SVNException {
        CreateDbInfo dbInfo = this.createDb(localAbspath, repositoryRootUrl, repositoryUUID, "wc.db");
        upgradeData.repositoryId = dbInfo.reposId;
        upgradeData.workingCopyId = dbInfo.wcId;
        SVNWCDbDir pdh = new SVNWCDbDir(localAbspath);
        SVNWCDbRoot root = new SVNWCDbRoot(this, localAbspath, dbInfo.sDb, dbInfo.wcId, -1, false, false);
        pdh.setWCRoot(root);
        upgradeData.root = root;
        this.dirData.put(upgradeData.rootAbsPath.getAbsolutePath(), pdh);
    }

    @Override
    public ISVNWCDb.SVNWCDbNodeCheckReplaceData nodeCheckReplace(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        DirParsedInfo pdh = this.parseDir(localAbspath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(pdh.wcDbDir);
        if (pdh.localRelPath == null || pdh.localRelPath.getPath() == null || pdh.localRelPath.getPath().length() == 0) {
            return ISVNWCDb.SVNWCDbNodeCheckReplaceData.NO_REPLACE;
        }
        CheckReplace checkReplace = new CheckReplace(pdh.wcDbDir.getWCRoot().getWcId(), pdh.localRelPath);
        checkReplace.replace = false;
        checkReplace.replaceRoot = false;
        checkReplace.baseReplace = false;
        pdh.wcDbDir.getWCRoot().getSDb().runTransaction(checkReplace, SqlJetTransactionMode.READ_ONLY);
        return new ISVNWCDb.SVNWCDbNodeCheckReplaceData(checkReplace.replaceRoot, checkReplace.replace, checkReplace.baseReplace);
    }

    public class CheckReplace
    implements SVNSqlJetTransaction {
        public long wcId;
        public File localRelpath;
        public boolean replaceRoot;
        public boolean baseReplace;
        public boolean replace;

        public CheckReplace(long wcId, File localRelpath) {
            this.wcId = wcId;
            this.localRelpath = localRelpath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            long replacedOpDepth;
            ISVNWCDb.SVNWCDbStatus replacedStatus;
            boolean haveRow;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            try {
                ISVNWCDb.SVNWCDbStatus status;
                stmt.bindf("is", this.wcId, this.localRelpath.getPath());
                haveRow = stmt.next();
                if (!haveRow) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)this.localRelpath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if ((status = SvnWcDbStatementUtil.getColumnPresence(stmt)) != ISVNWCDb.SVNWCDbStatus.Normal) {
                    return;
                }
                haveRow = stmt.next();
                if (!haveRow) {
                    return;
                }
                replacedStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                if (replacedStatus != ISVNWCDb.SVNWCDbStatus.NotPresent && replacedStatus != ISVNWCDb.SVNWCDbStatus.Excluded && replacedStatus != ISVNWCDb.SVNWCDbStatus.ServerExcluded && replacedStatus != ISVNWCDb.SVNWCDbStatus.Deleted) {
                    this.replace = true;
                }
                replacedOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                long opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                while (opDepth != 0L && haveRow) {
                    haveRow = stmt.next();
                    if (!haveRow) continue;
                    opDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                }
                if (haveRow && opDepth == 0L) {
                    ISVNWCDb.SVNWCDbStatus baseStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    this.baseReplace = baseStatus != ISVNWCDb.SVNWCDbStatus.NotPresent;
                }
            }
            finally {
                stmt.reset();
            }
            if (replacedStatus != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                long parentOpDepth;
                try {
                    stmt.bindf("is", this.wcId, SVNFileUtil.getFileDir(this.localRelpath));
                    stmt.nextRow();
                    parentOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    if (parentOpDepth >= replacedOpDepth) {
                        this.replaceRoot = parentOpDepth == replacedOpDepth;
                        return;
                    }
                    haveRow = stmt.next();
                    if (haveRow) {
                        parentOpDepth = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    }
                }
                finally {
                    stmt.reset();
                }
                if (!haveRow) {
                    this.replaceRoot = true;
                } else if (parentOpDepth < replacedOpDepth) {
                    this.replaceRoot = true;
                }
            }
        }
    }

    public class Commit
    implements SVNSqlJetTransaction {
        public SVNWCDbDir pdh;
        public File localRelpath;
        public long newRevision;
        public long changedRev;
        public SVNDate changedDate;
        public String changedAuthor;
        public SvnChecksum newChecksum;
        public List<File> newChildren;
        public SVNProperties newDavCache;
        public boolean keepChangelist;
        public boolean noUnlock;
        public SVNSkel workItems;
        public long reposId;
        public File reposRelPath;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt;
            ISVNWCDb.SVNWCDbKind newKind;
            long opDepth;
            boolean haveAct;
            SVNSqlJetStatement stmtAct = null;
            SVNSqlJetStatement stmtInfo = null;
            byte[] propBlob = null;
            String changelist = null;
            String newDepthStr = null;
            boolean fileExternal = false;
            ISVNWCDb.SVNWCDbStatus oldPresence = null;
            ReposInfo2 reposInfo = SVNWCDb.this.determineReposInfo(this.pdh, this.localRelpath);
            this.reposId = reposInfo.reposId;
            this.reposRelPath = reposInfo.reposRelPath;
            SVNSqlJetDb sdb = this.pdh.getWCRoot().getSDb();
            long wcId = this.pdh.getWCRoot().getWcId();
            try {
                stmtInfo = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                stmtInfo.bindf("is", wcId, this.localRelpath);
                stmtInfo.next();
                stmtAct = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
                stmtAct.bindf("is", wcId, this.localRelpath);
                haveAct = stmtAct.next();
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                newKind = SvnWcDbStatementUtil.getColumnKind(stmtInfo, SVNWCDbSchema.NODES__Fields.kind);
                if (newKind == ISVNWCDb.SVNWCDbKind.Dir) {
                    newDepthStr = SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.depth);
                }
                if (haveAct) {
                    propBlob = SvnWcDbStatementUtil.getColumnBlob(stmtAct, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                }
                if (propBlob == null) {
                    propBlob = SvnWcDbStatementUtil.getColumnBlob(stmtInfo, SVNWCDbSchema.NODES__Fields.properties);
                }
                if (this.keepChangelist && haveAct) {
                    changelist = SvnWcDbStatementUtil.getColumnText(stmtAct, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                }
                oldPresence = SvnWcDbStatementUtil.getColumnPresence(stmtInfo);
            }
            finally {
                if (stmtInfo != null) {
                    stmtInfo.reset();
                }
                if (stmtAct != null) {
                    stmtAct.reset();
                }
            }
            if (opDepth > 0L) {
                long affectedRows;
                stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ALL_LAYERS);
                try {
                    stmt.bindf("is", wcId, this.localRelpath);
                    affectedRows = stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (affectedRows > 1L) {
                    stmt = sdb.getStatement(SVNWCDbStatements.DELETE_SHADOWED_RECURSIVE);
                    try {
                        stmt.bindf("isi", wcId, this.localRelpath, opDepth);
                        stmt.done();
                    }
                    finally {
                        stmt.reset();
                    }
                }
                this.commitDescendant(this.localRelpath, this.reposRelPath, opDepth, this.newRevision);
            }
            File parentRelpath = this.localRelpath == null || "".equals(SVNFileUtil.getFilePath(this.localRelpath)) ? null : SVNFileUtil.getFileDir(this.localRelpath);
            ISVNWCDb.SVNWCDbStatus newPresence = oldPresence == ISVNWCDb.SVNWCDbStatus.Incomplete ? ISVNWCDb.SVNWCDbStatus.Incomplete : ISVNWCDb.SVNWCDbStatus.Normal;
            stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.APPLY_CHANGES_TO_BASE_NODE);
            try {
                stmt.bindf("issisrtstrisnbnn", this.pdh.getWCRoot().getWcId(), this.localRelpath, parentRelpath, this.reposId, this.reposRelPath, this.newRevision, SvnWcDbStatementUtil.getPresenceText(newPresence), newDepthStr, SvnWcDbStatementUtil.getKindText(newKind), this.changedRev, this.changedDate, this.changedAuthor, propBlob);
                stmt.bindChecksum(13, this.newChecksum);
                stmt.bindProperties(15, this.newDavCache);
                if (fileExternal) {
                    stmt.bindString(17, "1");
                } else {
                    stmt.bindNull(17);
                }
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (haveAct) {
                if (this.keepChangelist && changelist != null) {
                    stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.RESET_ACTUAL_WITH_CHANGELIST);
                    try {
                        stmt.bindf("isss", this.pdh.getWCRoot().getWcId(), this.localRelpath, SVNFileUtil.getFileDir(this.localRelpath), changelist);
                        stmt.done();
                    }
                    finally {
                        stmt.reset();
                    }
                }
                stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE);
                try {
                    stmt.bindf("is", this.pdh.getWCRoot().getWcId(), this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (!this.noUnlock) {
                SVNSqlJetStatement lockStmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.DELETE_LOCK);
                try {
                    lockStmt.bindf("is", this.reposId, this.reposRelPath);
                    lockStmt.done();
                }
                finally {
                    lockStmt.reset();
                }
            }
            SVNWCDb.this.addWorkItems(this.pdh.getWCRoot().getSDb(), this.workItems);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitDescendant(File parentLocalRelPath, File parentReposRelPath, long opDepth, long revision) throws SVNException {
            List<String> children = SVNWCDb.this.gatherRepoChildren(this.pdh, parentLocalRelPath, opDepth);
            for (String name : children) {
                SVNSqlJetStatement stmt = this.pdh.getWCRoot().getSDb().getStatement(SVNWCDbStatements.COMMIT_DESCENDANT_TO_BASE);
                try {
                    File childLocalRelPath = SVNFileUtil.createFilePath(parentLocalRelPath, name);
                    File childReposRelPath = SVNFileUtil.createFilePath(parentReposRelPath, name);
                    stmt.bindf("isiisr", this.pdh.getWCRoot().getWcId(), childLocalRelPath, opDepth, this.reposId, childReposRelPath, revision);
                    stmt.done();
                    this.commitDescendant(childLocalRelPath, childReposRelPath, opDepth, revision);
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    private static class ReposInfo2 {
        public long reposId;
        public File reposRelPath;

        private ReposInfo2() {
        }
    }

    private class WCLockObtain
    implements SVNSqlJetTransaction {
        SVNWCDbDir pdh;
        File localRelpath;
        int levelsToLock;
        boolean stealLock;

        private WCLockObtain() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNErrorMessage err;
            SVNErrorMessage err1;
            File lockRelpath;
            boolean gotRow;
            boolean nodeExists;
            SVNWCDbRoot wcroot = this.pdh.getWCRoot();
            if (this.localRelpath != null && !"".equals(SVNFileUtil.getFilePath(this.localRelpath)) && !(nodeExists = SvnWcDbShared.doesNodeExists(wcroot, this.localRelpath))) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcroot.getAbsPath(this.localRelpath));
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            int lockDepth = SVNWCUtils.relpathDepth(this.localRelpath);
            int maxDepth = lockDepth + this.levelsToLock;
            SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.FIND_WC_LOCK);
            try {
                stmt.bindf("is", wcroot.getWcId(), this.localRelpath);
                gotRow = stmt.next();
                while (gotRow) {
                    lockRelpath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.WC_LOCK__Fields.local_dir_relpath));
                    if (this.levelsToLock >= 0 && SVNWCUtils.relpathDepth(lockRelpath) > maxDepth) {
                        gotRow = stmt.next();
                        continue;
                    }
                    File lockAbspath = SVNFileUtil.createFilePath(wcroot.getAbsPath(), lockRelpath);
                    boolean ownLock = SVNWCDb.this.isWCLockOwns(lockAbspath, true);
                    if (!ownLock && !this.stealLock) {
                        err1 = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "''{0}'' is already locked.", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), lockRelpath));
                        err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), this.localRelpath));
                        err.setChildErrorMessage(err1);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    } else if (!ownLock) {
                        SVNWCDb.this.stealWCLock(wcroot, lockRelpath);
                    }
                    gotRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            if (this.stealLock) {
                SVNWCDb.this.stealWCLock(wcroot, this.localRelpath);
            }
            stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.SELECT_WC_LOCK);
            try {
                lockRelpath = this.localRelpath;
                while (true) {
                    stmt.bindf("is", wcroot.getWcId(), lockRelpath);
                    gotRow = stmt.next();
                    if (gotRow) {
                        long levels = stmt.getColumnLong(SVNWCDbSchema.WC_LOCK__Fields.locked_levels);
                        if (levels >= 0L) {
                            levels += (long)SVNWCUtils.relpathDepth(lockRelpath);
                        }
                        stmt.reset();
                        if (levels == -1L || levels >= (long)lockDepth) {
                            err1 = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "''{0}'' is already locked.", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), lockRelpath));
                            err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), this.localRelpath));
                            err.setChildErrorMessage(err1);
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                        break;
                    }
                    stmt.reset();
                    if (lockRelpath == null) {
                        break;
                    }
                    lockRelpath = SVNFileUtil.getFileDir(lockRelpath);
                }
            }
            finally {
                stmt.reset();
            }
            stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.INSERT_WC_LOCK);
            stmt.bindf("isi", wcroot.getWcId(), this.localRelpath, this.levelsToLock);
            try {
                stmt.done();
            }
            catch (SVNException e) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", (Object)SVNFileUtil.createFilePath(wcroot.getAbsPath(), this.localRelpath));
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            finally {
                stmt.reset();
            }
            SVNWCDbRoot.WCLock lock = new SVNWCDbRoot.WCLock();
            lock.localRelpath = this.localRelpath;
            lock.levels = this.levelsToLock;
            wcroot.getOwnedLocks().add(lock);
        }
    }

    private class SetRevRelpath
    implements SVNSqlJetTransaction {
        public SVNWCDbDir pdh;
        public File localRelpath;
        public long rev;
        public boolean setReposRelpath;
        public File reposRelpath;
        public SVNURL reposRootUrl;
        public String reposUuid;

        private SetRevRelpath() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt;
            if (SVNRevision.isValidRevisionNumber(this.rev)) {
                stmt = db.getStatement(SVNWCDbStatements.UPDATE_BASE_REVISION);
                try {
                    stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, this.rev);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (this.setReposRelpath) {
                final long reposId = SVNWCDb.this.createReposId(this.pdh.getWCRoot().getSDb(), this.reposRootUrl, this.reposUuid);
                stmt = new SVNSqlJetUpdateStatement(this.pdh.getWCRoot().getSDb(), SVNWCDbSchema.NODES){

                    @Override
                    public Map<String, Object> getUpdateValues() throws SVNException {
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        values.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), reposId);
                        values.put(SVNWCDbSchema.NODES__Fields.repos_path.toString(), SVNFileUtil.getFilePath(SetRevRelpath.this.reposRelpath));
                        return values;
                    }
                };
                try {
                    stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, 0);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BumpRevisionPostUpdate
    implements SVNSqlJetTransaction {
        private SVNDepth depth;
        private File newReposRelPath;
        private SVNURL newReposRootURL;
        private String newReposUUID;
        private long newRevision;
        private Collection<File> exludedRelPaths;
        private File localRelPath;
        private File wcRoot;
        private SVNWCDbRoot dbWcRoot;

        private BumpRevisionPostUpdate() {
        }

        @Override
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            ISVNWCDb.SVNWCDbStatus status = null;
            ISVNWCDb.WCDbBaseInfo baseInfo = null;
            try {
                baseInfo = SVNWCDb.this.getBaseInfo(this.dbWcRoot, this.localRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision);
                status = baseInfo.status;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    return;
                }
                throw e;
            }
            switch (status) {
                case NotPresent: 
                case ServerExcluded: 
                case Excluded: {
                    return;
                }
            }
            long reposId = -1L;
            if (this.newReposRootURL != null) {
                reposId = SVNWCDb.this.createReposId(db, this.newReposRootURL, this.newReposUUID);
            }
            this.bumpNodeRevision(this.dbWcRoot, this.wcRoot, this.localRelPath, baseInfo, reposId, this.newReposRelPath, this.newRevision, this.depth, this.exludedRelPaths, true, false);
        }

        private void bumpNodeRevision(SVNWCDbRoot root, File wcRoot, File localRelPath, ISVNWCDb.WCDbBaseInfo baseInfo, long reposId, File newReposRelPath, long newRevision, SVNDepth depth, Collection<File> exludedRelPaths, boolean isRoot, boolean skipWhenDir) throws SVNException {
            if (exludedRelPaths != null && exludedRelPaths.contains(localRelPath)) {
                return;
            }
            if (baseInfo.updateRoot && baseInfo.kind == ISVNWCDb.SVNWCDbKind.File && !isRoot) {
                return;
            }
            if (skipWhenDir && baseInfo.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                return;
            }
            if (!isRoot && (baseInfo.status == ISVNWCDb.SVNWCDbStatus.NotPresent || baseInfo.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded && baseInfo.revision != newRevision)) {
                SVNWCDb.this.removeBase(SVNFileUtil.createFilePath(wcRoot, localRelPath));
                return;
            }
            boolean setReposRelPath = false;
            if (newReposRelPath != null && !baseInfo.reposRelPath.equals(newReposRelPath)) {
                setReposRelPath = true;
            }
            if (setReposRelPath || newRevision >= 0L && newRevision != baseInfo.revision) {
                SVNWCDb.this.opSetRevAndReposRelpath(root, localRelPath, newRevision, setReposRelPath, newReposRelPath, this.newReposRootURL, this.newReposUUID);
            }
            if (depth.compareTo(SVNDepth.EMPTY) <= 0 || baseInfo.kind != ISVNWCDb.SVNWCDbKind.Dir || baseInfo.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || baseInfo.status == ISVNWCDb.SVNWCDbStatus.Excluded || baseInfo.status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                return;
            }
            SVNDepth depthBelowHere = depth;
            if (depth == SVNDepth.IMMEDIATES || depth == SVNDepth.FILES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            Map<String, ISVNWCDb.WCDbBaseInfo> children = SVNWCDb.this.getBaseChildrenMap(root, localRelPath, false);
            for (String child : children.keySet()) {
                File childReposRelPath = null;
                File childLocalRelPath = SVNFileUtil.createFilePath(localRelPath, child);
                if (newReposRelPath != null) {
                    childReposRelPath = SVNFileUtil.createFilePath(newReposRelPath, child);
                }
                this.bumpNodeRevision(root, wcRoot, childLocalRelPath, children.get(child), reposId, childReposRelPath, newRevision, depthBelowHere, exludedRelPaths, false, depth.compareTo(SVNDepth.IMMEDIATES) < 0);
            }
        }
    }

    private class MakeCopy
    implements SVNSqlJetTransaction {
        File localAbspath;
        SVNWCDbDir pdh;
        File localRelpath;
        long opDepth;

        private MakeCopy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            boolean removeWorking = false;
            boolean addWorkingBaseDeleted = false;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
            stmt.bindf("is", this.pdh.getWCRoot().getWcId(), this.localRelpath);
            try {
                boolean haveRow = stmt.next();
                if (haveRow) {
                    ISVNWCDb.SVNWCDbStatus workingStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    long workingOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    assert (workingStatus == ISVNWCDb.SVNWCDbStatus.Normal || workingStatus == ISVNWCDb.SVNWCDbStatus.BaseDeleted || workingStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || workingStatus == ISVNWCDb.SVNWCDbStatus.Incomplete);
                    if (workingOpDepth <= this.opDepth) {
                        addWorkingBaseDeleted = true;
                        if (workingStatus == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                            removeWorking = true;
                        }
                    }
                }
            }
            finally {
                stmt.reset();
            }
            if (removeWorking) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_LOWEST_WORKING_NODE);
                try {
                    stmt.bindf("is", this.pdh.getWCRoot().getWcId(), this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            if (addWorkingBaseDeleted) {
                stmt = db.getStatement(SVNWCDbStatements.INSERT_DELETE_FROM_BASE);
                try {
                    stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, this.opDepth);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            stmt = db.getStatement(SVNWCDbStatements.INSERT_WORKING_NODE_FROM_BASE_COPY);
            try {
                stmt.bindf("isi", this.pdh.getWCRoot().getWcId(), this.localRelpath, this.opDepth);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            List<String> children = SVNWCDb.this.gatherRepoChildren(this.pdh, this.localRelpath, 0L);
            for (String name : children) {
                MakeCopy cbt = new MakeCopy();
                cbt.localAbspath = SVNFileUtil.createFilePath(this.localAbspath, name);
                DirParsedInfo parseDir = SVNWCDb.this.parseDir(cbt.localAbspath, SVNSqlJetDb.Mode.ReadWrite);
                cbt.pdh = parseDir.wcDbDir;
                cbt.localRelpath = parseDir.localRelPath;
                SVNWCDb.verifyDirUsable(cbt.pdh);
                cbt.opDepth = this.opDepth;
                cbt.transaction(db);
            }
            this.pdh.flushEntries(this.localAbspath);
        }
    }

    private class StartDirectoryUpdate
    implements SVNSqlJetTransaction {
        public long wcId;
        public File localRelpath;
        public long newRevision;
        public File newReposRelpath;

        private StartDirectoryUpdate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.UPDATE_BASE_NODE_PRESENCE_REVNUM_AND_REPOS_PATH);
            try {
                stmt.bindf("istis", this.wcId, this.localRelpath, SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.Incomplete), this.newRevision, this.newReposRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    public static class ReposInfo {
        public String reposRootUrl;
        public String reposUuid;
    }

    private class BaseRemove
    implements SVNSqlJetTransaction {
        public long wcId;
        public File localRelpath;

        private BaseRemove() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            boolean haveRow = false;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.DELETE_BASE_NODE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            this.retractParentDelete(db);
            stmt = db.getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                haveRow = stmt.next();
            }
            finally {
                stmt.reset();
            }
            if (!haveRow) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_WITHOUT_CONFLICT);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retractParentDelete(SVNSqlJetDb db) throws SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.DELETE_LOWEST_WORKING_NODE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static class GatheredChildItem
    extends ISVNWCDb.SVNWCDbInfo {
        public int layersCount;
        public long opDepth;

        private GatheredChildItem() {
        }
    }

    private class GatherChildren
    implements SVNSqlJetTransaction {
        Map<String, ISVNWCDb.SVNWCDbInfo> nodes;
        Set<String> conflicts;
        File dirRelPath;
        SVNWCDbRoot wcRoot;

        private GatherChildren() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            ISVNWCDb.WCDbRepositoryInfo reposInfo = new ISVNWCDb.WCDbRepositoryInfo();
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_NODE_CHILDREN_INFO);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.dirRelPath);
                boolean haveRow = stmt.next();
                while (haveRow) {
                    File childRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath));
                    String name = SVNFileUtil.getFileName(childRelPath);
                    GatheredChildItem childItem = (GatheredChildItem)this.nodes.get(name);
                    boolean newChild = false;
                    if (childItem == null) {
                        newChild = true;
                        childItem = new GatheredChildItem();
                    }
                    long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    if (newChild || opDepth > childItem.opDepth) {
                        childItem.opDepth = opDepth;
                        childItem.kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                        childItem.status = SvnWcDbStatementUtil.getColumnPresence(stmt);
                        if (opDepth != 0L) {
                            childItem.incomplete = childItem.status == ISVNWCDb.SVNWCDbStatus.Incomplete;
                            childItem.status = SVNWCDb.getWorkingStatus(childItem.status);
                        }
                        if (opDepth != 0L) {
                            childItem.revnum = -1L;
                            childItem.reposRelpath = null;
                        } else {
                            childItem.revnum = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision);
                            childItem.reposRelpath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                        }
                        if (opDepth != 0L || SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id)) {
                            childItem.reposRootUrl = null;
                            childItem.reposUuid = null;
                        } else {
                            long reposId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id);
                            if (reposInfo.rootUrl == null) {
                                SVNWCDb.fetchReposInfo(reposInfo, db, reposId);
                            }
                            childItem.reposRootUrl = reposInfo.rootUrl;
                            childItem.reposUuid = reposInfo.uuid;
                        }
                        childItem.changedRev = SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.changed_revision);
                        childItem.changedDate = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.changed_date));
                        childItem.changedAuthor = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author);
                        if (childItem.kind != ISVNWCDb.SVNWCDbKind.Dir) {
                            childItem.depth = SVNDepth.UNKNOWN;
                        } else {
                            childItem.depth = SvnWcDbStatementUtil.getColumnDepth(stmt, SVNWCDbSchema.NODES__Fields.depth);
                            if (newChild) {
                                childItem.locked = SVNWCDb.this.isWCLocked(this.wcRoot, childRelPath, 0L);
                            }
                        }
                        childItem.recordedModTime = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.last_mod_time);
                        childItem.recordedSize = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.translated_size);
                        childItem.hasChecksum = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.checksum);
                        boolean bl = childItem.hadProps = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.properties) && SvnWcDbStatementUtil.getColumnBlob(stmt, SVNWCDbSchema.NODES__Fields.properties).length > 2;
                        if (childItem.hadProps) {
                            SVNProperties properties = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties);
                            boolean bl2 = childItem.special = properties.getSVNPropertyValue("svn:special") != null;
                        }
                        childItem.opRoot = opDepth == 0L ? false : opDepth == (long)SVNWCUtils.relpathDepth(childRelPath);
                        this.nodes.put(name, childItem);
                    }
                    if (opDepth == 0L) {
                        childItem.haveBase = true;
                        SVNSqlJetStatement lockStmt = stmt.getJoinedStatement(SVNWCDbSchema.LOCK);
                        if (lockStmt != null && !lockStmt.eof()) {
                            childItem.lock = new ISVNWCDb.SVNWCDbLock();
                            childItem.lock.token = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token);
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner)) {
                                childItem.lock.owner = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_owner);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment)) {
                                childItem.lock.comment = SvnWcDbStatementUtil.getColumnText(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_comment);
                            }
                            if (!SvnWcDbStatementUtil.isColumnNull(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date)) {
                                childItem.lock.date = SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_date));
                            }
                        }
                    } else {
                        ++childItem.layersCount;
                        childItem.haveMoreWork = childItem.layersCount > 1;
                    }
                    haveRow = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            stmt = db.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
            try {
                stmt.bindf("is", this.wcRoot.getWcId(), this.dirRelPath);
                while (stmt.next()) {
                    File childRelPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath));
                    String name = SVNFileUtil.getFileName(childRelPath);
                    GatheredChildItem childItem = (GatheredChildItem)this.nodes.get(name);
                    if (childItem == null) {
                        childItem = new GatheredChildItem();
                        childItem.status = ISVNWCDb.SVNWCDbStatus.NotPresent;
                    }
                    childItem.changelist = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist);
                    boolean bl = childItem.propsMod = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                    if (childItem.propsMod) {
                        SVNProperties properties = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                        childItem.special = properties.getSVNPropertyValue("svn:special") != null;
                    }
                    boolean bl3 = childItem.conflicted = !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) || !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                    if (!childItem.conflicted) continue;
                    this.conflicts.add(name);
                }
            }
            finally {
                stmt.reset();
            }
        }
    }

    private class SetTreeConflict
    implements SVNSqlJetTransaction {
        public File localRelpath;
        public long wcId;
        public File parentRelpath;
        public SVNTreeConflictDescription treeConflict;

        private SetTreeConflict() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            boolean haveRow;
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
            try {
                stmt.bindf("is", this.wcId, this.localRelpath);
                haveRow = stmt.next();
            }
            finally {
                stmt.reset();
            }
            String treeConflictData = this.treeConflict != null ? SVNTreeConflictUtil.getSingleTreeConflictData(this.treeConflict) : null;
            try {
                stmt = haveRow ? db.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_TREE_CONFLICTS) : db.getStatement(SVNWCDbStatements.INSERT_ACTUAL_TREE_CONFLICTS);
                stmt.bindf("iss", this.wcId, this.localRelpath, treeConflictData);
                if (!haveRow) {
                    stmt.bindString(4, SVNFileUtil.getFilePath(this.parentRelpath));
                } else {
                    stmt.bindNull(4);
                }
                stmt.done();
            }
            finally {
                if (stmt != null) {
                    stmt.reset();
                }
            }
            if (treeConflictData == null) {
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_EMPTY);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    private class SetProperties
    implements SVNSqlJetTransaction {
        SVNProperties props;
        SVNWCDbDir pdh;
        File localRelpath;
        SVNSkel conflict;
        SVNSkel workItems;
        boolean clearRecordedInfo;

        private SetProperties() {
        }

        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNProperties propDiffs;
            assert (this.conflict == null);
            SVNWCDb.this.addWorkItems(db, this.workItems);
            SVNProperties pristineProps = SvnWcDbProperties.readPristineProperties(this.pdh.getWCRoot(), this.localRelpath);
            if (this.props != null && pristineProps != null && (propDiffs = SVNWCUtils.propDiffs(this.props, pristineProps)).isEmpty()) {
                this.props = null;
            }
            SVNWCDb.this.setActualProperties(db, this.pdh.getWCRoot().getWcId(), this.localRelpath, this.props);
            if (this.clearRecordedInfo) {
                RecordFileinfo rfi = new RecordFileinfo();
                rfi.lastModTime = SVNDate.NULL;
                rfi.translatedSize = -1L;
                rfi.localRelpath = this.localRelpath;
                rfi.wcRoot = this.pdh.getWCRoot();
                rfi.transaction(db);
            }
        }
    }

    public static class DirParsedInfo {
        public SVNWCDbDir wcDbDir;
        public File localRelPath;
    }

    private class RecordFileinfo
    implements SVNSqlJetTransaction {
        public SVNDate lastModTime;
        public long translatedSize;
        public File localRelpath;
        public SVNWCDbRoot wcRoot;

        private RecordFileinfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.UPDATE_NODE_FILEINFO);
            try {
                stmt.bindf("isii", this.wcRoot.getWcId(), this.localRelpath, this.translatedSize, this.lastModTime);
                long affectedRows = stmt.done();
                assert (affectedRows == 1L);
            }
            finally {
                stmt.reset();
            }
        }
    }

    public class InsertWorking
    implements SVNSqlJetTransaction {
        public ISVNWCDb.SVNWCDbStatus status;
        public ISVNWCDb.SVNWCDbKind kind;
        public File reposRelpath;
        public SVNProperties props;
        public long changedRev = -1L;
        public SVNDate changedDate;
        public String changedAuthor;
        public List<File> children;
        public SVNDepth depth = SVNDepth.INFINITY;
        public SvnChecksum checksum;
        public File target;
        public SVNSkel workItems;
        public long wcId;
        public File localRelpath;
        public File originalReposRelPath;
        public long originalReposId;
        public long originalRevision;
        public long opDepth;
        public long notPresentOpDepth;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            File parentRelpath = SVNFileUtil.getFileDir(this.localRelpath);
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
            try {
                stmt.bindf("isisnnntstrisnnnnns", this.wcId, this.localRelpath, this.opDepth, parentRelpath, SvnWcDbStatementUtil.getPresenceText(this.status), this.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.asString(this.depth) : null, SvnWcDbStatementUtil.getKindText(this.kind), this.changedRev, this.changedDate, this.changedAuthor, this.kind == ISVNWCDb.SVNWCDbKind.Symlink ? this.target : null);
                if (this.kind == ISVNWCDb.SVNWCDbKind.File) {
                    stmt.bindChecksum(14, this.checksum);
                }
                if (this.originalReposRelPath != null) {
                    stmt.bindLong(5, this.originalReposId);
                    stmt.bindString(6, SVNFileUtil.getFilePath(this.originalReposRelPath));
                    stmt.bindLong(7, this.originalRevision);
                }
                stmt.bindProperties(15, this.props);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (this.kind == ISVNWCDb.SVNWCDbKind.Dir && this.children != null) {
                SVNWCDb.this.insertIncompleteChildren(db, this.wcId, this.localRelpath, this.originalRevision, this.children, this.opDepth);
            }
            if (this.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                stmt = db.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CLEAR_CHANGELIST);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
                stmt = db.getStatement(SVNWCDbStatements.DELETE_ACTUAL_EMPTY);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            SVNWCDb.this.addWorkItems(db, this.workItems);
            if (this.notPresentOpDepth > 0L && this.notPresentOpDepth < this.opDepth) {
                stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
                try {
                    stmt.bindf("isisisrtnt", this.wcId, this.localRelpath, this.notPresentOpDepth, parentRelpath, this.originalReposId, this.originalReposRelPath, this.originalRevision, SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.NotPresent), SvnWcDbStatementUtil.getKindText(this.kind));
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
        }
    }

    public class InsertBase
    implements SVNSqlJetTransaction {
        public ISVNWCDb.SVNWCDbStatus status;
        public ISVNWCDb.SVNWCDbKind kind;
        public long reposId = -1L;
        public File reposRelpath;
        public long revision = -1L;
        public SVNURL reposRootURL;
        public String reposUUID;
        public SVNProperties props;
        public long changedRev = -1L;
        public SVNDate changedDate;
        public String changedAuthor;
        public SVNProperties davCache;
        public List<File> children;
        public SVNDepth depth = SVNDepth.INFINITY;
        public SvnChecksum checksum;
        public File target;
        public boolean fileExternal;
        public SVNSkel conflict;
        public boolean updateActualProps;
        public SVNProperties actualProps;
        public boolean insertBaseDeleted;
        public boolean keepRecordedInfo;
        public SVNSkel workItems;
        public long wcId;
        public File localRelpath;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt;
            assert (this.conflict == null);
            long recordedSize = -1L;
            long recordedModTime = 0L;
            File parentRelpath = SVNFileUtil.getFileDir(this.localRelpath);
            if (this.reposId == -1L) {
                this.reposId = SVNWCDb.this.createReposId(db, this.reposRootURL, this.reposUUID);
            }
            if (this.keepRecordedInfo) {
                stmt = db.getStatement(SVNWCDbStatements.SELECT_BASE_NODE);
                try {
                    stmt.bindf("is", this.wcId, this.localRelpath);
                    boolean haveRow = stmt.next();
                    if (haveRow) {
                        recordedSize = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.translated_size);
                        recordedModTime = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.last_mod_time);
                    }
                }
                finally {
                    stmt.reset();
                }
            }
            stmt = db.getStatement(SVNWCDbStatements.INSERT_NODE);
            try {
                stmt.bindf("isisisrtstrisnnnnns", this.wcId, this.localRelpath, 0, parentRelpath, this.reposId, this.reposRelpath, this.revision, SvnWcDbStatementUtil.getPresenceText(this.status), this.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNDepth.asString(this.depth) : null, SvnWcDbStatementUtil.getKindText(this.kind), this.changedRev, this.changedDate, this.changedAuthor, this.kind == ISVNWCDb.SVNWCDbKind.Symlink ? this.target : null);
                if (this.kind == ISVNWCDb.SVNWCDbKind.File) {
                    stmt.bindChecksum(14, this.checksum);
                    if (recordedSize != -1L) {
                        stmt.bindLong(16, recordedSize);
                        stmt.bindLong(17, recordedModTime);
                    } else {
                        stmt.bindNull(16);
                        stmt.bindNull(17);
                    }
                } else {
                    stmt.bindNull(14);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                }
                stmt.bindProperties(15, this.props);
                if (this.davCache != null) {
                    stmt.bindProperties(18, this.davCache);
                } else {
                    stmt.bindNull(18);
                }
                if (this.fileExternal) {
                    stmt.bindString(20, "1");
                } else {
                    stmt.bindNull(20);
                }
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (this.updateActualProps) {
                SVNProperties diff;
                SVNProperties baseProps = this.props;
                SVNProperties newActualProps = this.actualProps;
                if (baseProps != null && newActualProps != null && baseProps.size() == newActualProps.size() && (diff = newActualProps.compareTo(baseProps)).size() == 0) {
                    newActualProps = null;
                }
                SVNWCDb.this.setActualProperties(db, this.wcId, this.localRelpath, newActualProps);
            }
            if (this.kind == ISVNWCDb.SVNWCDbKind.Dir && this.children != null) {
                SVNWCDb.this.insertIncompleteChildren(db, this.wcId, this.localRelpath, this.revision, this.children, 0L);
            }
            if (parentRelpath != null) {
                if (!(this.localRelpath == null || this.status != ISVNWCDb.SVNWCDbStatus.Normal && this.status != ISVNWCDb.SVNWCDbStatus.Incomplete || this.fileExternal)) {
                    SVNWCDb.this.extendParentDelete(db, this.wcId, this.localRelpath);
                } else if (this.status == ISVNWCDb.SVNWCDbStatus.NotPresent || this.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || this.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    SVNWCDb.this.retractParentDelete(db, this.wcId, this.localRelpath);
                }
            }
            if (this.insertBaseDeleted) {
                stmt = db.getStatement(SVNWCDbStatements.INSERT_DELETE_FROM_BASE);
                try {
                    stmt.bindf("isi", this.wcId, this.localRelpath, SVNWCUtils.relpathDepth(this.localRelpath));
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            SVNWCDb.this.addWorkItems(db, this.workItems);
        }
    }

    private class InsertLock
    implements SVNSqlJetTransaction {
        public File localAbsPath;
        public ISVNWCDb.SVNWCDbLock lock;

        private InsertLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            ISVNWCDb.WCDbBaseInfo baseInfo = SVNWCDb.this.getBaseInfo(this.localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposId);
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.INSERT_LOCK);
            try {
                stmt.bindf("issssi", baseInfo.reposId, baseInfo.reposRelPath, this.lock.token, this.lock.owner != null ? this.lock.owner : null, this.lock.comment != null ? this.lock.comment : null, this.lock.date != null ? this.lock.date : null);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    private class Delete
    implements SVNSqlJetTransaction {
        public SVNWCDbRoot root;
        public File localRelPath;
        public long deleteDepth;
        public ISVNEventHandler eventHandler;

        private Delete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            long selectDepth;
            ISVNWCDb.WCDbInfo info = SVNWCDb.this.readInfo(this.root, this.localRelPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.opRoot);
            ISVNWCDb.SVNWCDbStatus status = info.status;
            if (status == ISVNWCDb.SVNWCDbStatus.Deleted || status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                return;
            }
            SVNSqlJetStatement stmt = this.root.getSDb().getStatement(SVNWCDbStatements.HAS_SERVER_EXCLUDED_NODES);
            try {
                stmt.bindf("is", this.root.getWcId(), this.localRelPath);
                if (stmt.next()) {
                    File absentPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot delete ''{0}'' as ''{1}'' is excluded by server", this.localRelPath, absentPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            finally {
                stmt.reset();
            }
            boolean addWork = false;
            boolean refetchDepth = false;
            if (info.opRoot) {
                ISVNWCDb.WCDbInfo infoBelow = SVNWCDb.this.readInfoBelowWorking(this.root, this.localRelPath, -1);
                if ((infoBelow.haveBase || infoBelow.haveWork) && infoBelow.status != ISVNWCDb.SVNWCDbStatus.NotPresent && infoBelow.status != ISVNWCDb.SVNWCDbStatus.Deleted) {
                    addWork = true;
                    refetchDepth = true;
                }
                selectDepth = SVNWCUtils.relpathDepth(this.localRelPath);
            } else {
                addWork = true;
                selectDepth = SVNWCDb.this.readOpDepth(this.root, this.localRelPath);
            }
            stmt = new SVNWCDbCreateSchema(this.root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DELETE_LIST, -1);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (this.eventHandler != null) {
                stmt = new SVNWCDbInsertDeleteList(this.root.getSDb());
                try {
                    stmt.bindf("isi", this.root.getWcId(), this.localRelPath, selectDepth);
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            SVNSqlJetStatement deleteStmt = this.root.getSDb().getStatement(SVNWCDbStatements.DELETE_NODES_RECURSIVE);
            try {
                deleteStmt.bindf("isi", this.root.getWcId(), this.localRelPath, this.deleteDepth);
                deleteStmt.done();
            }
            finally {
                deleteStmt.reset();
            }
            if (refetchDepth) {
                selectDepth = SVNWCDb.this.readOpDepth(this.root, this.localRelPath);
            }
            deleteStmt = this.root.getSDb().getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
            try {
                deleteStmt.bindf("is", this.root.getWcId(), this.localRelPath);
                deleteStmt.done();
            }
            finally {
                deleteStmt.reset();
            }
            deleteStmt = this.root.getSDb().getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
            try {
                deleteStmt.bindf("is", this.root.getWcId(), this.localRelPath);
                deleteStmt.done();
            }
            finally {
                deleteStmt.reset();
            }
            deleteStmt = this.root.getSDb().getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN_RECURSIVE);
            try {
                deleteStmt.bindf("is", this.root.getWcId(), this.localRelPath);
                deleteStmt.done();
            }
            finally {
                deleteStmt.reset();
            }
            if (addWork) {
                SVNSqlJetStatement insertStmt = this.root.getSDb().getStatement(SVNWCDbStatements.INSERT_DELETE_FROM_NODE_RECURSIVE);
                try {
                    insertStmt.bindf("isii", this.root.getWcId(), this.localRelPath, selectDepth, this.deleteDepth);
                    insertStmt.done();
                }
                finally {
                    insertStmt.reset();
                }
            }
        }
    }

    private static class CreateDbInfo {
        public SVNSqlJetDb sDb;
        public long reposId;
        public long wcId;

        private CreateDbInfo() {
        }
    }
}

