/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;

public class PluginBlock
extends AbstractPluginBlock {
    protected ILaunchConfiguration fLaunchConfig;
    protected boolean fIsEnabled = false;
    protected boolean fInitDefaultCheckState = false;

    public PluginBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void initializeFrom(ILaunchConfiguration config, boolean enableTable) throws CoreException {
        if (this.fLaunchConfig != null && this.fLaunchConfig.equals(config) && this.fIsEnabled == enableTable) {
            return;
        }
        this.fLaunchConfig = config;
        this.fIsEnabled = enableTable;
        super.initializeFrom(config, enableTable);
        if (enableTable) {
            this.initWorkspacePluginsState(config);
            this.initExternalPluginsState(config);
            this.handleFilterButton();
            if (this.fLaunchConfig.isWorkingCopy()) {
                this.savePluginState((ILaunchConfigurationWorkingCopy)this.fLaunchConfig);
            }
        }
        this.enableViewer(enableTable);
        this.updateCounter();
        this.fTab.updateLaunchConfigurationDialog();
    }

    public void initialize(boolean enable) throws CoreException {
        if (this.fLaunchConfig != null) {
            this.fInitDefaultCheckState = enable && !this.fLaunchConfig.hasAttribute("selected_workspace_plugins") && !this.fLaunchConfig.hasAttribute("selected_target_plugins");
            this.fTab.updateLaunchConfigurationDialog();
            this.initializeFrom(this.fLaunchConfig, enable);
        }
    }

    protected void initWorkspacePluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap((ILaunchConfiguration)configuration, null, (String)"selected_workspace_plugins");
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumWorkspaceChecked = map.size();
        this.resetGroup(this.fWorkspacePlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.getWorkspaceModels().length);
    }

    protected void initExternalPluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap((ILaunchConfiguration)configuration, (Set)Collections.EMPTY_SET, (String)"selected_target_plugins");
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumExternalChecked = map.size();
        this.resetGroup(this.fExternalPlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.getExternalModels().length);
    }

    protected boolean isEnabled() {
        return this.fIsEnabled;
    }

    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        if (this.isEnabled() || this.fInitDefaultCheckState) {
            IPluginModelBase[] workspaceModels;
            AbstractPluginBlock.PluginModelNameBuffer wBuffer = new AbstractPluginBlock.PluginModelNameBuffer();
            AbstractPluginBlock.PluginModelNameBuffer tBuffer = new AbstractPluginBlock.PluginModelNameBuffer();
            if (this.fInitDefaultCheckState) {
                TreeSet<String> checkedWorkspace = new TreeSet<String>();
                workspaceModels = this.getWorkspaceModels();
                int i = 0;
                while (i < workspaceModels.length) {
                    String id = workspaceModels[i].getPluginBase().getId();
                    if (id != null) {
                        checkedWorkspace.add(id);
                    }
                    ++i;
                }
                IPluginModelBase[] externalModels = this.getExternalModels();
                int i2 = 0;
                while (i2 < externalModels.length) {
                    IPluginModelBase model = externalModels[i2];
                    boolean masked = checkedWorkspace.contains(model.getPluginBase().getId());
                    if (masked) {
                        wBuffer.add(model);
                    } else if (model.isEnabled()) {
                        tBuffer.add(model);
                    }
                    ++i2;
                }
                this.fInitDefaultCheckState = false;
            } else {
                Object[] selected = this.fPluginTreeViewer.getCheckedElements();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i] instanceof IPluginModelBase) {
                        IPluginModelBase model = (IPluginModelBase)selected[i];
                        if (model.getUnderlyingResource() == null) {
                            tBuffer.add(model);
                        } else {
                            wBuffer.add(model);
                        }
                    }
                    ++i;
                }
            }
            config.setAttribute("selected_workspace_plugins", wBuffer.toString());
            config.setAttribute("selected_target_plugins", tBuffer.toString());
            AbstractPluginBlock.PluginModelNameBuffer buffer = new AbstractPluginBlock.PluginModelNameBuffer();
            if (this.fAddWorkspaceButton.getSelection()) {
                workspaceModels = this.getWorkspaceModels();
                int i = 0;
                while (i < workspaceModels.length) {
                    if (!this.fPluginTreeViewer.getChecked((Object)workspaceModels[i])) {
                        buffer.add(workspaceModels[i]);
                    }
                    ++i;
                }
            }
            config.setAttribute("deselected_workspace_plugins", buffer.toString());
        }
    }

    protected void addRequiredPlugins() {
        try {
            String[] requiredIds = RequirementHelper.getApplicationRequirements((ILaunchConfiguration)this.fLaunchConfig);
            int i = 0;
            while (i < requiredIds.length) {
                IPluginModelBase base = this.findPlugin(requiredIds[i]);
                if (base == null && (base = PluginRegistry.findModel((String)requiredIds[i])) != null) {
                    this.fPluginTreeViewer.setChecked((Object)base, true);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        super.addRequiredPlugins();
    }

    protected LaunchValidationOperation createValidationOperation() {
        return new EclipsePluginValidationOperation(this.fLaunchConfig);
    }
}

