/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.client;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class PeekStatusCommand {
    private final IResource resource;
    private final IPath path;
    private ISVNStatus status = null;
    private ISVNInfo info = null;
    protected SVNRevision.Number revision;

    public PeekStatusCommand(IResource resource) {
        this.resource = resource;
        this.path = null;
    }

    public PeekStatusCommand(IPath path) {
        this.resource = null;
        this.path = path;
    }

    public void execute() throws SVNException {
        ISVNClientAdapter client = null;
        ISVNNotifyListener revisionListener = new ISVNNotifyListener(){

            public void setCommand(int command) {
            }

            public void logCommandLine(String commandLine) {
            }

            public void logMessage(String message) {
            }

            public void logError(String message) {
            }

            public void logRevision(long aRevision, String path) {
                PeekStatusCommand.this.revision = new SVNRevision.Number(aRevision);
            }

            public void logCompleted(String message) {
            }

            public void onNotify(File path, SVNNodeKind kind) {
            }
        };
        try {
            try {
                client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                client.addNotifyListener(revisionListener);
                File file = this.resource != null ? this.resource.getLocation().toFile() : this.path.toFile();
                this.status = null;
                ISVNStatus[] statuses = client.getStatus(file, false, true, false);
                int i = 0;
                while (i < statuses.length) {
                    if (file.equals(statuses[i].getFile())) {
                        this.status = statuses[i];
                        if (this.status.getUrl() == null && this.status.getTextStatus() != SVNStatusKind.UNVERSIONED) {
                            this.info = client.getInfo(this.status.getFile());
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            if (client != null) {
                client.removeNotifyListener(revisionListener);
                SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
            }
        }
    }

    public ISVNStatus getStatus() {
        return this.status;
    }

    public LocalResourceStatus getLocalResourceStatus() {
        return this.status != null ? new LocalResourceStatus(this.status, this.getURL(this.status)) : null;
    }

    public SVNRevision.Number getRevision() {
        return this.revision;
    }

    private String getURL(ISVNStatus status) {
        String url = status.getUrlString();
        if (url == null && this.info != null) {
            SVNUrl svnurl = this.info.getUrl();
            url = svnurl != null ? svnurl.toString() : null;
        }
        return url;
    }
}

