/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.resources.LocalFile;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNMoveDeleteHook
implements IMoveDeleteHook {
    private static Set<IFile> deletedFiles = new HashSet<IFile>();

    private void deleteResource(ISVNLocalResource resource) throws SVNException {
        ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
        try {
            try {
                svnClient.remove(new File[]{resource.getResource().getLocation().toFile()}, true);
            }
            catch (SVNClientException e) {
                throw new SVNException(4, -6, e.getMessage(), e);
            }
        }
        finally {
            resource.getRepository().returnSVNClient(svnClient);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        if (SVNWorkspaceRoot.isLinkedResource((IResource)file)) {
            return false;
        }
        LocalFile resource = new LocalFile(file);
        try {
            if (!resource.isManaged()) {
                return false;
            }
        }
        catch (SVNException e) {
            tree.failed(e.getStatus());
            return true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            if (this.getDeferFileDelete((IResource)file)) {
                return false;
            }
            monitor.beginTask(null, 1000);
            deletedFiles.add(file);
            this.deleteResource(resource);
            tree.deletedFile(file);
            return true;
        }
    }

    public static boolean isDeleted(IFile file) {
        return deletedFiles.contains(file);
    }

    public static void removeFromDeletedFileList(IFile file) {
        deletedFiles.remove(file);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        LocalFolder resource;
        block7: {
            if (SVNWorkspaceRoot.isLinkedResource((IResource)folder)) {
                return false;
            }
            resource = new LocalFolder((IContainer)folder);
            if (resource.isManaged()) break block7;
            monitor.done();
            return false;
        }
        try {
            try {
                monitor.beginTask(null, 1000);
                this.deleteResource(resource);
                tree.deletedFolder(folder);
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        LocalFile resource;
        RepositoryProvider repositoryProvider;
        block17: {
            if (SVNWorkspaceRoot.isLinkedResource((IResource)source)) {
                return false;
            }
            repositoryProvider = RepositoryProvider.getProvider((IProject)destination.getProject());
            if (repositoryProvider == null || !(repositoryProvider instanceof SVNTeamProvider)) {
                throw new SVNException(Policy.bind("SVNMoveHook.moveFileException"));
            }
            resource = new LocalFile(source);
            if (resource.isManaged()) break block17;
            monitor.done();
            return false;
        }
        try {
            try {
                ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
                monitor.beginTask(null, 1000);
                try {
                    try {
                        OperationManager.getInstance().beginOperation(svnClient);
                        if (!SVNWorkspaceRoot.getSVNFolderFor(destination.getParent()).isManaged()) {
                            SVNTeamProvider provider = (SVNTeamProvider)repositoryProvider;
                            provider.add(new IResource[]{destination.getParent()}, 0, (IProgressMonitor)new NullProgressMonitor());
                            ISVNLocalResource parent = SVNWorkspaceRoot.getSVNResourceFor((IResource)destination.getParent());
                            if (parent != null) {
                                parent.refreshStatus();
                            }
                        }
                        svnClient.move(source.getLocation().toFile(), destination.getLocation().toFile(), true);
                        tree.movedFile(source, destination);
                        destination.refreshLocal(0, monitor);
                    }
                    catch (SVNClientException e) {
                        throw SVNException.wrapException((Exception)((Object)e));
                    }
                    catch (TeamException e) {
                        throw SVNException.wrapException(e);
                    }
                    catch (CoreException e) {
                        throw SVNException.wrapException(e);
                    }
                }
                finally {
                    resource.getRepository().returnSVNClient(svnClient);
                    OperationManager.getInstance().endOperation(false, null, false);
                }
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        LocalFolder resource;
        block16: {
            if (SVNWorkspaceRoot.isLinkedResource((IResource)source)) {
                return false;
            }
            resource = new LocalFolder((IContainer)source);
            if (resource.isManaged()) break block16;
            monitor.done();
            return false;
        }
        try {
            try {
                RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)destination.getProject());
                if (repositoryProvider == null || !(repositoryProvider instanceof SVNTeamProvider)) {
                    throw new SVNException(Policy.bind("SVNMoveHook.moveFolderException"));
                }
                monitor.beginTask(null, 1000);
                ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
                try {
                    try {
                        OperationManager.getInstance().beginOperation(svnClient);
                        if (!SVNWorkspaceRoot.getSVNFolderFor(destination.getParent()).isManaged()) {
                            SVNTeamProvider provider = (SVNTeamProvider)repositoryProvider;
                            provider.add(new IResource[]{destination.getParent()}, 0, (IProgressMonitor)new NullProgressMonitor());
                            ISVNLocalResource parent = SVNWorkspaceRoot.getSVNResourceFor((IResource)destination.getParent());
                            if (parent != null) {
                                parent.refreshStatus();
                            }
                        }
                        svnClient.move(source.getLocation().toFile(), destination.getLocation().toFile(), true);
                        tree.movedFolderSubtree(source, destination);
                        destination.refreshLocal(2, monitor);
                    }
                    catch (SVNClientException e) {
                        throw SVNException.wrapException((Exception)((Object)e));
                    }
                    catch (CoreException e) {
                        throw SVNException.wrapException(e);
                    }
                }
                finally {
                    resource.getRepository().returnSVNClient(svnClient);
                    OperationManager.getInstance().endOperation(false);
                }
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        block11: {
            File databaseFile;
            block10: {
                File metaFolder;
                block9: {
                    block8: {
                        LocalFolder resource;
                        block7: {
                            resource = new LocalFolder((IContainer)project);
                            try {
                                if ((updateFlags & 8) != 8) break block7;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (resource.isManaged()) break block8;
                        return false;
                    }
                    File projectDirectory = new File(project.getLocationURI());
                    metaFolder = new File(projectDirectory, ".svn");
                    if (metaFolder.exists()) break block9;
                    return false;
                }
                databaseFile = new File(metaFolder, "wc.db");
                if (databaseFile.exists()) break block10;
                return false;
            }
            if (!databaseFile.delete()) break block11;
            return false;
        }
        SVNProviderPlugin.handleMessage(Policy.bind("SVNMoveDeleteHook.4"), String.valueOf(Policy.bind("SVNMoveDeleteHook.5")) + project.getName() + Policy.bind("SVNMoveDeleteHook.6"), 2);
        return true;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    private boolean getDeferFileDelete(IResource resource) {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
        ISVNProperty property = null;
        try {
            if (svnResource.isManaged()) {
                property = svnResource.getSvnProperty("DeferFileDelete");
            }
        }
        catch (SVNException sVNException) {}
        if (property != null && property.getValue() != null && property.getValue().trim().length() > 0) {
            return property.getValue().equalsIgnoreCase("true");
        }
        IResource checkResource = resource;
        while (checkResource.getParent() != null) {
            if ((checkResource = checkResource.getParent()).getParent() == null) {
                return false;
            }
            svnResource = SVNWorkspaceRoot.getSVNResourceFor(checkResource);
            try {
                if (svnResource.isManaged()) {
                    property = svnResource.getSvnProperty("DeferFileDelete");
                }
            }
            catch (SVNException sVNException) {}
            if (property == null || property.getValue() == null || property.getValue().trim().length() <= 0) continue;
            return property.getValue().equalsIgnoreCase("true");
        }
        return false;
    }
}

