/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.status;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.status.IStatusCache;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatusUpdateStrategy {
    protected IStatusCache statusCache;

    public StatusUpdateStrategy(IStatusCache statusCache) {
        this.setStatusCache(statusCache);
    }

    public void setStatusCache(IStatusCache statusCache) {
        this.statusCache = statusCache;
    }

    abstract ISVNStatus[] statusesToUpdate(IResource var1) throws SVNException;

    protected ISVNStatus[] collectUnversionedFolders(ISVNStatus[] statuses, boolean recursive) {
        if (statuses == null) {
            return null;
        }
        ArrayList<ISVNStatus> processed = new ArrayList<ISVNStatus>();
        ISVNStatus[] iSVNStatusArray = statuses;
        int n = 0;
        int n2 = iSVNStatusArray.length;
        while (n < n2) {
            File folder;
            ISVNStatus status = iSVNStatusArray[n];
            processed.add(status);
            if (status.getNodeKind() != SVNNodeKind.FILE && status.getTextStatus() == SVNStatusKind.UNVERSIONED && ((folder = status.getFile()).isDirectory() || folder.exists())) {
                try {
                    HashSet<String> alreadyProcessed = new HashSet<String>();
                    this.processUnversionedFolder(folder, processed, recursive, alreadyProcessed);
                }
                catch (IOException e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
            ++n;
        }
        return processed.toArray(new ISVNStatus[processed.size()]);
    }

    void processUnversionedFolder(File folder, List<ISVNStatus> statuses, boolean recursive, Set<String> alreadyProcessed) throws IOException {
        String canonicalPath = folder.getCanonicalPath();
        if (alreadyProcessed.contains(canonicalPath)) {
            return;
        }
        alreadyProcessed.add(canonicalPath);
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            statuses.add((ISVNStatus)new SVNStatusUnversioned(file, false));
            if (recursive && file.isDirectory()) {
                this.processUnversionedFolder(file, statuses, recursive, alreadyProcessed);
            }
            ++n;
        }
    }
}

