/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.sync;

import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.BaseFile;
import org.tigris.subversion.subclipse.core.resources.BaseFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class SVNStatusSyncInfo
extends SyncInfo {
    private final LocalResourceStatus baseStatusInfo;
    private final RemoteResourceStatus remoteStatusInfo;

    public SVNStatusSyncInfo(IResource local, LocalResourceStatus baseStatusInfo, RemoteResourceStatus remoteStatusInfo, IResourceVariantComparator comparator) {
        super(local, SVNStatusSyncInfo.createBaseResourceVariant(local, baseStatusInfo), SVNStatusSyncInfo.createLatestResourceVariant(local, baseStatusInfo, remoteStatusInfo), comparator);
        this.baseStatusInfo = baseStatusInfo != null ? baseStatusInfo : LocalResourceStatus.NONE;
        this.remoteStatusInfo = remoteStatusInfo;
    }

    public SVNRevision getRepositoryRevision() {
        if (this.remoteStatusInfo != null) {
            SVNRevision.Number rev = this.remoteStatusInfo.getRepositoryRevision();
            if (rev != null && !SVNRevision.INVALID_REVISION.equals((Object)rev)) {
                return rev;
            }
            return SVNRevision.HEAD;
        }
        return SVNRevision.HEAD;
    }

    public IResourceVariant getRemote() {
        IResourceVariant theRemote = super.getRemote();
        if (theRemote != null && (8 == SyncInfo.getDirection((int)this.getKind()) || 12 == SyncInfo.getDirection((int)this.getKind()))) {
            return theRemote;
        }
        return super.getBase() != null ? super.getBase() : theRemote;
    }

    public String getLocalContentIdentifier() {
        return this.baseStatusInfo.getLastChangedRevision() != null ? this.baseStatusInfo.getLastChangedRevision().toString() : null;
    }

    public RemoteResourceStatus getRemoteResourceStatus() {
        return this.remoteStatusInfo;
    }

    protected int calculateKind() throws TeamException {
        SVNStatusKind localKind = this.baseStatusInfo.getStatusKind();
        SVNStatusKind repositoryKind = this.remoteStatusInfo != null ? this.remoteStatusInfo.getStatusKind() : SVNStatusKind.NORMAL;
        IResource local = this.getLocal();
        if (!local.exists() && local.getLocation() != null && !local.getLocation().toFile().exists()) {
            if (SVNStatusSyncInfo.isAddition(repositoryKind)) {
                return 9;
            }
            if (localKind == SVNStatusKind.UNVERSIONED) {
                return 0;
            }
            if (this.isDeletion(repositoryKind)) {
                return 0;
            }
            if (!repositoryKind.equals((Object)SVNStatusKind.ADDED)) {
                if (localKind == SVNStatusKind.NONE) {
                    return 0;
                }
                if (this.isChange(repositoryKind)) {
                    return 14;
                }
                return 6;
            }
            return 9;
        }
        if (this.isDeletion(localKind)) {
            if (this.isNotModified(repositoryKind)) {
                if (this.isOutOfDate()) {
                    return 14;
                }
                return 6;
            }
            return 14;
        }
        if (this.isChange(localKind)) {
            if (this.isChange(repositoryKind) || SVNStatusSyncInfo.isAddition(repositoryKind) || this.isDeletion(repositoryKind)) {
                return 15;
            }
            if ((2 == local.getType() || 4 == local.getType()) && this.isOutOfDate()) {
                return 15;
            }
            return 7;
        }
        if (SVNStatusSyncInfo.isAddition(localKind)) {
            if (SVNStatusSyncInfo.isAddition(repositoryKind)) {
                return 13;
            }
            return 5;
        }
        if (this.isNotModified(localKind)) {
            if (this.isNotModified(repositoryKind)) {
                if ((2 == local.getType() || 4 == local.getType()) && this.isOutOfDate()) {
                    return 11;
                }
                return 0;
            }
            if (localKind == SVNStatusKind.IGNORED && repositoryKind == SVNStatusKind.ADDED) {
                return 13;
            }
            if (repositoryKind == SVNStatusKind.DELETED) {
                return 10;
            }
            if (repositoryKind == SVNStatusKind.ADDED) {
                return 9;
            }
            if (repositoryKind == SVNStatusKind.EXTERNAL) {
                return 0;
            }
            return 11;
        }
        if (repositoryKind == SVNStatusKind.EXTERNAL ? localKind == SVNStatusKind.EXTERNAL : localKind == SVNStatusKind.EXTERNAL && this.remoteStatusInfo == null) {
            return 0;
        }
        return super.calculateKind();
    }

    private boolean isOutOfDate() {
        if (this.remoteStatusInfo == null || this.baseStatusInfo == null) {
            return false;
        }
        if (this.remoteStatusInfo.getLastChangedRevision() == null || this.baseStatusInfo.getLastChangedRevision() == null) {
            return false;
        }
        return this.remoteStatusInfo.getLastChangedRevision().getNumber() > this.baseStatusInfo.getLastChangedRevision().getNumber();
    }

    private boolean isDeletion(SVNStatusKind kind) {
        return kind == SVNStatusKind.DELETED || kind == SVNStatusKind.MISSING;
    }

    private boolean isChange(SVNStatusKind kind) {
        return kind == SVNStatusKind.MODIFIED || kind == SVNStatusKind.REPLACED || kind == SVNStatusKind.OBSTRUCTED || kind == SVNStatusKind.CONFLICTED || kind == SVNStatusKind.MERGED;
    }

    private boolean isNotModified(SVNStatusKind kind) {
        return kind == SVNStatusKind.NORMAL || kind == SVNStatusKind.IGNORED || kind == SVNStatusKind.NONE;
    }

    private static boolean isAddition(SVNStatusKind kind) {
        return kind == SVNStatusKind.ADDED || kind == SVNStatusKind.UNVERSIONED;
    }

    private static IResourceVariant createBaseResourceVariant(IResource local, LocalResourceStatus baseStatusInfo) {
        if (baseStatusInfo == null || baseStatusInfo.getLastChangedRevision() == null) {
            return null;
        }
        if (local.getType() == 1) {
            String charset = null;
            try {
                charset = ((IEncodedStorage)local).getCharset();
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(4, e.getMessage(), e);
            }
            return new BaseFile(local, baseStatusInfo, charset);
        }
        return new BaseFolder(local, baseStatusInfo);
    }

    private static IResourceVariant createLatestResourceVariant(IResource local, LocalResourceStatus baseStatusInfo, RemoteResourceStatus remoteStatusInfo) {
        if (remoteStatusInfo == null || remoteStatusInfo.getStatusKind() == SVNStatusKind.DELETED) {
            return null;
        }
        if (remoteStatusInfo.getStatusKind() == SVNStatusKind.NONE && baseStatusInfo != null && SVNStatusSyncInfo.isAddition(baseStatusInfo.getStatusKind())) {
            return null;
        }
        if (local.getType() == 1) {
            return new RemoteFile(remoteStatusInfo);
        }
        return new RemoteFolder(remoteStatusInfo);
    }

    public String getLabel() {
        IResourceVariant remote = this.getRemote();
        if (remote != null && (8 == SyncInfo.getDirection((int)this.getKind()) || 12 == SyncInfo.getDirection((int)this.getKind()))) {
            ISVNRemoteResource remoteResource;
            if (remote instanceof ISVNRemoteResource && (remoteResource = (ISVNRemoteResource)remote).getAuthor() != null) {
                return " (" + remote.getContentIdentifier() + " - " + remoteResource.getAuthor() + ")";
            }
            return " (" + remote.getContentIdentifier() + ")";
        }
        return "";
    }

    public String toString() {
        return String.valueOf(SyncInfo.kindToString((int)this.getKind())) + " L: " + this.baseStatusInfo + " R: " + this.remoteStatusInfo;
    }
}

