/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskGroup;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details.CompCSEnclosingTextDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details.DetailsMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class CompCSTaskGroupDetails
extends CSAbstractDetails {
    private Section fDefinitionSection = null;
    private FormEntry fNameEntry = null;
    private ComboPart fKindCombo = null;
    private Button fSkip = null;
    private ICompCSTaskGroup fDataTaskGroup = null;
    private CompCSEnclosingTextDetails fEnclosingTextSection;
    private static final String F_KIND_VALUE_SET = DetailsMessages.CompCSTaskGroupDetails_set;
    private static final String F_KIND_VALUE_CHOICE = DetailsMessages.CompCSTaskGroupDetails_choice;
    private static final String F_KIND_VALUE_SEQUENCE = DetailsMessages.CompCSTaskGroupDetails_sequence;

    public CompCSTaskGroupDetails(ICSMaster section) {
        super(section, "compcs-context");
        this.fEnclosingTextSection = new CompCSEnclosingTextDetails(1, section);
    }

    public void setData(ICompCSTaskGroup object) {
        this.fDataTaskGroup = object;
        this.fEnclosingTextSection.setData((ICompCSTaskObject)object);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.fEnclosingTextSection.initialize(form);
    }

    public void createDetails(Composite parent) {
        int style = 384;
        this.fDefinitionSection = this.getPage().createUISection(parent, DetailsMessages.CompCSTaskGroupDetails_sectionTitle, DetailsMessages.CompCSTaskGroupDetails_sectionDescription, style);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fDefinitionSection);
        Composite sectionClient = this.getPage().createUISectionContainer((Composite)this.fDefinitionSection, 2);
        this.createUINameEntry(sectionClient);
        this.createUIKindLabel(sectionClient);
        this.createUIKindCombo(sectionClient);
        this.createUISkipButton(sectionClient);
        this.fEnclosingTextSection.createDetails(parent);
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
        this.fDefinitionSection.setClient((Control)sectionClient);
        this.markDetailsPart((Control)this.fDefinitionSection);
    }

    private void createUISkipButton(Composite parent) {
        Color foreground = this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fSkip = this.getToolkit().createButton(parent, DetailsMessages.CompCSTaskGroupDetails_optional, 32);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fSkip.setLayoutData((Object)data);
        this.fSkip.setForeground(foreground);
    }

    private void createUIKindLabel(Composite parent) {
        Color foreground = this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE");
        Label label = this.getToolkit().createLabel(parent, DetailsMessages.CompCSTaskGroupDetails_type, 64);
        label.setForeground(foreground);
        label.setToolTipText(DetailsMessages.CompCSTaskGroupDetails_tooltip1);
    }

    private void createUIKindCombo(Composite parent) {
        this.fKindCombo = new ComboPart();
        this.fKindCombo.createControl(parent, this.getToolkit(), 8);
        GridData data = new GridData(768);
        data.horizontalIndent = 3;
        this.fKindCombo.getControl().setLayoutData((Object)data);
        this.fKindCombo.add(F_KIND_VALUE_SET);
        this.fKindCombo.add(F_KIND_VALUE_SEQUENCE);
        this.fKindCombo.add(F_KIND_VALUE_CHOICE);
        this.fKindCombo.setText(F_KIND_VALUE_SET);
        this.fKindCombo.getControl().setToolTipText(DetailsMessages.CompCSTaskGroupDetails_tooltip2);
    }

    private void createUINameEntry(Composite parent) {
        this.fNameEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), DetailsMessages.CompCSTaskGroupDetails_name, 0);
    }

    public void hookListeners() {
        this.createListenersNameEntry();
        this.createListenersKindCombo();
        this.createListenersSkipButton();
        this.fEnclosingTextSection.hookListeners();
    }

    private void createListenersNameEntry() {
        this.fNameEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (CompCSTaskGroupDetails.this.fDataTaskGroup == null) {
                    return;
                }
                CompCSTaskGroupDetails.this.fDataTaskGroup.setFieldName(CompCSTaskGroupDetails.this.fNameEntry.getValue());
            }
        });
    }

    private void createListenersKindCombo() {
        this.fKindCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompCSTaskGroupDetails.this.fDataTaskGroup == null) {
                    return;
                }
                String selection = CompCSTaskGroupDetails.this.fKindCombo.getSelection();
                if (selection.equals(F_KIND_VALUE_CHOICE)) {
                    CompCSTaskGroupDetails.this.fDataTaskGroup.setFieldKind("choice");
                } else if (selection.equals(F_KIND_VALUE_SEQUENCE)) {
                    CompCSTaskGroupDetails.this.fDataTaskGroup.setFieldKind("sequence");
                } else if (selection.equals(F_KIND_VALUE_SET)) {
                    CompCSTaskGroupDetails.this.fDataTaskGroup.setFieldKind("set");
                }
            }
        });
    }

    private void createListenersSkipButton() {
        this.fSkip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompCSTaskGroupDetails.this.fDataTaskGroup == null) {
                    return;
                }
                CompCSTaskGroupDetails.this.fDataTaskGroup.setFieldSkip(CompCSTaskGroupDetails.this.fSkip.getSelection());
            }
        });
    }

    public void updateFields() {
        if (this.fDataTaskGroup == null) {
            return;
        }
        boolean editable = this.isEditableElement();
        this.updateNameEntry(editable);
        this.updateKindCombo(editable);
        this.updateSkipButton(editable);
        this.fEnclosingTextSection.updateFields();
    }

    private void updateNameEntry(boolean editable) {
        this.fNameEntry.setValue(this.fDataTaskGroup.getFieldName(), true);
        this.fNameEntry.setEditable(editable);
    }

    private void updateKindCombo(boolean editable) {
        String kind = this.fDataTaskGroup.getFieldKind();
        if (kind != null) {
            if (kind.compareTo("sequence") == 0) {
                this.fKindCombo.setText(F_KIND_VALUE_SEQUENCE);
            } else if (kind.compareTo("choice") == 0) {
                this.fKindCombo.setText(F_KIND_VALUE_CHOICE);
            } else {
                this.fKindCombo.setText(F_KIND_VALUE_SET);
            }
        }
        this.fKindCombo.setEnabled(editable);
    }

    private void updateSkipButton(boolean editable) {
        this.fSkip.setSelection(this.fDataTaskGroup.getFieldSkip());
        this.fSkip.setEnabled(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fNameEntry.commit();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object == null || !(object instanceof ICompCSTaskGroup)) {
            return;
        }
        this.setData((ICompCSTaskGroup)object);
        this.updateFields();
    }

    public void dispose() {
        if (this.fEnclosingTextSection != null) {
            this.fEnclosingTextSection.dispose();
            this.fEnclosingTextSection = null;
        }
        super.dispose();
    }
}

