/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver;

import com.l2jserver.Config;
import com.l2jserver.Server;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;
import org.bitlet.weupnp.PortMappingEntry;
import org.xml.sax.SAXException;

public class UPnPService {
    private static final Logger _log = Logger.getLogger(UPnPService.class.getName());
    private static final String PROTOCOL = "TCP";
    private final GatewayDiscover _gatewayDiscover = new GatewayDiscover();
    private GatewayDevice _activeGW;

    protected UPnPService() {
        try {
            this.load();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": error while initializing: ", e);
        }
    }

    private void load() throws Exception {
        if (!Config.ENABLE_UPNP) {
            _log.log(Level.WARNING, "UPnP Service is disabled.");
            return;
        }
        _log.log(Level.INFO, "Looking for UPnP Gateway Devices...");
        Map gateways = this._gatewayDiscover.discover();
        if (gateways.isEmpty()) {
            _log.log(Level.INFO, "No UPnP gateways found");
            return;
        }
        this._activeGW = this._gatewayDiscover.getValidGateway();
        if (this._activeGW == null) {
            _log.log(Level.INFO, "No active UPnP gateway found");
            return;
        }
        _log.log(Level.INFO, "Using UPnP gateway: " + this._activeGW.getFriendlyName());
        _log.log(Level.INFO, "Using local address: " + this._activeGW.getLocalAddress().getHostAddress() + " External address: " + this._activeGW.getExternalIPAddress());
        if (Server.serverMode == 1) {
            this.addPortMapping(Config.PORT_GAME, "L2j Game Server");
        } else if (Server.serverMode == 2) {
            this.addPortMapping(Config.PORT_LOGIN, "L2j Login Server");
        }
    }

    public void removeAllPorts() throws Exception {
        if (this._activeGW != null) {
            if (Server.serverMode == 1) {
                this.deletePortMapping(Config.PORT_GAME);
            } else if (Server.serverMode == 2) {
                this.deletePortMapping(Config.PORT_LOGIN);
            }
        }
    }

    private void addPortMapping(int port, String description) throws IOException, SAXException {
        PortMappingEntry portMapping = new PortMappingEntry();
        InetAddress localAddress = this._activeGW.getLocalAddress();
        if (this._activeGW.getSpecificPortMappingEntry(port, PROTOCOL, portMapping)) {
            this._activeGW.deletePortMapping(port, PROTOCOL);
        }
        if (this._activeGW.addPortMapping(port, port, localAddress.getHostAddress(), PROTOCOL, description)) {
            _log.log(Level.INFO, "Mapping successfull on [" + localAddress.getHostAddress() + ":" + port + "]");
        } else {
            _log.log(Level.INFO, "Mapping failed on [" + localAddress.getHostAddress() + ":" + port + "] - Already mapped?");
        }
    }

    private void deletePortMapping(int port) throws IOException, SAXException {
        if (this._activeGW.deletePortMapping(port, PROTOCOL)) {
            _log.log(Level.INFO, "Mapping was deleted from [" + this._activeGW.getLocalAddress().getHostAddress() + ":" + port + "]");
        }
    }

    public static UPnPService getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final UPnPService _instance = new UPnPService();

        private SingletonHolder() {
        }
    }
}

