/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.log.formatter;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class AccountingFormatter
extends Formatter {
    private final SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        Object[] params = record.getParameters();
        StringBuilder output = StringUtil.startAppend(30 + record.getMessage().length() + (params == null ? 0 : params.length * 10), "[", this.dateFmt.format(new Date(record.getMillis())), "] ", record.getMessage());
        if (params != null) {
            block7: for (Object p : params) {
                if (p == null) continue;
                StringUtil.append(output, ", ");
                if (p instanceof L2GameClient) {
                    L2GameClient client = (L2GameClient)p;
                    String address = null;
                    try {
                        if (!client.isDetached()) {
                            address = client.getConnection().getInetAddress().getHostAddress();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    switch (client.getState()) {
                        case IN_GAME: {
                            if (client.getActiveChar() != null) {
                                StringUtil.append(output, client.getActiveChar().getName());
                                StringUtil.append(output, "(", String.valueOf(client.getActiveChar().getObjectId()), ") ");
                            }
                        }
                        case AUTHED: {
                            if (client.getAccountName() != null) {
                                StringUtil.append(output, client.getAccountName(), " ");
                            }
                        }
                        case CONNECTED: {
                            if (address == null) continue block7;
                            StringUtil.append(output, address);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Missing state on switch");
                        }
                    }
                    continue;
                }
                if (p instanceof L2PcInstance) {
                    L2PcInstance player = (L2PcInstance)p;
                    StringUtil.append(output, player.getName());
                    StringUtil.append(output, "(", String.valueOf(player.getObjectId()), ")");
                    continue;
                }
                StringUtil.append(output, p.toString());
            }
        }
        output.append(Config.EOL);
        return output.toString();
    }
}

