/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.log.formatter;

import com.l2jserver.Config;
import com.l2jserver.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ChatLogFormatter
extends Formatter {
    private final SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        Object[] params = record.getParameters();
        StringBuilder output = StringUtil.startAppend(30 + record.getMessage().length() + (params != null ? 10 * params.length : 0), "[", this.dateFmt.format(new Date(record.getMillis())), "] ");
        if (params != null) {
            for (Object p : params) {
                StringUtil.append(output, String.valueOf(p), " ");
            }
        }
        StringUtil.append(output, record.getMessage(), Config.EOL);
        return output.toString();
    }
}

