/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.L2LoginServer;
import com.l2jserver.loginserver.network.L2JGameServerPacketHandler;
import com.l2jserver.loginserver.network.loginserverpackets.ChangePasswordResponse;
import com.l2jserver.loginserver.network.loginserverpackets.InitLS;
import com.l2jserver.loginserver.network.loginserverpackets.KickPlayer;
import com.l2jserver.loginserver.network.loginserverpackets.LoginServerFail;
import com.l2jserver.loginserver.network.loginserverpackets.RequestCharacters;
import com.l2jserver.util.Util;
import com.l2jserver.util.crypt.NewCrypt;
import com.l2jserver.util.network.BaseSendablePacket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastSet;

public class GameServerThread
extends Thread {
    protected static final Logger _log = Logger.getLogger(GameServerThread.class.getName());
    private final Socket _connection;
    private InputStream _in;
    private OutputStream _out;
    private final RSAPublicKey _publicKey;
    private final RSAPrivateKey _privateKey;
    private NewCrypt _blowfish;
    private L2JGameServerPacketHandler.GameServerState _loginConnectionState = L2JGameServerPacketHandler.GameServerState.CONNECTED;
    private final String _connectionIp;
    private GameServerTable.GameServerInfo _gsi;
    private final Set<String> _accountsOnGameServer = new FastSet();
    private String _connectionIPAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._connectionIPAddress = this._connection.getInetAddress().getHostAddress();
        if (GameServerThread.isBannedGameserverIP(this._connectionIPAddress)) {
            _log.info("GameServerRegistration: IP Address " + this._connectionIPAddress + " is on Banned IP list.");
            this.forceClose(1);
            return;
        }
        InitLS startPacket = new InitLS(this._publicKey.getModulus().toByteArray());
        try {
            this.sendPacket(startPacket);
            int lengthHi = 0;
            int lengthLo = 0;
            int length = 0;
            boolean checksumOk = false;
            while (true) {
                lengthLo = this._in.read();
                lengthHi = this._in.read();
                length = lengthHi * 256 + lengthLo;
                if (lengthHi < 0 || this._connection.isClosed()) {
                    _log.finer("LoginServerThread: Login terminated the connection.");
                    break;
                }
                byte[] data = new byte[length - 2];
                int receivedBytes = 0;
                int newBytes = 0;
                int left = length - 2;
                while (newBytes != -1 && receivedBytes < length - 2) {
                    newBytes = this._in.read(data, receivedBytes, left);
                    receivedBytes += newBytes;
                    left -= newBytes;
                }
                if (receivedBytes != length - 2) {
                    _log.warning("Incomplete Packet is sent to the server, closing connection.(LS)");
                    break;
                }
                this._blowfish.decrypt(data);
                checksumOk = NewCrypt.verifyChecksum(data);
                if (!checksumOk) {
                    _log.warning("Incorrect packet checksum, closing connection (LS)");
                    return;
                }
                if (Config.DEBUG) {
                    _log.warning("[C]" + Config.EOL + Util.printData(data));
                }
                L2JGameServerPacketHandler.handlePacket(data, this);
            }
        }
        catch (IOException e) {
            String serverName = this.getServerId() != -1 ? "[" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()) : "(" + this._connectionIPAddress + ")";
            String msg = "GameServer " + serverName + ": Connection lost: " + e.getMessage();
            _log.info(msg);
            this.broadcastToTelnet(msg);
        }
        finally {
            if (this.isAuthed()) {
                this._gsi.setDown();
                _log.info("Server [" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()) + " is now set as disconnected");
            }
            L2LoginServer.getInstance().getGameServerListener().removeGameServer(this);
            L2LoginServer.getInstance().getGameServerListener().removeFloodProtection(this._connectionIp);
        }
    }

    public boolean hasAccountOnGameServer(String account) {
        return this._accountsOnGameServer.contains(account);
    }

    public int getPlayerCount() {
        return this._accountsOnGameServer.size();
    }

    public void attachGameServerInfo(GameServerTable.GameServerInfo gsi, int port, String[] hosts, int maxPlayers) {
        this.setGameServerInfo(gsi);
        gsi.setGameServerThread(this);
        gsi.setPort(port);
        this.setGameHosts(hosts);
        gsi.setMaxPlayers(maxPlayers);
        gsi.setAuthed(true);
    }

    public void forceClose(int reason) {
        this.sendPacket(new LoginServerFail(reason));
        try {
            this._connection.close();
        }
        catch (IOException e) {
            _log.finer("GameServerThread: Failed disconnecting banned server, server already disconnected.");
        }
    }

    public static boolean isBannedGameserverIP(String ipAddress) {
        return false;
    }

    public GameServerThread(Socket con) {
        this._connection = con;
        this._connectionIp = con.getInetAddress().getHostAddress();
        try {
            this._in = this._connection.getInputStream();
            this._out = new BufferedOutputStream(this._connection.getOutputStream());
        }
        catch (IOException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": ", e);
        }
        KeyPair pair = GameServerTable.getInstance().getKeyPair();
        this._privateKey = (RSAPrivateKey)pair.getPrivate();
        this._publicKey = (RSAPublicKey)pair.getPublic();
        this._blowfish = new NewCrypt("_;v.]05-31!|+-%xT!^[$\u0000");
        this.setName(this.getClass().getSimpleName() + "-" + this.getId() + "@" + this._connectionIp);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(BaseSendablePacket sl) {
        try {
            byte[] data = sl.getContent();
            NewCrypt.appendChecksum(data);
            if (Config.DEBUG) {
                _log.finest("[S] " + sl.getClass().getSimpleName() + ":" + Config.EOL + Util.printData(data));
            }
            this._blowfish.crypt(data);
            int len = data.length + 2;
            OutputStream outputStream = this._out;
            synchronized (outputStream) {
                this._out.write(len);
                this._out.write(len >>> 8);
                this._out.write(data);
                this._out.flush();
            }
        }
        catch (IOException e) {
            _log.severe("IOException while sending packet " + sl.getClass().getSimpleName());
        }
    }

    public void broadcastToTelnet(String msg) {
        if (L2LoginServer.getInstance().getStatusServer() != null) {
            L2LoginServer.getInstance().getStatusServer().sendMessageToTelnets(msg);
        }
    }

    public void kickPlayer(String account) {
        this.sendPacket(new KickPlayer(account));
    }

    public void requestCharacters(String account) {
        this.sendPacket(new RequestCharacters(account));
    }

    public void ChangePasswordResponse(byte successful, String characterName, String msgToSend) {
        this.sendPacket(new ChangePasswordResponse(successful, characterName, msgToSend));
    }

    public void setGameHosts(String[] hosts) {
        _log.info("Updated Gameserver [" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()) + " IP's:");
        this._gsi.clearServerAddresses();
        for (int i = 0; i < hosts.length; i += 2) {
            try {
                this._gsi.addServerAddress(hosts[i], hosts[i + 1]);
                continue;
            }
            catch (Exception e) {
                _log.warning("Couldn't resolve hostname \"" + e + "\"");
            }
        }
        for (String s : this._gsi.getServerAddresses()) {
            _log.info(s);
        }
    }

    public boolean isAuthed() {
        if (this.getGameServerInfo() == null) {
            return false;
        }
        return this.getGameServerInfo().isAuthed();
    }

    public void setGameServerInfo(GameServerTable.GameServerInfo gsi) {
        this._gsi = gsi;
    }

    public GameServerTable.GameServerInfo getGameServerInfo() {
        return this._gsi;
    }

    public String getConnectionIpAddress() {
        return this._connectionIPAddress;
    }

    public int getServerId() {
        if (this.getGameServerInfo() != null) {
            return this.getGameServerInfo().getId();
        }
        return -1;
    }

    public RSAPrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public void SetBlowFish(NewCrypt blowfish) {
        this._blowfish = blowfish;
    }

    public void addAccountOnGameServer(String account) {
        this._accountsOnGameServer.add(account);
    }

    public void removeAccountOnGameServer(String account) {
        this._accountsOnGameServer.remove(account);
    }

    public L2JGameServerPacketHandler.GameServerState getLoginConnectionState() {
        return this._loginConnectionState;
    }

    public void setLoginConnectionState(L2JGameServerPacketHandler.GameServerState state) {
        this._loginConnectionState = state;
    }
}

