/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network;

import com.l2jserver.Config;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.network.gameserverpackets.BlowFishKey;
import com.l2jserver.loginserver.network.gameserverpackets.ChangeAccessLevel;
import com.l2jserver.loginserver.network.gameserverpackets.ChangePassword;
import com.l2jserver.loginserver.network.gameserverpackets.GameServerAuth;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerAuthRequest;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerInGame;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerLogout;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerTracert;
import com.l2jserver.loginserver.network.gameserverpackets.ReplyCharacters;
import com.l2jserver.loginserver.network.gameserverpackets.RequestSendMail;
import com.l2jserver.loginserver.network.gameserverpackets.RequestTempBan;
import com.l2jserver.loginserver.network.gameserverpackets.ServerStatus;
import com.l2jserver.util.network.BaseRecievePacket;
import java.util.logging.Logger;

public class L2JGameServerPacketHandler {
    protected static Logger _log = Logger.getLogger(L2JGameServerPacketHandler.class.getName());

    public static BaseRecievePacket handlePacket(byte[] data, GameServerThread server) {
        BaseRecievePacket msg = null;
        int opcode = data[0] & 0xFF;
        GameServerState state = server.getLoginConnectionState();
        block0 : switch (state) {
            case CONNECTED: {
                switch (opcode) {
                    case 0: {
                        msg = new BlowFishKey(data, server);
                        break block0;
                    }
                }
                _log.warning("Unknown Opcode (" + Integer.toHexString(opcode).toUpperCase() + ") in state " + state.name() + " from GameServer, closing connection.");
                server.forceClose(6);
                break;
            }
            case BF_CONNECTED: {
                switch (opcode) {
                    case 1: {
                        msg = new GameServerAuth(data, server);
                        break block0;
                    }
                }
                _log.warning("Unknown Opcode (" + Integer.toHexString(opcode).toUpperCase() + ") in state " + state.name() + " from GameServer, closing connection.");
                server.forceClose(6);
                break;
            }
            case AUTHED: {
                switch (opcode) {
                    case 2: {
                        msg = new PlayerInGame(data, server);
                        break block0;
                    }
                    case 3: {
                        msg = new PlayerLogout(data, server);
                        break block0;
                    }
                    case 4: {
                        msg = new ChangeAccessLevel(data, server);
                        break block0;
                    }
                    case 5: {
                        msg = new PlayerAuthRequest(data, server);
                        break block0;
                    }
                    case 6: {
                        msg = new ServerStatus(data, server);
                        break block0;
                    }
                    case 7: {
                        msg = new PlayerTracert(data);
                        break block0;
                    }
                    case 8: {
                        msg = new ReplyCharacters(data, server);
                        break block0;
                    }
                    case 9: {
                        if (!Config.EMAIL_SYS_ENABLED) break block0;
                        msg = new RequestSendMail(data);
                        break block0;
                    }
                    case 10: {
                        msg = new RequestTempBan(data);
                        break block0;
                    }
                    case 11: {
                        new ChangePassword(data);
                        break block0;
                    }
                }
                _log.warning("Unknown Opcode (" + Integer.toHexString(opcode).toUpperCase() + ") in state " + state.name() + " from GameServer, closing connection.");
                server.forceClose(6);
            }
        }
        return msg;
    }

    public static enum GameServerState {
        CONNECTED,
        BF_CONNECTED,
        AUTHED;

    }
}

