/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network.gameserverpackets;

import com.l2jserver.Config;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.network.L2JGameServerPacketHandler;
import com.l2jserver.loginserver.network.loginserverpackets.AuthResponse;
import com.l2jserver.util.network.BaseRecievePacket;
import java.util.Arrays;
import java.util.logging.Logger;

public class GameServerAuth
extends BaseRecievePacket {
    protected static Logger _log = Logger.getLogger(GameServerAuth.class.getName());
    GameServerThread _server;
    private final byte[] _hexId;
    private final int _desiredId;
    private final boolean _hostReserved;
    private final boolean _acceptAlternativeId;
    private final int _maxPlayers;
    private final int _port;
    private final String[] _hosts;

    public GameServerAuth(byte[] decrypt, GameServerThread server) {
        super(decrypt);
        this._server = server;
        this._desiredId = this.readC();
        this._acceptAlternativeId = this.readC() != 0;
        this._hostReserved = this.readC() != 0;
        this._port = this.readH();
        this._maxPlayers = this.readD();
        int size = this.readD();
        this._hexId = this.readB(size);
        size = 2 * this.readD();
        this._hosts = new String[size];
        for (int i = 0; i < size; ++i) {
            this._hosts[i] = this.readS();
        }
        if (Config.DEBUG) {
            _log.info("Auth request received");
        }
        if (this.handleRegProcess()) {
            AuthResponse ar = new AuthResponse(server.getGameServerInfo().getId());
            server.sendPacket(ar);
            if (Config.DEBUG) {
                _log.info("Authed: id: " + server.getGameServerInfo().getId());
            }
            server.broadcastToTelnet("GameServer [" + server.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(server.getServerId()) + " is connected");
            server.setLoginConnectionState(L2JGameServerPacketHandler.GameServerState.AUTHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRegProcess() {
        GameServerTable gameServerTable = GameServerTable.getInstance();
        int id = this._desiredId;
        byte[] hexId = this._hexId;
        GameServerTable.GameServerInfo gsi = gameServerTable.getRegisteredGameServerById(id);
        if (gsi != null) {
            if (Arrays.equals(gsi.getHexId(), hexId)) {
                GameServerTable.GameServerInfo gameServerInfo = gsi;
                synchronized (gameServerInfo) {
                    if (gsi.isAuthed()) {
                        this._server.forceClose(7);
                        return false;
                    }
                    this._server.attachGameServerInfo(gsi, this._port, this._hosts, this._maxPlayers);
                    return true;
                }
            }
            if (Config.ACCEPT_NEW_GAMESERVER && this._acceptAlternativeId) {
                gsi = new GameServerTable.GameServerInfo(id, hexId, this._server);
                if (gameServerTable.registerWithFirstAvaliableId(gsi)) {
                    this._server.attachGameServerInfo(gsi, this._port, this._hosts, this._maxPlayers);
                    gameServerTable.registerServerOnDB(gsi);
                    return true;
                }
                this._server.forceClose(5);
                return false;
            }
            this._server.forceClose(3);
            return false;
        }
        if (!Config.ACCEPT_NEW_GAMESERVER) {
            this._server.forceClose(3);
            return false;
        }
        gsi = new GameServerTable.GameServerInfo(id, hexId, this._server);
        if (gameServerTable.register(id, gsi)) {
            this._server.attachGameServerInfo(gsi, this._port, this._hosts, this._maxPlayers);
            gameServerTable.registerServerOnDB(gsi);
            return true;
        }
        this._server.forceClose(4);
        return false;
    }
}

