/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

public final class LinePointIterator {
    private int _srcX;
    private int _srcY;
    private final int _dstX;
    private final int _dstY;
    private final int _dx;
    private final int _dy;
    private final int _sx;
    private final int _sy;
    private int _err;
    private int _e2;
    private boolean _first;

    public LinePointIterator(int srcX, int srcY, int dstX, int dstY) {
        this._srcX = srcX;
        this._srcY = srcY;
        this._dstX = dstX;
        this._dstY = dstY;
        this._dx = Math.abs(dstX - srcX);
        this._sx = srcX < dstX ? 1 : -1;
        this._dy = -Math.abs(dstY - srcY);
        this._sy = srcY < dstY ? 1 : -1;
        this._err = this._dx + this._dy;
        this._e2 = 0;
        this._first = true;
    }

    public boolean next() {
        if (this._first) {
            this._first = false;
            return true;
        }
        if (this._srcX != this._dstX || this._srcY != this._dstY) {
            this._e2 = 2 * this._err;
            if (this._e2 > this._dy) {
                this._err += this._dy;
                this._srcX += this._sx;
            }
            if (this._e2 < this._dx) {
                this._err += this._dx;
                this._srcY += this._sy;
            }
            return true;
        }
        return false;
    }

    public int x() {
        return this._srcX;
    }

    public int y() {
        return this._srcY;
    }
}

