/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.util.StackTrace;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class GameTimeController
extends Thread {
    private static final Logger _log = Logger.getLogger(GameTimeController.class.getName());
    public static final int TICKS_PER_SECOND = 10;
    public static final int MILLIS_IN_TICK = 100;
    public static final int IG_DAYS_PER_DAY = 6;
    public static final int MILLIS_PER_IG_MINUTES = 10000;
    public static final int MILLIS_PER_IG_HOUR = 600000;
    public static final int MILLIS_PER_IG_DAY = 14400000;
    public static final int SECONDS_PER_IG_DAY = 14400;
    public static final int MINUTES_PER_IG_DAY = 240;
    public static final int TICKS_PER_IG_DAY = 144000;
    public static final int TICKS_SUN_STATE_CHANGE = 36000;
    private static GameTimeController _instance;
    private final FastIntObjectMap<L2Character> _movingObjects = new FastIntObjectMap().shared();
    private final long _referenceTime;
    private boolean _isNight;

    private GameTimeController() {
        super("GameTimeController");
        super.setDaemon(true);
        super.setPriority(10);
        _log.info("Initializing Game Time Controller");
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this._referenceTime = c.getTimeInMillis();
        this._isNight = this.isNight(System.currentTimeMillis());
        super.start();
    }

    public static final void init() {
        _instance = new GameTimeController();
    }

    public final int getGameTime() {
        return (int)(this.getGameTickMillis() / 10000L % 1440L);
    }

    public final int getGameHour() {
        return (int)(this.getGameTickMillis() / 600000L % 24L);
    }

    public final int getGameMinute() {
        return (int)(this.getGameTickMillis() / 10000L % 60L);
    }

    public final boolean isNight() {
        return this._isNight;
    }

    private final boolean isNight(long currentTimeMillis) {
        int gameHour = (int)((currentTimeMillis - this._referenceTime) / 600000L % 24L);
        return gameHour < 6;
    }

    public final int getGameTicks() {
        return (int)((System.currentTimeMillis() - this._referenceTime) / 100L);
    }

    public final long getGameTickMillis() {
        return System.currentTimeMillis() - this._referenceTime;
    }

    public final long getGameTimeMillis() {
        return 6L * (System.currentTimeMillis() - this._referenceTime);
    }

    public final void registerMovingObject(L2Character cha) {
        if (cha == null) {
            return;
        }
        this._movingObjects.putIfAbsent(cha.getObjectId(), (Object)cha);
    }

    private final void moveObjects(int gameTicks) {
        FastIntObjectMap.Entry e = this._movingObjects.head();
        FastIntObjectMap.Entry tail = this._movingObjects.tail();
        while ((e = e.getNext()) != tail) {
            L2Character character = (L2Character)e.getValue();
            if (!character.updatePosition(gameTicks)) continue;
            this._movingObjects.remove(e.getKey());
            this.fireCharacterArrived(character);
        }
    }

    private final void fireCharacterArrived(final L2Character character) {
        final L2CharacterAI ai = character.getAI();
        if (ai == null) {
            return;
        }
        ThreadPoolManager.getInstance().executeTask(new Runnable(){

            @Override
            public final void run() {
                try {
                    if (Config.MOVE_BASED_KNOWNLIST) {
                        character.getKnownList().findObjects();
                    }
                    ai.notifyEvent(CtrlEvent.EVT_ARRIVED);
                }
                catch (Throwable e) {
                    StackTrace.displayStackTraceInformation(e);
                }
            }
        });
    }

    public final void stopTimer() {
        super.interrupt();
        _log.log(Level.INFO, "Stopping " + this.getClass().getSimpleName());
    }

    @Override
    public final void run() {
        _log.log(Level.CONFIG, this.getClass().getSimpleName() + ": Started.");
        long now = System.currentTimeMillis();
        while (true) {
            long previousTime = now;
            now = System.currentTimeMillis();
            long gameTickMillis = now - this._referenceTime;
            int gameTicks = (int)(gameTickMillis / 100L);
            long nextTickTime = now / 100L * 100L + 100L;
            try {
                long sleepTime;
                this.moveObjects(gameTicks);
                boolean isNight = this.isNight(now);
                if (this._isNight != isNight && previousTime < now) {
                    this._isNight = isNight;
                    ThreadPoolManager.getInstance().executeTask(new Runnable(){

                        @Override
                        public final void run() {
                            DayNightSpawnManager.getInstance().notifyChangeMode();
                        }
                    });
                }
                if ((sleepTime = nextTickTime - System.currentTimeMillis()) <= 0L) continue;
                if (sleepTime > 100L) {
                    sleepTime = 100L;
                }
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                StackTrace.displayStackTraceInformation(e);
                continue;
            }
            break;
        }
    }

    public static final GameTimeController getInstance() {
        return _instance;
    }
}

