/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.util.Iterator;
import javolution.util.FastList;

public class ItemsAutoDestroy {
    protected FastList<L2ItemInstance> _items = new FastList();
    protected static long _sleep;

    protected ItemsAutoDestroy() {
        _sleep = Config.AUTODESTROY_ITEM_AFTER * 1000;
        if (_sleep == 0L) {
            _sleep = 3600000L;
        }
        ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckItemsForDestroy(), 5000L, 5000L);
    }

    public static ItemsAutoDestroy getInstance() {
        return SingletonHolder._instance;
    }

    public synchronized void addItem(L2ItemInstance item) {
        item.setDropTime(System.currentTimeMillis());
        this._items.add((Object)item);
    }

    public synchronized void removeItems() {
        if (this._items.isEmpty()) {
            return;
        }
        long curtime = System.currentTimeMillis();
        Iterator it = this._items.iterator();
        while (it.hasNext()) {
            L2ItemInstance item = (L2ItemInstance)it.next();
            if (item == null || item.getDropTime() == 0L || item.getItemLocation() != ItemLocation.VOID) {
                it.remove();
                continue;
            }
            if (item.getItem().getAutoDestroyTime() > 0) {
                if (curtime - item.getDropTime() <= (long)item.getItem().getAutoDestroyTime()) continue;
                L2World.getInstance().removeVisibleObject(item, item.getWorldRegion());
                L2World.getInstance().removeObject(item);
                this._items.remove((Object)item);
                if (!Config.SAVE_DROPPED_ITEM) continue;
                ItemsOnGroundManager.getInstance().removeObject(item);
                continue;
            }
            if (item.getItem().hasExImmediateEffect()) {
                if (curtime - item.getDropTime() <= (long)Config.HERB_AUTO_DESTROY_TIME) continue;
                L2World.getInstance().removeVisibleObject(item, item.getWorldRegion());
                L2World.getInstance().removeObject(item);
                it.remove();
                if (!Config.SAVE_DROPPED_ITEM) continue;
                ItemsOnGroundManager.getInstance().removeObject(item);
                continue;
            }
            if (curtime - item.getDropTime() <= _sleep) continue;
            L2World.getInstance().removeVisibleObject(item, item.getWorldRegion());
            L2World.getInstance().removeObject(item);
            it.remove();
            if (!Config.SAVE_DROPPED_ITEM) continue;
            ItemsOnGroundManager.getInstance().removeObject(item);
        }
    }

    private static class SingletonHolder {
        protected static final ItemsAutoDestroy _instance = new ItemsAutoDestroy();

        private SingletonHolder() {
        }
    }

    protected class CheckItemsForDestroy
    extends Thread {
        protected CheckItemsForDestroy() {
        }

        @Override
        public void run() {
            ItemsAutoDestroy.this.removeItems();
        }
    }
}

