/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

public abstract class L2PlayableAI
extends L2CharacterAI {
    public L2PlayableAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        if (target instanceof L2Playable) {
            if (target.getActingPlayer().isProtectionBlessingAffected() && this._actor.getActingPlayer().getLevel() - target.getActingPlayer().getLevel() >= 10 && this._actor.getActingPlayer().getKarma() > 0 && !target.isInsideZone(ZoneId.PVP)) {
                this._actor.getActingPlayer().sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.clientActionFailed();
                return;
            }
            if (this._actor.getActingPlayer().isProtectionBlessingAffected() && target.getActingPlayer().getLevel() - this._actor.getActingPlayer().getLevel() >= 10 && target.getActingPlayer().getKarma() > 0 && !target.isInsideZone(ZoneId.PVP)) {
                this._actor.getActingPlayer().sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.clientActionFailed();
                return;
            }
            if (target.getActingPlayer().isCursedWeaponEquipped() && this._actor.getActingPlayer().getLevel() <= 20) {
                this._actor.getActingPlayer().sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.clientActionFailed();
                return;
            }
            if (this._actor.getActingPlayer().isCursedWeaponEquipped() && target.getActingPlayer().getLevel() <= 20) {
                this._actor.getActingPlayer().sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.clientActionFailed();
                return;
            }
        }
        super.onIntentionAttack(target);
    }

    @Override
    protected void onIntentionCast(L2Skill skill, L2Object target) {
        if (target instanceof L2Playable && skill.isBad()) {
            if (target.getActingPlayer().isProtectionBlessingAffected() && this._actor.getActingPlayer().getLevel() - target.getActingPlayer().getLevel() >= 10 && this._actor.getActingPlayer().getKarma() > 0 && !target.isInsideZone(ZoneId.PVP)) {
                this._actor.getActingPlayer().sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.clientActionFailed();
                this._actor.setIsCastingNow(false);
                return;
            }
            if (this._actor.getActingPlayer().isProtectionBlessingAffected() && target.getActingPlayer().getLevel() - this._actor.getActingPlayer().getLevel() >= 10 && target.getActingPlayer().getKarma() > 0 && !target.isInsideZone(ZoneId.PVP)) {
                this._actor.getActingPlayer().sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.clientActionFailed();
                this._actor.setIsCastingNow(false);
                return;
            }
            if (target.getActingPlayer().isCursedWeaponEquipped() && (this._actor.getActingPlayer().getLevel() <= 20 || target.getActingPlayer().getLevel() <= 20)) {
                this._actor.getActingPlayer().sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.clientActionFailed();
                this._actor.setIsCastingNow(false);
                return;
            }
        }
        super.onIntentionCast(skill, target);
    }
}

