/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2PlayableAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.util.Rnd;
import java.util.concurrent.Future;

public class L2SummonAI
extends L2PlayableAI
implements Runnable {
    private static final int AVOID_RADIUS = 70;
    private volatile boolean _thinking;
    private volatile boolean _startFollow;
    private L2Character _lastAttack;
    private volatile boolean _startAvoid;
    private Future<?> _avoidTask;

    public L2SummonAI(L2Character.AIAccessor accessor) {
        super(accessor);
        this._startFollow = ((L2Summon)this._actor).getFollowStatus();
        this._lastAttack = null;
        this._startAvoid = false;
        this._avoidTask = null;
    }

    @Override
    protected void onIntentionIdle() {
        this.stopFollow();
        this._startFollow = false;
        this.onIntentionActive();
    }

    @Override
    protected void onIntentionActive() {
        L2Summon summon = (L2Summon)this._actor;
        if (this._startFollow) {
            this.setIntention(CtrlIntention.AI_INTENTION_FOLLOW, summon.getOwner());
        } else {
            super.onIntentionActive();
        }
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        switch (intention) {
            case AI_INTENTION_ACTIVE: 
            case AI_INTENTION_FOLLOW: {
                this.startAvoidTask();
                break;
            }
            default: {
                this.stopAvoidTask();
            }
        }
        super.changeIntention(intention, arg0, arg1);
    }

    private void thinkAttack() {
        if (this.checkTargetLostOrDead(this.getAttackTarget())) {
            this.setAttackTarget(null);
            return;
        }
        if (this.maybeMoveToPawn(this.getAttackTarget(), this._actor.getPhysicalAttackRange())) {
            return;
        }
        this.clientStopMoving(null);
        this._accessor.doAttack(this.getAttackTarget());
    }

    private void thinkCast() {
        L2Summon summon = (L2Summon)this._actor;
        if (this.checkTargetLost(this.getCastTarget())) {
            this.setCastTarget(null);
            return;
        }
        boolean val = this._startFollow;
        if (this.maybeMoveToPawn(this.getCastTarget(), this._actor.getMagicalAttackRange(this._skill))) {
            return;
        }
        this.clientStopMoving(null);
        summon.setFollowStatus(false);
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this._startFollow = val;
        this._accessor.doCast(this._skill);
    }

    private void thinkPickUp() {
        if (this.checkTargetLost(this.getTarget())) {
            return;
        }
        if (this.maybeMoveToPawn(this.getTarget(), 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        ((L2Summon.AIAccessor)this._accessor).doPickupItem(this.getTarget());
    }

    private void thinkInteract() {
        if (this.checkTargetLost(this.getTarget())) {
            return;
        }
        if (this.maybeMoveToPawn(this.getTarget(), 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onEvtThink() {
        if (this._thinking) return;
        if (this._actor.isCastingNow()) return;
        if (this._actor.isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            switch (this.getIntention()) {
                case AI_INTENTION_ATTACK: {
                    this.thinkAttack();
                    return;
                }
                case AI_INTENTION_CAST: {
                    this.thinkCast();
                    return;
                }
                case AI_INTENTION_PICK_UP: {
                    this.thinkPickUp();
                    return;
                }
                case AI_INTENTION_INTERACT: {
                    this.thinkInteract();
                    return;
                }
            }
            return;
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtFinishCasting() {
        if (this._lastAttack == null) {
            ((L2Summon)this._actor).setFollowStatus(this._startFollow);
        } else {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, this._lastAttack);
            this._lastAttack = null;
        }
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        super.onEvtAttacked(attacker);
        this.avoidAttack(attacker);
    }

    @Override
    protected void onEvtEvaded(L2Character attacker) {
        super.onEvtEvaded(attacker);
        this.avoidAttack(attacker);
    }

    private void avoidAttack(L2Character attacker) {
        if (((L2Summon)this._actor).getOwner() != null && ((L2Summon)this._actor).getOwner() != attacker && ((L2Summon)this._actor).getOwner().isInsideRadius(this._actor, 140, true, false)) {
            this._startAvoid = true;
        }
    }

    @Override
    public void run() {
        if (this._startAvoid) {
            this._startAvoid = false;
            if (!(this._clientMoving || this._actor.isDead() || this._actor.isMovementDisabled())) {
                int ownerX = ((L2Summon)this._actor).getOwner().getX();
                int ownerY = ((L2Summon)this._actor).getOwner().getY();
                double angle = Math.toRadians(Rnd.get(-90, 90)) + Math.atan2(ownerY - this._actor.getY(), ownerX - this._actor.getX());
                int targetX = ownerX + (int)(70.0 * Math.cos(angle));
                int targetY = ownerY + (int)(70.0 * Math.sin(angle));
                if (Config.GEODATA == 0 || GeoData.getInstance().canMove(this._actor.getX(), this._actor.getY(), this._actor.getZ(), targetX, targetY, this._actor.getZ(), this._actor.getInstanceId())) {
                    this.moveTo(targetX, targetY, this._actor.getZ());
                }
            }
        }
    }

    public void notifyFollowStatusChange() {
        this._startFollow = !this._startFollow;
        switch (this.getIntention()) {
            case AI_INTENTION_ACTIVE: 
            case AI_INTENTION_FOLLOW: 
            case AI_INTENTION_PICK_UP: 
            case AI_INTENTION_IDLE: 
            case AI_INTENTION_MOVE_TO: {
                ((L2Summon)this._actor).setFollowStatus(this._startFollow);
            }
        }
    }

    public void setStartFollowController(boolean val) {
        this._startFollow = val;
    }

    @Override
    protected void onIntentionCast(L2Skill skill, L2Object target) {
        this._lastAttack = this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK ? this.getAttackTarget() : null;
        super.onIntentionCast(skill, target);
    }

    private void startAvoidTask() {
        if (this._avoidTask == null) {
            this._avoidTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this, 100L, 100L);
        }
    }

    private void stopAvoidTask() {
        if (this._avoidTask != null) {
            this._avoidTask.cancel(false);
            this._avoidTask = null;
        }
    }

    @Override
    public void stopAITask() {
        this.stopAvoidTask();
        super.stopAITask();
    }
}

