/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.cache;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.file.filter.HTMLFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;
import jp.sf.l2j.troja.FastIntObjectMap;

public class HtmCache {
    Logger _log = Logger.getLogger(HtmCache.class.getName());
    private static final HTMLFilter htmlFilter = new HTMLFilter();
    private static final boolean TIMED_CACHE = true;
    private static final boolean CHECK_HASH_COLLISION = true;
    private static final int EXPIRE_TIME = 60;
    final FastIntObjectMap<TimedCache> _timedCache;
    private final FastMap<String, String> _cache;
    int _loadedFiles;
    long _bytesBuffLen;

    protected HtmCache() {
        this.checkHashCollision();
        this._timedCache = new FastIntObjectMap().shared();
        this._cache = null;
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new CacheScheduler(), 3600000L, 3600000L);
        this.reload();
    }

    public void reload() {
        this.reload(Config.DATAPACK_ROOT);
    }

    public void reload(File f) {
        if (this.getLoadedFiles() > 0) {
            this._log.info("Cache[HTML]: " + String.format("%.3f", this.getMemoryUsage()) + " megabytes on " + this.getLoadedFiles() + " files loaded");
        }
        this._timedCache.clear();
        this._loadedFiles = 0;
        this._bytesBuffLen = 0L;
        this._log.info("Cache[HTML]: Running timed cache");
    }

    public void reloadPath(File f) {
        this.parseDir(f);
        this._log.info("Cache[HTML]: Reloaded specified path.");
    }

    public double getMemoryUsage() {
        return (float)this._bytesBuffLen / 1048576.0f;
    }

    public int getLoadedFiles() {
        return this._loadedFiles;
    }

    private void parseDir(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory()) {
                this.loadFile(file);
                continue;
            }
            this.parseDir(file);
        }
    }

    private String removeBlank(String content) {
        char[] ca = new char[content.length()];
        int count = 0;
        boolean modify = false;
        int len = content.length();
        for (int index = 0; index < len; ++index) {
            char ch = content.charAt(index);
            if (ch == '\t' || ch == '\r' || ch == '\n' || ch == '\ufeff') continue;
            ca[count++] = ch;
        }
        if (modify || count != content.length()) {
            content = new String(ca, 0, count);
        }
        return content;
    }

    public String loadFile(File file) {
        return this.loadFile(file, false);
    }

    private String loadFile(File file, boolean checked) {
        if (!htmlFilter.accept(file)) {
            return null;
        }
        String relpath = Util.getRelativePath(Config.DATAPACK_ROOT, file);
        String content = null;
        try (FileInputStream fis = new FileInputStream(file);){
            String oldContent;
            byte[] raw = new byte[fis.available()];
            fis.read(raw);
            content = new String(raw, StandardCharsets.UTF_8);
            content = this.removeBlank(content);
            content = content.replaceAll("<!--.*?-->", "");
            String string = oldContent = checked ? null : this._cache_get(relpath);
            if (oldContent == null) {
                this._bytesBuffLen += (long)(content.length() * 2);
                ++this._loadedFiles;
            } else {
                this._bytesBuffLen = this._bytesBuffLen - (long)(oldContent.length() * 2) + (long)(content.length() * 2);
            }
            this._cache_put(relpath, content);
        }
        catch (IOException e) {
            this._log.log(Level.WARNING, "Problem with htm file " + e.getMessage(), e);
            e.printStackTrace();
        }
        return content;
    }

    public String getHtmForce(String prefix, String path) {
        String content = this.getHtm(prefix, path);
        if (content == null) {
            content = "<html><body>My text is missing:<br>" + path + "</body></html>";
            this._log.warning("Cache[HTML]: Missing HTML page: " + path);
        }
        return content;
    }

    public String getHtm(String prefix, String path) {
        if (prefix != null && !prefix.isEmpty()) {
            String newPath = prefix + path;
            String content = this.getHtm(newPath);
            if (content != null) {
                return content;
            }
            content = this.getHtm(path);
            if (content != null) {
                this._cache_put(newPath, content);
            }
            return content;
        }
        return this.getHtm(path);
    }

    private String getHtm(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        String content = this._cache_get(path);
        if (content == null) {
            content = this.loadFile(new File(Config.DATAPACK_ROOT, path), true);
        }
        return content;
    }

    private String _cache_get(String path) {
        TimedCache item = (TimedCache)this._timedCache.get(path.hashCode());
        if (item == null) {
            return null;
        }
        if (item.lastAccessTime != 0L) {
            item.lastAccessTime = GameTimeController.getInstance().getGameTime();
        }
        return item.content;
    }

    private void _cache_put(String path, String content) {
        TimedCache item = new TimedCache();
        item.lastAccessTime = path.endsWith("data/html/noquest.htm") || path.endsWith("data/html/alreadycompleted.htm") ? 0L : (long)GameTimeController.getInstance().getGameTime();
        item.content = content;
        this._timedCache.put(path.hashCode(), (Object)item);
    }

    private void checkHashCollision() {
        FastIntObjectMap map = new FastIntObjectMap();
        this.checkHashCollision_parseDir((FastIntObjectMap<String>)map, Config.DATAPACK_ROOT);
    }

    private void checkHashCollision_parseDir(FastIntObjectMap<String> map, File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.checkHashCollision_parseDir(map, file);
                continue;
            }
            String relpath = Util.getRelativePath(Config.DATAPACK_ROOT, file);
            int hashcode = relpath.hashCode();
            String v = (String)map.putIfAbsent(hashcode, (Object)relpath);
            if (v == null || v.equals(relpath)) continue;
            this._log.log(Level.WARNING, "HtmCache: Hashcode collision (" + hashcode + ")");
            this._log.log(Level.WARNING, "\t" + v);
            this._log.log(Level.WARNING, "\t" + relpath);
        }
    }

    public static HtmCache getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final HtmCache _instance = new HtmCache();

        private SingletonHolder() {
        }
    }

    class CacheScheduler
    implements Runnable {
        CacheScheduler() {
        }

        @Override
        public void run() {
            int[] keys;
            boolean update = false;
            int cTime = GameTimeController.getInstance().getGameTime();
            for (int hashcode : keys = HtmCache.this._timedCache.keys()) {
                TimedCache item = (TimedCache)HtmCache.this._timedCache.get(hashcode);
                if (item.lastAccessTime == 0L || (long)cTime - item.lastAccessTime <= 60L) continue;
                --HtmCache.this._loadedFiles;
                HtmCache.this._bytesBuffLen -= (long)(item.content.length() * 2);
                HtmCache.this._timedCache.remove(hashcode);
                update = true;
            }
            if (update) {
                HtmCache.this._log.info("Cache[HTML]: " + String.format("%.3f", HtmCache.this.getMemoryUsage()) + " megabytes on " + HtmCache.this.getLoadedFiles() + " files loaded");
            }
        }
    }

    static class TimedCache {
        long lastAccessTime;
        String content;

        TimedCache() {
        }
    }
}

