/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.L2ArmorSet;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ArmorSetsData
extends DocumentParser {
    private static final Map<Integer, L2ArmorSet> _armorSets = new HashMap<Integer, L2ArmorSet>();

    protected ArmorSetsData() {
        this.load();
    }

    @Override
    public void load() {
        _armorSets.clear();
        this.parseDatapackDirectory("data/stats/armorsets", false);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _armorSets.size() + " Armor sets.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"set".equalsIgnoreCase(d.getNodeName())) continue;
                L2ArmorSet set = new L2ArmorSet();
                block36: for (Node a = d.getFirstChild(); a != null; a = a.getNextSibling()) {
                    NamedNodeMap attrs = a.getAttributes();
                    switch (a.getNodeName()) {
                        case "chest": {
                            set.addChest(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "feet": {
                            set.addFeet(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "gloves": {
                            set.addGloves(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "head": {
                            set.addHead(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "legs": {
                            set.addLegs(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "shield": {
                            set.addShield(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "skill": {
                            int skillId = this.parseInteger(attrs, "id");
                            int skillLevel = this.parseInteger(attrs, "level");
                            set.addSkill(new SkillHolder(skillId, skillLevel));
                            continue block36;
                        }
                        case "shield_skill": {
                            int skillId = this.parseInteger(attrs, "id");
                            int skillLevel = this.parseInteger(attrs, "level");
                            set.addShieldSkill(new SkillHolder(skillId, skillLevel));
                            continue block36;
                        }
                        case "enchant6skill": {
                            int skillId = this.parseInteger(attrs, "id");
                            int skillLevel = this.parseInteger(attrs, "level");
                            set.addEnchant6Skill(new SkillHolder(skillId, skillLevel));
                            continue block36;
                        }
                        case "con": {
                            set.addCon(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "dex": {
                            set.addDex(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "str": {
                            set.addStr(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "men": {
                            set.addMen(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "wit": {
                            set.addWit(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "int": {
                            set.addInt(this.parseInteger(attrs, "val"));
                        }
                    }
                }
                _armorSets.put(set.getChestId(), set);
            }
        }
    }

    public boolean isArmorSet(int chestId) {
        return _armorSets.containsKey(chestId);
    }

    public L2ArmorSet getSet(int chestId) {
        return _armorSets.get(chestId);
    }

    public static ArmorSetsData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ArmorSetsData _instance = new ArmorSetsData();

        private SingletonHolder() {
        }
    }
}

