/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.communitybbs.Manager.ForumsBBSManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarEvent;
import com.l2jserver.gameserver.scripting.scriptengine.impl.L2Script;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.clan.ClanWarListener;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.EnumIntBitmask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;

public class ClanTable {
    private static final Logger _log = Logger.getLogger(ClanTable.class.getName());
    private static FastList<ClanWarListener> clanWarListeners = new FastList().shared();
    private final FastIntObjectMap<L2Clan> _clans = new FastIntObjectMap();

    public L2Clan[] getClans() {
        return this._clans.values().toArray(new L2Clan[this._clans.size()]);
    }

    protected ClanTable() {
        if (Config.COMMUNITY_TYPE > 0) {
            ForumsBBSManager.getInstance().initRoot();
        }
        int clanCount = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT clan_id FROM clan_data");){
            while (rs.next()) {
                int clanId = rs.getInt("clan_id");
                this._clans.put(clanId, (Object)new L2Clan(clanId));
                L2Clan clan = this.getClan(clanId);
                if (clan.getDissolvingExpiryTime() != 0L) {
                    this.scheduleRemoveClan(clan.getId());
                }
                ++clanCount;
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring ClanTable.", e);
        }
        _log.info(this.getClass().getSimpleName() + ": Restored " + clanCount + " clans from the database.");
        this.allianceCheck();
        this.restorewars();
    }

    public L2Clan getClan(int clanId) {
        return (L2Clan)this._clans.get(clanId);
    }

    public L2Clan getClanByName(String clanName) {
        for (L2Clan clan : this._clans.values()) {
            if (!clan.getName().equalsIgnoreCase(clanName)) continue;
            return clan;
        }
        return null;
    }

    public L2Clan createClan(L2PcInstance player, String clanName) {
        if (null == player) {
            return null;
        }
        if (Config.DEBUG) {
            _log.info(this.getClass().getSimpleName() + ": " + player.getObjectId() + "(" + player.getName() + ") requested a clan creation.");
        }
        if (10 > player.getLevel()) {
            player.sendPacket(SystemMessageId.YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN);
            return null;
        }
        if (0 != player.getClanId()) {
            player.sendPacket(SystemMessageId.FAILED_TO_CREATE_CLAN);
            return null;
        }
        if (System.currentTimeMillis() < player.getClanCreateExpiryTime()) {
            player.sendPacket(SystemMessageId.YOU_MUST_WAIT_XX_DAYS_BEFORE_CREATING_A_NEW_CLAN);
            return null;
        }
        if (!Util.isAlphaNumeric(clanName) || 2 > clanName.length()) {
            player.sendPacket(SystemMessageId.CLAN_NAME_INCORRECT);
            return null;
        }
        if (16 < clanName.length()) {
            player.sendPacket(SystemMessageId.CLAN_NAME_TOO_LONG);
            return null;
        }
        if (null != this.getClanByName(clanName)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_EXISTS);
            sm.addString(clanName);
            player.sendPacket(sm);
            sm = null;
            return null;
        }
        L2Clan clan = new L2Clan(IdFactory.getInstance().getNextId(), clanName);
        L2ClanMember leader = new L2ClanMember(clan, player);
        clan.setLeader(leader);
        leader.setPlayerInstance(player);
        clan.store();
        player.setClan(clan);
        player.setPledgeClass(L2ClanMember.calculatePledgeClass(player));
        player.setClanPrivileges(new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, true));
        this._clans.put(clan.getId(), (Object)clan);
        player.sendPacket(new PledgeShowInfoUpdate(clan));
        player.sendPacket(new PledgeShowMemberListAll(clan, player));
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.sendPacket(new PledgeShowMemberListUpdate(player));
        player.sendPacket(SystemMessageId.CLAN_CREATED);
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, clan, 3));
        return clan;
    }

    public synchronized void destroyClan(int clanId) {
        L2ClanMember leaderMember;
        Auction auction;
        int hallId;
        int fortId;
        L2Clan clan = this.getClan(clanId);
        if (clan == null) {
            return;
        }
        clan.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.CLAN_HAS_DISPERSED));
        int castleId = clan.getCastleId();
        if (castleId == 0) {
            for (Siege siege : SiegeManager.getInstance().getSieges()) {
                siege.removeSiegeClan(clan);
            }
        }
        if ((fortId = clan.getFortId()) == 0) {
            for (FortSiege siege : FortSiegeManager.getInstance().getSieges()) {
                siege.removeSiegeClan(clan);
            }
        }
        if ((hallId = clan.getHideoutId()) == 0) {
            for (SiegableHall hall : CHSiegeManager.getInstance().getConquerableHalls().values()) {
                hall.removeAttacker(clan);
            }
        }
        if ((auction = AuctionManager.getInstance().getAuction(clan.getAuctionBiddedAt())) != null) {
            auction.cancelBid(clan.getId());
        }
        if ((leaderMember = clan.getLeader()) == null) {
            clan.getWarehouse().destroyAllItems("ClanRemove", null, null);
        } else {
            clan.getWarehouse().destroyAllItems("ClanRemove", clan.getLeader().getPlayerInstance(), null);
        }
        for (L2ClanMember l2ClanMember : clan.getMembers()) {
            clan.removeClanMember(l2ClanMember.getObjectId(), 0L);
        }
        this._clans.remove(clanId);
        IdFactory.getInstance().releaseId(clanId);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            SiegableHall hall;
            L2Clan l2Clan;
            Fort fort;
            Throwable throwable = null;
            try (PreparedStatement ps = con.prepareStatement("DELETE FROM clan_data WHERE clan_id=?");){
                ps.setInt(1, clanId);
                ps.execute();
            }
            catch (Throwable x2) {
                Throwable throwable2 = x2;
                throw x2;
            }
            ps = con.prepareStatement("DELETE FROM clan_privs WHERE clan_id=?");
            Throwable throwable3 = null;
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            catch (Throwable x2) {
                Throwable throwable4 = x2;
                throw x2;
            }
            finally {
                if (ps != null) {
                    if (throwable3 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_skills WHERE clan_id=?");
            Throwable throwable5 = null;
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            catch (Throwable x2) {
                Throwable throwable6 = x2;
                throw x2;
            }
            finally {
                if (ps != null) {
                    if (throwable5 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            throwable5.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_subpledges WHERE clan_id=?");
            Throwable throwable7 = null;
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            catch (Throwable x2) {
                Throwable throwable8 = x2;
                throw x2;
            }
            finally {
                if (ps != null) {
                    if (throwable7 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            throwable7.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? OR clan2=?");
            Throwable throwable9 = null;
            try {
                ps.setInt(1, clanId);
                ps.setInt(2, clanId);
                ps.execute();
            }
            catch (Throwable x2) {
                Throwable throwable10 = x2;
                throw x2;
            }
            finally {
                if (ps != null) {
                    if (throwable9 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            throwable9.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_notices WHERE clan_id=?");
            Throwable throwable11 = null;
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            catch (Throwable x2) {
                Throwable throwable12 = x2;
                throw x2;
            }
            finally {
                if (ps != null) {
                    if (throwable11 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            throwable11.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            if (castleId != 0) {
                ps = con.prepareStatement("UPDATE castle SET taxPercent = 0 WHERE id = ?");
                Throwable throwable13 = null;
                try {
                    ps.setInt(1, castleId);
                    ps.execute();
                }
                catch (Throwable throwable14) {
                    Throwable throwable15 = throwable14;
                    throw throwable14;
                }
                finally {
                    if (ps != null) {
                        if (throwable13 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable x2) {
                                throwable13.addSuppressed(x2);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            if (fortId != 0 && (fort = FortManager.getInstance().getFortById(fortId)) != null && clan == (l2Clan = fort.getOwnerClan())) {
                fort.removeOwner(true);
            }
            if (hallId != 0 && (hall = CHSiegeManager.getInstance().getSiegableHall(hallId)) != null && hall.getOwnerId() == clanId) {
                hall.free();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error removing clan from DB.", e);
        }
    }

    public void scheduleRemoveClan(final int clanId) {
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                if (ClanTable.this.getClan(clanId) == null) {
                    return;
                }
                if (ClanTable.this.getClan(clanId).getDissolvingExpiryTime() != 0L) {
                    ClanTable.this.destroyClan(clanId);
                }
            }
        }, Math.max(this.getClan(clanId).getDissolvingExpiryTime() - System.currentTimeMillis(), 300000L));
    }

    public boolean isAllyExists(String allyName) {
        for (L2Clan clan : this.getClans()) {
            if (clan.getAllyName() == null || !clan.getAllyName().equalsIgnoreCase(allyName)) continue;
            return true;
        }
        return false;
    }

    public void storeclanswars(int clanId1, int clanId2) {
        L2Clan clan2;
        L2Clan clan1 = ClanTable.getInstance().getClan(clanId1);
        if (!this.fireClanWarStartListeners(clan1, clan2 = ClanTable.getInstance().getClan(clanId2))) {
            return;
        }
        clan1.setEnemyClan(clan2);
        clan2.setAttackerClan(clan1);
        clan1.broadcastClanStatus();
        clan2.broadcastClanStatus();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("REPLACE INTO clan_wars (clan1, clan2, wantspeace1, wantspeace2) VALUES(?,?,?,?)");){
            ps.setInt(1, clanId1);
            ps.setInt(2, clanId2);
            ps.setInt(3, 0);
            ps.setInt(4, 0);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error storing clan wars data.", e);
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_AGAINST_S1_IF_KILLED_LOSE_LOW_EXP);
        msg.addString(clan2.getName());
        clan1.broadcastToOnlineMembers(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_DECLARED_WAR);
        msg.addString(clan1.getName());
        clan2.broadcastToOnlineMembers(msg);
    }

    public void deleteclanswars(int clanId1, int clanId2) {
        L2Clan clan2;
        L2Clan clan1 = ClanTable.getInstance().getClan(clanId1);
        if (!this.fireClanWarEndListeners(clan1, clan2 = ClanTable.getInstance().getClan(clanId2))) {
            return;
        }
        clan1.deleteEnemyClan(clan2);
        clan2.deleteAttackerClan(clan1);
        clan1.broadcastClanStatus();
        clan2.broadcastClanStatus();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? AND clan2=?");){
            ps.setInt(1, clanId1);
            ps.setInt(2, clanId2);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error removing clan wars data.", e);
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.WAR_AGAINST_S1_HAS_STOPPED);
        msg.addString(clan2.getName());
        clan1.broadcastToOnlineMembers(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_HAS_DECIDED_TO_STOP);
        msg.addString(clan1.getName());
        clan2.broadcastToOnlineMembers(msg);
    }

    public void checkSurrender(L2Clan clan1, L2Clan clan2) {
        int count = 0;
        for (L2ClanMember player : clan1.getMembers()) {
            if (player == null || player.getPlayerInstance().getWantsPeace() != 1) continue;
            ++count;
        }
        if (count == clan1.getMembers().length - 1) {
            if (!this.fireClanWarEndListeners(clan1, clan2)) {
                return;
            }
            clan1.deleteEnemyClan(clan2);
            clan2.deleteEnemyClan(clan1);
            this.deleteclanswars(clan1.getId(), clan2.getId());
        }
    }

    private void restorewars() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement statement = con.createStatement();
             ResultSet rset = statement.executeQuery("SELECT clan1, clan2 FROM clan_wars");){
            while (rset.next()) {
                L2Clan clan1 = this.getClan(rset.getInt("clan1"));
                L2Clan clan2 = this.getClan(rset.getInt("clan2"));
                if (clan1 != null && clan2 != null) {
                    clan1.setEnemyClan(rset.getInt("clan2"));
                    clan2.setAttackerClan(rset.getInt("clan1"));
                    continue;
                }
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": restorewars one of clans is null clan1:" + clan1 + " clan2:" + clan2);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error restoring clan wars data.", e);
        }
    }

    private void allianceCheck() {
        for (L2Clan clan : this._clans.values()) {
            int allyId = clan.getAllyId();
            if (allyId == 0 || clan.getId() == allyId || this._clans.containsKey(allyId)) continue;
            clan.setAllyId(0);
            clan.setAllyName(null);
            clan.changeAllyCrest(0, true);
            clan.updateClanInDB();
            _log.info(this.getClass().getSimpleName() + ": Removed alliance from clan: " + clan);
        }
    }

    public List<L2Clan> getClanAllies(int allianceId) {
        ArrayList<L2Clan> clanAllies = new ArrayList<L2Clan>();
        if (allianceId != 0) {
            for (L2Clan clan : this._clans.values()) {
                if (clan == null || clan.getAllyId() != allianceId) continue;
                clanAllies.add(clan);
            }
        }
        return clanAllies;
    }

    public void storeClanScore() {
        for (L2Clan clan : this._clans.values()) {
            clan.updateClanScoreInDB();
        }
    }

    private boolean fireClanWarStartListeners(L2Clan clan1, L2Clan clan2) {
        if (!clanWarListeners.isEmpty() && clan1 != null && clan2 != null) {
            ClanWarEvent event = new ClanWarEvent();
            event.setClan1(clan1);
            event.setClan2(clan2);
            event.setStage(L2Script.EventStage.START);
            for (ClanWarListener listener : clanWarListeners) {
                if (listener.onWarStart(event)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean fireClanWarEndListeners(L2Clan clan1, L2Clan clan2) {
        if (!clanWarListeners.isEmpty() && clan1 != null && clan2 != null) {
            ClanWarEvent event = new ClanWarEvent();
            event.setClan1(clan1);
            event.setClan2(clan2);
            event.setStage(L2Script.EventStage.END);
            for (ClanWarListener listener : clanWarListeners) {
                if (listener.onWarEnd(event)) continue;
                return false;
            }
        }
        return true;
    }

    public static void addClanWarListener(ClanWarListener listener) {
        if (!clanWarListeners.contains((Object)listener)) {
            clanWarListeners.add((Object)listener);
        }
    }

    public static void removeClanWarListener(ClanWarListener listener) {
        clanWarListeners.remove((Object)listener);
    }

    public static ClanTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ClanTable _instance = new ClanTable();

        private SingletonHolder() {
        }
    }
}

