/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.enchant.AbstractEnchantItem;
import com.l2jserver.gameserver.model.items.enchant.EnchantScroll;
import com.l2jserver.gameserver.model.items.enchant.EnchantSupportItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.util.logging.Level;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnchantItemData
extends DocumentParser {
    public static final FastIntObjectMap<EnchantScroll> _scrolls = new FastIntObjectMap();
    public static final FastIntObjectMap<EnchantSupportItem> _supports = new FastIntObjectMap();

    public EnchantItemData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        _scrolls.clear();
        _supports.clear();
        this.parseDatapackFile("data/enchantItemData.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _scrolls.size() + " Enchant Scrolls.");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _supports.size() + " Support Items.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                AbstractEnchantItem item;
                Node att;
                StatsSet set;
                NamedNodeMap attrs;
                if ("enchant".equalsIgnoreCase(d.getNodeName())) {
                    attrs = d.getAttributes();
                    set = new StatsSet();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        att = attrs.item(i);
                        set.set(att.getNodeName(), att.getNodeValue());
                    }
                    try {
                        item = new EnchantScroll(set);
                        for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if (!"item".equalsIgnoreCase(cd.getNodeName())) continue;
                            ((EnchantScroll)item).addItem(this.parseInteger(cd.getAttributes(), "id"));
                        }
                        _scrolls.put(item.getId(), (Object)item);
                    }
                    catch (NullPointerException e) {
                        this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": Unexistent enchant scroll: " + set.getString("id") + " defined in enchant data!");
                    }
                    catch (IllegalAccessError e) {
                        this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": Wrong enchant scroll item type: " + set.getString("id") + " defined in enchant data!");
                    }
                    continue;
                }
                if (!"support".equalsIgnoreCase(d.getNodeName())) continue;
                attrs = d.getAttributes();
                set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                try {
                    item = new EnchantSupportItem(set);
                    _supports.put(item.getId(), (Object)item);
                    continue;
                }
                catch (NullPointerException e) {
                    this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": Unexistent enchant support item: " + set.getString("id") + " defined in enchant data!");
                    continue;
                }
                catch (IllegalAccessError e) {
                    this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": Wrong enchant support item type: " + set.getString("id") + " defined in enchant data!");
                }
            }
        }
    }

    public final EnchantScroll getEnchantScroll(L2ItemInstance scroll) {
        return (EnchantScroll)_scrolls.get(scroll.getId());
    }

    public final EnchantSupportItem getSupportItem(L2ItemInstance item) {
        return (EnchantSupportItem)_supports.get(item.getId());
    }

    public static final EnchantItemData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemData _instance = new EnchantItemData();

        private SingletonHolder() {
        }
    }
}

