/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.fishing.L2FishingMonster;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FishingMonstersData
extends DocumentParser {
    private static final HashMap<Integer, L2FishingMonster> _fishingMonstersData = new HashMap();

    protected FishingMonstersData() {
        this.load();
    }

    @Override
    public void load() {
        _fishingMonstersData.clear();
        this.parseDatapackFile("data/stats/fishing/fishingMonsters.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _fishingMonstersData.size() + " Fishing Monsters.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"fishingMonster".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                L2FishingMonster fishingMonster = new L2FishingMonster(set);
                _fishingMonstersData.put(fishingMonster.getFishingMonsterId(), fishingMonster);
            }
        }
    }

    public L2FishingMonster getFishingMonster(int lvl) {
        for (L2FishingMonster fishingMonster : _fishingMonstersData.values()) {
            if (lvl < fishingMonster.getUserMinLevel() || lvl > fishingMonster.getUserMaxLevel()) continue;
            return fishingMonster;
        }
        return null;
    }

    public L2FishingMonster getFishingMonsterById(int id) {
        return _fishingMonstersData.get(id);
    }

    public static FishingMonstersData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FishingMonstersData _instance = new FishingMonstersData();

        private SingletonHolder() {
        }
    }
}

