/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.items.L2Henna;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class HennaData
extends DocumentParser {
    private static final Map<Integer, L2Henna> _hennaList = new HashMap<Integer, L2Henna>();

    protected HennaData() {
        this.load();
    }

    @Override
    public void load() {
        _hennaList.clear();
        this.parseDatapackFile("data/stats/hennaList.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _hennaList.size() + " Henna data.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"henna".equals(d.getNodeName())) continue;
                this.parseHenna(d);
            }
        }
    }

    private void parseHenna(Node d) {
        StatsSet set = new StatsSet();
        ArrayList<ClassId> wearClassIds = new ArrayList<ClassId>();
        NamedNodeMap attrs = d.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            set.set(attr.getNodeName(), attr.getNodeValue());
        }
        block13: for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
            String name = c.getNodeName();
            attrs = c.getAttributes();
            switch (name) {
                case "stats": {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node attr = attrs.item(i);
                        set.set(attr.getNodeName(), attr.getNodeValue());
                    }
                    continue block13;
                }
                case "wear": {
                    Node attr = attrs.getNamedItem("count");
                    set.set("wear_count", attr.getNodeValue());
                    attr = attrs.getNamedItem("fee");
                    set.set("wear_fee", attr.getNodeValue());
                    continue block13;
                }
                case "cancel": {
                    Node attr = attrs.getNamedItem("count");
                    set.set("cancel_count", attr.getNodeValue());
                    attr = attrs.getNamedItem("fee");
                    set.set("cancel_fee", attr.getNodeValue());
                    continue block13;
                }
                case "classId": {
                    wearClassIds.add(ClassId.getClassId(Integer.parseInt(c.getTextContent())));
                }
            }
        }
        L2Henna henna = new L2Henna(set);
        henna.setWearClassIds(wearClassIds);
        _hennaList.put(henna.getDyeId(), henna);
    }

    public L2Henna getHenna(int id) {
        return _hennaList.get(id);
    }

    public List<L2Henna> getHennaList(ClassId classId) {
        ArrayList<L2Henna> list = new ArrayList<L2Henna>();
        for (L2Henna henna : _hennaList.values()) {
            if (!henna.isAllowedClass(classId)) continue;
            list.add(henna);
        }
        return list;
    }

    public static HennaData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final HennaData _instance = new HennaData();

        private SingletonHolder() {
        }
    }
}

